# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.message_response import MessageResponse
from ..types.workflow_request_chunk_strategy import WorkflowRequestChunkStrategy
from ..types.workflow_response import WorkflowResponse
from ..types.workflow_steps import WorkflowSteps
from ..types.workflows_response import WorkflowsResponse
from .raw_client import AsyncRawWorkflowsClient, RawWorkflowsClient
from .types.workflows_get_request_id import WorkflowsGetRequestId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowsClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowsResponse:
        """
        Get all workflows associated with the API key.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Create a workflow.

        Parameters
        ----------
        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Workflow successfully created

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.create()
        """
        _response = self._raw_client.create(
            chunk_strategy=chunk_strategy, name=name, extract=extract, steps=steps, request_options=request_options
        )
        return _response.data

    def get_account(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowResponse:
        """
        Get the workflow associated with customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.get_account()
        """
        _response = self._raw_client.get_account(request_options=request_options)
        return _response.data

    def add_to_account(
        self, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Assigns the given workflow to the customer account and is applied by default to all files unless overridden by document or bucket workflows.

        Parameters
        ----------
        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.add_to_account(
            workflow_id="workflowId",
        )
        """
        _response = self._raw_client.add_to_account(workflow_id=workflow_id, request_options=request_options)
        return _response.data

    def remove_from_account(self, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.remove_from_account()
        """
        _response = self._raw_client.remove_from_account(request_options=request_options)
        return _response.data

    def add_to_id(
        self, id: int, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Assigns the given workflow to the group or bucket and is applied by default to all files unless overridden by document workflows.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will be assigned to.

        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.add_to_id(
            id=1,
            workflow_id="workflowId",
        )
        """
        _response = self._raw_client.add_to_id(id, workflow_id=workflow_id, request_options=request_options)
        return _response.data

    def remove_from_id(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will removed from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.remove_from_id(
            id=1,
        )
        """
        _response = self._raw_client.remove_from_id(id, request_options=request_options)
        return _response.data

    def get(
        self, id: WorkflowsGetRequestId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowResponse:
        """
        look up a specific workflow by groupId, bucketId, or workflowId.

        Parameters
        ----------
        id : WorkflowsGetRequestId
            The id of the group, bucket, or workflow to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.get(
            id=1,
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Update an existing workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being updated.

        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Update success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, chunk_strategy=chunk_strategy, name=name, extract=extract, steps=steps, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Delete a workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Delete success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.workflows.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowsClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowsResponse:
        """
        Get all workflows associated with the API key.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Create a workflow.

        Parameters
        ----------
        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Workflow successfully created

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            chunk_strategy=chunk_strategy, name=name, extract=extract, steps=steps, request_options=request_options
        )
        return _response.data

    async def get_account(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowResponse:
        """
        Get the workflow associated with customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.get_account()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_account(request_options=request_options)
        return _response.data

    async def add_to_account(
        self, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Assigns the given workflow to the customer account and is applied by default to all files unless overridden by document or bucket workflows.

        Parameters
        ----------
        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.add_to_account(
                workflow_id="workflowId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_to_account(workflow_id=workflow_id, request_options=request_options)
        return _response.data

    async def remove_from_account(self, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.remove_from_account()


        asyncio.run(main())
        """
        _response = await self._raw_client.remove_from_account(request_options=request_options)
        return _response.data

    async def add_to_id(
        self, id: int, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Assigns the given workflow to the group or bucket and is applied by default to all files unless overridden by document workflows.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will be assigned to.

        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.add_to_id(
                id=1,
                workflow_id="workflowId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_to_id(id, workflow_id=workflow_id, request_options=request_options)
        return _response.data

    async def remove_from_id(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will removed from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Apply success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.remove_from_id(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remove_from_id(id, request_options=request_options)
        return _response.data

    async def get(
        self, id: WorkflowsGetRequestId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowResponse:
        """
        look up a specific workflow by groupId, bucketId, or workflowId.

        Parameters
        ----------
        id : WorkflowsGetRequestId
            The id of the group, bucket, or workflow to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.get(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowResponse:
        """
        Update an existing workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being updated.

        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResponse
            Update success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, chunk_strategy=chunk_strategy, name=name, extract=extract, steps=steps, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Delete a workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Delete success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
