# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_prompt_role import WorkflowPromptRole


class WorkflowPrompt(UniversalBaseModel):
    """
    Configurations for the prompt an agent uses in a workflow
    """

    abbreviated: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short version of the prompt that is included in historical chat transcripts as part of the prompt context
    """

    prompt: typing.Optional[str] = pydantic.Field(default=None)
    """
    The prompt that is sent to the LLM
    """

    role: typing.Optional[WorkflowPromptRole] = pydantic.Field(default=None)
    """
    An enumerated value that conforms to OpenAI '/chat/completion' specifications
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
