# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .workflow_engine_reasoning_effort import WorkflowEngineReasoningEffort
from .workflow_engine_service import WorkflowEngineService


class WorkflowEngine(UniversalBaseModel):
    """
    Configurations for the LLM an agent uses in a workflow
    """

    api_key: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="apiKey")] = pydantic.Field(
        default=None
    )
    """
    A token that is added to the header of a request as an authorization bearer token
    """

    base_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseURL")] = pydantic.Field(
        default=None
    )
    """
    The base URL that precedes '/chat/completion' for an OpenAI chat completion-compatible endpoint
    """

    engine_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="engineID")] = pydantic.Field(
        default=None
    )
    """
    The model name that will be included in the request
    """

    reasoning_effort: typing_extensions.Annotated[
        typing.Optional[WorkflowEngineReasoningEffort], FieldMetadata(alias="reasoningEffort")
    ] = pydantic.Field(default=None)
    """
    An enumerated value that conforms to OpenAI '/chat/completion' specifications
    """

    service: typing.Optional[WorkflowEngineService] = pydantic.Field(default=None)
    """
    An enumerated descriptor of the service type, impacts how the requests are configured
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
