# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .workflow_detail_chunk_strategy import WorkflowDetailChunkStrategy
from .workflow_detail_relationships import WorkflowDetailRelationships
from .workflow_steps import WorkflowSteps


class WorkflowDetail(UniversalBaseModel):
    """
    Workflow information
    """

    chunk_strategy: typing_extensions.Annotated[
        typing.Optional[WorkflowDetailChunkStrategy], FieldMetadata(alias="chunkStrategy")
    ] = None
    document_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="documentId")] = pydantic.Field(
        default=None
    )
    """
    The documentId associated with the workflow
    """

    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The bucketId or groupId associated with the workflow
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable name of the workflow
    """

    extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Extract agent definitions.
    """

    steps: typing.Optional[WorkflowSteps] = None
    relationships: typing.Optional[WorkflowDetailRelationships] = pydantic.Field(default=None)
    """
    Information describing what the workflow is associated with
    """

    workflow_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="workflowId")] = pydantic.Field(
        default=None
    )
    """
    Unique system generated ID for the workflow
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
