# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .search_result_item import SearchResultItem


class SearchResponseSearch(UniversalBaseModel):
    count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total results
    """

    results: typing.Optional[typing.List[SearchResultItem]] = pydantic.Field(default=None)
    """
    Search results
    """

    query: typing.Optional[str] = pydantic.Field(default=None)
    """
    The original search request query
    """

    score: typing.Optional[float] = pydantic.Field(default=None)
    """
    Confidence score in the search results
    """

    search_query: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="searchQuery")] = (
        pydantic.Field(default=None)
    )
    """
    The actual search query, if the search request query was re-written
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Suggested context for LLM completion
    """

    next_token: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="nextToken")] = pydantic.Field(
        default=None
    )
    """
    For paginated results
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
