# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .document_type import DocumentType
from .process_level import ProcessLevel
from .processing_status import ProcessingStatus


class DocumentDetail(UniversalBaseModel):
    bucket_id: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="bucketId")] = None
    document_id: typing_extensions.Annotated[str, FieldMetadata(alias="documentId")] = pydantic.Field()
    """
    Unique system generated ID for the document
    """

    file_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileName")] = None
    file_size: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fileSize")] = pydantic.Field(
        default=None
    )
    """
    The file size of the file stored in GroundX
    """

    file_type: typing_extensions.Annotated[typing.Optional[DocumentType], FieldMetadata(alias="fileType")] = None
    filter: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    A dictionary of key-value pairs that can be used to pre-filter documents prior to a search.
    """

    process_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="processId")] = pydantic.Field(
        default=None
    )
    """
    Unique system generated ID for the ingest request
    """

    process_level: typing_extensions.Annotated[typing.Optional[ProcessLevel], FieldMetadata(alias="processLevel")] = (
        None
    )
    search_data: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="searchData")
    ] = None
    source_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sourceUrl")] = pydantic.Field(
        default=None
    )
    """
    Source document URL
    """

    status: typing.Optional[ProcessingStatus] = None
    status_message: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="statusMessage")] = None
    text_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="textUrl")] = pydantic.Field(
        default=None
    )
    """
    Extracted text URL, if using the extract agent
    """

    xray_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="xrayUrl")] = pydantic.Field(
        default=None
    )
    """
    Document X-Ray results
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
