import { Connections } from '@aws-cdk/aws-ec2';
import * as efs from '@aws-cdk/aws-efs';
import * as iam from '@aws-cdk/aws-iam';
import { IDependable } from '@aws-cdk/core';
/**
 * (experimental) FileSystem configurations for the Lambda function.
 *
 * @experimental
 */
export interface FileSystemConfig {
    /**
     * (experimental) mount path in the lambda runtime environment.
     *
     * @experimental
     */
    readonly localMountPath: string;
    /**
     * (experimental) ARN of the access point.
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) array of IDependable that lambda function depends on.
     *
     * @default - no dependency
     * @experimental
     */
    readonly dependency?: IDependable[];
    /**
     * (experimental) connections object used to allow ingress traffic from lambda function.
     *
     * @default - no connections required to add extra ingress rules for Lambda function
     * @experimental
     */
    readonly connections?: Connections;
    /**
     * (experimental) additional IAM policies required for the lambda function.
     *
     * @default - no additional policies required
     * @experimental
     */
    readonly policies?: iam.PolicyStatement[];
}
/**
 * (experimental) Represents the filesystem for the Lambda function.
 *
 * @experimental
 */
export declare class FileSystem {
    readonly config: FileSystemConfig;
    /**
     * (experimental) mount the filesystem from Amazon EFS.
     *
     * @param ap the Amazon EFS access point.
     * @param mountPath the target path in the lambda runtime environment.
     * @experimental
     */
    static fromEfsAccessPoint(ap: efs.AccessPoint, mountPath: string): FileSystem;
    /**
     * @param config the FileSystem configurations for the Lambda function.
     * @experimental
     */
    protected constructor(config: FileSystemConfig);
}
