# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sphinx_charts']

package_data = \
{'': ['*'], 'sphinx_charts': ['extensions/*']}

extras_require = \
{'docs': ['sphinx>=4,<5',
          'sphinx-rtd-theme==1.0.0',
          'sphinx-tabs==3.2.0',
          'sphinx-math-dollar==1.2.0']}

setup_kwargs = {
    'name': 'sphinx-charts',
    'version': '0.2.0',
    'description': 'Interactive charts, graphs and figures for Sphinx HTML docs.',
    'long_description': '[![PyPI version](https://badge.fury.io/py/sphinx-charts.svg)](https://badge.fury.io/py/sphinx-charts)\n[![codecov](https://codecov.io/gh/thclark/sphinx-charts/branch/master/graph/badge.svg)](https://codecov.io/gh/thclark/sphinx-charts)\n[![Documentation Status](https://readthedocs.org/projects/sphinx_charts/badge/?version=latest)](https://sphinx_charts.readthedocs.io/en/latest/?badge=latest)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n# Sphinx Charts\n\nInteractive charts, graphs and figures for sphinx using [plotly v2.8.3](https://plotly.com/) and D3.\n\n[Documentation is here](https://sphinx_charts.readthedocs.io).\n\n## Quick start\n\nSee the documentation above for more, but in an nutshell, add the extension to your `conf.py`:\n\n```\nextensions = [\n    ...\n    \'sphinx_charts.charts\'\n]\n```\n\nPaste the following into a new file `<your_docs_src_directory>/charts/test.json`:\n\n```\n{\n  "data": [\n    {\n      "x": [1, 2, 3, 4, 5],\n      "y": [1, 2, 4, 8, 16]\n    }\n  ],\n  "layout": {\n    "margin": {"t": 15, "b": 30, "r": 15, "l": 35}\n  }\n}\n```\n\nInclude the following directive in your `*.rst` file:\n\n```\n.. chart:: charts/test.json\n\n    This is the caption of the chart\n```\n\n... and away you go!\n\n## Developer notes\n\n**Note: You don\'t need to pay attention to the following unless you plan to develop sphinx_charts itself.**\n\n### Getting started\n\n1. Click \'use this template\' to the top right, and away you go.\n2. Search for `{{` in your new repository. Do search and replace for the various terms - it\'s obvious what they are, like replace `{{github_username}}` with your github username!\n3. Set up the license you need in `LICENSE`.\n4. If you need to deploy to pypi, you have to do the first deploy manually - travis can\'t do that for you. [See the packaging instructions](https://packaging.python.org/tutorials/distributing-packages/#uploading-your-project-to-pypi).\n\n### Pre-Commit\n\nYou need to install pre-commit to get the hooks working. Do:\n\n```\npip install pre-commit\npre-commit install\n```\n\nOnce that\'s done, each time you make a commit, the following checks are made:\n\n- valid github repo and files\n- code style\n- import order\n- PEP8 compliance\n- documentation build\n\nUpon failure, the commit will halt. **Re-running the commit will automatically fix most issues** except:\n\n- The flake8 checks... hopefully over time Black (which fixes most things automatically already) will negate need for it.\n- You\'ll have to fix documentation yourself prior to a successful commit (there\'s no auto fix for that!!).\n\nYou can run pre-commit hooks without making a commit, too, like:\n\n```\npre-commit run black --all-files\n```\n\nor\n\n```\n# -v gives verbose output, useful for figuring out why docs won\'t build\npre-commit run build-docs -v\n```\n\n### Contributing\n\n- Please raise an issue on the board (or add your \\$0.02 to an existing issue) so the maintainers know\n  what\'s happening and can advise / steer you.\n\n- Create a fork of {{library_name}}, undertake your changes on a new branch, (see `.pre-commit-config.yaml` for branch naming conventions). To run tests and make commits,\n  you\'ll need to do something like:\n\n```\ngit clone <your_forked_repo_address>    # fetches the repo to your local machine\ncd sphinx_charts                     # move into the repo directory\npyenv virtualenv 3.6.9 myenv            # Makes a virtual environment for you to install the dev tools into. Use any python >= 3.6\npyend activate myenv                    # Activates the virtual environment so you don\'t screw up other installations\npip install -r requirements-dev.txt     # Installs the testing and code formatting utilities\npre-commit install                      # Installs the pre-commit code formatting hooks in the git repo\ntox                                     # Runs the tests with coverage. NB you can also just set up pycharm or vscode to run these.\n```\n\n- Adopt a Test Driven Development approach to implementing new features or fixing bugs.\n\n- Ask the `sphinx_charts` maintainers _where_ to make your pull request. We\'ll create a version branch, according to the\n  roadmap, into which you can make your PR. We\'ll help review the changes and improve the PR.\n\n- Once checks have passed, test coverage of the new code is >=95%, documentation is updated and the Review is passed, we\'ll merge into the version branch.\n\n- Once all the roadmapped features for that version are done, we\'ll release.\n\n### Release process\n\nThe process for creating a new release is as follows:\n\n1. Check out a branch for the next version, called `vX.Y.Z`\n2. Create a Pull Request into the `master` branch.\n3. Undertake your changes, committing and pushing to branch `vX.Y.Z`\n4. Ensure that documentation is updated to match changes, and increment the changelog. **Pull requests which do not update documentation will be refused.**\n5. Ensure that test coverage is sufficient. **Pull requests that decrease test coverage will be refused.**\n6. Ensure code meets style guidelines (pre-commit scripts and flake8 tests will fail otherwise)\n7. Address Review Comments on the PR\n8. Ensure the version in `setup.py` is correct and matches the branch version.\n9. Merge to master. Successful test, doc build, flake8 and a new version number will automatically create the release on pypi.\n10. Go to code > releases and create a new release on GitHub at the same SHA.\n\n## Documents\n\n### Building documents automatically\n\nThe documentation will build automatically in a pre-configured environment when you make a commit.\n\nIn fact, the way pre-commit works, you won\'t be allowed to make the commit unless the documentation builds,\nthis way we avoid getting broken documentation pushed to the main repository on any commit sha, so we can rely on\nbuilds working.\n\n### Building documents manually\n\n**If you did need to build the documentation**\n\nInstall `doxgen`. On a mac, that\'s `brew install doxygen`; other systems may differ.\n\nInstall sphinx and other requirements for building the docs:\n\n```\npip install -r docs/requirements.txt\n```\n\nRun the build process:\n\n```\nsphinx-build -b html docs/source docs/build\n```\n',
    'author': 'thclark',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/thclark/sphinx-charts',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
