"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthCheck = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a HTTP2 health check
     */
    static http2(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP2, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a GRPC health check
     */
    static grpc(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.GRPC, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheckImpl(shared_interfaces_1.Protocol.TCP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
}
exports.HealthCheck = HealthCheck;
_a = JSII_RTTI_SYMBOL_1;
HealthCheck[_a] = { fqn: "@aws-cdk/aws-appmesh.HealthCheck", version: "1.163.1" };
class HealthCheckImpl extends HealthCheck {
    constructor(protocol, healthyThreshold = 2, unhealthyThreshold = 2, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), path) {
        super();
        this.protocol = protocol;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.path = path;
        if (healthyThreshold < 2 || healthyThreshold > 10) {
            throw new Error('healthyThreshold must be between 2 and 10');
        }
        if (unhealthyThreshold < 2 || unhealthyThreshold > 10) {
            throw new Error('unhealthyThreshold must be between 2 and 10');
        }
        if (interval.toMilliseconds() < 5000 || interval.toMilliseconds() > 300000) {
            throw new Error('interval must be between 5 seconds and 300 seconds');
        }
        if (timeout.toMilliseconds() < 2000 || timeout.toMilliseconds() > 60000) {
            throw new Error('timeout must be between 2 seconds and 60 seconds');
        }
        // Default to / for HTTP Health Checks
        if (path === undefined && (protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2)) {
            this.path = '/';
        }
    }
    bind(_scope, options) {
        return {
            virtualNodeHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
            virtualGatewayHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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