"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
module.exports = {
    'can add same singleton Lambda multiple times, only instantiated once in template'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        for (let i = 0; i < 5; i++) {
            new lambda.SingletonFunction(stack, `Singleton${i}`, {
                uuid: '84c0de93-353f-4217-9b0b-45b6c993251a',
                code: new lambda.InlineCode('def hello(): pass'),
                runtime: lambda.Runtime.PYTHON_2_7,
                handler: 'index.hello',
                timeout: cdk.Duration.minutes(5),
            });
        }
        // THEN
        assert_1.expect(stack).to(assert_1.matchTemplate({
            Resources: {
                SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235: {
                    Type: 'AWS::IAM::Role',
                    Properties: {
                        AssumeRolePolicyDocument: {
                            Statement: [
                                {
                                    Action: 'sts:AssumeRole',
                                    Effect: 'Allow',
                                    Principal: { Service: 'lambda.amazonaws.com' },
                                },
                            ],
                            Version: '2012-10-17',
                        },
                        ManagedPolicyArns: [
                            {
                                'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':iam::aws:policy/service-role/AWSLambdaBasicExecutionRole']],
                            },
                        ],
                    },
                },
                SingletonLambda84c0de93353f42179b0b45b6c993251a840BCC38: {
                    Type: 'AWS::Lambda::Function',
                    Properties: {
                        Code: {
                            ZipFile: 'def hello(): pass',
                        },
                        Handler: 'index.hello',
                        Role: { 'Fn::GetAtt': ['SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235', 'Arn'] },
                        Runtime: 'python2.7',
                        Timeout: 300,
                    },
                    DependsOn: ['SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235'],
                },
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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