# thousandeyes-sdk-event-detection

Event detection occurs when ThousandEyes identifies that error signals related to a component (proxy, network node, AS, server etc) have deviated from the baselines established by events.
* To determine this, ThousandEyes takes the test results from all accounts groups within an organization, and analyzes that data.
* Noisy test results (those that have too many errors in a short window) are removed until they stabilize, and the rest of the results are tagged with the components associated with that test result (for example, proxy, network, or server).
* Next, any increase in failures from the test results and each component helps in determining the problem domain and which component may be at fault.
* When this failure rate increases beyond a pre-defined threshold (set by the algorithm), an event is triggered and an email notification is sent to the user (if they've enabled email alerts).

With the Events API, you can perform the following tasks on the ThousandEyes platform:
* **Retrieve Events**: Obtain a list of events and detailed information for each event. For more information about events, see [Event Detection](https://docs.thousandeyes.com/product-documentation/event-detection).


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 7.0.37
- Generator version: 7.6.0
- Build package: com.thousandeyes.api.codegen.ThousandeyesPythonGenerator

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

Install directly via PyPi:

```sh
pip install thousandeyes-sdk-event-detection
```
(you may need to run `pip` with root permission: `sudo pip install thousandeyes-sdk-event-detection`)

Then import the package:
```python
import thousandeyes_sdk.event_detection
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import thousandeyes_sdk.event_detection
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the installation procedure and then run the following:

```python

import thousandeyes_sdk.core
import thousandeyes_sdk.event_detection
from thousandeyes_sdk.core.exceptions import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.thousandeyes.com/v7
# See configuration.py for a list of all supported configuration parameters.
configuration = thousandeyes_sdk.core.Configuration(
    host = "https://api.thousandeyes.com/v7"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = thousandeyes_sdk.core.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with thousandeyes_sdk.core.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = thousandeyes_sdk.event_detection.EventsApi(api_client)
    id = 'e9c3bf02-a48c-4aa8-9e5f-898800d6f569' # str | Unique event ID.
    aid = '1234' # str | A unique identifier associated with your account group. You can retrieve your `AccountGroupId` from the `/account-groups` endpoint. Note that you must be assigned to the target account group. Specifying this parameter without being assigned to the target account group will result in an error response. (optional)

    try:
        # Retrieve event
        api_response = api_instance.get_event(id, aid=aid)
        print("The response of EventsApi->get_event:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EventsApi->get_event: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.thousandeyes.com/v7*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EventsApi* | [**get_event**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventsApi.md#get_event) | **GET** /events/{id} | Retrieve event
*EventsApi* | [**get_events**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventsApi.md#get_events) | **GET** /events | List events


## Documentation For Models

 - [AffectedAgents](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AffectedAgents.md)
 - [AffectedCount](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AffectedCount.md)
 - [AffectedTargets](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AffectedTargets.md)
 - [AffectedTests](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AffectedTests.md)
 - [AgentLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AgentLinks.md)
 - [AgentLocalEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AgentLocalEventDetail.md)
 - [AgentLocalEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/AgentLocalEventGrouping.md)
 - [ApiAffectedTarget](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/ApiAffectedTarget.md)
 - [CloudEnterpriseAgentType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/CloudEnterpriseAgentType.md)
 - [DnsEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/DnsEventDetail.md)
 - [DnsEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/DnsEventGrouping.md)
 - [Error](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/Error.md)
 - [Event](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/Event.md)
 - [EventAlertSeverity](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventAlertSeverity.md)
 - [EventApiAffectedAgent](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventApiAffectedAgent.md)
 - [EventApiAffectedTest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventApiAffectedTest.md)
 - [EventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventDetail.md)
 - [EventDetailBase](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventDetailBase.md)
 - [EventState](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventState.md)
 - [EventTestLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventTestLinks.md)
 - [EventType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/EventType.md)
 - [Events](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/Events.md)
 - [Link](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/Link.md)
 - [NetworkEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/NetworkEventDetail.md)
 - [NetworkEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/NetworkEventGrouping.md)
 - [NetworkPopEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/NetworkPopEventDetail.md)
 - [PaginationNextAndSelfLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/PaginationNextAndSelfLinks.md)
 - [ProxyEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/ProxyEventDetail.md)
 - [ProxyEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/ProxyEventGrouping.md)
 - [SelfLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/SelfLinks.md)
 - [SimpleEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/SimpleEventDetail.md)
 - [TargetEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/TargetEventDetail.md)
 - [TargetEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/TargetEventGrouping.md)
 - [TargetNetworkEventDetail](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/TargetNetworkEventDetail.md)
 - [TargetNetworkEventGrouping](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/TargetNetworkEventGrouping.md)
 - [TestType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/TestType.md)
 - [UnauthorizedError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/UnauthorizedError.md)
 - [ValidationError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/ValidationError.md)
 - [ValidationErrorItem](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-event-detection/docs/ValidationErrorItem.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author

<a href="mailto:api-team@thousandeyes.com">ThousandEyes API Team </a>


