import enum
from typing import Any, Dict, Optional, Set
from typing_extensions import Final, Literal

from . import connresource
from .connection import Connection

class TransactionState(enum.Enum):
    NEW: int = ...
    STARTED: int = ...
    COMMITTED: int = ...
    ROLLEDBACK: int = ...
    FAILED: int = ...

_IsolationLevels = Literal['read_committed', 'serializable', 'repeatable_read']
ISOLATION_LEVELS: Final[Set[_IsolationLevels]]
ISOLATION_LEVELS_BY_VALUE: Final[Dict[str, _IsolationLevels]]

class Transaction(connresource.ConnectionResource):
    def __init__(
        self,
        connection: Connection[Any],
        isolation: Optional[_IsolationLevels],
        readonly: bool,
        deferrable: bool,
    ) -> None: ...
    async def __aenter__(self) -> None: ...
    async def __aexit__(self, extype: Any, ex: Any, tb: Any) -> None: ...
    async def start(self) -> None: ...
    async def commit(self) -> None: ...
    async def rollback(self) -> None: ...
