import builtins
from typing import (
    Any,
    Hashable,
    Iterable,
    Iterator,
    Optional,
    Sequence,
    Sized,
    SupportsFloat,
    Text,
    Tuple,
    Type,
    TypeVar,
    Union,
    overload,
)
from typing_extensions import Literal, SupportsIndex

_BitString = TypeVar('_BitString', bound=BitString)
_BitOrderType = Literal['big', 'little']

class BitString:
    def __init__(self, bitstring: Optional[builtins.bytes] = ...) -> None: ...
    @classmethod
    def frombytes(
        cls: Type[_BitString],
        bytes_: Optional[builtins.bytes] = ...,
        bitlength: Optional[int] = ...,
    ) -> _BitString: ...
    @property
    def bytes(self) -> builtins.bytes: ...
    def as_string(self) -> str: ...
    def to_int(self, bitorder: _BitOrderType = ..., *, signed: bool = ...) -> int: ...
    @classmethod
    def from_int(
        cls: Type[_BitString],
        x: int,
        length: int,
        bitorder: _BitOrderType = ...,
        *,
        signed: bool = ...,
    ) -> _BitString: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __getitem__(self, i: int) -> int: ...
    def __len__(self) -> int: ...

class Point(Tuple[float, float]):
    def __init__(
        self,
        x: Union[
            SupportsFloat,
            SupportsIndex,
            Text,
            builtins.bytes,
            builtins.bytearray,
        ],
        y: Union[
            SupportsFloat,
            SupportsIndex,
            Text,
            builtins.bytes,
            builtins.bytearray,
        ],
    ) -> None: ...
    @property
    def x(self) -> float: ...
    @property
    def y(self) -> float: ...

class Box(Tuple[Point, Point]):
    def __init__(self, high: Sequence[float], low: Sequence[float]) -> None: ...
    @property
    def high(self) -> Point: ...
    @property
    def low(self) -> Point: ...

class Line(Tuple[float, float, float]):
    def __init__(self, A: float, B: float, C: float) -> None: ...
    @property
    def A(self) -> float: ...
    @property
    def B(self) -> float: ...
    @property
    def C(self) -> float: ...

class LineSegment(Tuple[Point, Point]):
    def __init__(self, p1: Sequence[float], p2: Sequence[float]) -> None: ...
    @property
    def p1(self) -> Point: ...
    @property
    def p2(self) -> Point: ...

class Path:
    points: Tuple[Point, ...]
    def __init__(self, *points: Sequence[float], is_closed: bool = ...) -> None: ...
    @property
    def is_closed(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __iter__(self) -> Iterator[Point]: ...
    def __len__(self) -> int: ...
    @overload
    def __getitem__(self, i: int) -> Point: ...
    @overload
    def __getitem__(self, i: slice) -> Tuple[Point, ...]: ...
    @overload
    def __getitem__(self, i: Union[int, slice]) -> Union[Point, Tuple[Point, ...]]: ...
    def __contains__(self, point: object) -> bool: ...

class Polygon(Path):
    def __init__(self, *points: Sequence[float]) -> None: ...

class Circle(Tuple[Point, float]):
    def __init__(self, center: Point, radius: float) -> None: ...
    @property
    def center(self) -> Point: ...
    @property
    def radius(self) -> float: ...
