from . import _base
from ._base import FatalPostgresError as FatalPostgresError
from ._base import InterfaceError as InterfaceError
from ._base import InterfaceWarning as InterfaceWarning
from ._base import InternalClientError as InternalClientError
from ._base import OutdatedSchemaCacheError as OutdatedSchemaCacheError
from ._base import PostgresError as PostgresError
from ._base import PostgresLogMessage as PostgresLogMessage
from ._base import ProtocolError as ProtocolError
from ._base import UnknownPostgresError as UnknownPostgresError
from ._base import UnsupportedClientFeatureError as UnsupportedClientFeatureError

class PostgresWarning(_base.PostgresLogMessage, Warning): ...
class DynamicResultSetsReturned(PostgresWarning): ...
class ImplicitZeroBitPadding(PostgresWarning): ...
class NullValueEliminatedInSetFunction(PostgresWarning): ...
class PrivilegeNotGranted(PostgresWarning): ...
class PrivilegeNotRevoked(PostgresWarning): ...
class StringDataRightTruncation(PostgresWarning): ...
class DeprecatedFeature(PostgresWarning): ...
class NoData(PostgresWarning): ...
class NoAdditionalDynamicResultSetsReturned(NoData): ...
class SQLStatementNotYetCompleteError(_base.PostgresError): ...
class PostgresConnectionError(_base.PostgresError): ...
class ConnectionDoesNotExistError(PostgresConnectionError): ...
class ConnectionFailureError(PostgresConnectionError): ...
class ClientCannotConnectError(PostgresConnectionError): ...
class ConnectionRejectionError(PostgresConnectionError): ...
class TransactionResolutionUnknownError(PostgresConnectionError): ...
class ProtocolViolationError(PostgresConnectionError): ...
class TriggeredActionError(_base.PostgresError): ...
class FeatureNotSupportedError(_base.PostgresError): ...
class InvalidCachedStatementError(FeatureNotSupportedError): ...
class InvalidTransactionInitiationError(_base.PostgresError): ...
class LocatorError(_base.PostgresError): ...
class InvalidLocatorSpecificationError(LocatorError): ...
class InvalidGrantorError(_base.PostgresError): ...
class InvalidGrantOperationError(InvalidGrantorError): ...
class InvalidRoleSpecificationError(_base.PostgresError): ...
class DiagnosticsError(_base.PostgresError): ...
class StackedDiagnosticsAccessedWithoutActiveHandlerError(DiagnosticsError): ...
class CaseNotFoundError(_base.PostgresError): ...
class CardinalityViolationError(_base.PostgresError): ...
class DataError(_base.PostgresError): ...
class ArraySubscriptError(DataError): ...
class CharacterNotInRepertoireError(DataError): ...
class DatetimeFieldOverflowError(DataError): ...
class DivisionByZeroError(DataError): ...
class ErrorInAssignmentError(DataError): ...
class EscapeCharacterConflictError(DataError): ...
class IndicatorOverflowError(DataError): ...
class IntervalFieldOverflowError(DataError): ...
class InvalidArgumentForLogarithmError(DataError): ...
class InvalidArgumentForNtileFunctionError(DataError): ...
class InvalidArgumentForNthValueFunctionError(DataError): ...
class InvalidArgumentForPowerFunctionError(DataError): ...
class InvalidArgumentForWidthBucketFunctionError(DataError): ...
class InvalidCharacterValueForCastError(DataError): ...
class InvalidDatetimeFormatError(DataError): ...
class InvalidEscapeCharacterError(DataError): ...
class InvalidEscapeOctetError(DataError): ...
class InvalidEscapeSequenceError(DataError): ...
class NonstandardUseOfEscapeCharacterError(DataError): ...
class InvalidIndicatorParameterValueError(DataError): ...
class InvalidParameterValueError(DataError): ...
class InvalidPrecedingOrFollowingSizeError(DataError): ...
class InvalidRegularExpressionError(DataError): ...
class InvalidRowCountInLimitClauseError(DataError): ...
class InvalidRowCountInResultOffsetClauseError(DataError): ...
class InvalidTablesampleArgumentError(DataError): ...
class InvalidTablesampleRepeatError(DataError): ...
class InvalidTimeZoneDisplacementValueError(DataError): ...
class InvalidUseOfEscapeCharacterError(DataError): ...
class MostSpecificTypeMismatchError(DataError): ...
class NullValueNotAllowedError(DataError): ...
class NullValueNoIndicatorParameterError(DataError): ...
class NumericValueOutOfRangeError(DataError): ...
class SequenceGeneratorLimitExceededError(DataError): ...
class StringDataLengthMismatchError(DataError): ...
class StringDataRightTruncationError(DataError): ...
class SubstringError(DataError): ...
class TrimError(DataError): ...
class UnterminatedCStringError(DataError): ...
class ZeroLengthCharacterStringError(DataError): ...
class PostgresFloatingPointError(DataError): ...
class InvalidTextRepresentationError(DataError): ...
class InvalidBinaryRepresentationError(DataError): ...
class BadCopyFileFormatError(DataError): ...
class UntranslatableCharacterError(DataError): ...
class NotAnXmlDocumentError(DataError): ...
class InvalidXmlDocumentError(DataError): ...
class InvalidXmlContentError(DataError): ...
class InvalidXmlCommentError(DataError): ...
class InvalidXmlProcessingInstructionError(DataError): ...
class DuplicateJsonObjectKeyValueError(DataError): ...
class InvalidJsonTextError(DataError): ...
class InvalidSQLJsonSubscriptError(DataError): ...
class MoreThanOneSQLJsonItemError(DataError): ...
class NoSQLJsonItemError(DataError): ...
class NonNumericSQLJsonItemError(DataError): ...
class NonUniqueKeysInAJsonObjectError(DataError): ...
class SingletonSQLJsonItemRequiredError(DataError): ...
class SQLJsonArrayNotFoundError(DataError): ...
class SQLJsonMemberNotFoundError(DataError): ...
class SQLJsonNumberNotFoundError(DataError): ...
class SQLJsonObjectNotFoundError(DataError): ...
class TooManyJsonArrayElementsError(DataError): ...
class TooManyJsonObjectMembersError(DataError): ...
class SQLJsonScalarRequiredError(DataError): ...
class IntegrityConstraintViolationError(_base.PostgresError): ...
class RestrictViolationError(IntegrityConstraintViolationError): ...
class NotNullViolationError(IntegrityConstraintViolationError): ...
class ForeignKeyViolationError(IntegrityConstraintViolationError): ...
class UniqueViolationError(IntegrityConstraintViolationError): ...
class CheckViolationError(IntegrityConstraintViolationError): ...
class ExclusionViolationError(IntegrityConstraintViolationError): ...
class InvalidCursorStateError(_base.PostgresError): ...
class InvalidTransactionStateError(_base.PostgresError): ...
class ActiveSQLTransactionError(InvalidTransactionStateError): ...
class BranchTransactionAlreadyActiveError(InvalidTransactionStateError): ...
class HeldCursorRequiresSameIsolationLevelError(InvalidTransactionStateError): ...
class InappropriateAccessModeForBranchTransactionError(
    InvalidTransactionStateError
): ...
class InappropriateIsolationLevelForBranchTransactionError(
    InvalidTransactionStateError
): ...
class NoActiveSQLTransactionForBranchTransactionError(InvalidTransactionStateError): ...
class ReadOnlySQLTransactionError(InvalidTransactionStateError): ...
class SchemaAndDataStatementMixingNotSupportedError(InvalidTransactionStateError): ...
class NoActiveSQLTransactionError(InvalidTransactionStateError): ...
class InFailedSQLTransactionError(InvalidTransactionStateError): ...
class IdleInTransactionSessionTimeoutError(InvalidTransactionStateError): ...
class InvalidSQLStatementNameError(_base.PostgresError): ...
class TriggeredDataChangeViolationError(_base.PostgresError): ...
class InvalidAuthorizationSpecificationError(_base.PostgresError): ...
class InvalidPasswordError(InvalidAuthorizationSpecificationError): ...
class DependentPrivilegeDescriptorsStillExistError(_base.PostgresError): ...
class DependentObjectsStillExistError(DependentPrivilegeDescriptorsStillExistError): ...
class InvalidTransactionTerminationError(_base.PostgresError): ...
class SQLRoutineError(_base.PostgresError): ...
class FunctionExecutedNoReturnStatementError(SQLRoutineError): ...
class ModifyingSQLDataNotPermittedError(SQLRoutineError): ...
class ProhibitedSQLStatementAttemptedError(SQLRoutineError): ...
class ReadingSQLDataNotPermittedError(SQLRoutineError): ...
class InvalidCursorNameError(_base.PostgresError): ...
class ExternalRoutineError(_base.PostgresError): ...
class ContainingSQLNotPermittedError(ExternalRoutineError): ...
class ModifyingExternalRoutineSQLDataNotPermittedError(ExternalRoutineError): ...
class ProhibitedExternalRoutineSQLStatementAttemptedError(ExternalRoutineError): ...
class ReadingExternalRoutineSQLDataNotPermittedError(ExternalRoutineError): ...
class ExternalRoutineInvocationError(_base.PostgresError): ...
class InvalidSqlstateReturnedError(ExternalRoutineInvocationError): ...
class NullValueInExternalRoutineNotAllowedError(ExternalRoutineInvocationError): ...
class TriggerProtocolViolatedError(ExternalRoutineInvocationError): ...
class SrfProtocolViolatedError(ExternalRoutineInvocationError): ...
class EventTriggerProtocolViolatedError(ExternalRoutineInvocationError): ...
class SavepointError(_base.PostgresError): ...
class InvalidSavepointSpecificationError(SavepointError): ...
class InvalidCatalogNameError(_base.PostgresError): ...
class InvalidSchemaNameError(_base.PostgresError): ...
class TransactionRollbackError(_base.PostgresError): ...
class TransactionIntegrityConstraintViolationError(TransactionRollbackError): ...
class SerializationError(TransactionRollbackError): ...
class StatementCompletionUnknownError(TransactionRollbackError): ...
class DeadlockDetectedError(TransactionRollbackError): ...
class SyntaxOrAccessError(_base.PostgresError): ...
class PostgresSyntaxError(SyntaxOrAccessError): ...
class InsufficientPrivilegeError(SyntaxOrAccessError): ...
class CannotCoerceError(SyntaxOrAccessError): ...
class GroupingError(SyntaxOrAccessError): ...
class WindowingError(SyntaxOrAccessError): ...
class InvalidRecursionError(SyntaxOrAccessError): ...
class InvalidForeignKeyError(SyntaxOrAccessError): ...
class InvalidNameError(SyntaxOrAccessError): ...
class NameTooLongError(SyntaxOrAccessError): ...
class ReservedNameError(SyntaxOrAccessError): ...
class DatatypeMismatchError(SyntaxOrAccessError): ...
class IndeterminateDatatypeError(SyntaxOrAccessError): ...
class CollationMismatchError(SyntaxOrAccessError): ...
class IndeterminateCollationError(SyntaxOrAccessError): ...
class WrongObjectTypeError(SyntaxOrAccessError): ...
class GeneratedAlwaysError(SyntaxOrAccessError): ...
class UndefinedColumnError(SyntaxOrAccessError): ...
class UndefinedFunctionError(SyntaxOrAccessError): ...
class UndefinedTableError(SyntaxOrAccessError): ...
class UndefinedParameterError(SyntaxOrAccessError): ...
class UndefinedObjectError(SyntaxOrAccessError): ...
class DuplicateColumnError(SyntaxOrAccessError): ...
class DuplicateCursorError(SyntaxOrAccessError): ...
class DuplicateDatabaseError(SyntaxOrAccessError): ...
class DuplicateFunctionError(SyntaxOrAccessError): ...
class DuplicatePreparedStatementError(SyntaxOrAccessError): ...
class DuplicateSchemaError(SyntaxOrAccessError): ...
class DuplicateTableError(SyntaxOrAccessError): ...
class DuplicateAliasError(SyntaxOrAccessError): ...
class DuplicateObjectError(SyntaxOrAccessError): ...
class AmbiguousColumnError(SyntaxOrAccessError): ...
class AmbiguousFunctionError(SyntaxOrAccessError): ...
class AmbiguousParameterError(SyntaxOrAccessError): ...
class AmbiguousAliasError(SyntaxOrAccessError): ...
class InvalidColumnReferenceError(SyntaxOrAccessError): ...
class InvalidColumnDefinitionError(SyntaxOrAccessError): ...
class InvalidCursorDefinitionError(SyntaxOrAccessError): ...
class InvalidDatabaseDefinitionError(SyntaxOrAccessError): ...
class InvalidFunctionDefinitionError(SyntaxOrAccessError): ...
class InvalidPreparedStatementDefinitionError(SyntaxOrAccessError): ...
class InvalidSchemaDefinitionError(SyntaxOrAccessError): ...
class InvalidTableDefinitionError(SyntaxOrAccessError): ...
class InvalidObjectDefinitionError(SyntaxOrAccessError): ...
class WithCheckOptionViolationError(_base.PostgresError): ...
class InsufficientResourcesError(_base.PostgresError): ...
class DiskFullError(InsufficientResourcesError): ...
class OutOfMemoryError(InsufficientResourcesError): ...
class TooManyConnectionsError(InsufficientResourcesError): ...
class ConfigurationLimitExceededError(InsufficientResourcesError): ...
class ProgramLimitExceededError(_base.PostgresError): ...
class StatementTooComplexError(ProgramLimitExceededError): ...
class TooManyColumnsError(ProgramLimitExceededError): ...
class TooManyArgumentsError(ProgramLimitExceededError): ...
class ObjectNotInPrerequisiteStateError(_base.PostgresError): ...
class ObjectInUseError(ObjectNotInPrerequisiteStateError): ...
class CantChangeRuntimeParamError(ObjectNotInPrerequisiteStateError): ...
class LockNotAvailableError(ObjectNotInPrerequisiteStateError): ...
class UnsafeNewEnumValueUsageError(ObjectNotInPrerequisiteStateError): ...
class OperatorInterventionError(_base.PostgresError): ...
class QueryCanceledError(OperatorInterventionError): ...
class AdminShutdownError(OperatorInterventionError): ...
class CrashShutdownError(OperatorInterventionError): ...
class CannotConnectNowError(OperatorInterventionError): ...
class DatabaseDroppedError(OperatorInterventionError): ...
class PostgresSystemError(_base.PostgresError): ...
class PostgresIOError(PostgresSystemError): ...
class UndefinedFileError(PostgresSystemError): ...
class DuplicateFileError(PostgresSystemError): ...
class SnapshotTooOldError(_base.PostgresError): ...
class ConfigFileError(_base.PostgresError): ...
class LockFileExistsError(ConfigFileError): ...
class FDWError(_base.PostgresError): ...
class FDWColumnNameNotFoundError(FDWError): ...
class FDWDynamicParameterValueNeededError(FDWError): ...
class FDWFunctionSequenceError(FDWError): ...
class FDWInconsistentDescriptorInformationError(FDWError): ...
class FDWInvalidAttributeValueError(FDWError): ...
class FDWInvalidColumnNameError(FDWError): ...
class FDWInvalidColumnNumberError(FDWError): ...
class FDWInvalidDataTypeError(FDWError): ...
class FDWInvalidDataTypeDescriptorsError(FDWError): ...
class FDWInvalidDescriptorFieldIdentifierError(FDWError): ...
class FDWInvalidHandleError(FDWError): ...
class FDWInvalidOptionIndexError(FDWError): ...
class FDWInvalidOptionNameError(FDWError): ...
class FDWInvalidStringLengthOrBufferLengthError(FDWError): ...
class FDWInvalidStringFormatError(FDWError): ...
class FDWInvalidUseOfNullPointerError(FDWError): ...
class FDWTooManyHandlesError(FDWError): ...
class FDWOutOfMemoryError(FDWError): ...
class FDWNoSchemasError(FDWError): ...
class FDWOptionNameNotFoundError(FDWError): ...
class FDWReplyHandleError(FDWError): ...
class FDWSchemaNotFoundError(FDWError): ...
class FDWTableNotFoundError(FDWError): ...
class FDWUnableToCreateExecutionError(FDWError): ...
class FDWUnableToCreateReplyError(FDWError): ...
class FDWUnableToEstablishConnectionError(FDWError): ...
class PLPGSQLError(_base.PostgresError): ...
class RaiseError(PLPGSQLError): ...
class NoDataFoundError(PLPGSQLError): ...
class TooManyRowsError(PLPGSQLError): ...
class AssertError(PLPGSQLError): ...
class InternalServerError(_base.PostgresError): ...
class DataCorruptedError(InternalServerError): ...
class IndexCorruptedError(InternalServerError): ...
