from asyncio import AbstractEventLoop, Future, StreamWriter, Task
from pathlib import Path
from typing import Any, AnyStr, Optional, TypeVar, overload
from typing_extensions import Final, Protocol

PY_36: Final[bool]
PY_37: Final[bool]
SYSTEM: Final[str]

_T = TypeVar('_T')
_T_co = TypeVar('_T_co', covariant=True)

class _PathLike(Protocol[_T_co]):
    def __fspath__(self) -> _T_co: ...

def aiter_compat(func: Any) -> Any: ...
@overload
def fspath(path: str) -> str: ...
@overload
def fspath(path: bytes) -> bytes: ...
@overload
def fspath(path: _PathLike[AnyStr]) -> Any: ...
def get_pg_home_directory() -> Optional[Path]: ...
def current_asyncio_task(loop: Optional[AbstractEventLoop]) -> Optional[Task[Any]]: ...
async def wait_closed(stream: StreamWriter) -> None: ...
async def wait_for(fut: Future[_T], timeout: float) -> _T: ...
