#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.image_entity import ImageEntity


# fmt: off
QUERY: List[str] = ["""
mutation DeleteImageMutation(
  $entityType: ImageEntity!
  $entityId: ID!
  $id: ID!
) {
  deleteImage(entityType: $entityType, entityId: $entityId, id: $id) {
    id
    fileName
  }
}

"""
]


class DeleteImageMutation:
    @dataclass(frozen=True)
    class DeleteImageMutationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class File(DataClassJsonMixin):
            id: str
            fileName: str

        deleteImage: File

    # fmt: off
    @classmethod
    def execute(cls, client: Client, entityType: ImageEntity, entityId: str, id: str) -> DeleteImageMutationData.File:
        variables: Dict[str, Any] = {"entityType": entityType, "entityId": entityId, "id": id}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.DeleteImageMutationData.from_dict(response_text)
        return res.deleteImage

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, entityType: ImageEntity, entityId: str, id: str) -> DeleteImageMutationData.File:
        variables: Dict[str, Any] = {"entityType": entityType, "entityId": entityId, "id": id}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.DeleteImageMutationData.from_dict(response_text)
        return res.deleteImage
