# -*- coding: utf-8 -*-
"""DNA Center Get task tree data model.

Copyright (c) 2019 Cisco and/or its affiliates.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""


from __future__ import (
    absolute_import,
    division,
    print_function,
    unicode_literals,
)

import fastjsonschema
import json
from dnacentersdk.exceptions import MalformedRequest

from builtins import *


class JSONSchemaValidatorF5A269C44F2A95Fa(object):
    """Get task tree request schema definition."""
    def __init__(self):
        super(JSONSchemaValidatorF5A269C44F2A95Fa, self).__init__()
        self._validator = fastjsonschema.compile(json.loads(
            '''{
                "properties": {
                "response": {
                "description":
                 "",
                "items": {
                "properties": {
                "additionalStatusURL": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "data": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "endTime": {
                "description":
                 "",
                "type": [
                "string",
                "null",
                "number"
                ]
                },
                "errorCode": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "errorKey": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "failureReason": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "id": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "instanceTenantId": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "isError": {
                "type": [
                "boolean",
                "null"
                ]
                },
                "lastUpdate": {
                "description":
                 "",
                "type": [
                "string",
                "null",
                "number"
                ]
                },
                "operationIdList": {},
                "parentId": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "progress": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "rootId": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "serviceType": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "startTime": {
                "description":
                 "",
                "type": [
                "string",
                "null",
                "number"
                ]
                },
                "username": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                },
                "version": {
                "type": [
                "number",
                "null"
                ]
                }
                },
                "type": [
                "object",
                "null"
                ]
                },
                "type": [
                "array",
                "null",
                "object"
                ]
                },
                "version": {
                "description":
                 "",
                "type": [
                "string",
                "null"
                ]
                }
                },
                "type": "object"
                }'''.replace("\n" + ' ' * 16, '')
        ))

    def validate(self, request):
        try:
            self._validator(request)
        except fastjsonschema.exceptions.JsonSchemaException as e:
            raise MalformedRequest(
                '{} is invalid. Reason: {}'.format(request, e.message)
            )
