import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SSOServiceException as __BaseException } from "./SSOServiceException";

export interface AccountInfo {
    
    accountId?: string;
    
    accountName?: string;
    
    emailAddress?: string;
}
export declare namespace AccountInfo {
    
    const filterSensitiveLog: (obj: AccountInfo) => any;
}
export interface GetRoleCredentialsRequest {
    
    roleName: string | undefined;
    
    accountId: string | undefined;
    
    accessToken: string | undefined;
}
export declare namespace GetRoleCredentialsRequest {
    
    const filterSensitiveLog: (obj: GetRoleCredentialsRequest) => any;
}

export interface RoleCredentials {
    
    accessKeyId?: string;
    
    secretAccessKey?: string;
    
    sessionToken?: string;
    
    expiration?: number;
}
export declare namespace RoleCredentials {
    
    const filterSensitiveLog: (obj: RoleCredentials) => any;
}
export interface GetRoleCredentialsResponse {
    
    roleCredentials?: RoleCredentials;
}
export declare namespace GetRoleCredentialsResponse {
    
    const filterSensitiveLog: (obj: GetRoleCredentialsResponse) => any;
}

export declare class InvalidRequestException extends __BaseException {
    readonly name: "InvalidRequestException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidRequestException, __BaseException>);
}

export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}

export declare class TooManyRequestsException extends __BaseException {
    readonly name: "TooManyRequestsException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<TooManyRequestsException, __BaseException>);
}

export declare class UnauthorizedException extends __BaseException {
    readonly name: "UnauthorizedException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<UnauthorizedException, __BaseException>);
}
export interface ListAccountRolesRequest {
    
    nextToken?: string;
    
    maxResults?: number;
    
    accessToken: string | undefined;
    
    accountId: string | undefined;
}
export declare namespace ListAccountRolesRequest {
    
    const filterSensitiveLog: (obj: ListAccountRolesRequest) => any;
}

export interface RoleInfo {
    
    roleName?: string;
    
    accountId?: string;
}
export declare namespace RoleInfo {
    
    const filterSensitiveLog: (obj: RoleInfo) => any;
}
export interface ListAccountRolesResponse {
    
    nextToken?: string;
    
    roleList?: RoleInfo[];
}
export declare namespace ListAccountRolesResponse {
    
    const filterSensitiveLog: (obj: ListAccountRolesResponse) => any;
}
export interface ListAccountsRequest {
    
    nextToken?: string;
    
    maxResults?: number;
    
    accessToken: string | undefined;
}
export declare namespace ListAccountsRequest {
    
    const filterSensitiveLog: (obj: ListAccountsRequest) => any;
}
export interface ListAccountsResponse {
    
    nextToken?: string;
    
    accountList?: AccountInfo[];
}
export declare namespace ListAccountsResponse {
    
    const filterSensitiveLog: (obj: ListAccountsResponse) => any;
}
export interface LogoutRequest {
    
    accessToken: string | undefined;
}
export declare namespace LogoutRequest {
    
    const filterSensitiveLog: (obj: LogoutRequest) => any;
}
