import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListAccountRolesRequest, ListAccountRolesResponse } from "../models/models_0";
import { deserializeAws_restJson1ListAccountRolesCommand, serializeAws_restJson1ListAccountRolesCommand, } from "../protocols/Aws_restJson1";
var ListAccountRolesCommand = (function (_super) {
    __extends(ListAccountRolesCommand, _super);
    function ListAccountRolesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListAccountRolesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSOClient";
        var commandName = "ListAccountRolesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListAccountRolesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListAccountRolesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListAccountRolesCommand.prototype.serialize = function (input, context) {
        return serializeAws_restJson1ListAccountRolesCommand(input, context);
    };
    ListAccountRolesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restJson1ListAccountRolesCommand(output, context);
    };
    return ListAccountRolesCommand;
}($Command));
export { ListAccountRolesCommand };
