import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { RestoreSecretRequest, RestoreSecretResponse } from "../models/models_0";
import { SecretsManagerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../SecretsManagerClient";
export interface RestoreSecretCommandInput extends RestoreSecretRequest {
}
export interface RestoreSecretCommandOutput extends RestoreSecretResponse, __MetadataBearer {
}

export declare class RestoreSecretCommand extends $Command<RestoreSecretCommandInput, RestoreSecretCommandOutput, SecretsManagerClientResolvedConfig> {
    readonly input: RestoreSecretCommandInput;
    constructor(input: RestoreSecretCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SecretsManagerClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RestoreSecretCommandInput, RestoreSecretCommandOutput>;
    private serialize;
    private deserialize;
}
