import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RemoveRegionsFromReplicationRequest, RemoveRegionsFromReplicationResponse } from "../models/models_0";
import { deserializeAws_json1_1RemoveRegionsFromReplicationCommand, serializeAws_json1_1RemoveRegionsFromReplicationCommand, } from "../protocols/Aws_json1_1";
var RemoveRegionsFromReplicationCommand = (function (_super) {
    __extends(RemoveRegionsFromReplicationCommand, _super);
    function RemoveRegionsFromReplicationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RemoveRegionsFromReplicationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "RemoveRegionsFromReplicationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RemoveRegionsFromReplicationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RemoveRegionsFromReplicationResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RemoveRegionsFromReplicationCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1RemoveRegionsFromReplicationCommand(input, context);
    };
    RemoveRegionsFromReplicationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1RemoveRegionsFromReplicationCommand(output, context);
    };
    return RemoveRegionsFromReplicationCommand;
}($Command));
export { RemoveRegionsFromReplicationCommand };
