"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_environment_secrets_1 = require("../handler/secrets/action-environment-secrets");
class ActionEnvironmentSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret, environment } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const handler = new action_environment_secrets_1.ActionEnvironmentSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionEnvironmentSecretCustomResourceHandler',
            description: 'Handles the creation/deletion of a GitHub Action environment secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            environment,
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionEnvironmentSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionEnvironmentSecret = ActionEnvironmentSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionEnvironmentSecret[_a] = { fqn: "cdk-github.ActionEnvironmentSecret", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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