import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
export interface ActionEnvironmentSecretProps {
    /**
     * The AWS secret in which the OAuth GitHub (personal) access token is stored
     */
    readonly githubTokenSecret: ISecret;
    /**
     * The GitHub repository owner
     */
    readonly repositoryOwner: string;
    /**
     * The GitHub repository name
     */
    readonly repositoryName: string;
    /**
     * The GitHub secret name to be stored
     */
    readonly repositorySecretName: string;
    /**
     * The GithHub environment name which the secret should be stored in
     */
    readonly environment: string;
    /**
     * This AWS secret value will be stored in GitHub as a secret (under the name of repositorySecretName)
     */
    readonly sourceSecret: ISecret;
}
export declare class ActionEnvironmentSecret extends Construct {
    constructor(scope: Construct, id: string, props: ActionEnvironmentSecretProps);
}
