#! /usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2021-10-18 17:25
# @Site    :
# @File    : DBHelper.py
# @Software: PyCharm
from XZGUtil import logger
import ast
from operator import itemgetter

def create_in_sql(table_name: str, data: dict, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = {'w':'d1','ew':'d2','wr':'d3','wa':'d4'}
    """
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                if isinstance(value, str) or conversion:
                    sql += f'"{value}",'
                elif value == None:
                    sql += f'null,'
                else:
                    sql += f'{value},'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    return sql

def create_many_sql(table_name: str, data_list: list, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = [{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'}]
    """

    rel_data = []
    data = data_list[0]
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        item_list = []
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                # if isinstance(value, str) or conversion:
                #     sql += f'"%s",'
                if value == None:
                    sql += '%s,'
                else:
                    sql += '%s,'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    for item in data_list:
        rel_data.append(tuple(item.values()))
    return sql, rel_data




def __paths(data, path='source_root', k=''):
    '''
    用于遍历json树
    :param data: 原始数据，或者key对应的value值
    :param path: key值字符串，默认值为''
    :return:
    '''
    if isinstance(data, dict):
        for k, v in data.items():
            tmp = path + ".get('%s')" % k
            if not isinstance(v, dict):
                yield (tmp, v, k)
            yield from __paths(v, tmp, k)
    if isinstance(data, list):
        for k, v in enumerate(data):
            if isinstance(k, int) and isinstance(v, str):
                pass
            else:
                tmp = path + '[%d]' % k
                if not isinstance(k, int):
                    yield (tmp, v, k)
                yield from __paths(v, tmp, k)

def find_key_path(key,data):
    '''
    查找key路径
    :param key: 需要查找路径的key值
    :return: 包含key值路径的list
    '''

    if isinstance(key, list):
        rel = []
        for ks in key:
            rel += find_key_path(ks, data)
        return rel
    result = []
    for path, value in __paths(data):
        if path.endswith("['%s']" % key):
            result.append(path)
    with open('path.txt', 'w+', encoding='utf-8') as f:
        list(map(lambda line: f.write(line + '\r'), result))
    return result

def find_value_path(key,data):
    '''
    查找某个值的路径
    :param key: 需要查找的值，限制为字符串，数字，浮点数，布尔值
    :return:
    '''
    result = []
    for path, value in __paths(data):
        if isinstance(value, (str, int, bool, float)):
            if value == key:
                result.append(path)
    with open('path.txt', 'w+', encoding='utf-8') as f:
        list(map(lambda line: f.write(line + '\r'), result))
    return result


def upper_lower(word: str):
    """单词大写字母换成下划线加小写"""
    new_str = ''
    for sr in word:
        if word.index(sr) == 0:
            new_str += sr.lower()
        else:
            if sr.islower():
                new_str += sr.lower()
            else:
                new_str += f"_{sr.lower()}"
    return new_str


def parse_json(data: dict, key_list: list = None):
    """
    第一步
    :param data: 传入想要解析的json
    :param key_list: 想要的key列表，不传递则返回所有的字段，传递则返回列表中的key  ex:['lastIndex']
    :return:
    """
    rel = []
    filter_list = []
    for i in __paths(data):
        print(i)
        key = upper_lower(i[2])
        if key not in filter_list:
            if key_list:
                rel.append({'key': key, "value": i[1], "path": i[0]} if i[2] in key_list else None)
            else:
                rel.append({'key': key, "value": i[1], "path": i[0]})
            filter_list.append(key)
    print(list(filter(None, rel)))


def create_msql_table(table_name, field: list):
    """
    第二步,创建建变sql
    :param table_name: 表名
    :param field: 此字段为第一步输出的列表 [{'key': 'lastIndex', 'value': None, 'path': "source_root.get('lastIndex')"}, {'key': 'lastIndex', 'value': '15', 'path': "source_root.get('result').get('page').get('lastIndex')"}]
    :return:
    """
    field = sorted(field, key=itemgetter('key'))
    head = f"""CREATE TABLE `{table_name}` (\n`id` int(6) NOT NULL AUTO_INCREMENT COMMENT '',\n`create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"""
    end = """PRIMARY KEY (`id`)\n ) ENGINE=InnoDB AUTO_INCREMENT=35765 DEFAULT CHARSET=utf8; """
    for item in field:
        key = item.get('key')
        value = item.get('value')
        if isinstance(value, float):
            field = f"`{key}` float DEFAULT NULL COMMENT '',\n"
        elif isinstance(value, int):
            if len(str(value)) <= 10:
                field = f"`{key}` int(11) DEFAULT NULL COMMENT '',\n"
            else:
                field = f"`{key}` bigint(128) DEFAULT NULL COMMENT '',\n"
        else:
            if len(f"{value}") >= 50:
                field = f"`{key}` longtext DEFAULT NULL COMMENT '',\n"
            else:
                field = f"`{key}` varchar(128) DEFAULT NULL COMMENT '',\n"
        head += field
    print(head+end)

if __name__ == '__main__':
    null = None
    true = True
    false = False
    data = {"lastIndex":null,"custId":null,"result":{"location":null,"page":{"lastIndex":"15","pagesize":"20","lastPage":"1","itemtotal":"16","sort":[],"location":null,"sorted":false,"pageSize":"20","pagenum":"1","itemTotal":"16","pagetotal":"1","offset":"0","pageNum":"1"},"totalItem":"16","data":[{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=676835988580","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:8;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.024633494038408216;payCnt30d:4134;clk7d:2754;isOnline:1;customerCoverage:8;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220722200000;recruitIndexShopLevel:1;tmc_tags:100034998,34998;attractInshopPv:10;marketCoverage:8;quantity:7059;highUvValueIndex:6;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 1839426, 1987074, 2016386, 21762, 404546, 2133506, 21826, 25346, 2193730, 2008514, 1702530, 25282, 2248898, 281666, 1880514, 57026, 212546, 101762, 2030018, 531906, 1991874, 2165506, 1973186, 1846530, 285186, 1474370, 113602, 2021442, 2148034, 349570, 299394, 28802, 1789826, 1835010, 1835330, 2119618, 2185986, 1602178, 1900354, 2293954, 288386, 5826];payCnt7d:842;first_starts_time:1655973858234;itemRank:10;originalStatus:0;bidCount:3986;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122292001;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=676835988580","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"8","shopContributionIndexShopLevel":"1","clk7d":"2754","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"10","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"7059","tmc_tags":"100034998,34998","bidCount":"3986","highUvValueIndex":"6","payCnt7d":"842","salesLevel":"5","indirConvertion":"10","tags":["21762","1987074","1839426","2133506","1973186","1702530","1789826","25282","25346","2238722","212546","5826","288386","2248898","531906","2021442","1880514","2119618","113602","1835010","281666","285186","404546","2293954","1474370","1602178","1835330","2008514","2185986","2193730","1900354","1991874","2165506","101762","21826","299394","349570","1846530","57026","2030018","2148034","2016386","28802"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 122222008 122292001","indirConvertionShopLevel":"1","marketCoverage":"8","repurchaseIndex":"6","ctr7d":"0.024633494038408216","starts":"20220722200000","attractInshopPv":"10","first_starts_time":"1655973858234","payCnt30d":"4134","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"10"},"title":"丽芙甲硝唑凝胶用于炎症性丘疹酒渣鼻红斑修复甲硝唑消炎凝胶","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"676835988580","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-06-23 16:44:18","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 122222008 122292001","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:15825736;1989854:137503148;5919063:3266779;5919063:3266785;5919063:3266781;10543965:563694485;12060095:12020975944;15073217:7146152;124112492:11643345;127516969:565140599;127532776:66047117;127570025:66047117;127598100:9695512;128132720:26878;128150061:556774857;132268776:39583581;132270815:1327353772;132270815:1142524358;132270815:1327353771;132344540:1142524358;132344540:1327353772;132344540:1327353771","itemId":"676835988580","imgUrl":"//img.alicdn.com/imgextra/i2/2209842646673/O1CN010LstZk1zAHiQbZZOw_!!2209842646673.jpg","cateNamePath":null,"price":"41.7","tagNames":["优选好货"],"tagName":"","itemNumId":"676835988580","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=648410292248","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:9;highUvValueIndexShopLevel:1;salesLevel:3;indirConvertionShopLevel:1;ctr7d:0.0732824427480916;payCnt30d:84;clk7d:48;isOnline:1;customerCoverage:7;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725162221;recruitIndexShopLevel:1;tmc_tags:100034998,100033079,34882,100033077,100033970,100034867,100035071,34697,100034556,100033788,34635,100034618,34380,33745,100033506,100033705,33506,100033745,33705,33970,34867,100034882,33077,34998,33079,34618,100034380,34556,33788,100034635,35071,100034697;attractInshopPv:9;marketCoverage:7;quantity:298145;highUvValueIndex:7;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:8;tags:[2178754, 2285058, 2016386, 1391490, 1841346, 2124290, 61442, 249858, 2131266, 1834818, 225410, 143746, 2253186, 2057538, 2038978, 2021442, 2206082, 1977538, 2148034, 2043010, 139778, 349570, 10818, 1875650, 2122818, 2032642, 360386, 2230338, 1834946, 1522498, 1845314, 1841474, 288962, 1682818, 2052738, 2288706, 2288386, 1391874, 200002, 1879426, 2261186, 130, 296066, 25282, 120962, 258, 101762, 2140162, 1400514, 2018178, 346562, 1860674, 2288770, 2170242, 3394, 1799170, 1789826, 2028098, 2060994, 1999362, 1805634, 2201410, 1502082, 2181762, 2293954, 2230594, 2102466, 1882370, 388354, 2289730, 98242, 2132674, 2057730, 165186, 2028162, 57026, 413762, 1362178, 2131458, 2016450, 113602, 2286978, 1691586, 1967490, 46914, 1892226, 2289602, 2256706, 2119618, 444802, 1842882, 2230530, 2052674, 2254402, 2187842, 2238722, 2264898, 1508482, 2039042, 49218, 21442, 2304834, 2294274, 2254338, 2183298, 2223874, 2307266, 1904386, 2106882, 2141058, 2228354, 2106818, 292354, 1315394, 299394, 1834882, 28802, 1835330, 2111042, 2188354, 2254466, 1900354, 2256642, 1739842];payCnt7d:36;first_starts_time:1624341705421;itemRank:0;originalStatus:0;bidCount:6071;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125056015 125030021;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=648410292248","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"9","shopContributionIndexShopLevel":"1","clk7d":"48","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"298145","tmc_tags":"100034998,100033079,34882,100033077,100033970,100034867,100035071,34697,100034556,100033788,34635,100034618,34380,33745,100033506,100033705,33506,100033745,33705,33970,34867,100034882,33077,34998,33079,34618,100034380,34556,33788,100034635,35071,100034697","bidCount":"6071","highUvValueIndex":"7","payCnt7d":"36","salesLevel":"3","indirConvertion":"8","tags":["1860674","10818","2307266","1834818","46914","61442","2238722","2181762","1977538","1508482","2254338","2052674","2016450","165186","2230530","413762","1904386","2230594","2293954","1999362","2304834","2256642","2264898","2043010","2057730","388354","349570","57026","2032642","1400514","2228354","49218","1892226","2223874","2183298","2131266","2057538","2254402","2018178","25282","292354","288962","139778","143746","2178754","2106818","2106882","120962","2256706","2102466","2119618","2028098","1875650","1502082","1315394","2028162","1835330","2294274","1842882","2289730","2261186","101762","2060994","2039042","1841346","2289602","2254466","2288706","2141058","225410","1362178","1789826","1799170","2285058","2288386","249858","2052738","1391490","1682818","2188354","2021442","2131458","444802","113602","2253186","2288770","2206082","1739842","3394","1900354","346562","1841474","28802","98242","1522498","2122818","1805634","2201410","2286978","360386","1845314","296066","2230338","130","2132674","1834882","1879426","1691586","2124290","2140162","1391874","2187842","2111042","299394","21442","258","2038978","200002","1967490","1834946","2148034","2170242","2016386","1882370"],"customerCoverage":"7","isNew":true,"categoryId":"50026800 125046003 125056015 125030021","indirConvertionShopLevel":"1","marketCoverage":"7","repurchaseIndex":"8","ctr7d":"0.0732824427480916","starts":"20220725162221","attractInshopPv":"9","first_starts_time":"1624341705421","payCnt30d":"84","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"9","recruitIndex":"6"},"title":"雅塑白芸豆压片糖果奶片咀嚼片即食大餐伴侣正品官方旗舰店","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"648410292248","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2021-06-22 14:01:45","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"50026800 125046003 125056015 125030021","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:109899538;251734303:255930637;20759:30517;21299:72700378;24477:3493528;1627207:3232483;1627207:90554;1627207:3232479;1989873:4383965;12060095:7324852915;13521388:29407;15073217:3508415;122216443:7184472;122216962:3220625;128132720:3622544;224607339:21959","itemId":"648410292248","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01SPaOLg1zAHiHhHzeQ_!!2209842646673.jpg","cateNamePath":null,"price":"58.0","tagNames":["优选好货"],"tagName":"","itemNumId":"648410292248","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=669946716767","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:6;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.08056096813925148;payCnt30d:8528;clk7d:12362;isOnline:1;customerCoverage:7;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725112919;recruitIndexShopLevel:1;tmc_tags:100034998,34882,34867,100034882,100034867,34998,34697,34618,34635,100034618,100034635,100034697;attractInshopPv:10;marketCoverage:7;quantity:17302;highUvValueIndex:4;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2256450, 2256770, 1839426, 1987074, 2016386, 2255362, 61442, 388354, 21826, 2008514, 1702530, 2132674, 2266498, 1834818, 281666, 2203202, 531906, 143746, 413762, 2256578, 2254274, 2021442, 2286978, 2148034, 349570, 10818, 2256706, 2200066, 1834946, 2230338, 2119618, 2230530, 2254402, 2187842, 2238722, 1993730, 2264898, 21762, 49218, 21442, 2288706, 2133506, 2288386, 1879426, 2261186, 130, 2268610, 25282, 2294274, 2254338, 2223874, 2307266, 1904386, 212546, 101762, 1991874, 2165506, 1846530, 1474370, 107842, 2140290, 2228354, 1876482, 2288770, 299394, 3394, 1834882, 1799170, 28802, 1789826, 1835330, 2288578, 49282, 2288450, 2257858, 2201410, 2254466, 1602178, 1900354, 2293954, 2230594, 2256642, 288386];payCnt7d:5106;first_starts_time:1647833359101;itemRank:0;originalStatus:0;bidCount:9625;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=669946716767","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"6","shopContributionIndexShopLevel":"1","clk7d":"12362","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"17302","tmc_tags":"100034998,34882,34867,100034882,100034867,34998,34697,34618,34635,100034618,100034635,100034697","bidCount":"9625","highUvValueIndex":"4","payCnt7d":"5106","salesLevel":"5","indirConvertion":"10","tags":["10818","1993730","21762","2307266","1834818","2266498","1789826","1799170","61442","2238722","212546","2288386","288386","2254274","531906","2021442","2256578","2254338","2288770","281666","2230530","413762","2288578","1904386","2230594","2293954","2268610","2256642","3394","1900354","2165506","2264898","49282","21826","388354","349570","2228354","49218","107842","2223874","28802","1839426","1987074","2254402","2133506","1702530","25282","2201410","143746","2286978","2256706","2230338","2256450","2119618","130","2203202","2257858","2288450","2132674","1834882","1474370","1879426","1602178","1835330","2294274","2256770","2008514","2187842","2140290","1991874","2261186","101762","2255362","299394","1846530","21442","1876482","2200066","2148034","1834946","2254466","2288706","2016386"],"customerCoverage":"7","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"7","repurchaseIndex":"6","ctr7d":"0.08056096813925148","starts":"20220725112919","attractInshopPv":"10","first_starts_time":"1647833359101","payCnt30d":"8528","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"-1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"10"},"title":"易下开塞露20ml20支润肠通便含甘油男女便秘药老人儿童排宿便清肠","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"669946716767","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-03-21 11:29:19","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:1593776827;1989854:112360886;5919063:4421995;5919063:3266781;5919063:215302757;5919063:501970821;5919063:3266779;12060095:1398307585;12060620:85664865;12167949:556774857;15073217:557074379;124112492:96124062;127516969:561546620;127532776:567348895;127570025:567348895;127598100:9695512;128132720:26878;132268776:39583581;132270815:3403653;132344540:3403653","itemId":"669946716767","imgUrl":"//img.alicdn.com/imgextra/i3/2209842646673/O1CN01a5qumw1zAHiN7MeBC_!!0-item_pic.jpg","cateNamePath":null,"price":"32.0","tagNames":["优选好货"],"tagName":"","itemNumId":"669946716767","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=632741133617","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.025770434488397664;payCnt30d:4039;clk7d:914;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725155902;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:300682;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[1349954, 1839426, 1987074, 2016386, 2285570, 61442, 21826, 1702530, 2243010, 2131266, 225410, 143746, 2074818, 2038978, 1649602, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 10818, 360386, 2075010, 2230338, 1929730, 2185986, 1619266, 1974658, 21762, 1682818, 2288706, 1887682, 2074882, 1831682, 200002, 256130, 2261186, 130, 296066, 25282, 2225730, 120962, 1846018, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1478530, 1704322, 346562, 1860674, 2007618, 1648770, 2170242, 3394, 2028418, 1799170, 1870594, 1789826, 2028098, 1999362, 1805634, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2218882, 1902338, 2102466, 388354, 98242, 1651458, 2132674, 2208450, 504898, 2028162, 281666, 1823554, 57026, 1721538, 2030018, 531906, 413762, 1902466, 1797506, 2131458, 113602, 393794, 2026818, 1691586, 162690, 1892226, 1784834, 461442, 2291394, 2200066, 2119618, 2253954, 2230530, 1974466, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 2243074, 2294274, 452738, 2183298, 2223874, 1904386, 1624130, 212546, 1901314, 1902402, 2106882, 1474370, 1481986, 1838722, 2228354, 2106818, 2194114, 299394, 28802, 1835330, 2111042, 2158210, 2257858, 1900354, 288386];payCnt7d:413;first_starts_time:1607327942032;itemRank:0;originalStatus:0;bidCount:182228;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=632741133617","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"914","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"300682","tmc_tags":"100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697","bidCount":"182228","highUvValueIndex":"9","payCnt7d":"413","salesLevel":"5","indirConvertion":"10","tags":["1481986","1860674","21762","10818","2074818","2238722","61442","212546","2181762","531906","1478530","2243010","281666","2230530","413762","1904386","36610","2230594","1974658","2293954","1999362","2185986","1704322","1649602","2264898","1887682","1349954","2043010","21826","388354","349570","57026","1400514","2228354","49218","2225730","1929730","1846018","1892226","2223874","2183298","2131266","2133506","2074882","1702530","25282","1648770","1733890","1619266","139778","143746","2106818","2106882","120962","2208450","2102466","2119618","2028098","2257858","1974466","1998018","1502082","2028162","256130","1835330","2294274","1602178","2261186","101762","2039042","2218882","2288706","1902338","225410","2075010","2253954","1789826","1799170","1902402","2257922","2026818","1784834","393794","288386","1682818","2021442","2131458","2028418","113602","2206082","452738","461442","1624130","3394","1900354","2165506","346562","2030018","2194114","1823554","28802","1831682","98242","1987074","1839426","1870594","2243074","504898","1797506","2158210","1805634","2201410","1838722","360386","2291394","296066","2230338","2285570","2007618","1902466","130","162690","1651458","2132674","1474370","1691586","2140162","2187842","2111042","299394","21442","1846530","2200066","1721538","2038978","200002","1901314","2170242","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"9","ctr7d":"0.025770434488397664","starts":"20220725155902","attractInshopPv":"10","first_starts_time":"1607327942032","payCnt30d":"4039","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"6"},"title":"艾丽奥利司他胶囊减肥药正品瘦身减脂排油丸专用减肥旗舰OTC官网","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"632741133617","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2020-12-07 15:59:02","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4207810;1989854:118326715;5919063:59904168;5919063:79046194;5919063:3266785;5919063:501970821;5919063:3266781;5919063:215304499;5919063:215302757;12060095:1323180239;12060620:566000040;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:597878364;132344540:1327353185;132344540:13245856","itemId":"632741133617","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01OgHV6G1zAHiSXdLXM_!!2209842646673.jpg","cateNamePath":null,"price":"162.0","tagNames":["优选好货"],"tagName":"","itemNumId":"632741133617","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=678996882135","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:0;collectCartNum:7;highUvValueIndexShopLevel:1;salesLevel:2;indirConvertionShopLevel:1;ctr7d:0.027544544245055414;payCnt30d:232;clk7d:4327;isOnline:1;customerCoverage:7;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220722111519;recruitIndexShopLevel:1;tmc_tags:null;attractInshopPv:9;marketCoverage:6;quantity:14739;highUvValueIndex:6;coldSpeedingStatus:0;attractIndex:null;isNew:true;repurchaseIndex:5;tags:[2238722, 1987074, 2016386, 2264898, 21762, 2288386, 21826, 1702530, 25282, 2269122, 281666, 57026, 212546, 101762, 413762, 2165506, 1846530, 1474370, 346562, 2021442, 349570, 299394, 28802, 1789826, 1835330, 2288578, 2288450, 1602178, 1900354, 288386];payCnt7d:231;first_starts_time:1657854919693;itemRank:10;originalStatus:0;bidCount:253;repurchaseIndexShopLevel:0;categoryId:201273575 50023720 122222008 122290002;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=678996882135","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"7","shopContributionIndexShopLevel":"1","clk7d":"4327","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"10","salesLevelShopLevel":"0","attractIndex":null,"repurchaseIndexShopLevel":"0","coldSpeedingStatus":"0","quantity":"14739","tmc_tags":null,"bidCount":"253","highUvValueIndex":"6","payCnt7d":"231","salesLevel":"2","indirConvertion":"10","tags":["21762","1987074","1702530","25282","1789826","2238722","2288386","212546","288386","2021442","2269122","281666","413762","2288450","2288578","1474370","1602178","1835330","1900354","2264898","2165506","101762","346562","21826","57026","1846530","349570","299394","2016386","28802"],"customerCoverage":"7","isNew":true,"categoryId":"201273575 50023720 122222008 122290002","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"5","ctr7d":"0.027544544245055414","starts":"20220722111519","attractInshopPv":"9","first_starts_time":"1657854919693","payCnt30d":"232","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"10"},"title":"蔓迪米诺地尔酊曼迪斑秃 蔓迪米诺地尔旗舰店 米诺地尔汀蔓迪90ml","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"678996882135","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-07-15 11:15:19","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 122222008 122290002","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:3883772;1989854:111043625;5919063:3266779;5919063:3266785;5919063:3266781;10543965:875552307;12060095:836508051;15073217:557074379;124112492:11643345;127516969:12284560;127532776:48712647;127566068:3883772;127570025:19221189;127598100:6672878;128132720:3622544;128132720:4099916;128150061:556774857;132268776:39583581;132270815:7621826;132270815:3481322;132344540:185628909","itemId":"678996882135","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN019RvJ811zAHiTgHQHf_!!0-item_pic.jpg","cateNamePath":null,"price":"158.0","tagNames":["优选好货"],"tagName":"","itemNumId":"678996882135","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=649167506944","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.06097560975609756;payCnt30d:1464;clk7d:25;isOnline:1;customerCoverage:6;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:7;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220720100430;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,100035071,34635,100034618,33970,34867,100034882,34998,100033825,32024,34618,100034635,35071;attractInshopPv:8;marketCoverage:6;quantity:196171;highUvValueIndex:3;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:8;tags:[2178754, 2285058, 2016386, 1391490, 1841346, 2124290, 61442, 1562306, 2008514, 249858, 2131266, 1834818, 225410, 2253186, 2057538, 2038978, 2021442, 1977538, 2148034, 2043010, 139778, 349570, 10818, 1875650, 2122818, 2032642, 360386, 2230338, 1834946, 2119938, 1845314, 1841474, 2120002, 1362242, 2238210, 1682818, 2052738, 2288706, 404546, 2064962, 2193730, 1879426, 2261186, 130, 296066, 25282, 120962, 258, 101762, 2140162, 1733890, 2165506, 1400514, 2018178, 2098306, 1860674, 2007618, 2170242, 3394, 2064834, 2119874, 1799170, 1789826, 2028098, 2060994, 1805634, 2201410, 1602178, 1502082, 2293954, 2230594, 2102466, 1882370, 388354, 2289730, 98242, 2132674, 2057730, 165186, 2028162, 57026, 1362178, 2131458, 2016450, 113602, 2064770, 2064898, 46914, 162690, 1892226, 2289602, 2256706, 2119618, 2253954, 444802, 1842882, 2230530, 2052674, 2254402, 2187842, 2238722, 2039042, 49218, 2133506, 2240002, 2304834, 2294274, 2254338, 2223874, 1904386, 2106818, 292354, 299394, 1834882, 28802, 1835330, 2111042, 2223106, 2158210, 2188354, 2254466, 1900354, 2256642, 1739842];payCnt7d:643;first_starts_time:1624340740894;itemRank:0;originalStatus:0;bidCount:4525;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125056015 125030021;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=649167506944","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"25","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"196171","tmc_tags":"100034998,33825,34882,100033970,100034867,100035071,34635,100034618,33970,34867,100034882,34998,100033825,32024,34618,100034635,35071","bidCount":"4525","highUvValueIndex":"3","payCnt7d":"643","salesLevel":"5","indirConvertion":"7","tags":["1860674","10818","2120002","1834818","46914","2119874","2238722","2119938","61442","1977538","2254338","2052674","2016450","165186","2230530","2238210","1904386","2230594","2293954","2304834","1562306","2256642","2193730","2043010","2064834","2057730","388354","349570","57026","2032642","1400514","49218","1892226","2223874","2131266","2254402","2057538","2133506","2018178","25282","1733890","292354","139778","2178754","2106818","120962","2256706","2102466","2119618","2028098","2064962","1875650","404546","1502082","2028162","1835330","2294274","1602178","1842882","2289730","2261186","101762","2060994","2039042","1841346","2289602","2064770","2254466","2288706","225410","1362178","2253954","1789826","1799170","2223106","2285058","2240002","249858","2052738","1391490","1682818","2188354","2021442","2131458","444802","113602","2253186","1739842","3394","1900354","2165506","1841474","28802","98242","2122818","2158210","2064898","2098306","1805634","2201410","360386","1362242","1845314","296066","2230338","2007618","130","162690","2132674","1834882","1879426","2124290","2140162","2008514","2187842","2111042","299394","258","2038978","1834946","2148034","2170242","2016386","1882370"],"customerCoverage":"6","isNew":true,"categoryId":"50026800 125046003 125056015 125030021","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"8","ctr7d":"0.06097560975609756","starts":"20220720100430","attractInshopPv":"8","first_starts_time":"1624340740894","payCnt30d":"1464","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"-1","marketCoverageShopLevel":"1","shopContributionIndex":"8","recruitIndex":"7"},"title":"【餐前2片 开袋即赠】雅塑白芸豆压片糖果奶片咀嚼片大餐伴侣抑制","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"649167506944","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2021-06-22 13:45:40","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"50026800 125046003 125056015 125030021","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:109899538;251734303:255930637;20759:30517;21299:72700378;24477:3493528;1627207:3232483;1627207:3232484;1989873:4383965;12060095:7324852915;13521388:29407;15073217:3508415;122216443:45701862;122216962:3220625;128132720:3622544;224607339:21959","itemId":"649167506944","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN0116WrDo1zAHiSB5JEi_!!2209842646673.jpg","cateNamePath":null,"price":"49.0","tagNames":["优选好货"],"tagName":"","itemNumId":"649167506944","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=669455525806","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:5;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.022102104853301573;payCnt30d:1811;clk7d:965;isOnline:1;customerCoverage:7;recruitIndex:9;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220721160213;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:102645;highUvValueIndex:4;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2256450, 2256770, 1839426, 1987074, 2016386, 2255362, 61442, 21826, 2289730, 2008514, 1702530, 2132674, 2266498, 2208450, 1834818, 281666, 57026, 2203202, 531906, 143746, 413762, 2256578, 2254274, 2289090, 113602, 2021442, 2206082, 2286978, 1977858, 2148034, 2043010, 139778, 393794, 349570, 10818, 2289602, 360386, 2256706, 2200066, 1834946, 2230338, 2119618, 2185986, 2230530, 2254402, 2187842, 1952450, 2238722, 21762, 49218, 21442, 2288706, 2133506, 2288386, 1879426, 200002, 2261186, 130, 25282, 2294274, 2225730, 2254338, 2223874, 1904386, 212546, 101762, 2257922, 1991874, 1733890, 2165506, 1846530, 1474370, 346562, 107842, 2140290, 2228354, 2288770, 299394, 3394, 1799170, 1834882, 28802, 1789826, 1835330, 2288578, 49282, 2288450, 2257858, 2201410, 2254466, 1602178, 1502082, 2293954, 2230594, 2256642, 288386];payCnt7d:570;first_starts_time:1646294533087;itemRank:0;originalStatus:0;bidCount:5747;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:0","displayUrl":"http://detail.tmall.com/item.htm?id=669455525806","extraAttributes":{"collectCartNumShopLevel":"0","recruitIndexShopLevel":"1","collectCartNum":"5","shopContributionIndexShopLevel":"1","clk7d":"965","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"102645","tmc_tags":"100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697","bidCount":"5747","highUvValueIndex":"4","payCnt7d":"570","salesLevel":"5","indirConvertion":"10","tags":["21762","10818","1834818","2266498","1789826","1799170","2257922","61442","2238722","212546","2288386","393794","288386","2254274","531906","2256578","2021442","2254338","113602","2288770","281666","2230530","413762","2206082","2288578","1904386","2230594","2293954","2256642","2185986","3394","2165506","49282","2043010","346562","21826","57026","349570","2228354","49218","2225730","2289090","107842","2223874","1952450","28802","1839426","1987074","2254402","2133506","1702530","25282","1733890","2201410","139778","143746","2286978","360386","2256706","2208450","2230338","2256450","2119618","130","2203202","2257858","2288450","1977858","1502082","2132674","1834882","1474370","1879426","1602178","1835330","2294274","2256770","2008514","2187842","2140290","2289730","1991874","2261186","101762","2255362","299394","1846530","21442","2289602","2200066","200002","2148034","1834946","2254466","2288706","2016386"],"customerCoverage":"7","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"6","ctr7d":"0.022102104853301573","starts":"20220721160213","attractInshopPv":"10","first_starts_time":"1646294533087","payCnt30d":"1811","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"-1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"9"},"title":"江中牌健胃消食片肠胃调理消化不良腹胀气积食乳酸菌素片养胃调胃","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"669455525806","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-03-03 16:02:13","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:3230013;1989854:69653604;5919063:79046194;5919063:3266779;5919063:3266781;5919063:3266789;5919063:3266785;12060095:7827527;12060620:571698732;12167949:3312861;15073217:3508415;124112492:3364499;127516969:48909577;127532776:7279871;127566068:562948962;127570025:471279828;127598100:6672878;128132720:26878;132268776:39583581;132270815:11666823;132344540:182776368;132344540:1327353059;132344540:11666823;132344540:434188979","itemId":"669455525806","imgUrl":"//img.alicdn.com/imgextra/i4/2209842646673/O1CN01zaIUr31zAHiM7lqcA_!!0-item_pic.jpg","cateNamePath":null,"price":"59.0","tagNames":["优选好货"],"tagName":"","itemNumId":"669455525806","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=632740201606","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:6;indirConvertionShopLevel:1;ctr7d:0.02033340808851013;payCnt30d:34498;clk7d:544;isOnline:1;customerCoverage:9;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220720235800;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:190685;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 1349954, 1839426, 2016386, 61442, 21826, 1702530, 2243010, 2131266, 2165442, 2269122, 225410, 143746, 2254274, 2038978, 1649602, 2021442, 1998018, 2206082, 2148034, 2043010, 139778, 349570, 10818, 1899458, 360386, 2075010, 2230338, 1929730, 2119938, 2185986, 2120002, 1817218, 1619266, 1974658, 21762, 2288706, 1887682, 1818306, 404546, 2074882, 2064962, 200002, 2261186, 130, 296066, 25282, 2225730, 120962, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1704322, 2098306, 2178882, 2170242, 3394, 2064834, 2119874, 1799170, 1789826, 2028098, 2201410, 15810, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2218882, 1902338, 2102466, 388354, 98242, 2132674, 2208450, 504898, 2028162, 281666, 57026, 531906, 413762, 1902466, 2131458, 113602, 2064770, 393794, 2064898, 162690, 1892226, 2291394, 2119618, 1998210, 2230530, 2254402, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 96002, 2243074, 2294274, 2254338, 2183298, 2223874, 1904386, 1624130, 212546, 1901314, 2106882, 1474370, 1481986, 2228354, 2106818, 299394, 28802, 1835330, 2111042, 2158210, 2188354, 2257858, 2254466, 1900354, 288386];payCnt7d:612;first_starts_time:1607327774330;itemRank:0;originalStatus:0;bidCount:71560;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=632740201606","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"544","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"190685","tmc_tags":"100034998,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,32024,34618,100034380,34556,100034635,100034697","bidCount":"71560","highUvValueIndex":"9","payCnt7d":"612","salesLevel":"6","indirConvertion":"8","tags":["1481986","21762","10818","2120002","2119874","2238722","2119938","61442","212546","2181762","2254274","531906","2269122","2243010","2254338","281666","2230530","413762","1904386","36610","2230594","1974658","2293954","2185986","1704322","1649602","2264898","1887682","1349954","2043010","2064834","21826","388354","349570","57026","1400514","2228354","49218","2225730","1929730","1892226","2223874","2183298","2131266","2254402","2133506","2074882","1702530","25282","96002","2165442","1817218","1733890","1619266","139778","143746","2178754","2106818","2106882","120962","2208450","2102466","2119618","2028098","2064962","2257858","1998018","404546","1502082","2028162","1835330","2294274","1602178","2261186","101762","2039042","2218882","2064770","2254466","2288706","1902338","225410","2075010","1789826","1799170","2178882","2257922","393794","288386","2188354","2021442","2131458","113602","15810","1998210","2206082","1624130","3394","1900354","2165506","28802","1818306","98242","1839426","2243074","504898","2158210","2064898","2098306","2201410","360386","296066","2291394","2230338","1902466","130","162690","2132674","1474370","2140162","2187842","2111042","299394","21442","1846530","2038978","200002","1901314","2148034","2170242","1899458","2016386"],"customerCoverage":"9","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"9","ctr7d":"0.02033340808851013","starts":"20220720235800","attractInshopPv":"10","first_starts_time":"1607327774330","payCnt30d":"34498","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"9","recruitIndex":"7"},"title":"艾丽奥利司他胶囊减肥药正品瘦身减肥旗舰排油丸减脂专用OTC官网","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"632740201606","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2020-12-07 15:56:14","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4207810;1989854:118326715;5919063:3266786;5919063:124062536;5919063:206264795;5919063:3284566;5919063:3266781;5919063:3284565;12060095:1323180239;12060620:653196795;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:13245856","itemId":"632740201606","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01p0oN3I1zAHiQsaVxz_!!2209842646673.jpg","cateNamePath":null,"price":"87.0","tagNames":["优选好货"],"tagName":"","itemNumId":"632740201606","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=633364711648","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.014876607577337504;payCnt30d:7675;clk7d:214;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:9;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725155656;recruitIndexShopLevel:1;tmc_tags:33825,100032949,100033745,100033150,100034556,100034618,100032762,100032697,33745,33172,32949,800132676,100033825,32024,32697,34618,800132939,32762,34556,33150;attractInshopPv:10;marketCoverage:6;quantity:149884;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[1349954, 1839426, 2016386, 21826, 1702530, 225410, 143746, 1649602, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 360386, 2075010, 1929730, 1619266, 1974658, 21762, 1682818, 2288706, 2180418, 1887682, 2074882, 200002, 2261186, 25282, 2225730, 120962, 1846018, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1478530, 1704322, 2007618, 1648770, 2028418, 1799170, 1870594, 1789826, 2028098, 1999362, 1805634, 2201410, 1602178, 36610, 1502082, 2181762, 1902338, 388354, 2289730, 98242, 2132674, 2208450, 504898, 2028162, 281666, 57026, 531906, 413762, 1902466, 1797506, 113602, 393794, 2026818, 1691586, 162690, 1892226, 1784834, 2289602, 2119618, 2254402, 2187842, 1301314, 21442, 2133506, 2294274, 2183298, 2223874, 2307266, 1904386, 1624130, 2008450, 212546, 1901314, 1902402, 2106882, 1474370, 1481986, 1838722, 2194114, 299394, 28802, 1835330, 2158210, 2257858, 1900354, 288386];payCnt7d:192;first_starts_time:1607327816298;itemRank:0;originalStatus:0;bidCount:102739;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=633364711648","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"214","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"149884","tmc_tags":"33825,100032949,100033745,100033150,100034556,100034618,100032762,100032697,33745,33172,32949,800132676,100033825,32024,32697,34618,800132939,32762,34556,33150","bidCount":"102739","highUvValueIndex":"9","payCnt7d":"192","salesLevel":"5","indirConvertion":"9","tags":["1481986","21762","2307266","212546","2181762","531906","1478530","281666","413762","1904386","36610","1974658","1999362","2180418","1704322","1649602","2043010","1349954","1887682","21826","388354","349570","57026","1400514","2225730","1929730","1846018","1892226","2223874","2183298","2254402","2133506","2074882","1702530","25282","1648770","1733890","1619266","139778","143746","120962","2106882","2208450","2119618","2028098","2257858","1998018","1502082","2028162","1835330","1602178","2294274","2289730","2261186","101762","2289602","2288706","1902338","225410","2075010","1789826","1799170","2257922","2026818","1902402","393794","1784834","288386","1682818","2021442","2028418","113602","2206082","1624130","1900354","2165506","2194114","28802","98242","1839426","1870594","504898","1797506","2158210","1805634","2201410","1838722","360386","2007618","1902466","162690","2132674","1691586","1474370","2140162","2187842","299394","1846530","21442","2008450","200002","1301314","1901314","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"6","repurchaseIndex":"9","ctr7d":"0.014876607577337504","starts":"20220725155656","attractInshopPv":"10","first_starts_time":"1607327816298","payCnt30d":"7675","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"6"},"title":"艾丽奥利司他胶囊减肥药正品排油丸瘦身减肥减脂专用OTC官网","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"633364711648","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2020-12-07 15:56:56","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4207810;1989854:118326715;5919063:79046194;5919063:3284567;5919063:3266785;12060095:1323180239;12060620:592182279;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:13245856","itemId":"633364711648","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01aizxbR1zAHhsEJa3i_!!0-item_pic.jpg","cateNamePath":null,"price":"350.0","tagNames":["优选好货"],"tagName":"","itemNumId":"633364711648","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=666149018128","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:4;indirConvertionShopLevel:1;ctr7d:0.008975797403430037;payCnt30d:143;clk7d:56;isOnline:1;customerCoverage:8;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220726154814;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,33705,100034556,100033788,34635,100034618,34380,33970,34867,100034882,34998,100033825,34618,100034380,34556,33788,100034635,100034697,100033705;attractInshopPv:9;marketCoverage:5;quantity:231285;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 2016386, 61442, 388354, 21826, 2234946, 98242, 2132674, 2131266, 2208450, 2269122, 281666, 57026, 531906, 143746, 413762, 2131458, 113602, 1998018, 2021442, 2206082, 1977858, 2148034, 2043010, 139778, 393794, 2026818, 349570, 10818, 360386, 2230338, 2119618, 2185986, 2230530, 1974466, 2187842, 1952450, 2238722, 21762, 49218, 21442, 2288706, 2133506, 404546, 2205762, 2193730, 200002, 2261186, 130, 25282, 2294274, 120962, 2225730, 2183298, 2223874, 1904386, 212546, 101762, 1733890, 2165506, 1474370, 346562, 2228354, 1648770, 2170242, 2194114, 299394, 2028418, 3394, 1799170, 28802, 1789826, 1835330, 2158210, 2257858, 2188354, 2201410, 1602178, 36610, 1502082, 2181762, 1900354, 2293954, 2230594, 288386];payCnt7d:28;first_starts_time:1641282494425;itemRank:0;originalStatus:0;bidCount:24533;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=666149018128","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"56","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"231285","tmc_tags":"100034998,33825,34882,100033970,100034867,34697,33705,100034556,100033788,34635,100034618,34380,33970,34867,100034882,34998,100033825,34618,100034380,34556,33788,100034635,100034697,100033705","bidCount":"24533","highUvValueIndex":"8","payCnt7d":"28","salesLevel":"4","indirConvertion":"8","tags":["10818","21762","1789826","1799170","61442","2026818","2238722","212546","393794","2181762","288386","531906","2188354","2021442","2131458","2028418","2269122","113602","281666","2230530","2206082","413762","1904386","2230594","36610","2293954","2185986","3394","2193730","1900354","2165506","2043010","346562","21826","388354","57026","349570","2194114","2228354","49218","2225730","2223874","1952450","28802","2183298","98242","2131266","2133506","25282","1648770","2158210","1733890","2201410","139778","143746","2178754","360386","120962","2208450","2230338","2119618","130","2257858","1998018","1974466","1977858","404546","1502082","2132674","1474370","1602178","1835330","2294274","2187842","2261186","101762","2205762","299394","2234946","21442","200002","2148034","2170242","2288706","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"9","ctr7d":"0.008975797403430037","starts":"20220726154814","attractInshopPv":"9","first_starts_time":"1641282494425","payCnt30d":"143","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"9","recruitIndex":"7"},"title":"雅塑奥利司他胶囊排油减脂减重瘦身国药准字减肥排油丸官方正品M","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"666149018128","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-01-04 15:48:14","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:109899538;1989854:589308221;5919063:3284566;5919063:215312402;5919063:59904168;5919063:3266779;5919063:3266785;12060095:12517140963;12060620:616524261;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:4383965;128132720:3622544;132268776:39583581;132270815:597878364;132344540:13245856","itemId":"666149018128","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01VeZC9S1zAHiPArnJd_!!2209842646673.jpg","cateNamePath":null,"price":"120.0","tagNames":["优选好货"],"tagName":"","itemNumId":"666149018128","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=678689909500","qualityflag":null,"tagUrls":[{"tagType":"1","cls":"border-green","location":null,"name":"新品","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:0;collectCartNum:6;highUvValueIndexShopLevel:0;salesLevel:2;indirConvertionShopLevel:1;ctr7d:0.01065429393822228;payCnt30d:671;clk7d:248;isOnline:1;customerCoverage:7;recruitIndex:8;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220722104309;recruitIndexShopLevel:1;tmc_tags:null;attractInshopPv:6;marketCoverage:5;quantity:9322;highUvValueIndex:5;coldSpeedingStatus:0;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 2016386, 2264898, 21762, 61442, 2288386, 21826, 1879426, 130, 25282, 1834818, 2289154, 101762, 2165506, 2289090, 346562, 113602, 2021442, 2148034, 349570, 10818, 2288770, 3394, 299394, 1834882, 28802, 1789826, 1835330, 2288578, 1834946, 2288450, 1602178, 1900354, 288386];payCnt7d:666;first_starts_time:1657852989135;itemRank:9;originalStatus:0;bidCount:113;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122294001;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=678689909500","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"6","shopContributionIndexShopLevel":"1","clk7d":"248","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"9","salesLevelShopLevel":"0","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"0","quantity":"9322","tmc_tags":null,"bidCount":"113","highUvValueIndex":"5","payCnt7d":"666","salesLevel":"2","indirConvertion":"10","tags":["21762","10818","1834818","1789826","25282","61442","2238722","2289154","2288386","288386","2021442","113602","130","2288770","2288450","2288578","1834882","1879426","1602178","1835330","3394","1900354","2264898","2165506","101762","346562","21826","349570","299394","2289090","1834946","2148034","2016386","28802"],"customerCoverage":"7","isNew":true,"categoryId":"201273575 50023720 122222008 122294001","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"6","ctr7d":"0.01065429393822228","starts":"20220722104309","attractInshopPv":"6","first_starts_time":"1657852989135","payCnt30d":"671","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"0","marketCoverageShopLevel":"1","shopContributionIndex":"8","recruitIndex":"8"},"title":"九芝堂足光散40g*3袋除脚气真菌感染非联苯笇唑喷雾止痒泡脚水","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"678689909500","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-07-15 10:43:09","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 122222008 122294001","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4404049;1989854:108922326;5919063:3266779;5919063:3266785;5919063:3266781;5919063:3266789;5919063:3284565;10543965:526160045;12060095:108922327;15073217:153312597;124112492:11643345;127516969:567218684;127532776:6158023;127566068:562654187;127570025:1081021068;127598100:6672878;128132720:3622544;128150061:556774857;132268776:39583581;132270815:24231493;132344540:24231493","itemId":"678689909500","imgUrl":"//img.alicdn.com/imgextra/i1/2209842646673/O1CN01eCX6i01zAHiLhO2MH_!!0-item_pic.jpg","cateNamePath":null,"price":"38.7","tagNames":["新品"],"tagName":"","itemNumId":"678689909500","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=641208298202","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:3;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.044738281055823434;payCnt30d:1031;clk7d:900;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220726144259;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:5;quantity:228835;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 1839426, 2017474, 1987074, 2016386, 61442, 21826, 1702530, 2131266, 2266498, 2165442, 2269122, 225410, 143746, 2074818, 2038978, 2289090, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 10818, 360386, 2230338, 2204226, 2119938, 2185986, 2120002, 2017346, 1619266, 1974658, 21762, 2017410, 2288706, 1887682, 2288386, 2064962, 200002, 2261186, 130, 296066, 25282, 2225730, 120962, 2257922, 101762, 2140162, 1991874, 1733890, 2165506, 1846530, 2098306, 346562, 1860674, 2007618, 1648770, 2288770, 2170242, 3394, 2028418, 2159746, 2064834, 2119874, 1799170, 1789826, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2102466, 388354, 98242, 2132674, 2208450, 281666, 57026, 2203202, 531906, 413762, 2131458, 113602, 2286978, 1977858, 2064770, 393794, 2026818, 2064898, 1967490, 162690, 1892226, 2200066, 2119618, 2253954, 2230530, 1974466, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 2205762, 2243074, 2294274, 2183298, 2223874, 2307266, 1904386, 212546, 2017218, 1901314, 2106882, 1474370, 2017282, 107842, 2228354, 2251906, 2106818, 2194114, 299394, 28802, 1835330, 2288578, 2111042, 2158210, 2288450, 2188354, 2257858, 2017602, 1900354, 288386];payCnt7d:160;first_starts_time:1616747238157;itemRank:0;originalStatus:0;bidCount:57205;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=641208298202","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"3","shopContributionIndexShopLevel":"1","clk7d":"900","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"228835","tmc_tags":"100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697","bidCount":"57205","highUvValueIndex":"9","payCnt7d":"160","salesLevel":"5","indirConvertion":"10","tags":["1860674","21762","10818","2307266","2120002","2074818","2119874","2238722","2119938","61442","212546","2181762","531906","2269122","281666","2230530","413762","1904386","36610","2230594","1974658","2293954","2185986","2264898","1887682","2043010","2064834","21826","388354","2017602","349570","57026","2228354","49218","2225730","2204226","1892226","2223874","2183298","2131266","2133506","1702530","25282","1648770","2251906","2165442","1733890","1619266","139778","143746","2178754","2106818","2106882","120962","2208450","2102466","2119618","2064962","2257858","1974466","1998018","2288450","1502082","1835330","2294274","1602178","2017346","2261186","101762","2205762","2039042","2064770","2288706","225410","2266498","2253954","1789826","1799170","2017474","2257922","2026818","2288386","393794","288386","2188354","2021442","2131458","2028418","113602","2288770","2206082","2288578","3394","1900354","2165506","346562","2159746","2194114","2289090","107842","28802","98242","1987074","1839426","2243074","2158210","2064898","2098306","2017218","2201410","2286978","360386","296066","2230338","2007618","130","2203202","162690","2017282","1977858","2132674","1474370","2140162","2187842","1991874","2111042","299394","21442","1846530","2200066","2038978","200002","1967490","1901314","2017410","2170242","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"9","ctr7d":"0.044738281055823434","starts":"20220726144259","attractInshopPv":"10","first_starts_time":"1616747238157","payCnt30d":"1031","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"10","recruitIndex":"6"},"title":"艾丽奥利司他胶囊瘦身减肥药正品排油丸减脂瘦身减肥旗舰OTC官网","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"641208298202","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2021-03-26 16:27:18","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4207810;1989854:589308221;5919063:3284567;5919063:205594680;5919063:206268731;5919063:215302757;5919063:3266789;12060095:1323180239;12060620:1000230913;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132344540:13245856","itemId":"641208298202","imgUrl":"//img.alicdn.com/imgextra/i3/2209842646673/O1CN01UwZ6Br1zAHiQ0W6jj_!!0-item_pic.jpg","cateNamePath":null,"price":"158.0","tagNames":["优选好货"],"tagName":"","itemNumId":"641208298202","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=668184440050","qualityflag":null,"tagUrls":[],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:4;indirConvertionShopLevel:1;ctr7d:0.015173067804646752;payCnt30d:119;clk7d:32;isOnline:1;customerCoverage:9;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:7;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220720082701;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:9;marketCoverage:5;quantity:42913;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:10;tags:[2016386, 61442, 21826, 48706, 2132674, 2208450, 1834818, 2269122, 2203202, 143746, 113602, 1998018, 2021442, 2206082, 1977858, 2148034, 2043010, 139778, 349570, 10818, 360386, 1834946, 2230338, 2119618, 2253954, 2185986, 2230530, 2187842, 2238722, 21762, 49218, 21442, 2288706, 404546, 2205762, 2193730, 1879426, 200002, 2261186, 130, 25282, 2294274, 2225730, 2183298, 2223874, 1904386, 101762, 1733890, 346562, 107842, 2228354, 299394, 3394, 1834882, 1799170, 28802, 1789826, 1835330, 2257858, 2201410, 1602178, 1502082, 1900354, 2293954, 2230594, 288386];payCnt7d:9;first_starts_time:1645085937585;itemRank:0;originalStatus:0;bidCount:14299;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=668184440050","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"4","shopContributionIndexShopLevel":"1","clk7d":"32","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"42913","tmc_tags":"100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697","bidCount":"14299","highUvValueIndex":"9","payCnt7d":"9","salesLevel":"4","indirConvertion":"7","tags":["10818","21762","1834818","2253954","1789826","1799170","61442","2238722","288386","2021442","2269122","113602","2230530","2206082","1904386","2230594","2293954","2185986","3394","2193730","1900354","2043010","346562","21826","349570","2228354","49218","2225730","107842","2223874","28802","2183298","25282","1733890","2201410","139778","143746","360386","2208450","2230338","2119618","130","2203202","2257858","1998018","1977858","404546","1502082","48706","2132674","1834882","1879426","1602178","1835330","2294274","2187842","2261186","101762","2205762","299394","21442","200002","1834946","2148034","2288706","2016386"],"customerCoverage":"9","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"10","ctr7d":"0.015173067804646752","starts":"20220720082701","attractInshopPv":"9","first_starts_time":"1645085937585","payCnt30d":"119","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"8","recruitIndex":"6"},"title":"赛洛兰奥利司他减肥胶囊正品排油丸减肥治疗肥胖减重瘦身脂肪nn","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"668184440050","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-02-17 16:18:57","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:1878075452;1989854:589308221;5919063:3266785;5919063:3266781;5919063:3266789;5919063:3266786;5919063:3284566;12060095:159606431;12060620:1006794461;12167949:556774857;15073217:3313463;124112492:3364499;127516969:14619650662;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:1081806004;132270815:1327353185;132344540:597878364;132344540:1327353185;132344540:13245856","itemId":"668184440050","imgUrl":"//img.alicdn.com/imgextra/i2/2209842646673/O1CN01KasC0N1zAHiKeiyEQ_!!0-item_pic.jpg","cateNamePath":null,"price":"180.0","tagNames":[],"tagName":"","itemNumId":"668184440050","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=655875932971","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:0;collectCartNum:6;highUvValueIndexShopLevel:1;salesLevel:2;indirConvertionShopLevel:-1;ctr7d:0.024024024024024024;payCnt30d:28;clk7d:48;isOnline:1;customerCoverage:8;recruitIndex:9;customerCoverageShopLevel:1;shopContributionIndexShopLevel:-1;marketCoverageShopLevel:1;indirConvertion:3;attractInshopPvShopLevel:-1;shopContributionIndex:4;starts:20220720103832;recruitIndexShopLevel:1;tmc_tags:100034998,100033079,34882,100033970,100034867,100033150,100035071,100034556,34635,100034618,33745,100033506,100033825,100033705,33825,33506,100033745,33705,33970,34867,100034882,34998,33079,34618,34556,100034635,33150,35071;attractInshopPv:4;marketCoverage:5;quantity:14957;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:7;tags:[2016386, 61442, 388354, 98242, 249858, 2132674, 2131266, 165186, 1834818, 2028162, 225410, 57026, 2038978, 2016450, 113602, 2021442, 1998018, 2206082, 2064770, 2043010, 139778, 1691586, 10818, 46914, 1875650, 360386, 2304642, 1834946, 2230338, 2119618, 2119938, 2120002, 2230530, 2254402, 2238722, 2264898, 1682818, 49218, 2288386, 2240002, 1879426, 130, 296066, 2304834, 25282, 2294274, 120962, 258, 2183298, 2223874, 101762, 2140162, 2018178, 2098306, 2106818, 292354, 2170242, 299394, 3394, 2119874, 1834882, 1799170, 28802, 1789826, 1835330, 2288578, 2028098, 2111042, 2158210, 1805634, 2288450, 2257858, 1602178, 1502082, 1900354, 2293954, 2230594, 1739842];payCnt7d:5;first_starts_time:1632967314494;itemRank:0;originalStatus:0;bidCount:197;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125076012 125100024;collectCartNumShopLevel:1","displayUrl":"http://detail.tmall.com/item.htm?id=655875932971","extraAttributes":{"collectCartNumShopLevel":"1","recruitIndexShopLevel":"1","collectCartNum":"6","shopContributionIndexShopLevel":"-1","clk7d":"48","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"0","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"14957","tmc_tags":"100034998,100033079,34882,100033970,100034867,100033150,100035071,100034556,34635,100034618,33745,100033506,100033825,100033705,33825,33506,100033745,33705,33970,34867,100034882,34998,33079,34618,34556,100034635,33150,35071","bidCount":"197","highUvValueIndex":"8","payCnt7d":"5","salesLevel":"2","indirConvertion":"3","tags":["225410","10818","2120002","46914","1834818","1789826","1799170","2119874","61442","2119938","2238722","2240002","2288386","249858","1682818","2021442","113602","2016450","165186","2230530","2206082","2288578","2230594","2293954","2304834","1739842","3394","1900354","2264898","2043010","388354","57026","49218","2223874","28802","2183298","98242","2131266","2254402","2018178","25282","2158210","1805634","2098306","292354","139778","360386","2106818","2304642","120962","296066","2230338","2119618","2028098","130","2257858","1875650","1998018","2288450","1502082","2132674","1834882","1691586","1879426","2028162","1602178","1835330","2140162","2294274","2111042","101762","299394","2064770","2038978","258","1834946","2170242","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"50026800 125046003 125076012 125100024","indirConvertionShopLevel":"-1","marketCoverage":"5","repurchaseIndex":"7","ctr7d":"0.024024024024024024","starts":"20220720103832","attractInshopPv":"4","first_starts_time":"1632967314494","payCnt30d":"28","attractInshopPvShopLevel":"-1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"4","recruitIndex":"9"},"title":"太极睡好片助改善失眠深度睡眠片退褪黑色素片定眠官方正品","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"655875932971","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2021-09-30 10:01:54","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"50026800 125046003 125076012 125100024","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:1863363448;256289359:564214112;20759:29404;21299:72700378;24477:3493528;1627207:3232484;1627207:3232482;1627207:28340;1989873:6672878;12060095:136232626;15073217:3508415;122216443:6455433785;122216962:3220625;128132720:3622544;222264532:10257350;224607339:21958;228679447:93968215;231463732:3228288","itemId":"655875932971","imgUrl":"//img.alicdn.com/imgextra/i4/2209842646673/O1CN01vc8laS1zAHiHhF2dT_!!2209842646673.jpg","cateNamePath":null,"price":"108.0","tagNames":["优选好货"],"tagName":"","itemNumId":"655875932971","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=677308780627","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:5;highUvValueIndexShopLevel:1;salesLevel:3;indirConvertionShopLevel:1;ctr7d:0.016644208688390807;payCnt30d:145;clk7d:877;isOnline:1;customerCoverage:8;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725102333;recruitIndexShopLevel:1;tmc_tags:100034998,34998;attractInshopPv:8;marketCoverage:5;quantity:25055;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 2016386, 2264898, 21762, 21442, 2288386, 21826, 200002, 1702530, 2132674, 25282, 2269122, 2289154, 1904386, 101762, 143746, 2165506, 1846530, 2289090, 346562, 113602, 2021442, 2148034, 349570, 10818, 2288770, 299394, 28802, 1789826, 1835330, 2288578, 2288450, 2201410, 1602178, 1900354, 2293954, 2187842, 288386];payCnt7d:92;first_starts_time:1656572881306;itemRank:10;originalStatus:0;bidCount:143;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122294001;collectCartNumShopLevel:0","displayUrl":"http://detail.tmall.com/item.htm?id=677308780627","extraAttributes":{"collectCartNumShopLevel":"0","recruitIndexShopLevel":"1","collectCartNum":"5","shopContributionIndexShopLevel":"1","clk7d":"877","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"10","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"25055","tmc_tags":"100034998,34998","bidCount":"143","highUvValueIndex":"8","payCnt7d":"92","salesLevel":"3","indirConvertion":"10","tags":["10818","21762","1702530","1789826","25282","2238722","2288386","2289154","2201410","143746","288386","2021442","2269122","113602","2288770","2288450","2288578","1904386","2132674","2293954","1602178","1835330","2187842","1900354","2264898","2165506","101762","346562","21826","299394","21442","1846530","349570","2289090","200002","2148034","2016386","28802"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 122222008 122294001","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"6","ctr7d":"0.016644208688390807","starts":"20220725102333","attractInshopPv":"8","first_starts_time":"1656572881306","payCnt30d":"145","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"9","recruitIndex":"10"},"title":"洛芙 联苯苄唑溶液60ml 去脚气喷雾搽剂止痒脱皮脚臭香港脚手足癣","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"677308780627","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2022-06-30 15:08:01","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 122222008 122294001","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:82994705;1989854:146933453;5919063:501970821;5919063:3284565;5919063:3266786;5919063:3266779;5919063:3266785;5919063:3266781;10543965:73281184;12060095:804428638;15073217:557074379;124112492:11643345;127516969:12284560;127532776:560808278;127570025:560808278;127598100:6672878;128132720:26878;128150061:556774857;132270815:77534680;132344540:27233421","itemId":"677308780627","imgUrl":"//img.alicdn.com/imgextra/i2/2209842646673/O1CN017c4o2A1zAHi6WxtN7_!!0-item_pic.jpg","cateNamePath":null,"price":"90.0","tagNames":["优选好货"],"tagName":"","itemNumId":"677308780627","isTaobaoMall":null,"srcFlag":null},{"expireTime":"2524579200000","cartTotal":null,"linkUrl":"http://detail.tmall.com/item.htm?id=637513470792","qualityflag":null,"tagUrls":[{"tagType":"10","cls":"border-red","location":null,"name":"优选好货","type":"txt"}],"lastSyncTime":null,"click":null,"couponUsableFlag":null,"mutiImageURL":null,"saleStarLevel":"1","extensions":"salesLevelShopLevel:1;collectCartNum:3;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.017868585342633785;payCnt30d:2728;clk7d:976;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725143126;recruitIndexShopLevel:1;tmc_tags:100034998,800131953,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33745,33172,100033825,32024,33825,100033745,33970,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:5;quantity:355659;highUvValueIndex:6;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:10;tags:[2178754, 1839426, 1987074, 2016386, 21826, 2188162, 2234946, 2008514, 1702530, 2269122, 225410, 143746, 2254274, 2278402, 1973186, 1649602, 2021442, 1998018, 2206082, 2148034, 2043010, 139778, 349570, 2122818, 360386, 2230338, 2185986, 2238210, 5826, 1619266, 1974658, 21762, 1682818, 2288706, 1887682, 2000258, 1831682, 200002, 2261186, 25282, 2225730, 120962, 2248898, 362178, 2027970, 450114, 2257922, 101762, 2140162, 1991874, 1733890, 2165506, 1846530, 285186, 1478530, 1704322, 346562, 2170242, 1799170, 1835010, 1870594, 1789826, 2166786, 2028098, 1805634, 2008386, 1982018, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 1902338, 368066, 388354, 98242, 2132674, 2208450, 1959874, 504898, 2028162, 281666, 1823554, 1880514, 57026, 2030018, 531906, 413762, 1902466, 113602, 1977858, 393794, 1691586, 1967490, 162690, 1892226, 1784834, 2188098, 2119618, 2253954, 2028034, 2230530, 1974466, 2187842, 2238722, 2264898, 49218, 21442, 2133506, 2205762, 1993858, 2294274, 2254338, 452738, 2183298, 2223874, 1904386, 1624130, 2008450, 212546, 1901314, 2106882, 1474370, 1481986, 2228354, 299394, 28802, 1835330, 2223106, 2158210, 2188354, 2257858, 2254466, 1900354, 288386];payCnt7d:561;first_starts_time:1611556286893;itemRank:0;originalStatus:0;bidCount:184685;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1","displayUrl":"http://detail.tmall.com/item.htm?id=637513470792","extraAttributes":{"collectCartNumShopLevel":"-1","recruitIndexShopLevel":"1","collectCartNum":"3","shopContributionIndexShopLevel":"1","clk7d":"976","customerCoverageShopLevel":"1","originalStatus":"0","isOnline":"1","itemRank":"0","salesLevelShopLevel":"1","attractIndex":null,"repurchaseIndexShopLevel":"1","coldSpeedingStatus":"-1","quantity":"355659","tmc_tags":"100034998,800131953,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33745,33172,100033825,32024,33825,100033745,33970,34867,100034882,34998,34618,100034380,34556,100034635,100034697","bidCount":"184685","highUvValueIndex":"6","payCnt7d":"561","salesLevel":"5","indirConvertion":"8","tags":["1481986","21762","2238722","212546","2181762","2248898","2254274","531906","450114","2008386","1478530","2269122","2254338","281666","2230530","2238210","413762","1904386","36610","2230594","1974658","2293954","2185986","1704322","1649602","2264898","1887682","2043010","21826","1959874","388354","349570","57026","2228354","49218","2166786","2225730","1892226","2223874","2183298","1993858","2133506","1702530","25282","1733890","1619266","5826","139778","143746","2178754","2106882","120962","2208450","2119618","2028098","2257858","1974466","1998018","1502082","2028162","1835330","2294274","1602178","2261186","101762","2205762","2000258","2254466","2288706","1902338","225410","2253954","1789826","1799170","2223106","2257922","1784834","393794","288386","2028034","1682818","2188354","2021442","1880514","113602","2206082","285186","452738","1624130","1900354","2165506","346562","2030018","1823554","28802","1831682","98242","1987074","1839426","1973186","1870594","368066","2122818","504898","2158210","1805634","2201410","360386","362178","2230338","1902466","1835010","162690","1977858","2132674","2188098","1474370","1691586","2027970","2140162","2008514","2187842","1991874","2278402","1982018","299394","21442","2234946","1846530","2008450","200002","1967490","1901314","2148034","2188162","2170242","2016386"],"customerCoverage":"8","isNew":true,"categoryId":"201273575 50023720 50023733","indirConvertionShopLevel":"1","marketCoverage":"5","repurchaseIndex":"10","ctr7d":"0.017868585342633785","starts":"20220725143126","attractInshopPv":"10","first_starts_time":"1611556286893","payCnt30d":"2728","attractInshopPvShopLevel":"1","highUvValueIndexShopLevel":"1","marketCoverageShopLevel":"1","shopContributionIndex":"9","recruitIndex":"6"},"title":"艾丽奥利司他胶囊6粒减肥药正品瘦身旗舰减脂专用排油丸OTC官网","skuPrice":null,"newItem":false,"kgbClick":null,"userCharId":"2209842646673","itemCharId":"637513470792","timing":false,"wirelessLongImageURL":null,"onsaleTime":"2021-01-25 14:31:26","landGmv":null,"qualityflagreason":null,"potentialRate":null,"userNumId":"2209842646673","status":"1","sortId":"201273575 50023720 50023733","competitionRate":null,"estPv":null,"recommendReason":null,"properties":"20000:4207810;1989854:589308221;5919063:3266779;5919063:206264795;5919063:3266785;5919063:215312402;12060095:1323180239;12060620:1124722041;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132344540:13245856","itemId":"637513470792","imgUrl":"//img.alicdn.com/imgextra/i3/2209842646673/O1CN01pn3NMQ1zAHhoC8sv6_!!0-item_pic.jpg","cateNamePath":null,"price":"29.9","tagNames":["优选好货"],"tagName":"","itemNumId":"637513470792","isTaobaoMall":null,"srcFlag":null}],"pageSize":"20"},"errors":[],"cause":null,"location":null,"analyseTraceId":null,"illogic":null,"memberId":null,"code":"200","innerMsg":null,"success":true,"msg":null}
    print(parse_json(data))
    q = [{'key': 'last_index', 'value': None, 'path': "source_root.get('lastIndex')"}, {'key': 'cust_id', 'value': None, 'path': "source_root.get('custId')"}, {'key': 'location', 'value': None, 'path': "source_root.get('result').get('location')"}, {'key': 'pagesize', 'value': '20', 'path': "source_root.get('result').get('page').get('pagesize')"}, {'key': 'last_page', 'value': '1', 'path': "source_root.get('result').get('page').get('lastPage')"}, {'key': 'itemtotal', 'value': '16', 'path': "source_root.get('result').get('page').get('itemtotal')"}, {'key': 'sort', 'value': [], 'path': "source_root.get('result').get('page').get('sort')"}, {'key': 'sorted', 'value': False, 'path': "source_root.get('result').get('page').get('sorted')"}, {'key': 'page_size', 'value': '20', 'path': "source_root.get('result').get('page').get('pageSize')"}, {'key': 'pagenum', 'value': '1', 'path': "source_root.get('result').get('page').get('pagenum')"}, {'key': 'item_total', 'value': '16', 'path': "source_root.get('result').get('page').get('itemTotal')"}, {'key': 'pagetotal', 'value': '1', 'path': "source_root.get('result').get('page').get('pagetotal')"}, {'key': 'offset', 'value': '0', 'path': "source_root.get('result').get('page').get('offset')"}, {'key': 'page_num', 'value': '1', 'path': "source_root.get('result').get('page').get('pageNum')"}, {'key': 'total_item', 'value': '16', 'path': "source_root.get('result').get('totalItem')"}, {'key': 'data', 'value': [{'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=676835988580', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:8;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.024633494038408216;payCnt30d:4134;clk7d:2754;isOnline:1;customerCoverage:8;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220722200000;recruitIndexShopLevel:1;tmc_tags:100034998,34998;attractInshopPv:10;marketCoverage:8;quantity:7059;highUvValueIndex:6;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 1839426, 1987074, 2016386, 21762, 404546, 2133506, 21826, 25346, 2193730, 2008514, 1702530, 25282, 2248898, 281666, 1880514, 57026, 212546, 101762, 2030018, 531906, 1991874, 2165506, 1973186, 1846530, 285186, 1474370, 113602, 2021442, 2148034, 349570, 299394, 28802, 1789826, 1835010, 1835330, 2119618, 2185986, 1602178, 1900354, 2293954, 288386, 5826];payCnt7d:842;first_starts_time:1655973858234;itemRank:10;originalStatus:0;bidCount:3986;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122292001;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=676835988580', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '8', 'shopContributionIndexShopLevel': '1', 'clk7d': '2754', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '10', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '7059', 'tmc_tags': '100034998,34998', 'bidCount': '3986', 'highUvValueIndex': '6', 'payCnt7d': '842', 'salesLevel': '5', 'indirConvertion': '10', 'tags': ['21762', '1987074', '1839426', '2133506', '1973186', '1702530', '1789826', '25282', '25346', '2238722', '212546', '5826', '288386', '2248898', '531906', '2021442', '1880514', '2119618', '113602', '1835010', '281666', '285186', '404546', '2293954', '1474370', '1602178', '1835330', '2008514', '2185986', '2193730', '1900354', '1991874', '2165506', '101762', '21826', '299394', '349570', '1846530', '57026', '2030018', '2148034', '2016386', '28802'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 122222008 122292001', 'indirConvertionShopLevel': '1', 'marketCoverage': '8', 'repurchaseIndex': '6', 'ctr7d': '0.024633494038408216', 'starts': '20220722200000', 'attractInshopPv': '10', 'first_starts_time': '1655973858234', 'payCnt30d': '4134', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '10'}, 'title': '丽芙甲硝唑凝胶用于炎症性丘疹酒渣鼻红斑修复甲硝唑消炎凝胶', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '676835988580', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-06-23 16:44:18', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 122222008 122292001', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:15825736;1989854:137503148;5919063:3266779;5919063:3266785;5919063:3266781;10543965:563694485;12060095:12020975944;15073217:7146152;124112492:11643345;127516969:565140599;127532776:66047117;127570025:66047117;127598100:9695512;128132720:26878;128150061:556774857;132268776:39583581;132270815:1327353772;132270815:1142524358;132270815:1327353771;132344540:1142524358;132344540:1327353772;132344540:1327353771', 'itemId': '676835988580', 'imgUrl': '//img.alicdn.com/imgextra/i2/2209842646673/O1CN010LstZk1zAHiQbZZOw_!!2209842646673.jpg', 'cateNamePath': None, 'price': '41.7', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '676835988580', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=648410292248', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:9;highUvValueIndexShopLevel:1;salesLevel:3;indirConvertionShopLevel:1;ctr7d:0.0732824427480916;payCnt30d:84;clk7d:48;isOnline:1;customerCoverage:7;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725162221;recruitIndexShopLevel:1;tmc_tags:100034998,100033079,34882,100033077,100033970,100034867,100035071,34697,100034556,100033788,34635,100034618,34380,33745,100033506,100033705,33506,100033745,33705,33970,34867,100034882,33077,34998,33079,34618,100034380,34556,33788,100034635,35071,100034697;attractInshopPv:9;marketCoverage:7;quantity:298145;highUvValueIndex:7;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:8;tags:[2178754, 2285058, 2016386, 1391490, 1841346, 2124290, 61442, 249858, 2131266, 1834818, 225410, 143746, 2253186, 2057538, 2038978, 2021442, 2206082, 1977538, 2148034, 2043010, 139778, 349570, 10818, 1875650, 2122818, 2032642, 360386, 2230338, 1834946, 1522498, 1845314, 1841474, 288962, 1682818, 2052738, 2288706, 2288386, 1391874, 200002, 1879426, 2261186, 130, 296066, 25282, 120962, 258, 101762, 2140162, 1400514, 2018178, 346562, 1860674, 2288770, 2170242, 3394, 1799170, 1789826, 2028098, 2060994, 1999362, 1805634, 2201410, 1502082, 2181762, 2293954, 2230594, 2102466, 1882370, 388354, 2289730, 98242, 2132674, 2057730, 165186, 2028162, 57026, 413762, 1362178, 2131458, 2016450, 113602, 2286978, 1691586, 1967490, 46914, 1892226, 2289602, 2256706, 2119618, 444802, 1842882, 2230530, 2052674, 2254402, 2187842, 2238722, 2264898, 1508482, 2039042, 49218, 21442, 2304834, 2294274, 2254338, 2183298, 2223874, 2307266, 1904386, 2106882, 2141058, 2228354, 2106818, 292354, 1315394, 299394, 1834882, 28802, 1835330, 2111042, 2188354, 2254466, 1900354, 2256642, 1739842];payCnt7d:36;first_starts_time:1624341705421;itemRank:0;originalStatus:0;bidCount:6071;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125056015 125030021;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=648410292248', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '9', 'shopContributionIndexShopLevel': '1', 'clk7d': '48', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '298145', 'tmc_tags': '100034998,100033079,34882,100033077,100033970,100034867,100035071,34697,100034556,100033788,34635,100034618,34380,33745,100033506,100033705,33506,100033745,33705,33970,34867,100034882,33077,34998,33079,34618,100034380,34556,33788,100034635,35071,100034697', 'bidCount': '6071', 'highUvValueIndex': '7', 'payCnt7d': '36', 'salesLevel': '3', 'indirConvertion': '8', 'tags': ['1860674', '10818', '2307266', '1834818', '46914', '61442', '2238722', '2181762', '1977538', '1508482', '2254338', '2052674', '2016450', '165186', '2230530', '413762', '1904386', '2230594', '2293954', '1999362', '2304834', '2256642', '2264898', '2043010', '2057730', '388354', '349570', '57026', '2032642', '1400514', '2228354', '49218', '1892226', '2223874', '2183298', '2131266', '2057538', '2254402', '2018178', '25282', '292354', '288962', '139778', '143746', '2178754', '2106818', '2106882', '120962', '2256706', '2102466', '2119618', '2028098', '1875650', '1502082', '1315394', '2028162', '1835330', '2294274', '1842882', '2289730', '2261186', '101762', '2060994', '2039042', '1841346', '2289602', '2254466', '2288706', '2141058', '225410', '1362178', '1789826', '1799170', '2285058', '2288386', '249858', '2052738', '1391490', '1682818', '2188354', '2021442', '2131458', '444802', '113602', '2253186', '2288770', '2206082', '1739842', '3394', '1900354', '346562', '1841474', '28802', '98242', '1522498', '2122818', '1805634', '2201410', '2286978', '360386', '1845314', '296066', '2230338', '130', '2132674', '1834882', '1879426', '1691586', '2124290', '2140162', '1391874', '2187842', '2111042', '299394', '21442', '258', '2038978', '200002', '1967490', '1834946', '2148034', '2170242', '2016386', '1882370'], 'customerCoverage': '7', 'isNew': True, 'categoryId': '50026800 125046003 125056015 125030021', 'indirConvertionShopLevel': '1', 'marketCoverage': '7', 'repurchaseIndex': '8', 'ctr7d': '0.0732824427480916', 'starts': '20220725162221', 'attractInshopPv': '9', 'first_starts_time': '1624341705421', 'payCnt30d': '84', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '9', 'recruitIndex': '6'}, 'title': '雅塑白芸豆压片糖果奶片咀嚼片即食大餐伴侣正品官方旗舰店', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '648410292248', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2021-06-22 14:01:45', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '50026800 125046003 125056015 125030021', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:109899538;251734303:255930637;20759:30517;21299:72700378;24477:3493528;1627207:3232483;1627207:90554;1627207:3232479;1989873:4383965;12060095:7324852915;13521388:29407;15073217:3508415;122216443:7184472;122216962:3220625;128132720:3622544;224607339:21959', 'itemId': '648410292248', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01SPaOLg1zAHiHhHzeQ_!!2209842646673.jpg', 'cateNamePath': None, 'price': '58.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '648410292248', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=669946716767', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:6;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.08056096813925148;payCnt30d:8528;clk7d:12362;isOnline:1;customerCoverage:7;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725112919;recruitIndexShopLevel:1;tmc_tags:100034998,34882,34867,100034882,100034867,34998,34697,34618,34635,100034618,100034635,100034697;attractInshopPv:10;marketCoverage:7;quantity:17302;highUvValueIndex:4;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2256450, 2256770, 1839426, 1987074, 2016386, 2255362, 61442, 388354, 21826, 2008514, 1702530, 2132674, 2266498, 1834818, 281666, 2203202, 531906, 143746, 413762, 2256578, 2254274, 2021442, 2286978, 2148034, 349570, 10818, 2256706, 2200066, 1834946, 2230338, 2119618, 2230530, 2254402, 2187842, 2238722, 1993730, 2264898, 21762, 49218, 21442, 2288706, 2133506, 2288386, 1879426, 2261186, 130, 2268610, 25282, 2294274, 2254338, 2223874, 2307266, 1904386, 212546, 101762, 1991874, 2165506, 1846530, 1474370, 107842, 2140290, 2228354, 1876482, 2288770, 299394, 3394, 1834882, 1799170, 28802, 1789826, 1835330, 2288578, 49282, 2288450, 2257858, 2201410, 2254466, 1602178, 1900354, 2293954, 2230594, 2256642, 288386];payCnt7d:5106;first_starts_time:1647833359101;itemRank:0;originalStatus:0;bidCount:9625;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=669946716767', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '6', 'shopContributionIndexShopLevel': '1', 'clk7d': '12362', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '17302', 'tmc_tags': '100034998,34882,34867,100034882,100034867,34998,34697,34618,34635,100034618,100034635,100034697', 'bidCount': '9625', 'highUvValueIndex': '4', 'payCnt7d': '5106', 'salesLevel': '5', 'indirConvertion': '10', 'tags': ['10818', '1993730', '21762', '2307266', '1834818', '2266498', '1789826', '1799170', '61442', '2238722', '212546', '2288386', '288386', '2254274', '531906', '2021442', '2256578', '2254338', '2288770', '281666', '2230530', '413762', '2288578', '1904386', '2230594', '2293954', '2268610', '2256642', '3394', '1900354', '2165506', '2264898', '49282', '21826', '388354', '349570', '2228354', '49218', '107842', '2223874', '28802', '1839426', '1987074', '2254402', '2133506', '1702530', '25282', '2201410', '143746', '2286978', '2256706', '2230338', '2256450', '2119618', '130', '2203202', '2257858', '2288450', '2132674', '1834882', '1474370', '1879426', '1602178', '1835330', '2294274', '2256770', '2008514', '2187842', '2140290', '1991874', '2261186', '101762', '2255362', '299394', '1846530', '21442', '1876482', '2200066', '2148034', '1834946', '2254466', '2288706', '2016386'], 'customerCoverage': '7', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '7', 'repurchaseIndex': '6', 'ctr7d': '0.08056096813925148', 'starts': '20220725112919', 'attractInshopPv': '10', 'first_starts_time': '1647833359101', 'payCnt30d': '8528', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '-1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '10'}, 'title': '易下开塞露20ml20支润肠通便含甘油男女便秘药老人儿童排宿便清肠', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '669946716767', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-03-21 11:29:19', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:1593776827;1989854:112360886;5919063:4421995;5919063:3266781;5919063:215302757;5919063:501970821;5919063:3266779;12060095:1398307585;12060620:85664865;12167949:556774857;15073217:557074379;124112492:96124062;127516969:561546620;127532776:567348895;127570025:567348895;127598100:9695512;128132720:26878;132268776:39583581;132270815:3403653;132344540:3403653', 'itemId': '669946716767', 'imgUrl': '//img.alicdn.com/imgextra/i3/2209842646673/O1CN01a5qumw1zAHiN7MeBC_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '32.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '669946716767', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=632741133617', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.025770434488397664;payCnt30d:4039;clk7d:914;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725155902;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:300682;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[1349954, 1839426, 1987074, 2016386, 2285570, 61442, 21826, 1702530, 2243010, 2131266, 225410, 143746, 2074818, 2038978, 1649602, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 10818, 360386, 2075010, 2230338, 1929730, 2185986, 1619266, 1974658, 21762, 1682818, 2288706, 1887682, 2074882, 1831682, 200002, 256130, 2261186, 130, 296066, 25282, 2225730, 120962, 1846018, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1478530, 1704322, 346562, 1860674, 2007618, 1648770, 2170242, 3394, 2028418, 1799170, 1870594, 1789826, 2028098, 1999362, 1805634, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2218882, 1902338, 2102466, 388354, 98242, 1651458, 2132674, 2208450, 504898, 2028162, 281666, 1823554, 57026, 1721538, 2030018, 531906, 413762, 1902466, 1797506, 2131458, 113602, 393794, 2026818, 1691586, 162690, 1892226, 1784834, 461442, 2291394, 2200066, 2119618, 2253954, 2230530, 1974466, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 2243074, 2294274, 452738, 2183298, 2223874, 1904386, 1624130, 212546, 1901314, 1902402, 2106882, 1474370, 1481986, 1838722, 2228354, 2106818, 2194114, 299394, 28802, 1835330, 2111042, 2158210, 2257858, 1900354, 288386];payCnt7d:413;first_starts_time:1607327942032;itemRank:0;originalStatus:0;bidCount:182228;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=632741133617', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '914', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '300682', 'tmc_tags': '100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697', 'bidCount': '182228', 'highUvValueIndex': '9', 'payCnt7d': '413', 'salesLevel': '5', 'indirConvertion': '10', 'tags': ['1481986', '1860674', '21762', '10818', '2074818', '2238722', '61442', '212546', '2181762', '531906', '1478530', '2243010', '281666', '2230530', '413762', '1904386', '36610', '2230594', '1974658', '2293954', '1999362', '2185986', '1704322', '1649602', '2264898', '1887682', '1349954', '2043010', '21826', '388354', '349570', '57026', '1400514', '2228354', '49218', '2225730', '1929730', '1846018', '1892226', '2223874', '2183298', '2131266', '2133506', '2074882', '1702530', '25282', '1648770', '1733890', '1619266', '139778', '143746', '2106818', '2106882', '120962', '2208450', '2102466', '2119618', '2028098', '2257858', '1974466', '1998018', '1502082', '2028162', '256130', '1835330', '2294274', '1602178', '2261186', '101762', '2039042', '2218882', '2288706', '1902338', '225410', '2075010', '2253954', '1789826', '1799170', '1902402', '2257922', '2026818', '1784834', '393794', '288386', '1682818', '2021442', '2131458', '2028418', '113602', '2206082', '452738', '461442', '1624130', '3394', '1900354', '2165506', '346562', '2030018', '2194114', '1823554', '28802', '1831682', '98242', '1987074', '1839426', '1870594', '2243074', '504898', '1797506', '2158210', '1805634', '2201410', '1838722', '360386', '2291394', '296066', '2230338', '2285570', '2007618', '1902466', '130', '162690', '1651458', '2132674', '1474370', '1691586', '2140162', '2187842', '2111042', '299394', '21442', '1846530', '2200066', '1721538', '2038978', '200002', '1901314', '2170242', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '9', 'ctr7d': '0.025770434488397664', 'starts': '20220725155902', 'attractInshopPv': '10', 'first_starts_time': '1607327942032', 'payCnt30d': '4039', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '6'}, 'title': '艾丽奥利司他胶囊减肥药正品瘦身减脂排油丸专用减肥旗舰OTC官网', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '632741133617', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2020-12-07 15:59:02', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4207810;1989854:118326715;5919063:59904168;5919063:79046194;5919063:3266785;5919063:501970821;5919063:3266781;5919063:215304499;5919063:215302757;12060095:1323180239;12060620:566000040;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:597878364;132344540:1327353185;132344540:13245856', 'itemId': '632741133617', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01OgHV6G1zAHiSXdLXM_!!2209842646673.jpg', 'cateNamePath': None, 'price': '162.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '632741133617', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=678996882135', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:0;collectCartNum:7;highUvValueIndexShopLevel:1;salesLevel:2;indirConvertionShopLevel:1;ctr7d:0.027544544245055414;payCnt30d:232;clk7d:4327;isOnline:1;customerCoverage:7;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220722111519;recruitIndexShopLevel:1;tmc_tags:null;attractInshopPv:9;marketCoverage:6;quantity:14739;highUvValueIndex:6;coldSpeedingStatus:0;attractIndex:null;isNew:true;repurchaseIndex:5;tags:[2238722, 1987074, 2016386, 2264898, 21762, 2288386, 21826, 1702530, 25282, 2269122, 281666, 57026, 212546, 101762, 413762, 2165506, 1846530, 1474370, 346562, 2021442, 349570, 299394, 28802, 1789826, 1835330, 2288578, 2288450, 1602178, 1900354, 288386];payCnt7d:231;first_starts_time:1657854919693;itemRank:10;originalStatus:0;bidCount:253;repurchaseIndexShopLevel:0;categoryId:201273575 50023720 122222008 122290002;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=678996882135', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '7', 'shopContributionIndexShopLevel': '1', 'clk7d': '4327', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '10', 'salesLevelShopLevel': '0', 'attractIndex': None, 'repurchaseIndexShopLevel': '0', 'coldSpeedingStatus': '0', 'quantity': '14739', 'tmc_tags': None, 'bidCount': '253', 'highUvValueIndex': '6', 'payCnt7d': '231', 'salesLevel': '2', 'indirConvertion': '10', 'tags': ['21762', '1987074', '1702530', '25282', '1789826', '2238722', '2288386', '212546', '288386', '2021442', '2269122', '281666', '413762', '2288450', '2288578', '1474370', '1602178', '1835330', '1900354', '2264898', '2165506', '101762', '346562', '21826', '57026', '1846530', '349570', '299394', '2016386', '28802'], 'customerCoverage': '7', 'isNew': True, 'categoryId': '201273575 50023720 122222008 122290002', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '5', 'ctr7d': '0.027544544245055414', 'starts': '20220722111519', 'attractInshopPv': '9', 'first_starts_time': '1657854919693', 'payCnt30d': '232', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '10'}, 'title': '蔓迪米诺地尔酊曼迪斑秃 蔓迪米诺地尔旗舰店 米诺地尔汀蔓迪90ml', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '678996882135', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-07-15 11:15:19', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 122222008 122290002', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:3883772;1989854:111043625;5919063:3266779;5919063:3266785;5919063:3266781;10543965:875552307;12060095:836508051;15073217:557074379;124112492:11643345;127516969:12284560;127532776:48712647;127566068:3883772;127570025:19221189;127598100:6672878;128132720:3622544;128132720:4099916;128150061:556774857;132268776:39583581;132270815:7621826;132270815:3481322;132344540:185628909', 'itemId': '678996882135', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN019RvJ811zAHiTgHQHf_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '158.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '678996882135', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=649167506944', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.06097560975609756;payCnt30d:1464;clk7d:25;isOnline:1;customerCoverage:6;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:7;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220720100430;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,100035071,34635,100034618,33970,34867,100034882,34998,100033825,32024,34618,100034635,35071;attractInshopPv:8;marketCoverage:6;quantity:196171;highUvValueIndex:3;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:8;tags:[2178754, 2285058, 2016386, 1391490, 1841346, 2124290, 61442, 1562306, 2008514, 249858, 2131266, 1834818, 225410, 2253186, 2057538, 2038978, 2021442, 1977538, 2148034, 2043010, 139778, 349570, 10818, 1875650, 2122818, 2032642, 360386, 2230338, 1834946, 2119938, 1845314, 1841474, 2120002, 1362242, 2238210, 1682818, 2052738, 2288706, 404546, 2064962, 2193730, 1879426, 2261186, 130, 296066, 25282, 120962, 258, 101762, 2140162, 1733890, 2165506, 1400514, 2018178, 2098306, 1860674, 2007618, 2170242, 3394, 2064834, 2119874, 1799170, 1789826, 2028098, 2060994, 1805634, 2201410, 1602178, 1502082, 2293954, 2230594, 2102466, 1882370, 388354, 2289730, 98242, 2132674, 2057730, 165186, 2028162, 57026, 1362178, 2131458, 2016450, 113602, 2064770, 2064898, 46914, 162690, 1892226, 2289602, 2256706, 2119618, 2253954, 444802, 1842882, 2230530, 2052674, 2254402, 2187842, 2238722, 2039042, 49218, 2133506, 2240002, 2304834, 2294274, 2254338, 2223874, 1904386, 2106818, 292354, 299394, 1834882, 28802, 1835330, 2111042, 2223106, 2158210, 2188354, 2254466, 1900354, 2256642, 1739842];payCnt7d:643;first_starts_time:1624340740894;itemRank:0;originalStatus:0;bidCount:4525;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125056015 125030021;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=649167506944', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '25', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '196171', 'tmc_tags': '100034998,33825,34882,100033970,100034867,100035071,34635,100034618,33970,34867,100034882,34998,100033825,32024,34618,100034635,35071', 'bidCount': '4525', 'highUvValueIndex': '3', 'payCnt7d': '643', 'salesLevel': '5', 'indirConvertion': '7', 'tags': ['1860674', '10818', '2120002', '1834818', '46914', '2119874', '2238722', '2119938', '61442', '1977538', '2254338', '2052674', '2016450', '165186', '2230530', '2238210', '1904386', '2230594', '2293954', '2304834', '1562306', '2256642', '2193730', '2043010', '2064834', '2057730', '388354', '349570', '57026', '2032642', '1400514', '49218', '1892226', '2223874', '2131266', '2254402', '2057538', '2133506', '2018178', '25282', '1733890', '292354', '139778', '2178754', '2106818', '120962', '2256706', '2102466', '2119618', '2028098', '2064962', '1875650', '404546', '1502082', '2028162', '1835330', '2294274', '1602178', '1842882', '2289730', '2261186', '101762', '2060994', '2039042', '1841346', '2289602', '2064770', '2254466', '2288706', '225410', '1362178', '2253954', '1789826', '1799170', '2223106', '2285058', '2240002', '249858', '2052738', '1391490', '1682818', '2188354', '2021442', '2131458', '444802', '113602', '2253186', '1739842', '3394', '1900354', '2165506', '1841474', '28802', '98242', '2122818', '2158210', '2064898', '2098306', '1805634', '2201410', '360386', '1362242', '1845314', '296066', '2230338', '2007618', '130', '162690', '2132674', '1834882', '1879426', '2124290', '2140162', '2008514', '2187842', '2111042', '299394', '258', '2038978', '1834946', '2148034', '2170242', '2016386', '1882370'], 'customerCoverage': '6', 'isNew': True, 'categoryId': '50026800 125046003 125056015 125030021', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '8', 'ctr7d': '0.06097560975609756', 'starts': '20220720100430', 'attractInshopPv': '8', 'first_starts_time': '1624340740894', 'payCnt30d': '1464', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '-1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '8', 'recruitIndex': '7'}, 'title': '【餐前2片 开袋即赠】雅塑白芸豆压片糖果奶片咀嚼片大餐伴侣抑制', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '649167506944', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2021-06-22 13:45:40', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '50026800 125046003 125056015 125030021', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:109899538;251734303:255930637;20759:30517;21299:72700378;24477:3493528;1627207:3232483;1627207:3232484;1989873:4383965;12060095:7324852915;13521388:29407;15073217:3508415;122216443:45701862;122216962:3220625;128132720:3622544;224607339:21959', 'itemId': '649167506944', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN0116WrDo1zAHiSB5JEi_!!2209842646673.jpg', 'cateNamePath': None, 'price': '49.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '649167506944', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=669455525806', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:5;highUvValueIndexShopLevel:-1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.022102104853301573;payCnt30d:1811;clk7d:965;isOnline:1;customerCoverage:7;recruitIndex:9;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220721160213;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:102645;highUvValueIndex:4;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2256450, 2256770, 1839426, 1987074, 2016386, 2255362, 61442, 21826, 2289730, 2008514, 1702530, 2132674, 2266498, 2208450, 1834818, 281666, 57026, 2203202, 531906, 143746, 413762, 2256578, 2254274, 2289090, 113602, 2021442, 2206082, 2286978, 1977858, 2148034, 2043010, 139778, 393794, 349570, 10818, 2289602, 360386, 2256706, 2200066, 1834946, 2230338, 2119618, 2185986, 2230530, 2254402, 2187842, 1952450, 2238722, 21762, 49218, 21442, 2288706, 2133506, 2288386, 1879426, 200002, 2261186, 130, 25282, 2294274, 2225730, 2254338, 2223874, 1904386, 212546, 101762, 2257922, 1991874, 1733890, 2165506, 1846530, 1474370, 346562, 107842, 2140290, 2228354, 2288770, 299394, 3394, 1799170, 1834882, 28802, 1789826, 1835330, 2288578, 49282, 2288450, 2257858, 2201410, 2254466, 1602178, 1502082, 2293954, 2230594, 2256642, 288386];payCnt7d:570;first_starts_time:1646294533087;itemRank:0;originalStatus:0;bidCount:5747;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:0', 'displayUrl': 'http://detail.tmall.com/item.htm?id=669455525806', 'extraAttributes': {'collectCartNumShopLevel': '0', 'recruitIndexShopLevel': '1', 'collectCartNum': '5', 'shopContributionIndexShopLevel': '1', 'clk7d': '965', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '102645', 'tmc_tags': '100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697', 'bidCount': '5747', 'highUvValueIndex': '4', 'payCnt7d': '570', 'salesLevel': '5', 'indirConvertion': '10', 'tags': ['21762', '10818', '1834818', '2266498', '1789826', '1799170', '2257922', '61442', '2238722', '212546', '2288386', '393794', '288386', '2254274', '531906', '2256578', '2021442', '2254338', '113602', '2288770', '281666', '2230530', '413762', '2206082', '2288578', '1904386', '2230594', '2293954', '2256642', '2185986', '3394', '2165506', '49282', '2043010', '346562', '21826', '57026', '349570', '2228354', '49218', '2225730', '2289090', '107842', '2223874', '1952450', '28802', '1839426', '1987074', '2254402', '2133506', '1702530', '25282', '1733890', '2201410', '139778', '143746', '2286978', '360386', '2256706', '2208450', '2230338', '2256450', '2119618', '130', '2203202', '2257858', '2288450', '1977858', '1502082', '2132674', '1834882', '1474370', '1879426', '1602178', '1835330', '2294274', '2256770', '2008514', '2187842', '2140290', '2289730', '1991874', '2261186', '101762', '2255362', '299394', '1846530', '21442', '2289602', '2200066', '200002', '2148034', '1834946', '2254466', '2288706', '2016386'], 'customerCoverage': '7', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '6', 'ctr7d': '0.022102104853301573', 'starts': '20220721160213', 'attractInshopPv': '10', 'first_starts_time': '1646294533087', 'payCnt30d': '1811', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '-1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '9'}, 'title': '江中牌健胃消食片肠胃调理消化不良腹胀气积食乳酸菌素片养胃调胃', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '669455525806', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-03-03 16:02:13', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:3230013;1989854:69653604;5919063:79046194;5919063:3266779;5919063:3266781;5919063:3266789;5919063:3266785;12060095:7827527;12060620:571698732;12167949:3312861;15073217:3508415;124112492:3364499;127516969:48909577;127532776:7279871;127566068:562948962;127570025:471279828;127598100:6672878;128132720:26878;132268776:39583581;132270815:11666823;132344540:182776368;132344540:1327353059;132344540:11666823;132344540:434188979', 'itemId': '669455525806', 'imgUrl': '//img.alicdn.com/imgextra/i4/2209842646673/O1CN01zaIUr31zAHiM7lqcA_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '59.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '669455525806', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=632740201606', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:6;indirConvertionShopLevel:1;ctr7d:0.02033340808851013;payCnt30d:34498;clk7d:544;isOnline:1;customerCoverage:9;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220720235800;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:6;quantity:190685;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 1349954, 1839426, 2016386, 61442, 21826, 1702530, 2243010, 2131266, 2165442, 2269122, 225410, 143746, 2254274, 2038978, 1649602, 2021442, 1998018, 2206082, 2148034, 2043010, 139778, 349570, 10818, 1899458, 360386, 2075010, 2230338, 1929730, 2119938, 2185986, 2120002, 1817218, 1619266, 1974658, 21762, 2288706, 1887682, 1818306, 404546, 2074882, 2064962, 200002, 2261186, 130, 296066, 25282, 2225730, 120962, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1704322, 2098306, 2178882, 2170242, 3394, 2064834, 2119874, 1799170, 1789826, 2028098, 2201410, 15810, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2218882, 1902338, 2102466, 388354, 98242, 2132674, 2208450, 504898, 2028162, 281666, 57026, 531906, 413762, 1902466, 2131458, 113602, 2064770, 393794, 2064898, 162690, 1892226, 2291394, 2119618, 1998210, 2230530, 2254402, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 96002, 2243074, 2294274, 2254338, 2183298, 2223874, 1904386, 1624130, 212546, 1901314, 2106882, 1474370, 1481986, 2228354, 2106818, 299394, 28802, 1835330, 2111042, 2158210, 2188354, 2257858, 2254466, 1900354, 288386];payCnt7d:612;first_starts_time:1607327774330;itemRank:0;originalStatus:0;bidCount:71560;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=632740201606', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '544', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '190685', 'tmc_tags': '100034998,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,32024,34618,100034380,34556,100034635,100034697', 'bidCount': '71560', 'highUvValueIndex': '9', 'payCnt7d': '612', 'salesLevel': '6', 'indirConvertion': '8', 'tags': ['1481986', '21762', '10818', '2120002', '2119874', '2238722', '2119938', '61442', '212546', '2181762', '2254274', '531906', '2269122', '2243010', '2254338', '281666', '2230530', '413762', '1904386', '36610', '2230594', '1974658', '2293954', '2185986', '1704322', '1649602', '2264898', '1887682', '1349954', '2043010', '2064834', '21826', '388354', '349570', '57026', '1400514', '2228354', '49218', '2225730', '1929730', '1892226', '2223874', '2183298', '2131266', '2254402', '2133506', '2074882', '1702530', '25282', '96002', '2165442', '1817218', '1733890', '1619266', '139778', '143746', '2178754', '2106818', '2106882', '120962', '2208450', '2102466', '2119618', '2028098', '2064962', '2257858', '1998018', '404546', '1502082', '2028162', '1835330', '2294274', '1602178', '2261186', '101762', '2039042', '2218882', '2064770', '2254466', '2288706', '1902338', '225410', '2075010', '1789826', '1799170', '2178882', '2257922', '393794', '288386', '2188354', '2021442', '2131458', '113602', '15810', '1998210', '2206082', '1624130', '3394', '1900354', '2165506', '28802', '1818306', '98242', '1839426', '2243074', '504898', '2158210', '2064898', '2098306', '2201410', '360386', '296066', '2291394', '2230338', '1902466', '130', '162690', '2132674', '1474370', '2140162', '2187842', '2111042', '299394', '21442', '1846530', '2038978', '200002', '1901314', '2148034', '2170242', '1899458', '2016386'], 'customerCoverage': '9', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '9', 'ctr7d': '0.02033340808851013', 'starts': '20220720235800', 'attractInshopPv': '10', 'first_starts_time': '1607327774330', 'payCnt30d': '34498', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '9', 'recruitIndex': '7'}, 'title': '艾丽奥利司他胶囊减肥药正品瘦身减肥旗舰排油丸减脂专用OTC官网', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '632740201606', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2020-12-07 15:56:14', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4207810;1989854:118326715;5919063:3266786;5919063:124062536;5919063:206264795;5919063:3284566;5919063:3266781;5919063:3284565;12060095:1323180239;12060620:653196795;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:13245856', 'itemId': '632740201606', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01p0oN3I1zAHiQsaVxz_!!2209842646673.jpg', 'cateNamePath': None, 'price': '87.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '632740201606', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=633364711648', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.014876607577337504;payCnt30d:7675;clk7d:214;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:9;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220725155656;recruitIndexShopLevel:1;tmc_tags:33825,100032949,100033745,100033150,100034556,100034618,100032762,100032697,33745,33172,32949,800132676,100033825,32024,32697,34618,800132939,32762,34556,33150;attractInshopPv:10;marketCoverage:6;quantity:149884;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[1349954, 1839426, 2016386, 21826, 1702530, 225410, 143746, 1649602, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 360386, 2075010, 1929730, 1619266, 1974658, 21762, 1682818, 2288706, 2180418, 1887682, 2074882, 200002, 2261186, 25282, 2225730, 120962, 1846018, 2257922, 101762, 2140162, 1733890, 2165506, 1400514, 1846530, 1478530, 1704322, 2007618, 1648770, 2028418, 1799170, 1870594, 1789826, 2028098, 1999362, 1805634, 2201410, 1602178, 36610, 1502082, 2181762, 1902338, 388354, 2289730, 98242, 2132674, 2208450, 504898, 2028162, 281666, 57026, 531906, 413762, 1902466, 1797506, 113602, 393794, 2026818, 1691586, 162690, 1892226, 1784834, 2289602, 2119618, 2254402, 2187842, 1301314, 21442, 2133506, 2294274, 2183298, 2223874, 2307266, 1904386, 1624130, 2008450, 212546, 1901314, 1902402, 2106882, 1474370, 1481986, 1838722, 2194114, 299394, 28802, 1835330, 2158210, 2257858, 1900354, 288386];payCnt7d:192;first_starts_time:1607327816298;itemRank:0;originalStatus:0;bidCount:102739;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=633364711648', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '214', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '149884', 'tmc_tags': '33825,100032949,100033745,100033150,100034556,100034618,100032762,100032697,33745,33172,32949,800132676,100033825,32024,32697,34618,800132939,32762,34556,33150', 'bidCount': '102739', 'highUvValueIndex': '9', 'payCnt7d': '192', 'salesLevel': '5', 'indirConvertion': '9', 'tags': ['1481986', '21762', '2307266', '212546', '2181762', '531906', '1478530', '281666', '413762', '1904386', '36610', '1974658', '1999362', '2180418', '1704322', '1649602', '2043010', '1349954', '1887682', '21826', '388354', '349570', '57026', '1400514', '2225730', '1929730', '1846018', '1892226', '2223874', '2183298', '2254402', '2133506', '2074882', '1702530', '25282', '1648770', '1733890', '1619266', '139778', '143746', '120962', '2106882', '2208450', '2119618', '2028098', '2257858', '1998018', '1502082', '2028162', '1835330', '1602178', '2294274', '2289730', '2261186', '101762', '2289602', '2288706', '1902338', '225410', '2075010', '1789826', '1799170', '2257922', '2026818', '1902402', '393794', '1784834', '288386', '1682818', '2021442', '2028418', '113602', '2206082', '1624130', '1900354', '2165506', '2194114', '28802', '98242', '1839426', '1870594', '504898', '1797506', '2158210', '1805634', '2201410', '1838722', '360386', '2007618', '1902466', '162690', '2132674', '1691586', '1474370', '2140162', '2187842', '299394', '1846530', '21442', '2008450', '200002', '1301314', '1901314', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '6', 'repurchaseIndex': '9', 'ctr7d': '0.014876607577337504', 'starts': '20220725155656', 'attractInshopPv': '10', 'first_starts_time': '1607327816298', 'payCnt30d': '7675', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '6'}, 'title': '艾丽奥利司他胶囊减肥药正品排油丸瘦身减肥减脂专用OTC官网', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '633364711648', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2020-12-07 15:56:56', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4207810;1989854:118326715;5919063:79046194;5919063:3284567;5919063:3266785;12060095:1323180239;12060620:592182279;12167949:556774857;15073217:3313463;124112492:3364499;127516969:561562160;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132270815:597878364;132270815:1327464621;132344540:13245856', 'itemId': '633364711648', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01aizxbR1zAHhsEJa3i_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '350.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '633364711648', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=666149018128', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:4;indirConvertionShopLevel:1;ctr7d:0.008975797403430037;payCnt30d:143;clk7d:56;isOnline:1;customerCoverage:8;recruitIndex:7;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220726154814;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,33705,100034556,100033788,34635,100034618,34380,33970,34867,100034882,34998,100033825,34618,100034380,34556,33788,100034635,100034697,100033705;attractInshopPv:9;marketCoverage:5;quantity:231285;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 2016386, 61442, 388354, 21826, 2234946, 98242, 2132674, 2131266, 2208450, 2269122, 281666, 57026, 531906, 143746, 413762, 2131458, 113602, 1998018, 2021442, 2206082, 1977858, 2148034, 2043010, 139778, 393794, 2026818, 349570, 10818, 360386, 2230338, 2119618, 2185986, 2230530, 1974466, 2187842, 1952450, 2238722, 21762, 49218, 21442, 2288706, 2133506, 404546, 2205762, 2193730, 200002, 2261186, 130, 25282, 2294274, 120962, 2225730, 2183298, 2223874, 1904386, 212546, 101762, 1733890, 2165506, 1474370, 346562, 2228354, 1648770, 2170242, 2194114, 299394, 2028418, 3394, 1799170, 28802, 1789826, 1835330, 2158210, 2257858, 2188354, 2201410, 1602178, 36610, 1502082, 2181762, 1900354, 2293954, 2230594, 288386];payCnt7d:28;first_starts_time:1641282494425;itemRank:0;originalStatus:0;bidCount:24533;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=666149018128', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '56', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '231285', 'tmc_tags': '100034998,33825,34882,100033970,100034867,34697,33705,100034556,100033788,34635,100034618,34380,33970,34867,100034882,34998,100033825,34618,100034380,34556,33788,100034635,100034697,100033705', 'bidCount': '24533', 'highUvValueIndex': '8', 'payCnt7d': '28', 'salesLevel': '4', 'indirConvertion': '8', 'tags': ['10818', '21762', '1789826', '1799170', '61442', '2026818', '2238722', '212546', '393794', '2181762', '288386', '531906', '2188354', '2021442', '2131458', '2028418', '2269122', '113602', '281666', '2230530', '2206082', '413762', '1904386', '2230594', '36610', '2293954', '2185986', '3394', '2193730', '1900354', '2165506', '2043010', '346562', '21826', '388354', '57026', '349570', '2194114', '2228354', '49218', '2225730', '2223874', '1952450', '28802', '2183298', '98242', '2131266', '2133506', '25282', '1648770', '2158210', '1733890', '2201410', '139778', '143746', '2178754', '360386', '120962', '2208450', '2230338', '2119618', '130', '2257858', '1998018', '1974466', '1977858', '404546', '1502082', '2132674', '1474370', '1602178', '1835330', '2294274', '2187842', '2261186', '101762', '2205762', '299394', '2234946', '21442', '200002', '2148034', '2170242', '2288706', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '9', 'ctr7d': '0.008975797403430037', 'starts': '20220726154814', 'attractInshopPv': '9', 'first_starts_time': '1641282494425', 'payCnt30d': '143', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '9', 'recruitIndex': '7'}, 'title': '雅塑奥利司他胶囊排油减脂减重瘦身国药准字减肥排油丸官方正品M', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '666149018128', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-01-04 15:48:14', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:109899538;1989854:589308221;5919063:3284566;5919063:215312402;5919063:59904168;5919063:3266779;5919063:3266785;12060095:12517140963;12060620:616524261;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:4383965;128132720:3622544;132268776:39583581;132270815:597878364;132344540:13245856', 'itemId': '666149018128', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01VeZC9S1zAHiPArnJd_!!2209842646673.jpg', 'cateNamePath': None, 'price': '120.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '666149018128', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=678689909500', 'qualityflag': None, 'tagUrls': [{'tagType': '1', 'cls': 'border-green', 'location': None, 'name': '新品', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:0;collectCartNum:6;highUvValueIndexShopLevel:0;salesLevel:2;indirConvertionShopLevel:1;ctr7d:0.01065429393822228;payCnt30d:671;clk7d:248;isOnline:1;customerCoverage:7;recruitIndex:8;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220722104309;recruitIndexShopLevel:1;tmc_tags:null;attractInshopPv:6;marketCoverage:5;quantity:9322;highUvValueIndex:5;coldSpeedingStatus:0;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 2016386, 2264898, 21762, 61442, 2288386, 21826, 1879426, 130, 25282, 1834818, 2289154, 101762, 2165506, 2289090, 346562, 113602, 2021442, 2148034, 349570, 10818, 2288770, 3394, 299394, 1834882, 28802, 1789826, 1835330, 2288578, 1834946, 2288450, 1602178, 1900354, 288386];payCnt7d:666;first_starts_time:1657852989135;itemRank:9;originalStatus:0;bidCount:113;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122294001;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=678689909500', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '6', 'shopContributionIndexShopLevel': '1', 'clk7d': '248', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '9', 'salesLevelShopLevel': '0', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '0', 'quantity': '9322', 'tmc_tags': None, 'bidCount': '113', 'highUvValueIndex': '5', 'payCnt7d': '666', 'salesLevel': '2', 'indirConvertion': '10', 'tags': ['21762', '10818', '1834818', '1789826', '25282', '61442', '2238722', '2289154', '2288386', '288386', '2021442', '113602', '130', '2288770', '2288450', '2288578', '1834882', '1879426', '1602178', '1835330', '3394', '1900354', '2264898', '2165506', '101762', '346562', '21826', '349570', '299394', '2289090', '1834946', '2148034', '2016386', '28802'], 'customerCoverage': '7', 'isNew': True, 'categoryId': '201273575 50023720 122222008 122294001', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '6', 'ctr7d': '0.01065429393822228', 'starts': '20220722104309', 'attractInshopPv': '6', 'first_starts_time': '1657852989135', 'payCnt30d': '671', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '0', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '8', 'recruitIndex': '8'}, 'title': '九芝堂足光散40g*3袋除脚气真菌感染非联苯笇唑喷雾止痒泡脚水', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '678689909500', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-07-15 10:43:09', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 122222008 122294001', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4404049;1989854:108922326;5919063:3266779;5919063:3266785;5919063:3266781;5919063:3266789;5919063:3284565;10543965:526160045;12060095:108922327;15073217:153312597;124112492:11643345;127516969:567218684;127532776:6158023;127566068:562654187;127570025:1081021068;127598100:6672878;128132720:3622544;128150061:556774857;132268776:39583581;132270815:24231493;132344540:24231493', 'itemId': '678689909500', 'imgUrl': '//img.alicdn.com/imgextra/i1/2209842646673/O1CN01eCX6i01zAHiLhO2MH_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '38.7', 'tagNames': ['新品'], 'tagName': '', 'itemNumId': '678689909500', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=641208298202', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:3;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.044738281055823434;payCnt30d:1031;clk7d:900;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220726144259;recruitIndexShopLevel:1;tmc_tags:100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:5;quantity:228835;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:9;tags:[2178754, 1839426, 2017474, 1987074, 2016386, 61442, 21826, 1702530, 2131266, 2266498, 2165442, 2269122, 225410, 143746, 2074818, 2038978, 2289090, 2021442, 1998018, 2206082, 2043010, 139778, 349570, 10818, 360386, 2230338, 2204226, 2119938, 2185986, 2120002, 2017346, 1619266, 1974658, 21762, 2017410, 2288706, 1887682, 2288386, 2064962, 200002, 2261186, 130, 296066, 25282, 2225730, 120962, 2257922, 101762, 2140162, 1991874, 1733890, 2165506, 1846530, 2098306, 346562, 1860674, 2007618, 1648770, 2288770, 2170242, 3394, 2028418, 2159746, 2064834, 2119874, 1799170, 1789826, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 2102466, 388354, 98242, 2132674, 2208450, 281666, 57026, 2203202, 531906, 413762, 2131458, 113602, 2286978, 1977858, 2064770, 393794, 2026818, 2064898, 1967490, 162690, 1892226, 2200066, 2119618, 2253954, 2230530, 1974466, 2187842, 2238722, 2264898, 2039042, 49218, 21442, 2133506, 2205762, 2243074, 2294274, 2183298, 2223874, 2307266, 1904386, 212546, 2017218, 1901314, 2106882, 1474370, 2017282, 107842, 2228354, 2251906, 2106818, 2194114, 299394, 28802, 1835330, 2288578, 2111042, 2158210, 2288450, 2188354, 2257858, 2017602, 1900354, 288386];payCnt7d:160;first_starts_time:1616747238157;itemRank:0;originalStatus:0;bidCount:57205;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=641208298202', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '3', 'shopContributionIndexShopLevel': '1', 'clk7d': '900', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '228835', 'tmc_tags': '100034998,33825,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33970,34867,100034882,33172,34998,100033825,32024,34618,100034380,34556,100034635,100034697', 'bidCount': '57205', 'highUvValueIndex': '9', 'payCnt7d': '160', 'salesLevel': '5', 'indirConvertion': '10', 'tags': ['1860674', '21762', '10818', '2307266', '2120002', '2074818', '2119874', '2238722', '2119938', '61442', '212546', '2181762', '531906', '2269122', '281666', '2230530', '413762', '1904386', '36610', '2230594', '1974658', '2293954', '2185986', '2264898', '1887682', '2043010', '2064834', '21826', '388354', '2017602', '349570', '57026', '2228354', '49218', '2225730', '2204226', '1892226', '2223874', '2183298', '2131266', '2133506', '1702530', '25282', '1648770', '2251906', '2165442', '1733890', '1619266', '139778', '143746', '2178754', '2106818', '2106882', '120962', '2208450', '2102466', '2119618', '2064962', '2257858', '1974466', '1998018', '2288450', '1502082', '1835330', '2294274', '1602178', '2017346', '2261186', '101762', '2205762', '2039042', '2064770', '2288706', '225410', '2266498', '2253954', '1789826', '1799170', '2017474', '2257922', '2026818', '2288386', '393794', '288386', '2188354', '2021442', '2131458', '2028418', '113602', '2288770', '2206082', '2288578', '3394', '1900354', '2165506', '346562', '2159746', '2194114', '2289090', '107842', '28802', '98242', '1987074', '1839426', '2243074', '2158210', '2064898', '2098306', '2017218', '2201410', '2286978', '360386', '296066', '2230338', '2007618', '130', '2203202', '162690', '2017282', '1977858', '2132674', '1474370', '2140162', '2187842', '1991874', '2111042', '299394', '21442', '1846530', '2200066', '2038978', '200002', '1967490', '1901314', '2017410', '2170242', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '9', 'ctr7d': '0.044738281055823434', 'starts': '20220726144259', 'attractInshopPv': '10', 'first_starts_time': '1616747238157', 'payCnt30d': '1031', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '10', 'recruitIndex': '6'}, 'title': '艾丽奥利司他胶囊瘦身减肥药正品排油丸减脂瘦身减肥旗舰OTC官网', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '641208298202', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2021-03-26 16:27:18', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4207810;1989854:589308221;5919063:3284567;5919063:205594680;5919063:206268731;5919063:215302757;5919063:3266789;12060095:1323180239;12060620:1000230913;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132344540:13245856', 'itemId': '641208298202', 'imgUrl': '//img.alicdn.com/imgextra/i3/2209842646673/O1CN01UwZ6Br1zAHiQ0W6jj_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '158.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '641208298202', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=668184440050', 'qualityflag': None, 'tagUrls': [], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:4;highUvValueIndexShopLevel:1;salesLevel:4;indirConvertionShopLevel:1;ctr7d:0.015173067804646752;payCnt30d:119;clk7d:32;isOnline:1;customerCoverage:9;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:7;attractInshopPvShopLevel:1;shopContributionIndex:8;starts:20220720082701;recruitIndexShopLevel:1;tmc_tags:100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:9;marketCoverage:5;quantity:42913;highUvValueIndex:9;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:10;tags:[2016386, 61442, 21826, 48706, 2132674, 2208450, 1834818, 2269122, 2203202, 143746, 113602, 1998018, 2021442, 2206082, 1977858, 2148034, 2043010, 139778, 349570, 10818, 360386, 1834946, 2230338, 2119618, 2253954, 2185986, 2230530, 2187842, 2238722, 21762, 49218, 21442, 2288706, 404546, 2205762, 2193730, 1879426, 200002, 2261186, 130, 25282, 2294274, 2225730, 2183298, 2223874, 1904386, 101762, 1733890, 346562, 107842, 2228354, 299394, 3394, 1834882, 1799170, 28802, 1789826, 1835330, 2257858, 2201410, 1602178, 1502082, 1900354, 2293954, 2230594, 288386];payCnt7d:9;first_starts_time:1645085937585;itemRank:0;originalStatus:0;bidCount:14299;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=668184440050', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '4', 'shopContributionIndexShopLevel': '1', 'clk7d': '32', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '42913', 'tmc_tags': '100034998,34882,100034867,34697,100034556,34635,100034618,34380,34867,100034882,34998,34618,100034380,34556,100034635,100034697', 'bidCount': '14299', 'highUvValueIndex': '9', 'payCnt7d': '9', 'salesLevel': '4', 'indirConvertion': '7', 'tags': ['10818', '21762', '1834818', '2253954', '1789826', '1799170', '61442', '2238722', '288386', '2021442', '2269122', '113602', '2230530', '2206082', '1904386', '2230594', '2293954', '2185986', '3394', '2193730', '1900354', '2043010', '346562', '21826', '349570', '2228354', '49218', '2225730', '107842', '2223874', '28802', '2183298', '25282', '1733890', '2201410', '139778', '143746', '360386', '2208450', '2230338', '2119618', '130', '2203202', '2257858', '1998018', '1977858', '404546', '1502082', '48706', '2132674', '1834882', '1879426', '1602178', '1835330', '2294274', '2187842', '2261186', '101762', '2205762', '299394', '21442', '200002', '1834946', '2148034', '2288706', '2016386'], 'customerCoverage': '9', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '10', 'ctr7d': '0.015173067804646752', 'starts': '20220720082701', 'attractInshopPv': '9', 'first_starts_time': '1645085937585', 'payCnt30d': '119', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '8', 'recruitIndex': '6'}, 'title': '赛洛兰奥利司他减肥胶囊正品排油丸减肥治疗肥胖减重瘦身脂肪nn', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '668184440050', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-02-17 16:18:57', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:1878075452;1989854:589308221;5919063:3266785;5919063:3266781;5919063:3266789;5919063:3266786;5919063:3284566;12060095:159606431;12060620:1006794461;12167949:556774857;15073217:3313463;124112492:3364499;127516969:14619650662;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132268776:39583581;132270815:13245856;132270815:1081806004;132270815:1327353185;132344540:597878364;132344540:1327353185;132344540:13245856', 'itemId': '668184440050', 'imgUrl': '//img.alicdn.com/imgextra/i2/2209842646673/O1CN01KasC0N1zAHiKeiyEQ_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '180.0', 'tagNames': [], 'tagName': '', 'itemNumId': '668184440050', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=655875932971', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:0;collectCartNum:6;highUvValueIndexShopLevel:1;salesLevel:2;indirConvertionShopLevel:-1;ctr7d:0.024024024024024024;payCnt30d:28;clk7d:48;isOnline:1;customerCoverage:8;recruitIndex:9;customerCoverageShopLevel:1;shopContributionIndexShopLevel:-1;marketCoverageShopLevel:1;indirConvertion:3;attractInshopPvShopLevel:-1;shopContributionIndex:4;starts:20220720103832;recruitIndexShopLevel:1;tmc_tags:100034998,100033079,34882,100033970,100034867,100033150,100035071,100034556,34635,100034618,33745,100033506,100033825,100033705,33825,33506,100033745,33705,33970,34867,100034882,34998,33079,34618,34556,100034635,33150,35071;attractInshopPv:4;marketCoverage:5;quantity:14957;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:7;tags:[2016386, 61442, 388354, 98242, 249858, 2132674, 2131266, 165186, 1834818, 2028162, 225410, 57026, 2038978, 2016450, 113602, 2021442, 1998018, 2206082, 2064770, 2043010, 139778, 1691586, 10818, 46914, 1875650, 360386, 2304642, 1834946, 2230338, 2119618, 2119938, 2120002, 2230530, 2254402, 2238722, 2264898, 1682818, 49218, 2288386, 2240002, 1879426, 130, 296066, 2304834, 25282, 2294274, 120962, 258, 2183298, 2223874, 101762, 2140162, 2018178, 2098306, 2106818, 292354, 2170242, 299394, 3394, 2119874, 1834882, 1799170, 28802, 1789826, 1835330, 2288578, 2028098, 2111042, 2158210, 1805634, 2288450, 2257858, 1602178, 1502082, 1900354, 2293954, 2230594, 1739842];payCnt7d:5;first_starts_time:1632967314494;itemRank:0;originalStatus:0;bidCount:197;repurchaseIndexShopLevel:1;categoryId:50026800 125046003 125076012 125100024;collectCartNumShopLevel:1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=655875932971', 'extraAttributes': {'collectCartNumShopLevel': '1', 'recruitIndexShopLevel': '1', 'collectCartNum': '6', 'shopContributionIndexShopLevel': '-1', 'clk7d': '48', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '0', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '14957', 'tmc_tags': '100034998,100033079,34882,100033970,100034867,100033150,100035071,100034556,34635,100034618,33745,100033506,100033825,100033705,33825,33506,100033745,33705,33970,34867,100034882,34998,33079,34618,34556,100034635,33150,35071', 'bidCount': '197', 'highUvValueIndex': '8', 'payCnt7d': '5', 'salesLevel': '2', 'indirConvertion': '3', 'tags': ['225410', '10818', '2120002', '46914', '1834818', '1789826', '1799170', '2119874', '61442', '2119938', '2238722', '2240002', '2288386', '249858', '1682818', '2021442', '113602', '2016450', '165186', '2230530', '2206082', '2288578', '2230594', '2293954', '2304834', '1739842', '3394', '1900354', '2264898', '2043010', '388354', '57026', '49218', '2223874', '28802', '2183298', '98242', '2131266', '2254402', '2018178', '25282', '2158210', '1805634', '2098306', '292354', '139778', '360386', '2106818', '2304642', '120962', '296066', '2230338', '2119618', '2028098', '130', '2257858', '1875650', '1998018', '2288450', '1502082', '2132674', '1834882', '1691586', '1879426', '2028162', '1602178', '1835330', '2140162', '2294274', '2111042', '101762', '299394', '2064770', '2038978', '258', '1834946', '2170242', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '50026800 125046003 125076012 125100024', 'indirConvertionShopLevel': '-1', 'marketCoverage': '5', 'repurchaseIndex': '7', 'ctr7d': '0.024024024024024024', 'starts': '20220720103832', 'attractInshopPv': '4', 'first_starts_time': '1632967314494', 'payCnt30d': '28', 'attractInshopPvShopLevel': '-1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '4', 'recruitIndex': '9'}, 'title': '太极睡好片助改善失眠深度睡眠片退褪黑色素片定眠官方正品', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '655875932971', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2021-09-30 10:01:54', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '50026800 125046003 125076012 125100024', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:1863363448;256289359:564214112;20759:29404;21299:72700378;24477:3493528;1627207:3232484;1627207:3232482;1627207:28340;1989873:6672878;12060095:136232626;15073217:3508415;122216443:6455433785;122216962:3220625;128132720:3622544;222264532:10257350;224607339:21958;228679447:93968215;231463732:3228288', 'itemId': '655875932971', 'imgUrl': '//img.alicdn.com/imgextra/i4/2209842646673/O1CN01vc8laS1zAHiHhF2dT_!!2209842646673.jpg', 'cateNamePath': None, 'price': '108.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '655875932971', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=677308780627', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:5;highUvValueIndexShopLevel:1;salesLevel:3;indirConvertionShopLevel:1;ctr7d:0.016644208688390807;payCnt30d:145;clk7d:877;isOnline:1;customerCoverage:8;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725102333;recruitIndexShopLevel:1;tmc_tags:100034998,34998;attractInshopPv:8;marketCoverage:5;quantity:25055;highUvValueIndex:8;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 2016386, 2264898, 21762, 21442, 2288386, 21826, 200002, 1702530, 2132674, 25282, 2269122, 2289154, 1904386, 101762, 143746, 2165506, 1846530, 2289090, 346562, 113602, 2021442, 2148034, 349570, 10818, 2288770, 299394, 28802, 1789826, 1835330, 2288578, 2288450, 2201410, 1602178, 1900354, 2293954, 2187842, 288386];payCnt7d:92;first_starts_time:1656572881306;itemRank:10;originalStatus:0;bidCount:143;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122294001;collectCartNumShopLevel:0', 'displayUrl': 'http://detail.tmall.com/item.htm?id=677308780627', 'extraAttributes': {'collectCartNumShopLevel': '0', 'recruitIndexShopLevel': '1', 'collectCartNum': '5', 'shopContributionIndexShopLevel': '1', 'clk7d': '877', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '10', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '25055', 'tmc_tags': '100034998,34998', 'bidCount': '143', 'highUvValueIndex': '8', 'payCnt7d': '92', 'salesLevel': '3', 'indirConvertion': '10', 'tags': ['10818', '21762', '1702530', '1789826', '25282', '2238722', '2288386', '2289154', '2201410', '143746', '288386', '2021442', '2269122', '113602', '2288770', '2288450', '2288578', '1904386', '2132674', '2293954', '1602178', '1835330', '2187842', '1900354', '2264898', '2165506', '101762', '346562', '21826', '299394', '21442', '1846530', '349570', '2289090', '200002', '2148034', '2016386', '28802'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 122222008 122294001', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '6', 'ctr7d': '0.016644208688390807', 'starts': '20220725102333', 'attractInshopPv': '8', 'first_starts_time': '1656572881306', 'payCnt30d': '145', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '9', 'recruitIndex': '10'}, 'title': '洛芙 联苯苄唑溶液60ml 去脚气喷雾搽剂止痒脱皮脚臭香港脚手足癣', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '677308780627', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2022-06-30 15:08:01', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 122222008 122294001', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:82994705;1989854:146933453;5919063:501970821;5919063:3284565;5919063:3266786;5919063:3266779;5919063:3266785;5919063:3266781;10543965:73281184;12060095:804428638;15073217:557074379;124112492:11643345;127516969:12284560;127532776:560808278;127570025:560808278;127598100:6672878;128132720:26878;128150061:556774857;132270815:77534680;132344540:27233421', 'itemId': '677308780627', 'imgUrl': '//img.alicdn.com/imgextra/i2/2209842646673/O1CN017c4o2A1zAHi6WxtN7_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '90.0', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '677308780627', 'isTaobaoMall': None, 'srcFlag': None}, {'expireTime': '2524579200000', 'cartTotal': None, 'linkUrl': 'http://detail.tmall.com/item.htm?id=637513470792', 'qualityflag': None, 'tagUrls': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'lastSyncTime': None, 'click': None, 'couponUsableFlag': None, 'mutiImageURL': None, 'saleStarLevel': '1', 'extensions': 'salesLevelShopLevel:1;collectCartNum:3;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.017868585342633785;payCnt30d:2728;clk7d:976;isOnline:1;customerCoverage:8;recruitIndex:6;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:8;attractInshopPvShopLevel:1;shopContributionIndex:9;starts:20220725143126;recruitIndexShopLevel:1;tmc_tags:100034998,800131953,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33745,33172,100033825,32024,33825,100033745,33970,34867,100034882,34998,34618,100034380,34556,100034635,100034697;attractInshopPv:10;marketCoverage:5;quantity:355659;highUvValueIndex:6;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:10;tags:[2178754, 1839426, 1987074, 2016386, 21826, 2188162, 2234946, 2008514, 1702530, 2269122, 225410, 143746, 2254274, 2278402, 1973186, 1649602, 2021442, 1998018, 2206082, 2148034, 2043010, 139778, 349570, 2122818, 360386, 2230338, 2185986, 2238210, 5826, 1619266, 1974658, 21762, 1682818, 2288706, 1887682, 2000258, 1831682, 200002, 2261186, 25282, 2225730, 120962, 2248898, 362178, 2027970, 450114, 2257922, 101762, 2140162, 1991874, 1733890, 2165506, 1846530, 285186, 1478530, 1704322, 346562, 2170242, 1799170, 1835010, 1870594, 1789826, 2166786, 2028098, 1805634, 2008386, 1982018, 2201410, 1602178, 36610, 1502082, 2181762, 2293954, 2230594, 1902338, 368066, 388354, 98242, 2132674, 2208450, 1959874, 504898, 2028162, 281666, 1823554, 1880514, 57026, 2030018, 531906, 413762, 1902466, 113602, 1977858, 393794, 1691586, 1967490, 162690, 1892226, 1784834, 2188098, 2119618, 2253954, 2028034, 2230530, 1974466, 2187842, 2238722, 2264898, 49218, 21442, 2133506, 2205762, 1993858, 2294274, 2254338, 452738, 2183298, 2223874, 1904386, 1624130, 2008450, 212546, 1901314, 2106882, 1474370, 1481986, 2228354, 299394, 28802, 1835330, 2223106, 2158210, 2188354, 2257858, 2254466, 1900354, 288386];payCnt7d:561;first_starts_time:1611556286893;itemRank:0;originalStatus:0;bidCount:184685;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 50023733;collectCartNumShopLevel:-1', 'displayUrl': 'http://detail.tmall.com/item.htm?id=637513470792', 'extraAttributes': {'collectCartNumShopLevel': '-1', 'recruitIndexShopLevel': '1', 'collectCartNum': '3', 'shopContributionIndexShopLevel': '1', 'clk7d': '976', 'customerCoverageShopLevel': '1', 'originalStatus': '0', 'isOnline': '1', 'itemRank': '0', 'salesLevelShopLevel': '1', 'attractIndex': None, 'repurchaseIndexShopLevel': '1', 'coldSpeedingStatus': '-1', 'quantity': '355659', 'tmc_tags': '100034998,800131953,34882,100033970,100034867,34697,100034556,34635,100034618,34380,33745,33172,100033825,32024,33825,100033745,33970,34867,100034882,34998,34618,100034380,34556,100034635,100034697', 'bidCount': '184685', 'highUvValueIndex': '6', 'payCnt7d': '561', 'salesLevel': '5', 'indirConvertion': '8', 'tags': ['1481986', '21762', '2238722', '212546', '2181762', '2248898', '2254274', '531906', '450114', '2008386', '1478530', '2269122', '2254338', '281666', '2230530', '2238210', '413762', '1904386', '36610', '2230594', '1974658', '2293954', '2185986', '1704322', '1649602', '2264898', '1887682', '2043010', '21826', '1959874', '388354', '349570', '57026', '2228354', '49218', '2166786', '2225730', '1892226', '2223874', '2183298', '1993858', '2133506', '1702530', '25282', '1733890', '1619266', '5826', '139778', '143746', '2178754', '2106882', '120962', '2208450', '2119618', '2028098', '2257858', '1974466', '1998018', '1502082', '2028162', '1835330', '2294274', '1602178', '2261186', '101762', '2205762', '2000258', '2254466', '2288706', '1902338', '225410', '2253954', '1789826', '1799170', '2223106', '2257922', '1784834', '393794', '288386', '2028034', '1682818', '2188354', '2021442', '1880514', '113602', '2206082', '285186', '452738', '1624130', '1900354', '2165506', '346562', '2030018', '1823554', '28802', '1831682', '98242', '1987074', '1839426', '1973186', '1870594', '368066', '2122818', '504898', '2158210', '1805634', '2201410', '360386', '362178', '2230338', '1902466', '1835010', '162690', '1977858', '2132674', '2188098', '1474370', '1691586', '2027970', '2140162', '2008514', '2187842', '1991874', '2278402', '1982018', '299394', '21442', '2234946', '1846530', '2008450', '200002', '1967490', '1901314', '2148034', '2188162', '2170242', '2016386'], 'customerCoverage': '8', 'isNew': True, 'categoryId': '201273575 50023720 50023733', 'indirConvertionShopLevel': '1', 'marketCoverage': '5', 'repurchaseIndex': '10', 'ctr7d': '0.017868585342633785', 'starts': '20220725143126', 'attractInshopPv': '10', 'first_starts_time': '1611556286893', 'payCnt30d': '2728', 'attractInshopPvShopLevel': '1', 'highUvValueIndexShopLevel': '1', 'marketCoverageShopLevel': '1', 'shopContributionIndex': '9', 'recruitIndex': '6'}, 'title': '艾丽奥利司他胶囊6粒减肥药正品瘦身旗舰减脂专用排油丸OTC官网', 'skuPrice': None, 'newItem': False, 'kgbClick': None, 'userCharId': '2209842646673', 'itemCharId': '637513470792', 'timing': False, 'wirelessLongImageURL': None, 'onsaleTime': '2021-01-25 14:31:26', 'landGmv': None, 'qualityflagreason': None, 'potentialRate': None, 'userNumId': '2209842646673', 'status': '1', 'sortId': '201273575 50023720 50023733', 'competitionRate': None, 'estPv': None, 'recommendReason': None, 'properties': '20000:4207810;1989854:589308221;5919063:3266779;5919063:206264795;5919063:3266785;5919063:215312402;12060095:1323180239;12060620:1124722041;12167949:556774857;15073217:3313463;124112492:3364499;127516969:12284560;127532776:73567370;127570025:73567370;127598100:9695512;128132720:3622544;132270815:13245856;132344540:13245856', 'itemId': '637513470792', 'imgUrl': '//img.alicdn.com/imgextra/i3/2209842646673/O1CN01pn3NMQ1zAHhoC8sv6_!!0-item_pic.jpg', 'cateNamePath': None, 'price': '29.9', 'tagNames': ['优选好货'], 'tagName': '', 'itemNumId': '637513470792', 'isTaobaoMall': None, 'srcFlag': None}], 'path': "source_root.get('result').get('data')"}, {'key': 'expire_time', 'value': '2524579200000', 'path': "source_root.get('result').get('data')[0].get('expireTime')"}, {'key': 'cart_total', 'value': None, 'path': "source_root.get('result').get('data')[0].get('cartTotal')"}, {'key': 'link_url', 'value': 'http://detail.tmall.com/item.htm?id=676835988580', 'path': "source_root.get('result').get('data')[0].get('linkUrl')"}, {'key': 'qualityflag', 'value': None, 'path': "source_root.get('result').get('data')[0].get('qualityflag')"}, {'key': 'tag_urls', 'value': [{'tagType': '10', 'cls': 'border-red', 'location': None, 'name': '优选好货', 'type': 'txt'}], 'path': "source_root.get('result').get('data')[0].get('tagUrls')"}, {'key': 'tag_type', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('tagUrls')[0].get('tagType')"}, {'key': 'cls', 'value': 'border-red', 'path': "source_root.get('result').get('data')[0].get('tagUrls')[0].get('cls')"}, {'key': 'name', 'value': '优选好货', 'path': "source_root.get('result').get('data')[0].get('tagUrls')[0].get('name')"}, {'key': 'type', 'value': 'txt', 'path': "source_root.get('result').get('data')[0].get('tagUrls')[0].get('type')"}, {'key': 'last_sync_time', 'value': None, 'path': "source_root.get('result').get('data')[0].get('lastSyncTime')"}, {'key': 'click', 'value': None, 'path': "source_root.get('result').get('data')[0].get('click')"}, {'key': 'coupon_usable_flag', 'value': None, 'path': "source_root.get('result').get('data')[0].get('couponUsableFlag')"}, {'key': 'muti_image_u_r_l', 'value': None, 'path': "source_root.get('result').get('data')[0].get('mutiImageURL')"}, {'key': 'sale_star_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('saleStarLevel')"}, {'key': 'extensions', 'value': 'salesLevelShopLevel:1;collectCartNum:8;highUvValueIndexShopLevel:1;salesLevel:5;indirConvertionShopLevel:1;ctr7d:0.024633494038408216;payCnt30d:4134;clk7d:2754;isOnline:1;customerCoverage:8;recruitIndex:10;customerCoverageShopLevel:1;shopContributionIndexShopLevel:1;marketCoverageShopLevel:1;indirConvertion:10;attractInshopPvShopLevel:1;shopContributionIndex:10;starts:20220722200000;recruitIndexShopLevel:1;tmc_tags:100034998,34998;attractInshopPv:10;marketCoverage:8;quantity:7059;highUvValueIndex:6;coldSpeedingStatus:-1;attractIndex:null;isNew:true;repurchaseIndex:6;tags:[2238722, 1839426, 1987074, 2016386, 21762, 404546, 2133506, 21826, 25346, 2193730, 2008514, 1702530, 25282, 2248898, 281666, 1880514, 57026, 212546, 101762, 2030018, 531906, 1991874, 2165506, 1973186, 1846530, 285186, 1474370, 113602, 2021442, 2148034, 349570, 299394, 28802, 1789826, 1835010, 1835330, 2119618, 2185986, 1602178, 1900354, 2293954, 288386, 5826];payCnt7d:842;first_starts_time:1655973858234;itemRank:10;originalStatus:0;bidCount:3986;repurchaseIndexShopLevel:1;categoryId:201273575 50023720 122222008 122292001;collectCartNumShopLevel:1', 'path': "source_root.get('result').get('data')[0].get('extensions')"}, {'key': 'display_url', 'value': 'http://detail.tmall.com/item.htm?id=676835988580', 'path': "source_root.get('result').get('data')[0].get('displayUrl')"}, {'key': 'collect_cart_num_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('collectCartNumShopLevel')"}, {'key': 'recruit_index_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('recruitIndexShopLevel')"}, {'key': 'collect_cart_num', 'value': '8', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('collectCartNum')"}, {'key': 'shop_contribution_index_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('shopContributionIndexShopLevel')"}, {'key': 'clk_7d', 'value': '2754', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('clk7d')"}, {'key': 'customer_coverage_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('customerCoverageShopLevel')"}, {'key': 'original_status', 'value': '0', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('originalStatus')"}, {'key': 'is_online', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('isOnline')"}, {'key': 'item_rank', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('itemRank')"}, {'key': 'sales_level_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('salesLevelShopLevel')"}, {'key': 'attract_index', 'value': None, 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('attractIndex')"}, {'key': 'repurchase_index_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('repurchaseIndexShopLevel')"}, {'key': 'cold_speeding_status', 'value': '-1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('coldSpeedingStatus')"}, {'key': 'quantity', 'value': '7059', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('quantity')"}, {'key': 'tmc__tags', 'value': '100034998,34998', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('tmc_tags')"}, {'key': 'bid_count', 'value': '3986', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('bidCount')"}, {'key': 'high_uv_value_index', 'value': '6', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('highUvValueIndex')"}, {'key': 'pay_cnt_7d', 'value': '842', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('payCnt7d')"}, {'key': 'sales_level', 'value': '5', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('salesLevel')"}, {'key': 'indir_convertion', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('indirConvertion')"}, {'key': 'tags', 'value': ['21762', '1987074', '1839426', '2133506', '1973186', '1702530', '1789826', '25282', '25346', '2238722', '212546', '5826', '288386', '2248898', '531906', '2021442', '1880514', '2119618', '113602', '1835010', '281666', '285186', '404546', '2293954', '1474370', '1602178', '1835330', '2008514', '2185986', '2193730', '1900354', '1991874', '2165506', '101762', '21826', '299394', '349570', '1846530', '57026', '2030018', '2148034', '2016386', '28802'], 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('tags')"}, {'key': 'customer_coverage', 'value': '8', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('customerCoverage')"}, {'key': 'is_new', 'value': True, 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('isNew')"}, {'key': 'category_id', 'value': '201273575 50023720 122222008 122292001', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('categoryId')"}, {'key': 'indir_convertion_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('indirConvertionShopLevel')"}, {'key': 'market_coverage', 'value': '8', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('marketCoverage')"}, {'key': 'repurchase_index', 'value': '6', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('repurchaseIndex')"}, {'key': 'ctr_7d', 'value': '0.024633494038408216', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('ctr7d')"}, {'key': 'starts', 'value': '20220722200000', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('starts')"}, {'key': 'attract_inshop_pv', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('attractInshopPv')"}, {'key': 'first__starts__time', 'value': '1655973858234', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('first_starts_time')"}, {'key': 'pay_cnt_3_0d', 'value': '4134', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('payCnt30d')"}, {'key': 'attract_inshop_pv_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('attractInshopPvShopLevel')"}, {'key': 'high_uv_value_index_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('highUvValueIndexShopLevel')"}, {'key': 'market_coverage_shop_level', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('marketCoverageShopLevel')"}, {'key': 'shop_contribution_index', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('shopContributionIndex')"}, {'key': 'recruit_index', 'value': '10', 'path': "source_root.get('result').get('data')[0].get('extraAttributes').get('recruitIndex')"}, {'key': 'title', 'value': '丽芙甲硝唑凝胶用于炎症性丘疹酒渣鼻红斑修复甲硝唑消炎凝胶', 'path': "source_root.get('result').get('data')[0].get('title')"}, {'key': 'sku_price', 'value': None, 'path': "source_root.get('result').get('data')[0].get('skuPrice')"}, {'key': 'new_item', 'value': False, 'path': "source_root.get('result').get('data')[0].get('newItem')"}, {'key': 'kgb_click', 'value': None, 'path': "source_root.get('result').get('data')[0].get('kgbClick')"}, {'key': 'user_char_id', 'value': '2209842646673', 'path': "source_root.get('result').get('data')[0].get('userCharId')"}, {'key': 'item_char_id', 'value': '676835988580', 'path': "source_root.get('result').get('data')[0].get('itemCharId')"}, {'key': 'timing', 'value': False, 'path': "source_root.get('result').get('data')[0].get('timing')"}, {'key': 'wireless_long_image_u_r_l', 'value': None, 'path': "source_root.get('result').get('data')[0].get('wirelessLongImageURL')"}, {'key': 'onsale_time', 'value': '2022-06-23 16:44:18', 'path': "source_root.get('result').get('data')[0].get('onsaleTime')"}, {'key': 'land_gmv', 'value': None, 'path': "source_root.get('result').get('data')[0].get('landGmv')"}, {'key': 'qualityflagreason', 'value': None, 'path': "source_root.get('result').get('data')[0].get('qualityflagreason')"}, {'key': 'potential_rate', 'value': None, 'path': "source_root.get('result').get('data')[0].get('potentialRate')"}, {'key': 'user_num_id', 'value': '2209842646673', 'path': "source_root.get('result').get('data')[0].get('userNumId')"}, {'key': 'status', 'value': '1', 'path': "source_root.get('result').get('data')[0].get('status')"}, {'key': 'sort_id', 'value': '201273575 50023720 122222008 122292001', 'path': "source_root.get('result').get('data')[0].get('sortId')"}, {'key': 'competition_rate', 'value': None, 'path': "source_root.get('result').get('data')[0].get('competitionRate')"}, {'key': 'est_pv', 'value': None, 'path': "source_root.get('result').get('data')[0].get('estPv')"}, {'key': 'recommend_reason', 'value': None, 'path': "source_root.get('result').get('data')[0].get('recommendReason')"}, {'key': 'properties', 'value': '20000:15825736;1989854:137503148;5919063:3266779;5919063:3266785;5919063:3266781;10543965:563694485;12060095:12020975944;15073217:7146152;124112492:11643345;127516969:565140599;127532776:66047117;127570025:66047117;127598100:9695512;128132720:26878;128150061:556774857;132268776:39583581;132270815:1327353772;132270815:1142524358;132270815:1327353771;132344540:1142524358;132344540:1327353772;132344540:1327353771', 'path': "source_root.get('result').get('data')[0].get('properties')"}, {'key': 'item_id', 'value': '676835988580', 'path': "source_root.get('result').get('data')[0].get('itemId')"}, {'key': 'img_url', 'value': '//img.alicdn.com/imgextra/i2/2209842646673/O1CN010LstZk1zAHiQbZZOw_!!2209842646673.jpg', 'path': "source_root.get('result').get('data')[0].get('imgUrl')"}, {'key': 'cate_name_path', 'value': None, 'path': "source_root.get('result').get('data')[0].get('cateNamePath')"}, {'key': 'price', 'value': '41.7', 'path': "source_root.get('result').get('data')[0].get('price')"}, {'key': 'tag_names', 'value': ['优选好货'], 'path': "source_root.get('result').get('data')[0].get('tagNames')"}, {'key': 'tag_name', 'value': '', 'path': "source_root.get('result').get('data')[0].get('tagName')"}, {'key': 'item_num_id', 'value': '676835988580', 'path': "source_root.get('result').get('data')[0].get('itemNumId')"}, {'key': 'is_taobao_mall', 'value': None, 'path': "source_root.get('result').get('data')[0].get('isTaobaoMall')"}, {'key': 'src_flag', 'value': None, 'path': "source_root.get('result').get('data')[0].get('srcFlag')"}, {'key': 'errors', 'value': [], 'path': "source_root.get('errors')"}, {'key': 'cause', 'value': None, 'path': "source_root.get('cause')"}, {'key': 'analyse_trace_id', 'value': None, 'path': "source_root.get('analyseTraceId')"}, {'key': 'illogic', 'value': None, 'path': "source_root.get('illogic')"}, {'key': 'member_id', 'value': None, 'path': "source_root.get('memberId')"}, {'key': 'code', 'value': '200', 'path': "source_root.get('code')"}, {'key': 'inner_msg', 'value': None, 'path': "source_root.get('innerMsg')"}, {'key': 'success', 'value': True, 'path': "source_root.get('success')"}, {'key': 'msg', 'value': None, 'path': "source_root.get('msg')"}]
    create_msql_table("55", q)
