from ..guardpoint_utils import GuardPointResponse
from ..guardpoint_dataclasses import Area
from ..guardpoint_error import GuardPointError, GuardPointUnauthorized


class AreasAPI:
    async def get_areas(self):
        url = "/odata/API_Areas"
        headers = {
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }

        code, json_body = await self.gp_json_query("GET", headers=headers, url=url)

        if code != 200:
            error_msg = GuardPointResponse.extract_error_msg(json_body)

            if code == 401:
                raise GuardPointUnauthorized(f"Unauthorized - ({error_msg})")
            elif code == 404:  # Not Found
                raise GuardPointError(f"Cardholder Not Found")
            else:
                raise GuardPointError(f"{error_msg}")

        if not isinstance(json_body, dict):
            raise GuardPointError("Badly formatted response.")
        if 'value' not in json_body:
            raise GuardPointError("Badly formatted response.")
        if not isinstance(json_body['value'], list):
            raise GuardPointError("Badly formatted response.")

        areas = []
        for x in json_body['value']:
            areas.append(Area(x))
        return areas