from typing import overload
from typing import TypeVar
from .RenderCommon_RenderElement import *
from .ItemStackHelper import *
from .RenderCommon_Item import *

MatrixStack = TypeVar["net.minecraft.client.util.math.MatrixStack"]
ItemStack = TypeVar["net.minecraft.item.ItemStack"]

class RenderCommon_Item(RenderCommon_RenderElement):
	item: ItemStack
	ovText: str
	overlay: bool
	scale: float
	rotation: float
	x: int
	y: int
	zIndex: int

	@overload
	def __init__(self, x: int, y: int, zIndex: int, id: str, overlay: bool, scale: float, rotation: float) -> None:
		pass

	@overload
	def __init__(self, x: int, y: int, zIndex: int, i: ItemStackHelper, overlay: bool, scale: float, rotation: float) -> None:
		pass

	@overload
	def setPos(self, x: int, y: int) -> "RenderCommon_Item":
		pass

	@overload
	def setScale(self, scale: float) -> "RenderCommon_Item":
		pass

	@overload
	def setRotation(self, rotation: float) -> "RenderCommon_Item":
		pass

	@overload
	def setOverlay(self, overlay: bool) -> "RenderCommon_Item":
		pass

	@overload
	def setOverlayText(self, ovText: str) -> "RenderCommon_Item":
		pass

	@overload
	def setItem(self, i: ItemStackHelper) -> "RenderCommon_Item":
		pass

	@overload
	def setItem(self, id: str, count: int) -> "RenderCommon_Item":
		pass

	@overload
	def getItem(self) -> ItemStackHelper:
		pass

	@overload
	def render(self, matrices: MatrixStack, mouseX: int, mouseY: int, delta: float) -> None:
		pass

	@overload
	def getZIndex(self) -> int:
		pass

	pass


