"""a Plotly Dash app used to explore collider observables."""

# ==================================================================================================
# --- Imports
# ==================================================================================================
import importlib.metadata
import logging

# ==================================================================================================
# --- Package version
# ==================================================================================================
try:
    __version__ = importlib.metadata.version("collider-dashboard")
except importlib.metadata.PackageNotFoundError:
    __version__ = "unknown"
# ==================================================================================================
# --- Customize logging
# ==================================================================================================
logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s.%(msecs)03d %(levelname)s %(module)s - %(funcName)s: %(message)s",
    datefmt="%Y-%m-%d %H:%M:%S",
)

# ==================================================================================================
# --- Import build_app to namespace
# ==================================================================================================
logging.info("Starting imports")
