/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.optimization.GoldenSectionLineSearch;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.DoubleUnaryOperator;

public class CRFBiasedClassifier<IN extends CoreMap>
extends CRFClassifier<IN> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CRFBiasedClassifier.class);
    private static final String BIAS = "@@@DECODING_CLASS_BIAS@@@";
    private boolean testTime = false;

    public CRFBiasedClassifier(Properties props) {
        super(props);
    }

    public CRFBiasedClassifier(SeqClassifierFlags flags) {
        super(flags);
    }

    @Override
    public CRFDatum<List<String>, CRFLabel> makeDatum(List<IN> info, int loc, List<FeatureFactory<IN>> featureFactories) {
        this.pad.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
        PaddedList<CoreMap> pInfo = new PaddedList<CoreMap>(info, this.pad);
        ArrayList features = new ArrayList();
        Set<Clique> done = Generics.newHashSet();
        for (int i = 0; i < this.windowSize; ++i) {
            ArrayList<String> featuresC = new ArrayList<String>();
            List<Clique> windowCliques = FeatureFactory.getCliques(i, 0);
            windowCliques.removeAll(done);
            done.addAll(windowCliques);
            for (Clique c : windowCliques) {
                for (FeatureFactory<CoreMap> featureFactory : featureFactories) {
                    featuresC.addAll(featureFactory.getCliqueFeatures(pInfo, loc, c));
                }
            }
            if (this.testTime && i == 0) {
                featuresC.add(BIAS);
            }
            features.add(featuresC);
        }
        int[] labels = new int[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            String answer = (String)pInfo.get(loc + i - this.windowSize + 1).get(CoreAnnotations.AnswerAnnotation.class);
            labels[i] = this.classIndex.indexOf(answer);
        }
        return new CRFDatum<List<String>, CRFLabel>(features, new CRFLabel(labels), null);
    }

    private void addBiasFeature() {
        if (!this.featureIndex.contains(BIAS)) {
            this.featureIndex.add(BIAS);
            double[][] newWeights = new double[this.weights.length + 1][];
            System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
            newWeights[this.weights.length] = new double[this.classIndex.size()];
            this.weights = newWeights;
        }
    }

    public void setBiasWeight(String cname, double weight) {
        int ci = this.classIndex.indexOf(cname);
        this.setBiasWeight(ci, weight);
    }

    public void setBiasWeight(int cindex, double weight) {
        this.addBiasFeature();
        int fi = this.featureIndex.indexOf(BIAS);
        this.weights[fi][cindex] = weight;
    }

    @Override
    public List<IN> classify(List<IN> document) {
        this.testTime = true;
        List<IN> l = super.classify(document);
        this.testTime = false;
        return l;
    }

    public void adjustBias(List<List<IN>> develData, DoubleUnaryOperator evalFunction, double low, double high) {
        GoldenSectionLineSearch ls = new GoldenSectionLineSearch(true, 0.01, low, high);
        CRFBiasedClassifierOptimizer optimizer = new CRFBiasedClassifierOptimizer(this, evalFunction);
        double optVal = ls.minimize(optimizer);
        int bi = this.featureIndex.indexOf(BIAS);
        log.info("Class bias of " + this.weights[bi][0] + " reaches optimal value " + optVal);
    }

    public static void main(String[] args) throws Exception {
        StringUtils.logInvocationString(log, args);
        Properties props = StringUtils.argsToProperties(args);
        CRFBiasedClassifier crf = new CRFBiasedClassifier(props);
        String testFile = crf.flags.testFile;
        String loadPath = crf.flags.loadClassifier;
        if (loadPath != null) {
            crf.loadClassifierNoExceptions(loadPath, props);
        } else if (crf.flags.loadJarClassifier != null) {
            crf.loadClassifierNoExceptions(crf.flags.loadJarClassifier, props);
        } else {
            crf.loadDefaultClassifier();
        }
        if (crf.flags.classBias != null) {
            StringTokenizer biases = new StringTokenizer(crf.flags.classBias, ",");
            while (biases.hasMoreTokens()) {
                StringTokenizer bias = new StringTokenizer(biases.nextToken(), ":");
                String cname = bias.nextToken();
                double w = Double.parseDouble(bias.nextToken());
                crf.setBiasWeight(cname, w);
                log.info("Setting bias for class " + cname + " to " + w);
            }
        }
        if (testFile != null) {
            DocumentReaderAndWriter readerAndWriter = crf.makeReaderAndWriter();
            if (crf.flags.printFirstOrderProbs) {
                crf.printFirstOrderProbs(testFile, readerAndWriter);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile, readerAndWriter);
            } else if (crf.flags.useKBest) {
                int k = crf.flags.kBest;
                crf.classifyAndWriteAnswersKBest(testFile, k, readerAndWriter);
            } else {
                crf.classifyAndWriteAnswers(testFile, readerAndWriter, true);
            }
        }
    }

    class CRFBiasedClassifierOptimizer
    implements DoubleUnaryOperator {
        private final CRFBiasedClassifier<IN> crf;
        private final DoubleUnaryOperator evalFunction;

        CRFBiasedClassifierOptimizer(CRFBiasedClassifier<IN> c, DoubleUnaryOperator e) {
            this.crf = c;
            this.evalFunction = e;
        }

        @Override
        public double applyAsDouble(double w) {
            this.crf.setBiasWeight(0, w);
            return this.evalFunction.applyAsDouble(w);
        }
    }
}

