/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;

public class IterableIterator<E>
implements Iterator<E>,
Iterable<E> {
    private Iterator<E> it;
    private Iterable<E> iterable;
    private Stream<E> stream;

    public IterableIterator(Iterator<E> it) {
        this.it = it;
    }

    public IterableIterator(Iterable<E> iterable) {
        this.iterable = iterable;
        this.it = iterable.iterator();
    }

    public IterableIterator(Stream<E> stream) {
        this.stream = stream;
        this.it = stream.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public E next() {
        return this.it.next();
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    @Override
    public Iterator<E> iterator() {
        if (this.iterable != null) {
            return this.iterable.iterator();
        }
        if (this.stream != null) {
            return this.stream.iterator();
        }
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.iterable != null) {
            return this.iterable.spliterator();
        }
        if (this.stream != null) {
            return this.stream.spliterator();
        }
        return Spliterators.spliteratorUnknownSize(this.it, 4112);
    }
}

