
# S N E K T A L K

Snektalk is a groundbreaking new kind of REPL.

* Live code editing!
* Rich and interactive object representations!
* Built-in debugger!
* Connect to remote processes!
* Not another Jupyter clone

# Features

At a glance Snektalk might appear similar to Jupyter notebooks, but it follows different paradigms. It has no "cells" and is meant to be used like a straightforward REPL or command line. At the same time, it has many features neither standard REPLs nor Jupyter tend to have.

## Edit functions and data

Simply type `/edit func` and you will be greeted with a small inline editor for the source code of `func`. You may change it and hit `Ctrl+Enter` to change it in the current process, or `Ctrl+Shift+Enter` to save it back into the original file it came from. You can come back to it at any time, of course.

Virtually *any* function can be edited, whether it is yours or comes from a third party library or even the standard library.

`/edit` also works on data structures. You will be given an editable sandbox where you can change dictionaries, reorder lists, change the values of the fields of an object, and so on. Objects can even define a custom `__snek_edit__` method to control how they are edited.

## Rich and interactive representations

Snektalk does not print lists, dictionaries or objects as mere text, but as rich HTML objects.

`Ctrl+Click` (or `Cmd+Click` on Mac) the representation of an object to put it in a temporary variable. This makes it very easy to test or play with objects that are deeply nested in another.

Representations are highly customizable and recursive representations can be defined and configured in a snap.

The representation of exceptions is particularly interesting because each frame is associated to a live editor, so you can simply fix the error right there as you see it.

## Visualization

Snektalk supports elaborate visualizations: plots, graphs, and so on. Integrating a new or existing JavaScript library is mostly a matter of linking it from a CDN and writing a small wrapper.


## Debugging

`/debug f(x, y)` will enter a function call in debugger mode. Snektalk's debugger is quite similar to `pdb` and the usual `pdb` commands (`step`, `next`, `continue`, etc.) should work just the same.


## Threads

`/thread f(x, y)` will run `f(x, y)` in a separate thread, which lets you keep working while it's running. Each thread is given a mnemonic name so that you can easily `/kill` them.
