# AUTOGENERATED! DO NOT EDIT! File to edit: 00_cli.ipynb (unless otherwise specified).

__all__ = ['NB_VERSION', 'extract']

# Cell
import glob, re
import nbformat as nbf
from pathlib import Path
from fastscript import call_parse,Param

NB_VERSION=4

# Cell
@call_parse
def extract(path:Param("Path to book notebooks (default is current directory)", str)=None,
            save_path:Param("Path for saving output (default is current directory)", str)=None):

    if (path == None): path=Path('.')
    if type(path) == str: path=Path(path)

    if (os.path.isdir(path)):
        nb_files = [Path(p) for p in glob.glob(str(path/"*.ipynb"))]
    elif os.path.isfile(path):
        nb_files = [path]
    else:
        print("Unkown path object" )

    if save_path == None: save_path = Path('.')
    if type(save_path) == str: save_path = Path(save_path)
    save_path.mkdir(parents=True, exist_ok=True)


    for nb in nb_files:
        print(f"Extracting {nb}.")
        with open(nb,'r') as f: onb = nbf.read(f,NB_VERSION)

        # Assumption that the notebook title is the contents of the first markdown cell
        title_index = [i for i, a in enumerate(onb['cells']) if (a['cell_type']=='markdown')]
        if len(title_index) == 0:
            nb_title = nb.name
        else:
            nb_title = onb['cells'][title_index[0]]['source']

        # extract the questions
        qheader_index = [i for i, a in enumerate(onb['cells']) if (a['cell_type']=='markdown') and (a['source']=='## Questionnaire')]
        if len(qheader_index) == 0:
            print(f"    Error: couldn't find Questionnaire heading, skipping.")
            continue

        # chapter 1 has an extra paragraph introducing the questionnaires
        offset=1
        while onb['cells'][qheader_index[0]+offset].source[0] != '1':
            offset+=1

        # split on question numbers
        questions = re.split(r'\n[\d]+\.',onb['cells'][qheader_index[0]+offset].source)

        questions = [f'{i+1}. {q}' for i,q in enumerate(questions)]

        # create new notebook, inserting title then [question, blank markdown] for all questions.
        output_nb = nbf.v4.new_notebook()
        questions = [nbf.v4.new_markdown_cell(q) for q in questions]
        blanks = [nbf.v4.new_markdown_cell('')]*len(questions)
        output_nb['cells'] = [nbf.v4.new_markdown_cell(f'{nb_title}: Questionaire')]+[j for i in zip(questions,blanks) for j in i]

        # save to output path
        output_nb.metadata.authors=[{"name":"Jeremy Howard"},{"name":"Sylvain Gugger"}]
        output_nb.metadata.kernelspec = onb.metadata.kernelspec
        nbf.write(output_nb, save_path / nb.name.replace('.ipynb','_Q.ipynb'))

