"""Constants for `DescriptorSheet` validation."""

COLUMNS = {
    "Sample name",
    "Collection name",
    "Experimental design",
    "Scientist",
    "PI",
    "Method",
    "Protocol document",
    "Protein",
    "Cells/tissue",
    "Condition (optional)",
    "Species",
    "5' barcode",
    "3' adapter",
    "Sequencer type",
    "Antibody used",
    "RT primer",
    "Linker",
    "PMID of published data (optional)",
    "Data link (optional)",
    "Year of data release (optional)",
    "MW band cut (kDa) (optional)",
    "Replicate (optional)",
    "Sequencing length (optional)",
    "Resequencing ID (optional)",
    "Page of gel images in lab notebook (optional)",
    "Date of gel images in lab notebook (optional)",
    "Comments (optional)",
    "Consensus mapping (optional)",
}

TISSUE = {
    "293Flp",
    "3T3",
    "786O",
    "A375",
    "AF9",
    "astrocytes",
    "Bcells",
    "BJAB",
    "BMDM",
    "brain",
    "brainstem",
    "Cal51",
    "CD4 T cells",
    "CD8 T cells",
    "CD8 Tcells",
    "CEM_SS",
    "CEM-SS",
    "cerebellum",
    "CHP-212",
    "cortex",
    "COS7",
    "dermal fibroblasts",
    "DoHH2",
    "drosophila",
    "E.coli",
    "Embryonic body",
    "ESC neurons",
    "ESC",
    "fission yeast",
    "frontal cortex",
    "H1",
    "H1299",
    "HAP1",
    "HCT116",
    "Head",
    "HEK293 HR1",
    "HEK293",
    "HEK293T",
    "Hela nuclear extract",
    "Hela",
    "HelaFlp",
    "HepG2",
    "hippocampus",
    "HIV IIIB",
    "Huh7.5",
    "HUVEC",
    "IMR-32",
    "input",
    "iPSC motor neurons",
    "iPSC NPC",
    "iPSC",
    "Jurkat",
    "K562",
    "MCF7",
    "MDA231",
    "MEF",
    "MOLM13",
    "motor neurons",
    "mushroom bodies",
    "Mutu",
    "myoblast",
    "N2A",
    "neurons",
    "NSC",
    "NSC34",
    "OC13",
    "OCI-AML3",
    "olfactory bulb",
    "oligo",
    "P19",
    "PANC-1",
    "PANC-1",
    "primary AML",
    "primary neurons",
    "Raji",
    "rhabdomyosarcoma",
    "S.aureus",
    "SHSY5Y",
    "SK-N-AS",
    "SK1 yeast",
    "SKmel10",
    "SMI",
    "spinal cord",
    "striatum-thalamus",
    "TCMK",
    "temp",
    "temporal cortex",
    "THP-1",
    "U251",
    "U266",
    "U2932",
    "U2OS",
    "Usti_filaments",
    "Ustilago filaments",
    "WM164",
    "yeast",
}

PROTEIN = {
    "53BP1",
    "AGO1-4",
    "GR100",
    "IgG",
    "OdTcapture",
    "PR100",
    "TIRR",
    "bisox",
    "ctrl",
    "input",
    "m1A",
    "m1G",
    "m2A",
    "m22G",
    "m3U",
    "m4C",
    "m62A",
    "m6A",
    "m8A",
    "noIgG",
    "noUV",
    "pA",
    "pG",
    "pseudoU",
    "sDMA",
    "temp",
}

METHOD = {
    "4SU-iCLIP",
    "BrdU-CLIP",
    "CLAP",
    "CLIP",
    "CLIP-seq",
    "FAST-iCLIP",
    "FLASH",
    "HITS-CLIP",
    "PAR-CLIP",
    "RIP",
    "eCLIP",
    "hiCLIP",
    "iCLIP",
    "irCLIP",
    "miCLIP",
    "sCLIP",
    "uvCLAP",
}

REQUIRED_COLUMNS = {
    "Collection name",
    "Experimental design",
    "Scientist",
    "PI",
    "5' barcode",
    "3' adapter",
    "Sequencer type",
    "Antibody used",
    "RT primer",
    "Linker",
}

INTEGER_COLUMNS = {
    "Resequencing ID (optional)",
    "Replicate (optional)",
    "Page of gel images in lab notebook (optional)",
    "Year of data release (optional)",
}
