# quantile_scatter

下の方に日本語の説明があります

## Overview
- Visualization tool that makes it easier to get scatter plots right.
- The number of uniform data is divided into intervals on the x-axis, and the quantile points for each interval are displayed.

## Usage
```python
import quantile_scatter

# dummy data
x_ls = [(4 * random.random() - 2) ** 3
	for _ in range(1000)]
y_ls = [math.sin(x) + random.random() * 0.5
	for x in x_ls]

# plot [quantile_scatter]
quantile_scatter.plot(
	x = x_ls,	# x-list
	y = y_ls,	# y-list
	group_n = 20,	# divide group number
	ile_ls = [0.25, 0.5, 0.75]
)
```

## 概要
- 散布図を正しく把握しやすくする可視化ツール
- 均一データ数の横軸区間に分け、各区間の分位点を表示する
- 説明は執筆中です

## 使用例
```python
import quantile_scatter

# ダミーデータ
x_ls = [(4 * random.random() - 2) ** 3
	for _ in range(1000)]
y_ls = [math.sin(x) + random.random() * 0.5
	for x in x_ls]

# 分位点散布図の描画 [quantile_scatter]
quantile_scatter.plot(
	x = x_ls,	# 横軸数値リスト
	y = y_ls,	# 縦軸数値リスト
	group_n = 20,	# 分割グループ数
	ile_ls = [0.25, 0.5, 0.75]	# どこの分位点を出すか
)
```
