# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['sphinx_nested_apidoc']

package_data = \
{'': ['*']}

install_requires = \
['Sphinx>=5.0.0,<6.0.0']

entry_points = \
{'console_scripts': ['sphinx-nested-apidoc = '
                     'sphinx_nested_apidoc.__main__:main']}

setup_kwargs = {
    'name': 'sphinx-nested-apidoc',
    'version': '1.2.1',
    'description': 'sphinx-nested-apidoc: When flattened is not enough',
    'long_description': 'sphinx-nested-apidoc\n====================\n\nWhen flattened is not enough.\n\n.. image:: https://github.com/arunanshub/sphinx-nested-apidoc/actions/workflows/ci.yml/badge.svg\n   :alt: CI\n   :target: https://github.com/arunanshub/sphinx-nested-apidoc/actions/workflows/ci.yml\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :alt: Black\n   :target: https://github.com/psf/black\n\n.. image:: https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336\n   :alt: isort\n   :target: https://pycqa.github.io/isort\n\n.. image:: https://img.shields.io/pypi/pyversions/sphinx-nested-apidoc\n   :target: https://pypi.org/project/sphinx-nested-apidoc\n   :alt: PyPI - Python Version\n\n.. image:: https://readthedocs.org/projects/sphinx-nested-apidoc/badge/?version=latest\n    :target: https://sphinx-nested-apidoc.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n\nInstallation\n++++++++++++\n\nUse ``pip`` or ``pip3`` to install ``sphinx-nested-apidoc``\n\n.. code-block:: bash\n\n   pip install sphinx-nested-apidoc\n\nor\n\n.. code-block:: bash\n\n   pip3 install sphinx-nested-apidoc\n\nIntroduction\n++++++++++++\n\n``sphinx-apidoc`` is a great tool for generating documentation, but it does not\nreplicate the directory structure of your package. ``sphinx-nested-apidoc``\naims to solve that problem.\n\nTutorial\n++++++++\n\nLet\'s say we have the following directory structure of our package:\n\n.. code-block:: text\n\n   mymodule/\n   ├── fruits/\n   │   ├── __init__.py\n   │   ├── mango.py\n   │   ├── pear.py\n   ├── animals/\n   │   ├── special/\n   │   │   ├── __init__.py\n   │   │   ├── doggo.py\n   │   │   └── catto.py\n   │   ├── __init__.py\n   │   ├── monke.py\n   │   └── chimp.py\n   ├── __init__.py\n   ├── base.py\n   └── exceptions.py\n\nAnd we want to generate documentation for this package in some directory ``docs/``.\n\nLet\'s see the difference.\n\nUsing ``sphinx-apidoc`` we get\n------------------------------\n\nWe use the following command:\n\n.. code-block:: bash\n\n   sphinx-apidoc -o docs/ mymodule/ -e\n\nIt generates:\n\n.. code-block:: text\n\n   docs/\n   ├── modules.rst\n   ├── mymodule.animals.chimp.rst\n   ├── mymodule.animals.monke.rst\n   ├── mymodule.animals.rst\n   ├── mymodule.animals.special.catto.rst\n   ├── mymodule.animals.special.doggo.rst\n   ├── mymodule.animals.special.rst\n   ├── mymodule.base.rst\n   ├── mymodule.exceptions.rst\n   ├── mymodule.fruits.mango.rst\n   ├── mymodule.fruits.pear.rst\n   ├── mymodule.fruits.rst\n   └── mymodule.rst\n\nThis is not very clean, obviously.\n\nUsing ``sphinx-nested-apidoc`` we get\n-------------------------------------\n\nWe use the following command:\n\n.. code-block:: bash\n\n   sphinx-nested-apidoc -o docs/ mymodule/\n\nIt generates:\n\n.. code-block:: text\n\n   docs/\n   ├── modules.rst\n   └── mymodule/\n       ├── animals/\n       │   ├── chimp.rst\n       │   ├── index.rst\n       │   ├── monke.rst\n       │   └── special/\n       │       ├── catto.rst\n       │       ├── doggo.rst\n       │       └── index.rst\n       ├── base.rst\n       ├── exceptions.rst\n       ├── fruits/\n       │   ├── mango.rst\n       │   ├── pear.rst\n       │   └── index.rst\n       └── index.rst\n\nLooks clean!\n\nWant to name the package something else?\n----------------------------------------\n\n.. code-block:: bash\n\n   sphinx-nested-apidoc --package-name src -o docs/ mymodule/\n\nIt generates:\n\n.. code-block:: text\n\n   docs/\n   ├── modules.rst\n   └── src/\n       ├── animals/\n       │   ├── chimp.rst\n       │   ├── index.rst\n       │   ├── monke.rst\n       │   └── special/\n       │       ├── catto.rst\n       │       ├── doggo.rst\n       │       └── index.rst\n       ├── base.rst\n       ├── exceptions.rst\n       ├── fruits/\n       │   ├── mango.rst\n       │   ├── pear.rst\n       │   └── index.rst\n       └── index.rst\n\nNote that ``sphinx_nested_apidoc`` has been renamed to ``src``.\n\nAs a Sphinx Extension\n---------------------\n\nYou can also use this as a sphinx extension.\n\nCreate a file called ``docs/conf.py`` and configure it like this:\n\n.. code-block:: python\n\n   # ...\n   extensions = [\n       "sphinx_nested_apidoc",\n       # ...other extensions\n   ]\n\n   # Name of the package directory.\n   sphinx_nested_apidoc_package_dir = "packagename"\n   # Name of the folder to put all the package documentation in. By default it is\n   # the name of the package itself.\n   sphinx_nested_apidoc_package_name = "src"\n   # ...\n\nAnd then run:\n\n.. code-block:: bash\n\n   sphinx-build docs docs/_build\n\nUsage Details\n+++++++++++++\n\n.. code-block:: text\n\n   usage: sphinx-nested-apidoc [-h] [-v | -q] [--version] [-f] [-n] -o DESTDIR\n                               [--package-name PACKAGE_NAME] [-s SUFFIX]\n                               [--implicit-namespaces]\n                               module_path ...\n\nGenerates nested directory from sphinx-apidoc\'s flattened files. It is simply a\nwrapper over sphinx-apidoc and you can pass additional arguments to it for\nextended configuration.\n\npositional arguments:\n   ``module_path``\n      Path to package to document.\n\noptions:\n   -h, --help\n      show this help message and exit\n   -v, --verbose\n      Increase application verbosity. This option is repeatable and will\n      increase verbosity each time it is repeated. This option cannot be used\n      when -q/--quiet is used. (default: 3)\n   -q, --quiet\n      Disable logging. This option cannot be used when -v/--verbose is used.\n      (default: False)\n   --version\n      show program\'s version number and exit\n   -f, --force\n      Replace existing files. (default: False)\n   -n, --dry-run\n      Run the script without creating files (default: False)\n   -o, --output-dir\n      directory to place all output (default: None)\n   --package-name\n      Name of the directory to put the package documentation in. By default it\n      is the name of the package itself. (default: None)\n\n``sphinx-apidoc`` options:\n   -s, --suffix\n      file suffix (default: rst)\n   --implicit-namespaces\n      interpret module paths according to PEP-0420 implicit namespaces\n      specification (default: False)\n\nSphinx Extension Configuration\n++++++++++++++++++++++++++++++\n\nThe following configuration values are used:\n\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| Option Name                                   | Description                                                                                                      | Default                 | Required?  |\n+===============================================+==================================================================================================================+=========================+============+\n| ``sphinx_nested_apidoc_package_dir``          | This is where the package to document resides.                                                                   |                         | **YES**    |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| ``sphinx_nested_apidoc_package_name``         | Name of the directory to put all the package documentation in. By default it is the name of the package itself.  | ``None``                |            |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| ``sphinx_nested_apidoc_suffix``               | The suffix of the generated documentation files.                                                                 | ``rst``                 |            |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| ``sphinx_nested_apidoc_excluded_files``       | List of files (without extension) to exclude from modification/renaming.                                         | ``index``, ``modules``  |            |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| ``sphinx_nested_apidoc_module_first``         | put module documentation before submodule documentation.                                                         | ``False``               |            |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n| ``sphinx_nested_apidoc_implicit_namespaces``  | interpret module paths according to PEP-0420 implicit namespaces specification.                                  | ``False``               |            |\n+-----------------------------------------------+------------------------------------------------------------------------------------------------------------------+-------------------------+------------+\n\nSome additional details\n+++++++++++++++++++++++\n\nWhat it does\n------------\n\n- As you saw earlier, it generates a nested directory from a flattened one.\n- Under the hood, it uses ``sphinx-apidoc``. More on this below.\n\nAs stated above, ``sphinx-nested-apidoc`` uses ``sphinx-apidoc`` internally.\nThis means, you can configure ``sphinx-apidoc`` from ``sphinx-nested-apidoc``.\nFor example:\n\n.. code-block:: bash\n\n   # You can pass arguments like this:\n   sphinx-nested-apidoc -o docs/ mymodule/ -- -M -F --ext-githubpages\n   # or you can simply omit the \'--\'.\n\nEverything after the required positional argument of ``sphinx-nested-apidoc``\nis passed to ``sphinx-apidoc``.\n\nWhat it does not do\n-------------------\n\n- It does not modify the contents of the file. It just renames (or moves) them.\n- It is not a standalone tool. It requires ``sphinx-apidoc`` for its work.\n\nLicense\n+++++++\n\n`MIT <https://choosealicense.com/licenses/mit/>`_\n',
    'author': 'Arunanshu Biswas',
    'author_email': 'mydellpc07@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/arunanshub/sphinx-nested-apidoc',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
