#!/usr/bin/env python
# -*- coding: ascii -*-
from __future__ import print_function

# NOTICE... this file is generated by TkGridGUI.
# Any code or comments added by the user must be in designated areas ONLY.
# User additions will be lost if they are placed in code-generated areas.
# (i.e. Saving from TkGridGUI will over-write code-generated areas.)

# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "imports"


from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import str
from builtins import range
from builtins import object

from tkinter.ttk import Combobox, Progressbar, Separator, Treeview, Notebook

from tkinter import *
from tkinter import Button, Canvas, Checkbutton, Entry, Frame, Label, LabelFrame
from tkinter import Listbox, Message, Radiobutton, Spinbox, Text
from tkinter import OptionMenu
import tkinter.filedialog
from tkinter import _setit as set_command


# >>>>>>insert any user code below this comment for section "imports"
# Place any user import statements here
import tkinter.colorchooser

from tkgridgui.named_color_picker_Dialog import named_color_picker
from tkgridgui.color_lists import h_sorted_colorL, lum_sorted_colorL, cstr_sorted_colorL, name_sorted_colorL
from tkgridgui.wiq_color import w3_luminance, w3_contrast, rgb_to_wiq, wiq_to_rgb, hex_to_rgbfloat, rgbfloat_to_hex

DX_CANVAS = 8 # width of canvas swatches
N_CANVAS = 16*2  # number of swatches per side of canvas
CANVAS_SIZE = DX_CANVAS * N_CANVAS

# I, Q: color components I=-0.6 to +0.6,  Q=-0.52 to +0.52
IMIN, IMAX = -0.6, 0.6
QMIN, QMAX = -0.52, 0.52
DI = (IMAX - IMIN) / (N_CANVAS-1)
DQ = (QMAX - QMIN) / (N_CANVAS-1)

# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "top_of_init"

if sys.version_info < (3,):
    from tkSimpleDialog import Dialog
else:
    from tkinter.simpledialog import Dialog

class _Dialog(Dialog):
    # use dialogOptions dictionary to set any values in the dialog
    def __init__(self, parent, title = None, dialogOptions=None):
    
        self.dialogOptions = dialogOptions
        Dialog.__init__(self, parent, title)

class _contrast_color(_Dialog):

    def body(self, master):
        dialogframe = Frame(master, width=584, height=321)
        self.dialogframe = dialogframe
        dialogframe.pack()


        self.RadioGroup_1_StringVar = StringVar()

        self.make_Canvas_1( self.dialogframe )         #      Canvas:  at Main(2,2)
        self.make_Frame_1( self.dialogframe )          #       Frame:  at Main(2,1)
        self.make_Label_1( self.dialogframe )          #       Label:  at Main(2,3)
        self.make_Label_11( self.dialogframe )         #       Label: dark : at Main(3,4)
        self.make_Label_12( self.dialogframe )         #       Label: light : at Main(3,5)
        self.make_Label_6( self.dialogframe )          #       Label:  at Main(2,6)
        self.make_RadioGroup_1( self.dialogframe )     #  RadioGroup: Select Nominal Contrast Ratio : at Main(3,2)
        self.make_Scale_1( self.dialogframe )          #       Scale:  at Main(2,4)
        self.make_Scale_2( self.dialogframe )          #       Scale:  at Main(2,5)
        self.make_Button_1( self.Frame_1 )             #      Button: Select Generic BG Color : at Frame_1(1,1)
        self.make_Button_2( self.Frame_1 )             #      Button: Select Named BG Color : at Frame_1(2,1)
        self.make_Label_10( self.Frame_1 )             #       Label: CR = Contrast Ratio : at Frame_1(10,1)
        self.make_Label_2( self.Frame_1 )              #       Label: #ffffff : at Frame_1(4,1)
        self.make_Label_3( self.Frame_1 )              #       Label: background color : at Frame_1(3,1)
        self.make_Label_4( self.Frame_1 )              #       Label: contrasting foreground color : at Frame_1(6,1)
        self.make_Label_5( self.Frame_1 )              #       Label: #000000 : at Frame_1(7,1)
        self.make_Label_7( self.Frame_1 )              #       Label:  at Frame_1(9,1)
        self.make_Label_8( self.Frame_1 )              #       Label:  at Frame_1(5,1)
        self.make_Label_9( self.Frame_1 )              #       Label: click color chart to select : at Frame_1(8,1)
        self.make_Radiobutton_1( self.RadioGroup_1 )   # Radiobutton: AA CR=4.5:1 normal text : at RadioGroup_1(1,1)
        self.make_Radiobutton_2( self.RadioGroup_1 )   # Radiobutton: AA CR=3:1 large text : at RadioGroup_1(2,1)
        self.make_Radiobutton_3( self.RadioGroup_1 )   # Radiobutton: AAA CR=7:1 for normal text : at RadioGroup_1(3,1)
        self.make_Radiobutton_4( self.RadioGroup_1 )   # Radiobutton: AAA CR=4.5:1 for large text : at RadioGroup_1(4,1)

        self.dialogframe.columnconfigure(1, weight=1)

        self.RadioGroup_1_StringVar.set("2")
        self.RadioGroup_1_StringVar_traceName = self.RadioGroup_1_StringVar.trace_variable("w", self.RadioGroup_1_StringVar_Callback)
        # >>>>>>insert any user code below this comment for section "top_of_init"
        
        self.ref_color_str = '#808080' # '#ffffff'       # default ref_color_str is white
        self.contrast_color_str = '#000000'  # default contrast_color_str is black
        
        self.Label_2.configure( text=self.ref_color_str,  fg=self.contrast_color_str, bg=self.ref_color_str )

        
        self.ref_lum_p05 = self.get_lum_p05( self.ref_color_str )
        self.con_lum_p05 = self.get_lum_p05( self.contrast_color_str )
        self.CR = 21.0
        self.CR_request = 4.5

        self.crL = [4.5, 3.0, 7.0, 4.5]
        self.set_targ_lum_from_radiogroup()
        
        self.draw_canvas()
        self.ignore_slider = False
    
    def get_lum_p05(self, cstr):
        """Return luminance + 0.05 (used in contrast ratio calc.)"""
        (r,g,b) = hex_to_rgbfloat( cstr )
        lum_p05 = w3_luminance(r,g,b) + 0.05
        return lum_p05
    
    def set_slider_targ_lum(self):

        self.ignore_slider = True

        min_cr_val = 1.0

        # ---------- set Scale_1 based on best contrast possible
        #if self.ref_lum_p05 > 0.229: # best contrast is for low luminosity
        max_cr_val = self.ref_lum_p05 / 0.05
        #else:
        #    max_cr_val = max(1.05/self.ref_lum_p05, self.CR_request)
        
        self.Scale_1.configure(tickinterval=0.1, from_=min_cr_val, to=max_cr_val, 
                               resolution=0.1, digits=3)

        self.Scale_1_StringVar.set( self.CR_request )
        

        # ---------- set Scale_2 based on lesser contrast possible
        #if self.ref_lum_p05 > 0.229: # IGNORE best contrast is for low luminosity
        max_cr_val = 1.05/self.ref_lum_p05
        #else:
        #max_cr_val = self.ref_lum_p05 / 0.05
        
        self.Scale_2.configure(tickinterval=0.1, from_=min_cr_val, to=max_cr_val, resolution=0.1, digits=3)

        self.Scale_2_StringVar.set( self.CR_request )
        
        
        self.ignore_slider = False

    def set_targ_lum_from_radiogroup(self):
    
        i = int( self.RadioGroup_1_StringVar.get() ) - 1
        self.CR_request = self.crL[i]
        
        # calc required target luminance based on Radio Group Selection
        if self.ref_lum_p05 > 0.229: # best contrast is for low luminosity
            self.targ_lum = max(0.0, (self.ref_lum_p05 / self.CR_request)-0.05 )
        else:                   # best contrast is for high luminosity
            self.targ_lum = min(1.0, (self.CR_request * self.ref_lum_p05)-0.05 )

        self.set_slider_targ_lum()

    def draw_canvas(self):
        # clear canvas
        self.Canvas_1.delete("all")
        
        # paint canvas
        for i in range( N_CANVAS ):
            for j in range( N_CANVAS ):
                I = IMIN + i*DI
                Q = QMIN + j*DQ
                (r,g,b) = wiq_to_rgb(self.targ_lum, I, Q)
                cstr = rgbfloat_to_hex( (r,g,b) )
                
                w = i*DX_CANVAS
                h = j*DX_CANVAS
                self.Canvas_1.create_rectangle((w, h, w+DX_CANVAS, h+DX_CANVAS), outline=cstr, fill=cstr)
                
        # make sure that contrast label is set.
        self.set_contrast_color_label()
    
    def set_contrast_color_label(self):
        
        if self.ref_lum_p05 > self.con_lum_p05:
            self.CR = self.ref_lum_p05 / self.con_lum_p05
        else:
            self.CR = self.con_lum_p05 / self.ref_lum_p05
                    
        msg = 'fg=%s, CR=%.1f'%( self.contrast_color_str, self.CR )
        self.Label_5.configure( text=msg, bg=self.ref_color_str,  fg=self.contrast_color_str, width=len(msg)+2)
        


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Canvas_1"
    def make_Canvas_1(self, frame):
        """      Canvas:  at Main(2,2)"""
        self.Canvas_1 = Canvas( frame , height="160", width="160")
        self.Canvas_1.grid(row=2, column=2, sticky="n")

        # >>>>>>insert any user code below this comment for section "make_Canvas_1"

        self.Canvas_1.config(bg='#ffffcc', height=CANVAS_SIZE, width=CANVAS_SIZE)
        self.Canvas_1.bind("<ButtonRelease-1>", self.Canvas_1_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Frame_1"
    def make_Frame_1(self, frame):
        """       Frame:  at Main(2,1)"""
        self.Frame_1 = Frame( frame , width="60", relief="flat", height="50", borderwidth="6")
        self.Frame_1.grid(row=2, column=1, rowspan="2")

        # >>>>>>insert any user code below this comment for section "make_Frame_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_1"
    def make_Label_1(self, frame):
        """       Label:  at Main(2,3)"""
        self.Label_1 = Label( frame , text="", width="2")
        self.Label_1.grid(row=2, column=3)

        # >>>>>>insert any user code below this comment for section "make_Label_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_11"
    def make_Label_11(self, frame):
        """       Label: dark : at Main(3,4)"""
        self.Label_11 = Label( frame , text="dark", width="5")
        self.Label_11.grid(row=3, column=4, sticky="ne")

        # >>>>>>insert any user code below this comment for section "make_Label_11"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_12"
    def make_Label_12(self, frame):
        """       Label: light : at Main(3,5)"""
        self.Label_12 = Label( frame , text="light", width="5")
        self.Label_12.grid(row=3, column=5, sticky="ne")

        # >>>>>>insert any user code below this comment for section "make_Label_12"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_6"
    def make_Label_6(self, frame):
        """       Label:  at Main(2,6)"""
        self.Label_6 = Label( frame , text="", width="2")
        self.Label_6.grid(row=2, column=6)

        # >>>>>>insert any user code below this comment for section "make_Label_6"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_RadioGroup_1"
    def make_RadioGroup_1(self, frame):
        """  RadioGroup: Select Nominal Contrast Ratio : at Main(3,2)"""
        self.RadioGroup_1 = LabelFrame( frame , text="Select Nominal Contrast Ratio", width="60", height="50")
        self.RadioGroup_1.grid(row=3, column=2, sticky="new", columnspan="2")

        # >>>>>>insert any user code below this comment for section "make_RadioGroup_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Scale_1"
    def make_Scale_1(self, frame):
        """       Scale:  at Main(2,4)"""
        self.Scale_1 = Scale( frame , width="16", to="100", length="160", borderwidth="1", label="")
        self.Scale_1.grid(row=2, column=4, sticky="n")
        self.Scale_1_StringVar = StringVar()

        # >>>>>>insert any user code below this comment for section "make_Scale_1"

        self.Scale_1.configure(variable=self.Scale_1_StringVar)
        self.Scale_1_StringVar_traceName = self.Scale_1_StringVar.trace_variable("w", self.Scale_1_StringVar_Callback)
        self.Scale_1.configure( length=CANVAS_SIZE )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Scale_2"
    def make_Scale_2(self, frame):
        """       Scale:  at Main(2,5)"""
        self.Scale_2 = Scale( frame , to="100", width="16", length="160", borderwidth="1", label="")
        self.Scale_2.grid(row=2, column=5, sticky="n")
        self.Scale_2_StringVar = StringVar()

        # >>>>>>insert any user code below this comment for section "make_Scale_2"

        self.Scale_2.configure(variable=self.Scale_2_StringVar)
        self.Scale_2_StringVar_traceName = self.Scale_2_StringVar.trace_variable("w", self.Scale_2_StringVar_Callback)
        self.Scale_2.configure( length=CANVAS_SIZE )

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Button_1"
    def make_Button_1(self, frame):
        """      Button: Select Generic BG Color : at Frame_1(1,1)"""
        self.Button_1 = Button( frame , text="Select Generic BG Color", width="30")
        self.Button_1.grid(row=1, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Button_1"

        self.Button_1.bind("<ButtonRelease-1>", self.Button_1_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Button_2"
    def make_Button_2(self, frame):
        """      Button: Select Named BG Color : at Frame_1(2,1)"""
        self.Button_2 = Button( frame , text="Select Named BG Color", width="30")
        self.Button_2.grid(row=2, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Button_2"

        self.Button_2.bind("<ButtonRelease-1>", self.Button_2_Click)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_10"
    def make_Label_10(self, frame):
        """       Label: CR = Contrast Ratio : at Frame_1(10,1)"""
        self.Label_10 = Label( frame , text="CR = Contrast Ratio", width="30")
        self.Label_10.grid(row=10, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_10"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_2"
    def make_Label_2(self, frame):
        """       Label: #ffffff : at Frame_1(4,1)"""
        self.Label_2 = Label( frame , foreground="#000000", text="#ffffff", width="15", background="#ffffff", font="Times\ New\ Roman 16 bold roman")
        self.Label_2.grid(row=4, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Label_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_3"
    def make_Label_3(self, frame):
        """       Label: background color : at Frame_1(3,1)"""
        self.Label_3 = Label( frame , text="background color", width="15")
        self.Label_3.grid(row=3, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_4"
    def make_Label_4(self, frame):
        """       Label: contrasting foreground color : at Frame_1(6,1)"""
        self.Label_4 = Label( frame , text="contrasting foreground color", width="25")
        self.Label_4.grid(row=6, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_4"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_5"
    def make_Label_5(self, frame):
        """       Label: #000000 : at Frame_1(7,1)"""
        self.Label_5 = Label( frame , foreground="#000000", text="#000000", width="15", background="#ffffff", font="Times\ New\ Roman 16 bold roman")
        self.Label_5.grid(row=7, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Label_5"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_7"
    def make_Label_7(self, frame):
        """       Label:  at Frame_1(9,1)"""
        self.Label_7 = Label( frame , text="", width="15")
        self.Label_7.grid(row=9, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_7"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_8"
    def make_Label_8(self, frame):
        """       Label:  at Frame_1(5,1)"""
        self.Label_8 = Label( frame , text="", width="15")
        self.Label_8.grid(row=5, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_8"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_9"
    def make_Label_9(self, frame):
        """       Label: click color chart to select : at Frame_1(8,1)"""
        self.Label_9 = Label( frame , text="click color chart to select", width="30", font="Times\ New\ Roman 12 bold roman")
        self.Label_9.grid(row=8, column=1)

        # >>>>>>insert any user code below this comment for section "make_Label_9"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_1"
    def make_Radiobutton_1(self, frame):
        """ Radiobutton: AA CR=4.5:1 normal text : at RadioGroup_1(1,1)"""
        self.Radiobutton_1 = Radiobutton( frame , text="AA CR=4.5:1 normal text", value="1", width="20", anchor="w", justify="left")
        self.Radiobutton_1.grid(row=1, column=1, sticky="w")

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_1"

        self.Radiobutton_1.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_2"
    def make_Radiobutton_2(self, frame):
        """ Radiobutton: AA CR=3:1 large text : at RadioGroup_1(2,1)"""
        self.Radiobutton_2 = Radiobutton( frame , text="AA CR=3:1 large text", value="2", width="16", anchor="w", justify="left")
        self.Radiobutton_2.grid(row=2, column=1, sticky="w")

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_2"

        self.Radiobutton_2.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_3"
    def make_Radiobutton_3(self, frame):
        """ Radiobutton: AAA CR=7:1 for normal text : at RadioGroup_1(3,1)"""
        self.Radiobutton_3 = Radiobutton( frame , text="AAA CR=7:1 for normal text", value="3", width="20", anchor="w", justify="left")
        self.Radiobutton_3.grid(row=3, column=1, sticky="w")

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_3"

        self.Radiobutton_3.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_4"
    def make_Radiobutton_4(self, frame):
        """ Radiobutton: AAA CR=4.5:1 for large text : at RadioGroup_1(4,1)"""
        self.Radiobutton_4 = Radiobutton( frame , text="AAA CR=4.5:1 for large text", value="4", width="20", anchor="w", justify="left")
        self.Radiobutton_4.grid(row=4, column=1, sticky="w")

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_4"

        self.Radiobutton_4.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Canvas_1_Click"
    def Canvas_1_Click(self, event): #bind method for component ID=Canvas_1
        """      Canvas:  at Main(2,2)"""
        pass
        # >>>>>>insert any user code below this comment for section "Canvas_1_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Canvas_1_Click" )

        #print( "clicked in canvas at x,y =",event.x,event.y )
        
        #w = int(self.Canvas_1.cget("width"))
        #h = int(self.Canvas_1.cget("height"))
        #self.Canvas_1.create_rectangle((2, 2, w+1, h+1), outline="blue")
        #self.Canvas_1.create_line(0, 0, w+2, h+2, fill="red")
        x = int(event.x)
        y = int(event.y)
        #print( "event x,y=",x,y )
        item = self.Canvas_1.find_closest(event.x, event.y)
        
        # fill color of rectangle on canvas
        self.contrast_color_str = self.Canvas_1.itemcget(item, "fill")
        self.con_lum_p05 =  self.get_lum_p05( self.contrast_color_str )

        self.set_contrast_color_label()
        #self.set_slider_targ_lum()
        
        #self.Canvas_1.create_text(x,y, text="NE", fill="green", anchor=NE)
        #self.Canvas_1.create_text(x,y, text="SW", fill="magenta", anchor=SW)
        
    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Button_1_Click"
    def Button_1_Click(self, event): #bind method for component ID=Button_1
        """      Button: Select Generic BG Color : at Frame_1(1,1)"""
        pass
        # >>>>>>insert any user code below this comment for section "Button_1_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Button_1_Click" )
        
        ctup,cstr = tkinter.colorchooser.askcolor(title='Selected Color')
        if cstr:
            #print( cstr )
            lum_p05 = self.get_lum_p05( cstr )
            
            if lum_p05>0.229:
                fg = '#000000'
            else:
                fg = '#ffffff'
                
            msg = cstr
            self.Label_2.configure( text=msg,  fg=fg, bg=cstr, width=len(msg)+2)
            
            self.ref_color_str = cstr
            self.ref_lum_p05 = self.get_lum_p05( self.ref_color_str )
            
            self.set_targ_lum_from_radiogroup()
            self.draw_canvas()



    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Button_2_Click"
    def Button_2_Click(self, event): #bind method for component ID=Button_2
        """      Button: Select Named BG Color : at Frame_1(2,1)"""
        pass
        # >>>>>>insert any user code below this comment for section "Button_2_Click"
        # replace, delete, or comment-out the following
        #print( "executed method Button_2_Click" )
        
        dialog = named_color_picker(self.parent, title="Get Named Color")
        if dialog.result is not None:
            (_, lum_p05, _, _, _, _, cstr, name) = dialog.result["named_color"]
            
            if lum_p05>0.229:
                fg = '#000000'
            else:
                fg = '#ffffff'
            
            msg = name + ' ' + cstr
            self.Label_2.configure( text=msg,  fg=fg, bg=cstr, width=len(msg)+2)

            self.ref_color_str = cstr
            self.ref_lum_p05 = self.get_lum_p05( self.ref_color_str )
            
            self.set_targ_lum_from_radiogroup()
            self.draw_canvas()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Scale_1_StringVar_traceName"
    def Scale_1_StringVar_Callback(self, varName, index, mode):
        """       Scale:  at Main(2,4)"""
        pass

        # >>>>>>insert any user code below this comment for section "Scale_1_StringVar_traceName"
        # replace, delete, or comment-out the following
        #print( "Scale_1_StringVar_Callback varName, index, mode",varName, index, mode )
        #print( "    new StringVar value =",self.Scale_1_StringVar.get() )
        
        if self.ignore_slider:
            return
            
        CR = float( self.Scale_1_StringVar.get() )
        
        #if self.ref_lum_p05 > 0.229: # best contrast is for low luminosity
        self.targ_lum = max(0.0, (self.ref_lum_p05 / CR)-0.05 )
        #else:                   # best contrast is for high luminosity
        #    self.targ_lum = min(1.0, (CR * self.ref_lum_p05)-0.05 )

        self.draw_canvas()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "Scale_2_StringVar_traceName"
    def Scale_2_StringVar_Callback(self, varName, index, mode):
        """       Scale:  at Main(2,5)"""
        pass

        # >>>>>>insert any user code below this comment for section "Scale_2_StringVar_traceName"
        # replace, delete, or comment-out the following
        #print( "Scale_2_StringVar_Callback varName, index, mode",varName, index, mode )
        #print( "    new StringVar value =",self.Scale_2_StringVar.get() )

        
        if self.ignore_slider:
            return
            
        CR = float( self.Scale_2_StringVar.get() )
        
        #if self.ref_lum_p05 > 0.229: # IGNORE best contrast is for low luminosity
        #    self.targ_lum = max(0.0, (self.ref_lum_p05 / CR)-0.05 )
        #else:                   # IGNORE best contrast is for high luminosity
        self.targ_lum = min(1.0, (CR * self.ref_lum_p05)-0.05 )

        self.draw_canvas()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "RadioGroup_1_StringVar_traceName"
    def RadioGroup_1_StringVar_Callback(self, varName, index, mode):
        """  RadioGroup: Select Nominal Contrast Ratio : at Main(3,2)"""
        pass

        # >>>>>>insert any user code below this comment for section "RadioGroup_1_StringVar_traceName"
        # replace, delete, or comment-out the following
        #print( "RadioGroup_1_StringVar_Callback varName, index, mode",varName, index, mode )
        #print( "    new StringVar value =",self.RadioGroup_1_StringVar.get() )
        
        self.set_targ_lum_from_radiogroup()
        self.draw_canvas()


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "dialog_validate"
    def validate(self):
        self.result = {} # return a dictionary of results
    

        self.result["Scale_1"] = self.Scale_1_StringVar.get()
        self.result["Scale_2"] = self.Scale_2_StringVar.get()
        self.result["RadioGroup_1"] = self.RadioGroup_1_StringVar.get()

        # >>>>>>insert any user code below this comment for section "dialog_validate"
        # set values in "self.result" dictionary for return
        # for example...
        # self.result["age"] = self.Entry_2_StringVar.get() 

        self.result = {} # reinitialize return a dictionary of results

        self.result["bg_color_str"] = self.ref_color_str
        self.result["fg_color_str"] = self.contrast_color_str
        
        self.result["contrast_ratio"] = self.CR
                
        return 1
# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "end"


    def apply(self):
        pass
        #print( 'apply called' )

class _Testdialog:
    def __init__(self, master):
        frame = Frame(master, width=300, height=300)
        frame.pack()
        self.master = master
        self.x, self.y, self.w, self.h = -1,-1,-1,-1
        
        self.Button_1 = Button(text="Test Dialog", relief="raised", width="15")
        self.Button_1.place(x=84, y=36)
        self.Button_1.bind("<ButtonRelease-1>", self.Button_1_Click)

    def Button_1_Click(self, event): #click method for component ID=1
        dialog = _contrast_color(self.master, "Test Dialog")
        print( '===============Result from Dialog====================' )
        print( dialog.result )
        print( '=====================================================' )

def main():
    root = Tk()
    app = _Testdialog(root)
    root.mainloop()

if __name__ == '__main__':
    main()
