#!/usr/bin/env python
# -*- coding: ascii -*-
from __future__ import print_function

# NOTICE... this file is generated by TkGridGUI.
# Any code or comments added by the user must be in designated areas ONLY.
# User additions will be lost if they are placed in code-generated areas.
# (i.e. Saving from TkGridGUI will over-write code-generated areas.)

# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "imports"


from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import str
from builtins import range
from builtins import object

from tkinter.ttk import Combobox, Progressbar, Separator, Treeview, Notebook

from tkinter import *
from tkinter import Button, Canvas, Checkbutton, Entry, Frame, Label, LabelFrame
from tkinter import Listbox, Message, Radiobutton, Spinbox, Text
from tkinter import OptionMenu
import tkinter.filedialog
from tkinter import _setit as set_command


# >>>>>>insert any user code below this comment for section "imports"
# Place any user import statements here
from color_lists import h_sorted_colorL, lum_sorted_colorL, cstr_sorted_colorL, name_sorted_colorL
COL_COUNT = 39

# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "top_of_init"

if sys.version_info < (3,):
    from tkSimpleDialog import Dialog
else:
    from tkinter.simpledialog import Dialog

class _Dialog(Dialog):
    # use dialogOptions dictionary to set any values in the dialog
    def __init__(self, parent, title = None, dialogOptions=None):
    
        self.dialogOptions = dialogOptions
        Dialog.__init__(self, parent, title)

class _color_picker(_Dialog):

    def body(self, master):
        dialogframe = Frame(master, width=536, height=225)
        self.dialogframe = dialogframe
        dialogframe.pack()


        self.RadioGroup_1_StringVar = StringVar()

        self.make_LabelFrame_1( self.dialogframe )     #  LabelFrame: Colors : at Main(5,1)
        self.make_Label_1( self.dialogframe )          #       Label: Left Click Background : at Main(2,1)
        self.make_Label_2( self.dialogframe )          #       Label: Right Click Foreground : at Main(3,1)
        self.make_Label_3( self.dialogframe )          #       Label: Luminance and Contrast Ratio shown above : at Main(4,1)
        self.make_RadioGroup_1( self.dialogframe )     #  RadioGroup: Sort By: : at Main(1,1)
        self.make_Radiobutton_1( self.RadioGroup_1 )   # Radiobutton: HSV hue : at RadioGroup_1(1,1)
        self.make_Radiobutton_2( self.RadioGroup_1 )   # Radiobutton: W3 Luminance : at RadioGroup_1(1,2)
        self.make_Radiobutton_3( self.RadioGroup_1 )   # Radiobutton: HEX String : at RadioGroup_1(1,3)
        self.make_Radiobutton_4( self.RadioGroup_1 )   # Radiobutton: Color Name : at RadioGroup_1(1,4)


        self.RadioGroup_1_StringVar.set("2")
        self.RadioGroup_1_StringVar_traceName = self.RadioGroup_1_StringVar.trace_variable("w", self.RadioGroup_1_StringVar_Callback)
        # >>>>>>insert any user code below this comment for section "top_of_init"
        
        self.labelD = {} # index=(row,col): value=Label object
        row = 0
        col = 0
        for (lum, lum_p05, h, r, g, b, cstr, name) in lum_sorted_colorL:
            lab = Label( self.LabelFrame_1 , text="  ", width="3", padx=0, pady=0)
            lab.grid(row=row, column=col)
            self.labelD[ (row,col) ] = lab
            lab.configure( background=cstr, relief="raised" )
            
            lab.bind("<Enter>", self.label_enter)
            lab.bind("<Leave>", self.label_leave)
            lab.bind("<ButtonRelease-1>", self.ColorPickLabel_LeftClick)
            lab.bind("<ButtonRelease-3>", self.ColorPickLabel_RightClick)

            col += 1
            if col>=COL_COUNT:
                col = 0
                row += 1

        self.tw = None
        self.bg_selectionT = lum_sorted_colorL[-1]# set selection to white
        self.fg_selectionT = lum_sorted_colorL[0] # set selection to black
        
        self.bg_label = None
        self.fg_label = None
    
    def get_info_for_row_col(self, row, col):
        
        lab = self.labelD[ (row,col) ]
        
        val = self.RadioGroup_1_StringVar.get()
        if val=="1":
            L = h_sorted_colorL
        elif val=="2":
            L = lum_sorted_colorL
        elif val=="3":
            L = cstr_sorted_colorL
        elif val=="4":
            L = name_sorted_colorL
        
        i = col + row * COL_COUNT
        (lum, lum_p05, h, r, g, b, cstr, name) = L[i]
        
        return (lum, lum_p05, h, r, g, b, cstr, name)
    
    def unhighlight_label(self, label):
        
        if label is not None:
            label.configure(relief='raised', text='  ')
    
    def highlight_label(self, label, text=" X"):
        
        if label is not None:
            text = '<%s>'%text.strip()
            label.configure(relief='sunken', text=text)

            info = label.grid_info()
            row = int( info["row"] )
            col = int( info["column"] )
            
            (lumbg, lum_p05bg, hbg, rbg, gbg, bbg, cstrbg, namebg) = self.get_info_for_row_col( row, col)
            if lum_p05bg>0.229: # gives Contrast Ratio of 4.5 or better with best of white or black
                label.configure(fg='#000000')
            else:
                label.configure(fg='#ffffff')

    
    def ColorPickLabel_RightClick(self, event):
        """Pick the Foreground color."""
        
        self.unhighlight_label( self.fg_label )
        self.fg_label = event.widget
        self.highlight_label( self.fg_label, text=" F" )
        
        info = event.widget.grid_info()
        row = int( info["row"] )
        col = int( info["column"] )
        #print((info["row"], info["column"]))
        
        (lumfg, lum_p05fg, hfg, rfg, gfg, bfg, cstrfg, namefg) = self.get_info_for_row_col( row, col)
        self.fg_selectionT = (lumfg, lum_p05fg, hfg, rfg, gfg, bfg, cstrfg, namefg)
        
        (lumbg, lum_p05bg, _, _, _, _, cstrbg, namebg) = self.bg_selectionT

        if lum_p05fg > lum_p05bg:
            CR = lum_p05fg / lum_p05bg
        else:
            CR = lum_p05bg / lum_p05fg

        text = 'Foreground: '+namefg+" "+cstrfg.upper()+" lum=%.3f,"%lumfg + " CR=%.2f"%CR

        self.Label_2.configure( fg=self.fg_selectionT[-2] )
        self.Label_2.configure(background=self.bg_selectionT[-2], text=text)

    def ColorPickLabel_LeftClick(self, event):
        """Pick the Background color"""
        
        
        self.unhighlight_label( self.bg_label )
        self.bg_label = event.widget
        self.highlight_label( self.bg_label, text=" B" )
        
        # show selection
        info = event.widget.grid_info()
        row = int( info["row"] )
        col = int( info["column"] )
        #print((info["row"], info["column"]))
        
        (lumbg, lum_p05bg, hbg, rbg, gbg, bbg, cstrbg, namebg) = self.get_info_for_row_col( row, col)
        self.bg_selectionT = (lumbg, lum_p05bg, hbg, rbg, gbg, bbg, cstrbg, namebg)


        if lum_p05bg>0.229: # gives Contrast Ratio of 4.5 or better with best of white or black
            local_fg_selectionT = lum_sorted_colorL[0] # black
            msg = ' (w black)'
        else:
            local_fg_selectionT = lum_sorted_colorL[-1] # white
            msg = ' (w white)'
            
        (lumfg, lum_p05fg, hfg, rfg, gfg, bfg, cstrfg, namefg) = local_fg_selectionT
        if self.fg_label is None:
            self.fg_selectionT = local_fg_selectionT

        if lum_p05fg > lum_p05bg:
            CR = lum_p05fg / lum_p05bg
        else:
            CR = lum_p05bg / lum_p05fg
        
        text = 'Background: '+namebg+" "+cstrbg.upper()+" lum=%.3f,"%lumbg + " CR=%.2f"%CR + msg

        self.Label_1.configure( fg=local_fg_selectionT[-2] )
        self.Label_1.configure(background=cstrbg, text=text)

        # local foreground may not be global foreground
        (lumfg, lum_p05fg, hfg, rfg, gfg, bfg, cstrfg, namefg) = self.fg_selectionT

        if lum_p05fg > lum_p05bg:
            CR = lum_p05fg / lum_p05bg
        else:
            CR = lum_p05bg / lum_p05fg
        text = 'Foreground: '+namefg+" "+cstrfg.upper()+" lum=%.3f,"%lumfg + " CR=%.2f"%CR

        self.Label_2.configure( fg=self.fg_selectionT[-2] )
        self.Label_2.configure(background=self.bg_selectionT[-2], text=text)


    def label_enter(self, event=None):
        if event is None:
            return
            
        info = event.widget.grid_info()
        row = int( info["row"] )
        col = int( info["column"] )
        #print((info["row"], info["column"]))
        
        (lum, lum_p05, h, r, g, b, cstr, name) = self.get_info_for_row_col( row, col)

        x = y = 0
        
        try:
            x_y_cx_cy = event.widget.bbox("insert")
        except:
            x_y_cx_cy = None
        
        if x_y_cx_cy is not None:
            x, y, cx, cy = event.widget.bbox("insert")
            x += event.widget.winfo_rootx() + 40
            y += event.widget.winfo_rooty() - 24
            # creates a toplevel window
            self.tw = Toplevel(event.widget)
            # Leaves only the label and removes the app window
            self.tw.wm_overrideredirect(True)
            self.tw.wm_geometry("+%d+%d" % (x, y))
            
            
            label = Label(self.tw, text=name  , justify='left',
                           background='#ffffff', relief='solid', borderwidth=1,
                           font=("times", "12", "normal"))
            label.pack(ipadx=1)


    def label_leave(self, event=None):
        if self.tw:
            self.tw.destroy()

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_LabelFrame_1"
    def make_LabelFrame_1(self, frame):
        """  LabelFrame: Colors : at Main(5,1)"""
        self.LabelFrame_1 = LabelFrame( frame , text="Colors", width="60", height="50")
        self.LabelFrame_1.grid(row=5, column=1)

        # >>>>>>insert any user code below this comment for section "make_LabelFrame_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_1"
    def make_Label_1(self, frame):
        """       Label: Left Click Background : at Main(2,1)"""
        self.Label_1 = Label( frame , text="Left Click Background", width="30", font="Times\ New\ Roman 18 bold roman")
        self.Label_1.grid(row=2, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Label_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_2"
    def make_Label_2(self, frame):
        """       Label: Right Click Foreground : at Main(3,1)"""
        self.Label_2 = Label( frame , text="Right Click Foreground", width="30", font="Times\ New\ Roman 18 bold roman")
        self.Label_2.grid(row=3, column=1, sticky="ew")

        # >>>>>>insert any user code below this comment for section "make_Label_2"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Label_3"
    def make_Label_3(self, frame):
        """       Label: Luminance and Contrast Ratio shown above : at Main(4,1)"""
        self.Label_3 = Label( frame , text="Luminance and Contrast Ratio shown above", width="45")
        self.Label_3.grid(row=4, column=1, sticky="e")

        # >>>>>>insert any user code below this comment for section "make_Label_3"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_RadioGroup_1"
    def make_RadioGroup_1(self, frame):
        """  RadioGroup: Sort By: : at Main(1,1)"""
        self.RadioGroup_1 = LabelFrame( frame , text="Sort By:", width="60", height="50")
        self.RadioGroup_1.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_RadioGroup_1"


    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_1"
    def make_Radiobutton_1(self, frame):
        """ Radiobutton: HSV hue : at RadioGroup_1(1,1)"""
        self.Radiobutton_1 = Radiobutton( frame , text="HSV hue", value="1", width="15")
        self.Radiobutton_1.grid(row=1, column=1)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_1"

        self.Radiobutton_1.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_2"
    def make_Radiobutton_2(self, frame):
        """ Radiobutton: W3 Luminance : at RadioGroup_1(1,2)"""
        self.Radiobutton_2 = Radiobutton( frame , text="W3 Luminance", value="2", width="15")
        self.Radiobutton_2.grid(row=1, column=2)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_2"

        self.Radiobutton_2.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_3"
    def make_Radiobutton_3(self, frame):
        """ Radiobutton: HEX String : at RadioGroup_1(1,3)"""
        self.Radiobutton_3 = Radiobutton( frame , text="HEX String", value="3", width="15")
        self.Radiobutton_3.grid(row=1, column=3)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_3"

        self.Radiobutton_3.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "make_Radiobutton_4"
    def make_Radiobutton_4(self, frame):
        """ Radiobutton: Color Name : at RadioGroup_1(1,4)"""
        self.Radiobutton_4 = Radiobutton( frame , text="Color Name", value="4", width="15")
        self.Radiobutton_4.grid(row=1, column=4)

        # >>>>>>insert any user code below this comment for section "make_Radiobutton_4"

        self.Radiobutton_4.configure(variable=self.RadioGroup_1_StringVar)

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "RadioGroup_1_StringVar_traceName"
    def RadioGroup_1_StringVar_Callback(self, varName, index, mode):
        """  RadioGroup: Sort By: : at Main(1,1)"""
        pass

        # >>>>>>insert any user code below this comment for section "RadioGroup_1_StringVar_traceName"
        # replace, delete, or comment-out the following
        #print( "RadioGroup_1_StringVar_Callback varName, index, mode",varName, index, mode )
        #print( "    new StringVar value =",self.RadioGroup_1_StringVar.get() )
        
        # handle label highlights
        self.unhighlight_label( self.fg_label )
        self.fg_label = None
        
        self.unhighlight_label( self.bg_label )
        self.bg_label = None

        # show resorting
        val = self.RadioGroup_1_StringVar.get()
        if val=="1":
            L = h_sorted_colorL
        elif val=="2":
            L = lum_sorted_colorL
        elif val=="3":
            L = cstr_sorted_colorL
        elif val=="4":
            L = name_sorted_colorL
        
        row = 0
        col = 0
        for (lum, lum_p05, h, r, g, b, cstr, name) in L:
            lab = self.labelD[ (row,col) ]
            lab.configure( background=cstr )

            if self.bg_selectionT[-1] == name:
                self.highlight_label( lab, text=" B" )
                self.bg_label = lab
                
            if self.fg_selectionT[-1] == name:
                self.highlight_label( lab, text=" F" )
                self.fg_label = lab


            col += 1
            if col>=COL_COUNT:
                col = 0
                row += 1

    # TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "dialog_validate"
    def validate(self):
        self.result = {} # return a dictionary of results
    

        self.result["RadioGroup_1"] = self.RadioGroup_1_StringVar.get()

        # >>>>>>insert any user code below this comment for section "dialog_validate"
        # set values in "self.result" dictionary for return
        # for example...
        # self.result["age"] = self.Entry_2_StringVar.get() 


        self.result["bg_color"] = self.bg_selectionT
        self.result["fg_color"] = self.fg_selectionT
        return 1
# TkGridGUI generated code. DO NOT EDIT THE FOLLOWING. section "end"


    def apply(self):
        print( 'apply called' )

class _Testdialog:
    def __init__(self, master):
        frame = Frame(master, width=300, height=300)
        frame.pack()
        self.master = master
        self.x, self.y, self.w, self.h = -1,-1,-1,-1
        
        self.Button_1 = Button(text="Test Dialog", relief="raised", width="15")
        self.Button_1.place(x=84, y=36)
        self.Button_1.bind("<ButtonRelease-1>", self.Button_1_Click)

    def Button_1_Click(self, event): #click method for component ID=1
        dialog = _color_picker(self.master, "Test Dialog")
        print( '===============Result from Dialog====================' )
        print( dialog.result )
        print( '=====================================================' )

def main():
    root = Tk()
    app = _Testdialog(root)
    root.mainloop()

if __name__ == '__main__':
    main()
