
from __future__ import print_function

"""
Colors, sorted by luminance and HSV hue
For ease of use in complying with WCAG 2 Contrast Ratio guidance.

Relative Luminance    see: https://www.w3.org/WAI/GL/wiki/Relative_luminance
Contrast Ratio WCAG 2 see: https://www.w3.org/WAI/GL/wiki/Contrast_ratio

Contrast Ratio WCAG 2 see: https://en.wikipedia.org/wiki/Template:Color_contrast_ratio


"""

# lum_sorted_colorL are the colors in order of their luminance.
#   create   "lum_sorted_colorL"   at bottome of file
# lum_sorted_colorL = sorted( h_sorted_colorL ) 
# cstr_sorted_colorL = sorted(lum_sorted_colorL, key=lambda t: t[-2])
# name_sorted_colorL = sorted(lum_sorted_colorL, key=lambda t: t[-1])

# h_sorted_colorL are the colors, sorted by their hue from the HSV color model

#   (lum,      lum_p05,    h,        r,        g,        b,       cstr, name) 
h_sorted_colorL = [\
    (0.000000, 0.050000, 0.000000, 0.000000, 0.000000, 0.000000, "#000000", "black"),
    (0.001384, 0.051384, 0.000000, 0.074510, 0.000000, 0.000000, "#130000", "diesel"),
    (0.003347, 0.053347, 0.000000, 0.043137, 0.043137, 0.043137, "#0b0b0b", "cod gray"),
    (0.005614, 0.055614, 0.000000, 0.168627, 0.007843, 0.007843, "#2b0202", "sepia black"),
    (0.008600, 0.058600, 0.000000, 0.215686, 0.007843, 0.007843, "#370202", "chocolate"),
    (0.009629, 0.059629, 0.000000, 0.149020, 0.078431, 0.078431, "#261414", "gondola"),
    (0.012299, 0.062299, 0.000000, 0.258824, 0.011765, 0.011765, "#420303", "burnt maroon"),
    (0.013205, 0.063205, 0.000000, 0.203922, 0.082353, 0.082353, "#341515", "tamarind"),
    (0.014733, 0.064733, 0.000000, 0.282353, 0.015686, 0.015686, "#480404", "rustic red"),
    (0.017631, 0.067631, 0.000000, 0.305882, 0.023529, 0.023529, "#4e0606", "mahogany"),
    (0.020087, 0.070087, 0.000000, 0.231373, 0.121569, 0.121569, "#3b1f1f", "jon"),
    (0.022921, 0.072921, 0.000000, 0.282353, 0.109804, 0.109804, "#481c1c", "cocoa bean"),
    (0.031896, 0.081896, 0.000000, 0.196078, 0.196078, 0.196078, "#323232", "mine shaft"),
    (0.032328, 0.082328, 0.000000, 0.400000, 0.062745, 0.062745, "#661010", "dark tan"),
    (0.032751, 0.082751, 0.000000, 0.427451, 0.003922, 0.003922, "#6d0101", "lonestar"),
    (0.037961, 0.087961, 0.000000, 0.282353, 0.192157, 0.192157, "#483131", "woody brown"),
    (0.043591, 0.093591, 0.000000, 0.439216, 0.109804, 0.109804, "#701c1c", "persian plum"),
    (0.045892, 0.095892, 0.000000, 0.501961, 0.000000, 0.000000, "#800000", "maroon"),
    (0.050008, 0.100008, 0.000000, 0.466667, 0.121569, 0.121569, "#771f1f", "crown of thorns"),
    (0.051321, 0.101321, 0.000000, 0.349020, 0.215686, 0.215686, "#593737", "congo brown"),
    (0.053084, 0.103084, 0.000000, 0.501961, 0.094118, 0.094118, "#801818", "falu red"),
    (0.057508, 0.107508, 0.000000, 0.556863, 0.000000, 0.000000, "#8e0000", "red berry"),
    (0.069516, 0.119516, 0.000000, 0.564706, 0.117647, 0.117647, "#901e1e", "old brick"),
    (0.086263, 0.136263, 0.000000, 0.525490, 0.235294, 0.235294, "#863c3c", "lotus"),
    (0.093471, 0.143471, 0.000000, 0.694118, 0.000000, 0.000000, "#b10000", "bright red"),
    (0.095766, 0.145766, 0.000000, 0.552941, 0.247059, 0.247059, "#8d3f3f", "tosca"),
    (0.096722, 0.146722, 0.000000, 0.654902, 0.145098, 0.145098, "#a72525", "mexican red"),
    (0.104630, 0.154630, 0.000000, 0.729412, 0.003922, 0.003922, "#ba0101", "guardsman red"),
    (0.112573, 0.162573, 0.000000, 0.580392, 0.278431, 0.278431, "#944747", "copper rust"),
    (0.150590, 0.200590, 0.000000, 0.427451, 0.423529, 0.423529, "#6d6c6c", "dove gray"),
    (0.154440, 0.204440, 0.000000, 0.800000, 0.200000, 0.200000, "#cc3333", "persian red"),
    (0.172344, 0.222344, 0.000000, 0.600000, 0.400000, 0.400000, "#996666", "copper rose"),
    (0.194618, 0.244618, 0.000000, 0.478431, 0.478431, 0.478431, "#7a7a7a", "boulder"),
    (0.199018, 0.249018, 0.000000, 0.658824, 0.419608, 0.419608, "#a86b6b", "coral tree"),
    (0.212600, 0.262600, 0.000000, 1.000000, 0.000000, 0.000000, "#ff0000", "red"),
    (0.214061, 0.264061, 0.000000, 0.803922, 0.360784, 0.360784, "#cd5c5c", "chestnut rose"),
    (0.215860, 0.265860, 0.000000, 0.501961, 0.501961, 0.501961, "#808080", "gray"),
    (0.252970, 0.302970, 0.000000, 1.000000, 0.250980, 0.250980, "#ff4040", "coral red"),
    (0.343009, 0.393009, 0.000000, 0.776471, 0.568627, 0.568627, "#c69191", "oriental pink"),
    (0.402067, 0.452067, 0.000000, 0.984314, 0.537255, 0.537255, "#fb8989", "geraldine"),
    (0.412543, 0.462543, 0.000000, 0.674510, 0.674510, 0.674510, "#acacac", "silver chalice"),
    (0.446859, 0.496859, 0.000000, 0.717647, 0.694118, 0.694118, "#b7b1b1", "nobel"),
    (0.517848, 0.567848, 0.000000, 0.807843, 0.729412, 0.729412, "#cebaba", "cold turkey"),
    (0.527115, 0.577115, 0.000000, 0.752941, 0.752941, 0.752941, "#c0c0c0", "silver"),
    (0.568755, 0.618755, 0.000000, 0.890196, 0.745098, 0.745098, "#e3bebe", "cavern pink"),
    (0.708376, 0.758376, 0.000000, 0.858824, 0.858824, 0.858824, "#dbdbdb", "alto"),
    (0.778079, 0.828079, 0.000000, 0.913725, 0.890196, 0.890196, "#e9e3e3", "ebb"),
    (0.783538, 0.833538, 0.000000, 0.898039, 0.898039, 0.898039, "#e5e5e5", "mercury"),
    (0.863157, 0.913157, 0.000000, 0.937255, 0.937255, 0.937255, "#efefef", "gallery"),
    (0.879622, 0.929622, 0.000000, 0.945098, 0.945098, 0.945098, "#f1f1f1", "seashell"),
    (0.887923, 0.937923, 0.000000, 0.949020, 0.949020, 0.949020, "#f2f2f2", "concrete"),
    (0.904661, 0.954661, 0.000000, 0.956863, 0.956863, 0.956863, "#f4f4f4", "wild sand"),
    (0.951001, 1.001001, 0.000000, 0.984314, 0.976471, 0.976471, "#fbf9f9", "hint of red"),
    (0.955973, 1.005973, 0.000000, 0.980392, 0.980392, 0.980392, "#fafafa", "alabaster"),
    (1.000000, 1.050000, 0.000000, 1.000000, 1.000000, 1.000000, "#ffffff", "white"),
    (0.123012, 0.173012, 0.001282, 0.705882, 0.200000, 0.196078, "#b43332", "well read"),
    (0.190472, 0.240472, 0.001502, 0.768627, 0.337255, 0.333333, "#c45655", "fuzzy wuzzy brown"),
    (0.073931, 0.123931, 0.003731, 0.600000, 0.086275, 0.074510, "#991613", "tamarillo"),
    (0.252978, 0.302978, 0.003968, 0.870588, 0.388235, 0.376471, "#de6360", "roman"),
    (0.268478, 0.318478, 0.004032, 0.882353, 0.407843, 0.396078, "#e16865", "sunglo"),
    (0.116206, 0.166206, 0.004831, 0.701961, 0.176471, 0.160784, "#b32d29", "tall poppy"),
    (0.658740, 0.708740, 0.005952, 0.913725, 0.807843, 0.803922, "#e9cecd", "oyster pink"),
    (0.322120, 0.372120, 0.007576, 0.843137, 0.513725, 0.498039, "#d7837f", "new york pink"),
    (0.640960, 0.690960, 0.007937, 1.000000, 0.764706, 0.752941, "#ffc3c0", "your pink"),
    (0.552892, 0.602892, 0.008032, 1.000000, 0.690196, 0.674510, "#ffb0ac", "cornflower lilac"),
    (0.157354, 0.207354, 0.008621, 0.592157, 0.376471, 0.364706, "#97605d", "au chico"),
    (0.162309, 0.212309, 0.008850, 0.725490, 0.305882, 0.282353, "#b94e48", "chestnut"),
    (0.250629, 0.300629, 0.009031, 1.000000, 0.247059, 0.203922, "#ff3f34", "red orange"),
    (0.017021, 0.067021, 0.009259, 0.188235, 0.121569, 0.117647, "#301f1e", "cocoa brown"),
    (0.092857, 0.142857, 0.009804, 0.552941, 0.239216, 0.219608, "#8d3d38", "sanguine brown"),
    (0.804381, 0.854381, 0.010417, 1.000000, 0.882353, 0.874510, "#ffe1df", "pippin"),
    (0.600348, 0.650348, 0.010417, 0.933333, 0.756863, 0.745098, "#eec1be", "beauty bush"),
    (0.266099, 0.316099, 0.010526, 0.996078, 0.298039, 0.250980, "#fe4c40", "sunset orange"),
    (0.035148, 0.085148, 0.010802, 0.431373, 0.035294, 0.007843, "#6e0902", "red oxide"),
    (0.106000, 0.156000, 0.012037, 0.721569, 0.066667, 0.015686, "#b81104", "milano red"),
    (0.035560, 0.085560, 0.012346, 0.396078, 0.101961, 0.078431, "#651a14", "cherrywood"),
    (0.251019, 0.301019, 0.012821, 0.776471, 0.447059, 0.419608, "#c6726b", "contessa"),
    (0.388864, 0.438864, 0.013333, 0.858824, 0.588235, 0.564706, "#db9690", "petite orchid"),
    (0.204753, 0.254753, 0.013333, 0.890196, 0.258824, 0.203922, "#e34234", "cinnabar"),
    (0.190090, 0.240090, 0.013458, 0.847059, 0.266667, 0.215686, "#d84437", "valencia"),
    (0.924324, 0.974324, 0.013889, 1.000000, 0.956863, 0.952941, "#fff4f3", "chablis"),
    (0.209963, 0.259963, 0.013889, 0.529412, 0.486275, 0.482353, "#877c7b", "hurricane"),
    (0.042745, 0.092745, 0.014620, 0.466667, 0.058824, 0.019608, "#770f05", "dark burgundy"),
    (0.130378, 0.180378, 0.015027, 0.686275, 0.250980, 0.207843, "#af4035", "medium carmine"),
    (0.105981, 0.155981, 0.015152, 0.419608, 0.341176, 0.333333, "#6b5755", "dorado"),
    (0.148270, 0.198270, 0.015432, 0.686275, 0.301961, 0.262745, "#af4d43", "apple blossom"),
    (0.194690, 0.244690, 0.015779, 0.862745, 0.262745, 0.200000, "#dc4333", "punch"),
    (0.176989, 0.226989, 0.016304, 0.690196, 0.364706, 0.329412, "#b05d54", "matrix"),
    (0.042442, 0.092442, 0.016667, 0.431373, 0.113725, 0.078431, "#6e1d14", "moccaccino"),
    (0.937641, 0.987641, 0.016667, 1.000000, 0.964706, 0.960784, "#fff6f5", "rose white"),
    (0.117824, 0.167824, 0.016667, 0.458824, 0.352941, 0.341176, "#755a57", "russett"),
    (0.332479, 0.382479, 0.017708, 0.996078, 0.435294, 0.368627, "#fe6f5e", "bittersweet"),
    (0.300948, 0.350948, 0.017857, 0.733333, 0.537255, 0.513725, "#bb8983", "brandy rose"),
    (0.640608, 0.690608, 0.017857, 0.898039, 0.800000, 0.788235, "#e5ccc9", "dust storm"),
    (0.102443, 0.152443, 0.018657, 0.650980, 0.184314, 0.125490, "#a62f20", "roof terracotta"),
    (0.130002, 0.180002, 0.018849, 0.752941, 0.168627, 0.094118, "#c02b18", "thunderbird"),
    (0.551084, 0.601084, 0.018868, 0.909804, 0.725490, 0.701961, "#e8b9b3", "shilo"),
    (0.363245, 0.413245, 0.019231, 0.839216, 0.568627, 0.533333, "#d69188", "my pink"),
    (0.159888, 0.209888, 0.019465, 0.752941, 0.278431, 0.215686, "#c04737", "mojo"),
    (0.367242, 0.417242, 0.019608, 0.686275, 0.627451, 0.619608, "#afa09e", "martini"),
    (0.095239, 0.145239, 0.019928, 0.560784, 0.243137, 0.200000, "#8f3e33", "el salva"),
    (0.418941, 0.468941, 0.020000, 0.811765, 0.639216, 0.615686, "#cfa39d", "eunry"),
    (0.488879, 0.538879, 0.020249, 1.000000, 0.631373, 0.580392, "#ffa194", "mona lisa"),
    (0.246549, 0.296549, 0.020833, 0.639216, 0.501961, 0.482353, "#a3807b", "pharlap"),
    (0.682694, 0.732694, 0.020833, 0.866667, 0.839216, 0.835294, "#ddd6d5", "swiss coffee"),
    (0.075715, 0.125715, 0.022831, 0.600000, 0.105882, 0.027451, "#991b07", "totem pole"),
    (0.323999, 0.373999, 0.023256, 1.000000, 0.419608, 0.325490, "#ff6b53", "persimmon"),
    (0.165693, 0.215693, 0.023416, 0.725490, 0.317647, 0.250980, "#b95140", "crail"),
    (0.225218, 0.275218, 0.023529, 1.000000, 0.141176, 0.000000, "#ff2400", "scarlet"),
    (0.051853, 0.101853, 0.023810, 0.443137, 0.160784, 0.113725, "#71291d", "metallic copper"),
    (0.206232, 0.256232, 0.023810, 0.564706, 0.470588, 0.454902, "#907874", "hemp"),
    (0.917121, 0.967121, 0.023810, 1.000000, 0.952941, 0.945098, "#fff3f1", "chardon"),
    (0.773014, 0.823014, 0.024390, 1.000000, 0.862745, 0.839216, "#ffdcd6", "peach schnapps"),
    (0.078983, 0.128983, 0.024510, 0.541176, 0.200000, 0.141176, "#8a3324", "burnt umber"),
    (0.089683, 0.139683, 0.024648, 0.627451, 0.152941, 0.070588, "#a02712", "tabasco"),
    (0.799004, 0.849004, 0.025253, 0.992157, 0.882353, 0.862745, "#fde1dc", "cinderella"),
    (0.562507, 0.612507, 0.026144, 0.905882, 0.737255, 0.705882, "#e7bcb4", "rose fog"),
    (0.890491, 0.940491, 0.026316, 1.000000, 0.937255, 0.925490, "#ffefec", "fair pink"),
    (0.592058, 0.642058, 0.026749, 0.996078, 0.729412, 0.678431, "#febaad", "melon"),
    (0.100293, 0.150293, 0.027027, 0.525490, 0.282353, 0.235294, "#86483c", "ironstone"),
    (0.930359, 0.980359, 0.027778, 1.000000, 0.960784, 0.952941, "#fff5f3", "sauvignon"),
    (0.363260, 0.413260, 0.027778, 0.713725, 0.615686, 0.596078, "#b69d98", "thatch"),
    (0.012594, 0.062594, 0.028249, 0.239216, 0.047059, 0.007843, "#3d0c02", "bean  "),
    (0.289587, 0.339587, 0.028395, 0.886275, 0.447059, 0.356863, "#e2725b", "terracotta"),
    (0.549944, 0.599944, 0.028409, 0.984314, 0.698039, 0.639216, "#fbb2a3", "rose bud"),
    (0.236825, 0.286825, 0.028846, 0.952941, 0.278431, 0.137255, "#f34723", "pomegranate"),
    (0.903436, 0.953436, 0.029412, 1.000000, 0.945098, 0.933333, "#fff1ee", "forget me not"),
    (0.020558, 0.070558, 0.030055, 0.286275, 0.090196, 0.047059, "#49170c", "van cleef"),
    (0.345112, 0.395112, 0.030864, 0.690196, 0.603922, 0.584314, "#b09a95", "del rio"),
    (0.007584, 0.057584, 0.031250, 0.121569, 0.070588, 0.058824, "#1f120f", "night rider"),
    (0.505481, 0.555481, 0.031532, 0.831373, 0.713725, 0.686275, "#d4b6af", "clam shell"),
    (0.019051, 0.069051, 0.031746, 0.243137, 0.109804, 0.078431, "#3e1c14", "cedar"),
    (0.349050, 0.399050, 0.031915, 0.741176, 0.592157, 0.556863, "#bd978e", "quicksand"),
    (0.046451, 0.096451, 0.032051, 0.301961, 0.219608, 0.200000, "#4d3833", "rock"),
    (0.015453, 0.065453, 0.032051, 0.192157, 0.109804, 0.090196, "#311c17", "eclipse"),
    (0.032902, 0.082902, 0.032051, 0.364706, 0.117647, 0.058824, "#5d1e0f", "redwood"),
    (0.051266, 0.101266, 0.032213, 0.486275, 0.109804, 0.019608, "#7c1c05", "kenyan copper"),
    (0.098027, 0.148027, 0.032787, 0.603922, 0.219608, 0.125490, "#9a3820", "prairie sand"),
    (0.456010, 0.506010, 0.032808, 1.000000, 0.600000, 0.501961, "#ff9980", "vivid tangerine"),
    (0.754817, 0.804817, 0.033333, 0.933333, 0.870588, 0.854902, "#eededa", "bizarre"),
    (0.945457, 0.995457, 0.033333, 0.988235, 0.972549, 0.968627, "#fcf8f7", "vista white"),
    (0.299016, 0.349016, 0.034167, 1.000000, 0.376471, 0.215686, "#ff6037", "outrageous orange"),
    (0.040584, 0.090584, 0.034247, 0.380392, 0.152941, 0.094118, "#612718", "espresso"),
    (0.102880, 0.152880, 0.034615, 0.623529, 0.219608, 0.113725, "#9f381d", "cognac"),
    (0.623187, 0.673187, 0.034722, 0.870588, 0.796078, 0.776471, "#decbc6", "wafer"),
    (0.436786, 0.486786, 0.034799, 0.905882, 0.623529, 0.549020, "#e79f8c", "tonys pink"),
    (0.059400, 0.109400, 0.035088, 0.470588, 0.176471, 0.098039, "#782d19", "mocha"),
    (0.299151, 0.349151, 0.035613, 0.847059, 0.486275, 0.388235, "#d87c63", "japonica"),
    (0.010243, 0.060243, 0.035714, 0.164706, 0.078431, 0.054902, "#2a140e", "coffee bean"),
    (0.255414, 0.305414, 0.035833, 0.949020, 0.333333, 0.164706, "#f2552a", "flamingo"),
    (0.226731, 0.276731, 0.036008, 0.854902, 0.356863, 0.219608, "#da5b38", "flame pea"),
    (0.071441, 0.121441, 0.036082, 0.501961, 0.203922, 0.121569, "#80341f", "red robin"),
    (0.894471, 0.944471, 0.037037, 0.996078, 0.941176, 0.925490, "#fef0ec", "bridesmaid"),
    (0.014064, 0.064064, 0.037037, 0.235294, 0.070588, 0.023529, "#3c1206", "rebel"),
    (0.188850, 0.238850, 0.038012, 0.603922, 0.431373, 0.380392, "#9a6e61", "toast"),
    (0.062118, 0.112118, 0.038095, 0.490196, 0.172549, 0.078431, "#7d2c14", "pueblo"),
    (0.042495, 0.092495, 0.038348, 0.443137, 0.101961, 0.000000, "#711a00", "cedar wood finish"),
    (0.304085, 0.354085, 0.038377, 0.913725, 0.454902, 0.317647, "#e97451", "burnt sienna"),
    (0.410361, 0.460361, 0.038889, 1.000000, 0.549020, 0.411765, "#ff8c69", "salmon"),
    (0.166065, 0.216065, 0.039823, 0.686275, 0.349020, 0.243137, "#af593e", "brown rust"),
    (0.118141, 0.168141, 0.040476, 0.533333, 0.325490, 0.258824, "#885342", "spicy mix"),
    (0.048322, 0.098322, 0.042146, 0.419608, 0.164706, 0.078431, "#6b2a14", "hairy heath"),
    (0.060840, 0.110840, 0.042517, 0.470588, 0.184314, 0.086275, "#782f16", "peanut"),
    (0.102872, 0.152872, 0.043011, 0.549020, 0.278431, 0.184314, "#8c472f", "mule fawn"),
    (0.087454, 0.137454, 0.043137, 0.505882, 0.258824, 0.172549, "#81422c", "nutmeg"),
    (0.820553, 0.870553, 0.043860, 0.960784, 0.905882, 0.886275, "#f5e7e2", "pot pourri"),
    (0.611218, 0.661218, 0.044271, 0.949020, 0.764706, 0.698039, "#f2c3b2", "mandys pink"),
    (0.397674, 0.447674, 0.044444, 0.921569, 0.576471, 0.450980, "#eb9373", "apricot"),
    (0.255951, 0.305951, 0.044662, 0.854902, 0.415686, 0.254902, "#da6a41", "red damask"),
    (0.370179, 0.420179, 0.044762, 1.000000, 0.498039, 0.313725, "#ff7f50", "coral"),
    (0.617864, 0.667864, 0.045977, 1.000000, 0.752941, 0.658824, "#ffc0a8", "wax flower"),
    (0.189993, 0.239993, 0.046667, 0.529412, 0.458824, 0.431373, "#87756e", "americano"),
    (0.208936, 0.258936, 0.047368, 0.694118, 0.427451, 0.321569, "#b16d52", "santa fe"),
    (0.829897, 0.879897, 0.047619, 0.952941, 0.913725, 0.898039, "#f3e9e5", "dawn pink"),
    (0.151214, 0.201214, 0.047872, 0.619608, 0.356863, 0.250980, "#9e5b40", "sepia skin"),
    (0.774779, 0.824779, 0.048611, 1.000000, 0.866667, 0.811765, "#ffddcf", "watusi"),
    (0.369272, 0.419272, 0.048822, 0.850980, 0.576471, 0.462745, "#d99376", "burning sand"),
    (0.006424, 0.056424, 0.049020, 0.141176, 0.047059, 0.007843, "#240c02", "kilamanjaro"),
    (0.330963, 0.380963, 0.049261, 1.000000, 0.439216, 0.203922, "#ff7034", "burning orange"),
    (0.025517, 0.075517, 0.049383, 0.231373, 0.156863, 0.125490, "#3b2820", "treehouse"),
    (0.028732, 0.078732, 0.049383, 0.243137, 0.168627, 0.137255, "#3e2b23", "english walnut"),
    (0.037778, 0.087778, 0.050000, 0.298039, 0.188235, 0.141176, "#4c3024", "saddle"),
    (0.002790, 0.052790, 0.050000, 0.078431, 0.023529, 0.000000, "#140600", "nero"),
    (0.907164, 0.957164, 0.050000, 0.980392, 0.952941, 0.941176, "#faf3f0", "fantasy"),
    (0.102351, 0.152351, 0.050147, 0.572549, 0.262745, 0.129412, "#924321", "cumin"),
    (0.155034, 0.205034, 0.050279, 0.756863, 0.266667, 0.054902, "#c1440e", "tia maria"),
    (0.138796, 0.188796, 0.050296, 0.717647, 0.254902, 0.054902, "#b7410e", "rust"),
    (0.265678, 0.315678, 0.050327, 1.000000, 0.301961, 0.000000, "#ff4d00", "vermilion"),
    (0.340617, 0.390617, 0.050725, 0.854902, 0.541176, 0.403922, "#da8a67", "copperfield"),
    (0.021412, 0.071412, 0.051020, 0.254902, 0.121569, 0.062745, "#411f10", "paco"),
    (0.927265, 0.977265, 0.051282, 0.996078, 0.960784, 0.945098, "#fef5f1", "provincial pink"),
    (0.003687, 0.053687, 0.051282, 0.074510, 0.039216, 0.023529, "#130a06", "asphalt"),
    (0.268520, 0.318520, 0.051634, 1.000000, 0.309804, 0.000000, "#ff4f00", "international orange"),
    (0.073622, 0.123622, 0.052083, 0.368627, 0.282353, 0.243137, "#5e483e", "kabul"),
    (0.593409, 0.643409, 0.052778, 0.921569, 0.760784, 0.686275, "#ebc2af", "zinnwaldite"),
    (0.773807, 0.823807, 0.053333, 1.000000, 0.866667, 0.803922, "#ffddcd", "tuft bush"),
    (0.212875, 0.262875, 0.053763, 0.564706, 0.482353, 0.443137, "#907b71", "almond frost"),
    (0.312596, 0.362596, 0.054315, 1.000000, 0.407843, 0.121569, "#ff681f", "orange"),
    (0.021943, 0.071943, 0.054422, 0.254902, 0.125490, 0.062745, "#412010", "deep oak"),
    (0.028568, 0.078568, 0.054487, 0.286275, 0.149020, 0.082353, "#492615", "brown derby"),
    (0.147219, 0.197219, 0.054598, 0.729412, 0.270588, 0.047059, "#ba450c", "rock spray"),
    (0.185265, 0.235265, 0.054773, 0.835294, 0.274510, 0.000000, "#d54600", "grenadier"),
    (0.222783, 0.272783, 0.055066, 0.901961, 0.305882, 0.011765, "#e64e03", "trinidad"),
    (0.450018, 0.500018, 0.055556, 1.000000, 0.600000, 0.400000, "#ff9966", "atomic tangerine"),
    (0.519708, 0.569708, 0.055556, 1.000000, 0.670588, 0.505882, "#ffab81", "hit pink"),
    (0.970939, 1.020939, 0.055556, 1.000000, 0.984314, 0.976471, "#fffbf9", "soapstone"),
    (0.190215, 0.240215, 0.055944, 0.741176, 0.368627, 0.180392, "#bd5e2e", "tuscany"),
    (0.063411, 0.113411, 0.056604, 0.384314, 0.247059, 0.176471, "#623f2d", "quincy"),
    (0.027646, 0.077646, 0.057143, 0.250980, 0.160784, 0.113725, "#40291d", "cork"),
    (0.170543, 0.220543, 0.057471, 0.509804, 0.435294, 0.396078, "#826f65", "sand dune"),
    (0.147641, 0.197641, 0.058667, 0.650980, 0.333333, 0.160784, "#a65529", "paarl"),
    (0.075159, 0.125159, 0.058730, 0.494118, 0.227451, 0.082353, "#7e3a15", "copper canyon"),
    (0.176138, 0.226138, 0.059140, 0.635294, 0.400000, 0.270588, "#a26645", "cape palliser"),
    (0.352876, 0.402876, 0.059406, 0.992157, 0.482353, 0.200000, "#fd7b33", "crusta"),
    (0.537046, 0.587046, 0.059524, 0.788235, 0.752941, 0.733333, "#c9c0bb", "silver rust"),
    (0.186223, 0.236223, 0.060429, 0.768627, 0.341176, 0.098039, "#c45719", "orange roughy"),
    (0.182352, 0.232352, 0.060606, 0.572549, 0.435294, 0.356863, "#926f5b", "beaver"),
    (0.008239, 0.058239, 0.060606, 0.149020, 0.066667, 0.019608, "#261105", "wood bark"),
    (0.017454, 0.067454, 0.060847, 0.250980, 0.094118, 0.003922, "#401801", "brown pod"),
    (0.073957, 0.123957, 0.061111, 0.415686, 0.266667, 0.180392, "#6a442e", "spice"),
    (0.126774, 0.176774, 0.061508, 0.549020, 0.341176, 0.219608, "#8c5738", "potters clay"),
    (0.313959, 0.363959, 0.062290, 0.784314, 0.541176, 0.396078, "#c88a65", "antique brass"),
    (0.707721, 0.757721, 0.062500, 1.000000, 0.823529, 0.717647, "#ffd2b7", "romantic"),
    (0.045034, 0.095034, 0.062500, 0.250980, 0.231373, 0.219608, "#403b38", "masala"),
    (0.187936, 0.237936, 0.062842, 0.588235, 0.439216, 0.349020, "#967059", "leather"),
    (0.124491, 0.174491, 0.062874, 0.666667, 0.258824, 0.011765, "#aa4203", "fire"),
    (0.124155, 0.174155, 0.062963, 0.474510, 0.364706, 0.298039, "#795d4c", "roman coffee"),
    (0.142688, 0.192688, 0.063253, 0.694118, 0.290196, 0.043137, "#b14a0b", "vesuvius"),
    (0.019700, 0.069700, 0.063492, 0.227451, 0.125490, 0.062745, "#3a2010", "sambuca"),
    (0.025085, 0.075085, 0.063596, 0.301961, 0.117647, 0.003922, "#4d1e01", "indian tan"),
    (0.034754, 0.084754, 0.063927, 0.333333, 0.156863, 0.047059, "#55280c", "cioccolato"),
    (0.563665, 0.613665, 0.064103, 0.901961, 0.745098, 0.647059, "#e6bea5", "cashmere"),
    (0.214625, 0.264625, 0.064257, 0.788235, 0.388235, 0.137255, "#c96323", "piper"),
    (0.678262, 0.728262, 0.065315, 0.984314, 0.807843, 0.694118, "#fbceb1", "apricot peach"),
    (0.649983, 0.699983, 0.065359, 0.925490, 0.803922, 0.725490, "#eccdb9", "just right"),
    (0.288111, 0.338111, 0.065476, 0.823529, 0.490196, 0.274510, "#d27d46", "raw sienna"),
    (0.156653, 0.206653, 0.065625, 0.701961, 0.321569, 0.074510, "#b35213", "fiery orange"),
    (0.443870, 0.493870, 0.066308, 0.870588, 0.650980, 0.505882, "#dea681", "tumbleweed"),
    (0.075515, 0.125515, 0.066308, 0.466667, 0.247059, 0.101961, "#773f1a", "walnut"),
    (0.028188, 0.078188, 0.066667, 0.239216, 0.168627, 0.121569, "#3d2b1f", "bistre"),
    (0.307627, 0.357627, 0.066667, 1.000000, 0.400000, 0.000000, "#ff6600", "blaze orange"),
    (0.118967, 0.168967, 0.066667, 0.427451, 0.368627, 0.329412, "#6d5e54", "pine cone"),
    (0.036260, 0.086260, 0.066667, 0.219608, 0.207843, 0.200000, "#383533", "dune"),
    (0.340485, 0.390485, 0.067100, 1.000000, 0.458824, 0.094118, "#ff7518", "pumpkin"),
    (0.043851, 0.093851, 0.067130, 0.356863, 0.188235, 0.074510, "#5b3013", "jambalaya"),
    (0.086802, 0.136802, 0.067164, 0.447059, 0.290196, 0.184314, "#724a2f", "old copper"),
    (0.357598, 0.407598, 0.067235, 0.937255, 0.525490, 0.247059, "#ef863f", "jaffa"),
    (0.059103, 0.109103, 0.067251, 0.372549, 0.239216, 0.149020, "#5f3d26", "irish coffee"),
    (0.927379, 0.977379, 0.068627, 1.000000, 0.960784, 0.933333, "#fff5ee", "seashell peach"),
    (0.193344, 0.243344, 0.069444, 0.800000, 0.333333, 0.000000, "#cc5500", "burnt orange"),
    (0.238985, 0.288985, 0.069444, 0.823529, 0.411765, 0.117647, "#d2691e", "hot cinnamon"),
    (0.451761, 0.501761, 0.069792, 0.980392, 0.615686, 0.352941, "#fa9d5a", "tan hide"),
    (0.628730, 0.678730, 0.069892, 0.929412, 0.788235, 0.686275, "#edc9af", "desert sand"),
    (0.111523, 0.161523, 0.069940, 0.556863, 0.301961, 0.117647, "#8e4d1e", "rope"),
    (0.384050, 0.434050, 0.070261, 0.835294, 0.603922, 0.435294, "#d59a6f", "whiskey"),
    (0.006264, 0.056264, 0.070513, 0.117647, 0.058824, 0.015686, "#1e0f04", "creole"),
    (0.036502, 0.086502, 0.070588, 0.349020, 0.156863, 0.015686, "#592804", "brown bramble"),
    (0.197955, 0.247955, 0.070732, 0.803922, 0.341176, 0.000000, "#cd5700", "tenn"),
    (0.090486, 0.140486, 0.070957, 0.501961, 0.274510, 0.105882, "#80461b", "russet"),
    (0.021077, 0.071077, 0.071078, 0.266667, 0.113725, 0.000000, "#441d00", "morocco brown"),
    (0.666522, 0.716522, 0.071429, 1.000000, 0.796078, 0.643137, "#ffcba4", "flesh"),
    (0.450903, 0.500903, 0.071429, 0.741176, 0.694118, 0.658824, "#bdb1a8", "silk"),
    (0.017107, 0.067107, 0.072464, 0.215686, 0.113725, 0.035294, "#371d09", "clinker"),
    (0.338074, 0.388074, 0.072464, 0.980392, 0.470588, 0.078431, "#fa7814", "ecstasy"),
    (0.228482, 0.278482, 0.073333, 0.560784, 0.505882, 0.462745, "#8f8176", "squirrel"),
    (0.238379, 0.288379, 0.073988, 0.854902, 0.388235, 0.015686, "#da6304", "bamboo"),
    (0.021642, 0.071642, 0.074074, 0.247059, 0.129412, 0.035294, "#3f2109", "bronze"),
    (0.175734, 0.225734, 0.074171, 0.749020, 0.333333, 0.000000, "#bf5500", "rose of sharon"),
    (0.216031, 0.266031, 0.074346, 0.815686, 0.372549, 0.015686, "#d05f04", "red stage"),
    (0.114816, 0.164816, 0.074561, 0.607843, 0.278431, 0.011765, "#9b4703", "oregon"),
    (0.064971, 0.114971, 0.074561, 0.349020, 0.266667, 0.200000, "#594433", "millbrook"),
    (0.075425, 0.125425, 0.074667, 0.498039, 0.227451, 0.007843, "#7f3a02", "peru tan"),
    (0.320074, 0.370074, 0.074960, 0.929412, 0.478431, 0.109804, "#ed7a1c", "tango"),
    (0.174687, 0.224687, 0.075117, 0.682353, 0.376471, 0.125490, "#ae6020", "desert"),
    (0.070415, 0.120415, 0.075137, 0.482353, 0.219608, 0.003922, "#7b3801", "red beech"),
    (0.104698, 0.154698, 0.075321, 0.525490, 0.301961, 0.117647, "#864d1e", "bull shot"),
    (0.048397, 0.098397, 0.075758, 0.282353, 0.235294, 0.196078, "#483c32", "taupe"),
    (0.466285, 0.516285, 0.076577, 0.956863, 0.643137, 0.376471, "#f4a460", "sandy brown"),
    (0.381841, 0.431841, 0.076923, 0.674510, 0.647059, 0.623529, "#aca59f", "cloudy"),
    (0.234979, 0.284979, 0.076923, 0.545098, 0.517647, 0.494118, "#8b847e", "schooner"),
    (0.049010, 0.099010, 0.076923, 0.290196, 0.235294, 0.188235, "#4a3c30", "mondo"),
    (0.518297, 0.568297, 0.077160, 0.929412, 0.701961, 0.505882, "#edb381", "tacao"),
    (0.195014, 0.245014, 0.077519, 0.552941, 0.462745, 0.384314, "#8d7662", "cement"),
    (0.303139, 0.353139, 0.078231, 0.670588, 0.568627, 0.478431, "#ab917a", "sandrift"),
    (0.573880, 0.623880, 0.078283, 1.000000, 0.725490, 0.482353, "#ffb97b", "macaroni and cheese"),
    (0.029093, 0.079093, 0.078431, 0.243137, 0.172549, 0.109804, "#3e2c1c", "black marlin"),
    (0.386507, 0.436507, 0.078667, 0.858824, 0.600000, 0.368627, "#db995e", "di serria"),
    (0.145267, 0.195267, 0.078675, 0.658824, 0.325490, 0.027451, "#a85307", "rich gold"),
    (0.284755, 0.334755, 0.078684, 0.913725, 0.431373, 0.000000, "#e96e00", "clementine"),
    (0.659007, 0.709007, 0.078704, 0.894118, 0.819608, 0.752941, "#e4d1c0", "bone"),
    (0.080897, 0.130897, 0.078704, 0.431373, 0.282353, 0.149020, "#6e4826", "pickled bean"),
    (0.109035, 0.159035, 0.078811, 0.560784, 0.294118, 0.054902, "#8f4b0e", "korma"),
    (0.014338, 0.064338, 0.078947, 0.156863, 0.117647, 0.082353, "#281e15", "oil"),
    (0.716455, 0.766455, 0.078947, 0.992157, 0.835294, 0.694118, "#fdd5b1", "light apricot"),
    (0.138816, 0.188816, 0.079012, 0.615686, 0.337255, 0.086275, "#9d5616", "hawaiian tan"),
    (0.292723, 0.342723, 0.079186, 0.905882, 0.450980, 0.039216, "#e7730a", "christine"),
    (0.329744, 0.379744, 0.079235, 0.968627, 0.466667, 0.011765, "#f77703", "chilean fire"),
    (0.353133, 0.403133, 0.079268, 0.992157, 0.486275, 0.027451, "#fd7c07", "sorbus"),
    (0.359426, 0.409426, 0.079301, 1.000000, 0.490196, 0.027451, "#ff7d07", "flamenco"),
    (0.158841, 0.208841, 0.079710, 0.474510, 0.427451, 0.384314, "#796d62", "sandstone"),
    (0.226908, 0.276908, 0.080201, 0.721569, 0.450980, 0.200000, "#b87333", "copper"),
    (0.518162, 0.568162, 0.080645, 0.850980, 0.725490, 0.607843, "#d9b99b", "cameo"),
    (0.061381, 0.111381, 0.080808, 0.329412, 0.262745, 0.200000, "#544333", "judge gray"),
    (0.034942, 0.084942, 0.080952, 0.262745, 0.192157, 0.125490, "#433120", "iroko"),
    (0.012871, 0.062871, 0.081301, 0.180392, 0.098039, 0.019608, "#2e1905", "jacko bean"),
    (0.020046, 0.070046, 0.081818, 0.235294, 0.125490, 0.019608, "#3c2005", "dark ebony"),
    (0.290236, 0.340236, 0.082251, 0.905882, 0.447059, 0.000000, "#e77200", "mango tango"),
    (0.042315, 0.092315, 0.082418, 0.360784, 0.180392, 0.003922, "#5c2e01", "carnaby tan"),
    (0.364387, 0.414387, 0.083007, 1.000000, 0.498039, 0.000000, "#ff7f00", "flush orange"),
    (0.992355, 1.042355, 0.083333, 1.000000, 0.996078, 0.992157, "#fffefd", "romance"),
    (0.009825, 0.059825, 0.083333, 0.145098, 0.086275, 0.027451, "#251607", "graphite"),
    (0.073917, 0.123917, 0.083333, 0.439216, 0.258824, 0.078431, "#704214", "sepia"),
    (0.087963, 0.137963, 0.083333, 0.419608, 0.305882, 0.192157, "#6b4e31", "shingle fawn"),
    (0.198561, 0.248561, 0.083333, 0.486275, 0.482353, 0.478431, "#7c7b7a", "concord"),
    (0.442815, 0.492815, 0.083333, 1.000000, 0.600000, 0.200000, "#ff9933", "neon carrot"),
    (0.796839, 0.846839, 0.083333, 1.000000, 0.886275, 0.772549, "#ffe2c5", "negroni"),
    (0.667456, 0.717456, 0.083333, 1.000000, 0.800000, 0.600000, "#ffcc99", "peach orange"),
    (0.717884, 0.767884, 0.083333, 0.933333, 0.850980, 0.768627, "#eed9c4", "almond"),
    (0.883573, 0.933573, 0.083333, 0.980392, 0.941176, 0.901961, "#faf0e6", "linen"),
    (0.881028, 0.931028, 0.083333, 0.972549, 0.941176, 0.909804, "#f8f0e8", "white linen"),
    (0.035784, 0.085784, 0.083333, 0.211765, 0.207843, 0.203922, "#363534", "tuatara"),
    (0.261465, 0.311465, 0.083333, 0.800000, 0.466667, 0.133333, "#cc7722", "ochre"),
    (0.115162, 0.165162, 0.083333, 0.588235, 0.294118, 0.000000, "#964b00", "brown"),
    (0.466249, 0.516249, 0.083333, 0.788235, 0.698039, 0.607843, "#c9b29b", "rodeo dust"),
    (0.334864, 0.384864, 0.083333, 0.647059, 0.607843, 0.568627, "#a59b91", "zorba"),
    (0.006970, 0.056970, 0.083333, 0.109804, 0.070588, 0.031373, "#1c1208", "crowshead"),
    (0.046314, 0.096314, 0.083333, 0.254902, 0.235294, 0.215686, "#413c37", "merlin"),
    (0.287435, 0.337435, 0.084746, 0.666667, 0.552941, 0.435294, "#aa8d6f", "sandal"),
    (0.848591, 0.898591, 0.085271, 1.000000, 0.917647, 0.831373, "#ffead4", "karry"),
    (0.077660, 0.127660, 0.085366, 0.482353, 0.247059, 0.000000, "#7b3f00", "cinnamon"),
    (0.084871, 0.134871, 0.085648, 0.431373, 0.294118, 0.149020, "#6e4b26", "dallas"),
    (0.646074, 0.696074, 0.085859, 0.929412, 0.803922, 0.670588, "#edcdab", "pancho"),
    (0.317543, 0.367543, 0.086283, 0.913725, 0.486275, 0.027451, "#e97c07", "tahiti gold"),
    (0.179207, 0.229207, 0.086345, 0.694118, 0.380392, 0.043137, "#b1610b", "pumpkin skin"),
    (0.055814, 0.105814, 0.086538, 0.407843, 0.211765, 0.000000, "#683600", "nutmeg wood finish"),
    (0.134600, 0.184600, 0.086538, 0.619608, 0.325490, 0.007843, "#9e5302", "chelsea gem"),
    (0.219017, 0.269017, 0.086538, 0.729412, 0.435294, 0.117647, "#ba6f1e", "bourbon"),
    (0.332397, 0.382397, 0.086634, 0.898039, 0.517647, 0.105882, "#e5841b", "zest"),
    (0.197526, 0.247526, 0.086806, 0.556863, 0.466667, 0.368627, "#8e775e", "domino"),
    (0.634857, 0.684857, 0.086957, 0.960784, 0.788235, 0.600000, "#f5c999", "manhattan"),
    (0.917876, 0.967876, 0.086957, 1.000000, 0.956863, 0.909804, "#fff4e8", "serenade"),
    (0.363497, 0.413497, 0.087302, 0.670588, 0.631373, 0.588235, "#aba196", "bronco"),
    (0.117943, 0.167943, 0.087302, 0.443137, 0.364706, 0.278431, "#715d47", "tobacco brown"),
    (0.484919, 0.534919, 0.088889, 0.749020, 0.721569, 0.690196, "#bfb8b0", "tide"),
    (0.487844, 0.537844, 0.089147, 0.917647, 0.682353, 0.411765, "#eaae69", "porsche"),
    (0.532094, 0.582094, 0.089431, 0.819608, 0.745098, 0.658824, "#d1bea8", "vanilla"),
    (0.346660, 0.396660, 0.089903, 0.945098, 0.509804, 0.000000, "#f18200", "gold drop"),
    (0.458956, 0.508956, 0.090047, 1.000000, 0.619608, 0.172549, "#ff9e2c", "sunshade"),
    (0.415453, 0.465453, 0.090278, 1.000000, 0.568627, 0.058824, "#ff910f", "west side"),
    (0.031205, 0.081205, 0.090476, 0.290196, 0.164706, 0.015686, "#4a2a04", "bracken"),
    (0.176863, 0.226863, 0.090703, 0.658824, 0.396078, 0.082353, "#a86515", "reno sand"),
    (0.219913, 0.269913, 0.090750, 0.760784, 0.419608, 0.011765, "#c26b03", "indochine"),
    (0.542295, 0.592295, 0.090909, 0.968627, 0.713725, 0.407843, "#f7b668", "rajah"),
    (0.961629, 1.011629, 0.090909, 1.000000, 0.980392, 0.956863, "#fffaf4", "bridal heath"),
    (0.240977, 0.290977, 0.090909, 0.545098, 0.525490, 0.501961, "#8b8680", "natural gray"),
    (0.010193, 0.060193, 0.091398, 0.145098, 0.090196, 0.023529, "#251706", "cannon black"),
    (0.383651, 0.433651, 0.091503, 0.929412, 0.568627, 0.129412, "#ed9121", "carrot orange"),
    (0.301860, 0.351860, 0.091575, 0.717647, 0.556863, 0.360784, "#b78e5c", "muddy waters"),
    (0.356523, 0.406523, 0.091598, 0.949020, 0.521569, 0.000000, "#f28500", "tangerine"),
    (0.819771, 0.869771, 0.092262, 1.000000, 0.901961, 0.780392, "#ffe6c7", "tequila"),
    (0.337545, 0.387545, 0.092409, 0.760784, 0.584314, 0.364706, "#c2955d", "twine"),
    (0.296418, 0.346418, 0.092480, 0.803922, 0.517647, 0.160784, "#cd8429", "brandy punch"),
    (0.300452, 0.350452, 0.092593, 0.650980, 0.572549, 0.474510, "#a69279", "donkey brown"),
    (0.695212, 0.745212, 0.092803, 0.980392, 0.827451, 0.635294, "#fad3a2", "corvette"),
    (0.187504, 0.237504, 0.093254, 0.690196, 0.400000, 0.031373, "#b06608", "mai tai"),
    (0.281208, 0.331208, 0.093860, 0.815686, 0.490196, 0.070588, "#d07d12", "meteor"),
    (0.873669, 0.923669, 0.094017, 1.000000, 0.933333, 0.847059, "#ffeed8", "derby"),
    (0.412065, 0.462065, 0.094118, 1.000000, 0.564706, 0.000000, "#ff9000", "pizazz"),
    (0.549636, 0.599636, 0.094118, 1.000000, 0.709804, 0.333333, "#ffb555", "texas rose"),
    (0.668161, 0.718161, 0.094203, 1.000000, 0.803922, 0.549020, "#ffcd8c", "chardonnay"),
    (0.554849, 0.604849, 0.094203, 0.901961, 0.745098, 0.541176, "#e6be8a", "gold sand"),
    (0.075403, 0.125403, 0.094276, 0.435294, 0.266667, 0.047059, "#6f440c", "cafe royale"),
    (0.767572, 0.817572, 0.094298, 1.000000, 0.870588, 0.701961, "#ffdeb3", "frangipani"),
    (0.445611, 0.495611, 0.094918, 0.988235, 0.611765, 0.113725, "#fc9c1d", "tree poppy"),
    (0.341071, 0.391071, 0.095008, 0.886275, 0.537255, 0.074510, "#e28913", "golden bell"),
    (0.482376, 0.532376, 0.095238, 0.823529, 0.705882, 0.549020, "#d2b48c", "tan"),
    (0.519255, 0.569255, 0.095238, 1.000000, 0.682353, 0.258824, "#ffae42", "yellow orange"),
    (0.461591, 0.511591, 0.095238, 0.984314, 0.631373, 0.160784, "#fba129", "sea buckthorn"),
    (0.615427, 0.665427, 0.095238, 0.827451, 0.803922, 0.772549, "#d3cdc5", "swirl"),
    (0.210897, 0.260897, 0.095238, 0.537255, 0.490196, 0.427451, "#897d6d", "makara"),
    (0.189048, 0.239048, 0.095238, 0.482353, 0.470588, 0.454902, "#7b7874", "tapa"),
    (0.557165, 0.607165, 0.095556, 0.878431, 0.752941, 0.584314, "#e0c095", "calico"),
    (0.270360, 0.320360, 0.095745, 0.686275, 0.529412, 0.317647, "#af8751", "driftwood"),
    (0.760680, 0.810680, 0.095833, 1.000000, 0.866667, 0.686275, "#ffddaf", "caramel"),
    (0.085861, 0.135861, 0.096220, 0.450980, 0.290196, 0.070588, "#734a12", "raw umber"),
    (0.752712, 0.802712, 0.096491, 0.909804, 0.878431, 0.835294, "#e8e0d5", "pearl bush"),
    (0.241239, 0.291239, 0.096774, 0.572549, 0.521569, 0.450980, "#928573", "stonewall"),
    (0.049144, 0.099144, 0.097222, 0.262745, 0.243137, 0.215686, "#433e37", "armadillo"),
    (0.886946, 0.936946, 0.097222, 1.000000, 0.941176, 0.858824, "#fff0db", "peach cream"),
    (0.512419, 0.562419, 0.097222, 0.760784, 0.741176, 0.713725, "#c2bdb6", "cotton seed"),
    (0.045329, 0.095329, 0.097701, 0.345098, 0.203922, 0.003922, "#583401", "saddle brown"),
    (0.023799, 0.073799, 0.097884, 0.247059, 0.145098, 0.000000, "#3f2500", "cola"),
    (0.584814, 0.634814, 0.097917, 1.000000, 0.741176, 0.372549, "#ffbd5f", "koromiko"),
    (0.495899, 0.545899, 0.098039, 0.756863, 0.729412, 0.690196, "#c1bab0", "tea"),
    (0.400915, 0.450915, 0.098090, 0.909804, 0.600000, 0.156863, "#e89928", "fire bush"),
    (0.134080, 0.184080, 0.098765, 0.439216, 0.396078, 0.333333, "#706555", "coffee"),
    (0.558715, 0.608715, 0.099537, 0.870588, 0.756863, 0.588235, "#dec196", "brandy"),
    (0.765197, 0.815197, 0.099593, 1.000000, 0.870588, 0.678431, "#ffdead", "navajo white"),
    (0.120240, 0.170240, 0.100000, 0.415686, 0.376471, 0.317647, "#6a6051", "soya bean"),
    (0.276195, 0.326195, 0.100775, 0.674510, 0.541176, 0.337255, "#ac8a56", "limed oak"),
    (0.452328, 0.502328, 0.101190, 0.741176, 0.698039, 0.631373, "#bdb2a1", "malta"),
    (0.277666, 0.327666, 0.101266, 0.666667, 0.545098, 0.356863, "#aa8b5b", "muesli"),
    (0.042280, 0.092280, 0.101449, 0.286275, 0.215686, 0.105882, "#49371b", "metallic bronze"),
    (0.451935, 0.501935, 0.102000, 0.996078, 0.615686, 0.015686, "#fe9d04", "california"),
    (0.548620, 0.598620, 0.102020, 0.972549, 0.721569, 0.325490, "#f8b853", "casablanca"),
    (0.117458, 0.167458, 0.102151, 0.525490, 0.337255, 0.039216, "#86560a", "rusty nail"),
    (0.374145, 0.424145, 0.102310, 0.886275, 0.580392, 0.094118, "#e29418", "dixie"),
    (0.697420, 0.747420, 0.102899, 1.000000, 0.827451, 0.549020, "#ffd38c", "grandis"),
    (0.842758, 0.892758, 0.103030, 1.000000, 0.917647, 0.784314, "#ffeac8", "sandy beach"),
    (0.877971, 0.927971, 0.103175, 1.000000, 0.937255, 0.835294, "#ffefd5", "papaya whip"),
    (0.008696, 0.058696, 0.103175, 0.117647, 0.086275, 0.035294, "#1e1609", "karaka"),
    (0.446971, 0.496971, 0.103333, 0.764706, 0.690196, 0.568627, "#c3b091", "indian khaki"),
    (0.572388, 0.622388, 0.103448, 0.819608, 0.776471, 0.705882, "#d1c6b4", "soft amber"),
    (0.695390, 0.745390, 0.103922, 0.960784, 0.835294, 0.627451, "#f5d5a0", "maize"),
    (0.553836, 0.603836, 0.104167, 0.780392, 0.768627, 0.749020, "#c7c4bf", "cloud"),
    (0.017437, 0.067437, 0.104167, 0.160784, 0.137255, 0.098039, "#292319", "zeus"),
    (0.876262, 0.926262, 0.104167, 0.964706, 0.941176, 0.901961, "#f6f0e6", "merino"),
    (0.444920, 0.494920, 0.104167, 0.729412, 0.694118, 0.635294, "#bab1a2", "nomad"),
    (0.464016, 0.514016, 0.104575, 1.000000, 0.627451, 0.000000, "#ffa000", "orange peel"),
    (0.169928, 0.219928, 0.104575, 0.513725, 0.439216, 0.313725, "#837050", "shadow"),
    (0.248161, 0.298161, 0.104762, 0.580392, 0.529412, 0.443137, "#948771", "arrowtown"),
    (0.035785, 0.085785, 0.104762, 0.290196, 0.188235, 0.015686, "#4a3004", "deep bronze"),
    (0.140794, 0.190794, 0.105178, 0.533333, 0.384314, 0.129412, "#886221", "kumera"),
    (0.010938, 0.060938, 0.105263, 0.129412, 0.101961, 0.054902, "#211a0e", "eternity"),
    (0.563041, 0.613041, 0.106061, 0.831373, 0.768627, 0.658824, "#d4c4a8", "akaroa"),
    (0.161539, 0.211539, 0.106061, 0.466667, 0.435294, 0.380392, "#776f61", "pablo"),
    (0.223963, 0.273963, 0.106164, 0.678431, 0.470588, 0.105882, "#ad781b", "mandalay"),
    (0.332794, 0.382794, 0.106227, 0.819608, 0.560784, 0.105882, "#d18f1b", "geebung"),
    (0.313900, 0.363900, 0.106250, 0.694118, 0.580392, 0.380392, "#b19461", "teak"),
    (0.083576, 0.133576, 0.106349, 0.439216, 0.290196, 0.027451, "#704a07", "antique bronze"),
    (0.518062, 0.568062, 0.106481, 0.878431, 0.725490, 0.454902, "#e0b974", "harvest gold"),
    (0.351608, 0.401608, 0.106557, 0.772549, 0.600000, 0.294118, "#c5994b", "tussock"),
    (0.581059, 0.631059, 0.106625, 0.976471, 0.749020, 0.345098, "#f9bf58", "saffron mango"),
    (0.273276, 0.323276, 0.106667, 0.650980, 0.545098, 0.356863, "#a68b5b", "barley corn"),
    (0.891285, 0.941285, 0.106838, 1.000000, 0.945098, 0.847059, "#fff1d8", "pink lady"),
    (0.145506, 0.195506, 0.107143, 0.435294, 0.415686, 0.380392, "#6f6a61", "flint"),
    (0.913432, 0.963432, 0.107527, 1.000000, 0.956863, 0.878431, "#fff4e0", "sazerac"),
    (0.481703, 0.531703, 0.107843, 1.000000, 0.647059, 0.000000, "#ffa500", "web orange"),
    (0.823935, 0.873935, 0.107843, 0.960784, 0.913725, 0.827451, "#f5e9d3", "albescent white"),
    (0.371967, 0.421967, 0.108025, 0.709804, 0.635294, 0.498039, "#b5a27f", "mongoose"),
    (0.792049, 0.842049, 0.108187, 0.972549, 0.894118, 0.749020, "#f8e4bf", "givry"),
    (0.761165, 0.811165, 0.108225, 0.980392, 0.874510, 0.678431, "#fadfad", "peach yellow"),
    (0.689330, 0.739330, 0.108333, 0.898039, 0.843137, 0.741176, "#e5d7bd", "stark white"),
    (0.749097, 0.799097, 0.108586, 0.960784, 0.870588, 0.701961, "#f5deb3", "wheat"),
    (0.919006, 0.969006, 0.108696, 0.992157, 0.960784, 0.901961, "#fdf5e6", "old lace"),
    (0.805939, 0.855939, 0.108889, 1.000000, 0.898039, 0.705882, "#ffe5b4", "peach"),
    (0.478848, 0.528848, 0.109195, 0.756863, 0.717647, 0.643137, "#c1b7a4", "bison hide"),
    (0.792574, 0.842574, 0.109290, 0.976471, 0.894118, 0.737255, "#f9e4bc", "dairy cream"),
    (0.399712, 0.449712, 0.109546, 0.894118, 0.607843, 0.058824, "#e49b0f", "gamboge"),
    (0.024298, 0.074298, 0.109756, 0.215686, 0.160784, 0.054902, "#37290e", "brown tumbleweed"),
    (0.500613, 0.550613, 0.109914, 0.984314, 0.674510, 0.074510, "#fbac13", "sun"),
    (0.463553, 0.513553, 0.109983, 0.925490, 0.662745, 0.152941, "#eca927", "fuel yellow"),
    (0.494555, 0.544555, 0.110000, 0.996078, 0.662745, 0.015686, "#fea904", "yellow sea"),
    (0.731053, 0.781053, 0.110000, 0.988235, 0.854902, 0.596078, "#fcda98", "cherokee"),
    (0.535991, 0.585991, 0.110119, 1.000000, 0.701961, 0.121569, "#ffb31f", "my sin"),
    (0.695821, 0.745821, 0.110465, 0.952941, 0.839216, 0.615686, "#f3d69d", "new orleans"),
    (0.374597, 0.424597, 0.111111, 0.674510, 0.643137, 0.580392, "#aca494", "napa"),
    (0.689267, 0.739267, 0.111111, 0.901961, 0.843137, 0.725490, "#e6d7b9", "double spanish white"),
    (0.675014, 0.725014, 0.111111, 0.894118, 0.835294, 0.717647, "#e4d5b7", "grain brown"),
    (0.889104, 0.939104, 0.111111, 0.956863, 0.949020, 0.933333, "#f4f2ee", "pampas"),
    (0.498029, 0.548029, 0.111111, 0.807843, 0.725490, 0.560784, "#ceb98f", "sorrell brown"),
    (0.270571, 0.320571, 0.111111, 0.596078, 0.552941, 0.466667, "#988d77", "pale oyster"),
    (0.362807, 0.412807, 0.111111, 0.650980, 0.635294, 0.603922, "#a6a29a", "dawn"),
    (0.911818, 0.961818, 0.112745, 1.000000, 0.956863, 0.866667, "#fff4dd", "egg sour"),
    (0.256244, 0.306244, 0.112933, 0.729412, 0.498039, 0.011765, "#ba7f03", "pirate gold"),
    (0.710959, 0.760959, 0.113333, 0.917647, 0.854902, 0.721569, "#eadab8", "raffia"),
    (0.601059, 0.651059, 0.113333, 0.827451, 0.796078, 0.729412, "#d3cbba", "sisal"),
    (0.730538, 0.780538, 0.113553, 0.972549, 0.858824, 0.615686, "#f8db9d", "marzipan"),
    (0.009063, 0.059063, 0.113636, 0.117647, 0.090196, 0.031373, "#1e1708", "el paso"),
    (0.030359, 0.080359, 0.113636, 0.215686, 0.188235, 0.129412, "#373021", "birch"),
    (0.489998, 0.539998, 0.113876, 0.952941, 0.678431, 0.086275, "#f3ad16", "buttercup"),
    (0.500484, 0.550484, 0.114286, 0.917647, 0.701961, 0.231373, "#eab33b", "tulip tree"),
    (0.652184, 0.702184, 0.114519, 1.000000, 0.800000, 0.360784, "#ffcc5c", "golden tainoi"),
    (0.872601, 0.922601, 0.114583, 0.996078, 0.937255, 0.807843, "#feefce", "oasis"),
    (0.736570, 0.786570, 0.115044, 0.996078, 0.858824, 0.552941, "#fedb8d", "salomie"),
    (0.591415, 0.641415, 0.115819, 0.917647, 0.776471, 0.454902, "#eac674", "rob roy"),
    (0.800880, 0.850880, 0.115854, 0.996078, 0.898039, 0.674510, "#fee5ac", "cape honey"),
    (0.007421, 0.057421, 0.115942, 0.105882, 0.078431, 0.015686, "#1b1404", "acadia"),
    (0.846745, 0.896745, 0.115942, 0.980392, 0.925490, 0.800000, "#faeccc", "champagne"),
    (0.295172, 0.345172, 0.116092, 0.725490, 0.552941, 0.156863, "#b98d28", "marigold"),
    (0.561939, 0.611939, 0.116402, 0.843137, 0.768627, 0.596078, "#d7c498", "pavlova"),
    (0.694945, 0.744945, 0.116667, 0.862745, 0.850980, 0.823529, "#dcd9d2", "westar"),
    (0.673498, 0.723498, 0.116667, 0.850980, 0.839216, 0.811765, "#d9d6cf", "timberwolf"),
    (0.072989, 0.122989, 0.116883, 0.376471, 0.286275, 0.074510, "#604913", "horses neck"),
    (0.507172, 0.557172, 0.117117, 0.780392, 0.737255, 0.635294, "#c7bca2", "coral reef"),
    (0.203287, 0.253287, 0.117117, 0.631373, 0.458824, 0.050980, "#a1750d", "buttered rum"),
    (0.250374, 0.300374, 0.117248, 0.701961, 0.501961, 0.027451, "#b38007", "hot toddy"),
    (0.528941, 0.578941, 0.117333, 0.882353, 0.737255, 0.392157, "#e1bc64", "equator"),
    (0.531817, 0.581817, 0.117371, 0.831373, 0.749020, 0.552941, "#d4bf8d", "straw"),
    (0.536626, 0.586626, 0.117560, 0.874510, 0.745098, 0.435294, "#dfbe6f", "apache"),
    (0.336515, 0.386515, 0.117593, 0.788235, 0.580392, 0.082353, "#c99415", "pizza"),
    (0.614937, 0.664937, 0.117647, 0.960784, 0.784314, 0.360784, "#f5c85c", "cream can"),
    (0.901299, 0.951299, 0.118421, 0.996078, 0.952941, 0.847059, "#fef3d8", "bleach white"),
    (0.922189, 0.972189, 0.119048, 0.972549, 0.964706, 0.945098, "#f8f6f1", "spring wood"),
    (0.625450, 0.675450, 0.119048, 0.905882, 0.803922, 0.549020, "#e7cd8c", "putty"),
    (0.908867, 0.958867, 0.119048, 0.996078, 0.956863, 0.858824, "#fef4db", "half spanish white"),
    (0.208914, 0.258914, 0.119048, 0.501961, 0.494118, 0.474510, "#807e79", "friar gray"),
    (0.419200, 0.469200, 0.119176, 0.854902, 0.647059, 0.125490, "#daa520", "golden grass"),
    (0.723652, 0.773652, 0.119444, 0.929412, 0.862745, 0.694118, "#eddcb1", "chamois"),
    (0.924992, 0.974992, 0.119792, 1.000000, 0.964706, 0.874510, "#fff6df", "varden"),
    (0.049658, 0.099658, 0.119883, 0.301961, 0.239216, 0.078431, "#4d3d14", "punga"),
    (0.019184, 0.069184, 0.120690, 0.176471, 0.145098, 0.062745, "#2d2510", "mikado"),
    (0.808754, 0.858754, 0.121005, 0.984314, 0.905882, 0.698039, "#fbe7b2", "banana mania"),
    (0.798367, 0.848367, 0.121053, 1.000000, 0.898039, 0.627451, "#ffe5a0", "cream brulee"),
    (0.041943, 0.091943, 0.121212, 0.258824, 0.223529, 0.129412, "#423921", "lisbon brown"),
    (0.833529, 0.883529, 0.121212, 0.956863, 0.921569, 0.827451, "#f4ebd3", "janna"),
    (0.497454, 0.547454, 0.121212, 0.878431, 0.713725, 0.274510, "#e0b646", "anzac"),
    (0.563778, 0.613778, 0.121569, 1.000000, 0.729412, 0.000000, "#ffba00", "selective yellow"),
    (0.584885, 0.634885, 0.121622, 0.988235, 0.752941, 0.117647, "#fcc01e", "lightning yellow"),
    (0.347683, 0.397683, 0.121677, 0.772549, 0.600000, 0.133333, "#c59922", "nugget"),
    (0.854592, 0.904592, 0.121891, 1.000000, 0.929412, 0.737255, "#ffedbc", "colonial white"),
    (0.774453, 0.824453, 0.123397, 0.992157, 0.886275, 0.584314, "#fde295", "golden glow"),
    (0.231613, 0.281613, 0.123457, 0.545098, 0.517647, 0.439216, "#8b8470", "olive haze"),
    (0.868433, 0.918433, 0.123656, 1.000000, 0.937255, 0.756863, "#ffefc1", "egg white"),
    (0.816317, 0.866317, 0.123656, 0.945098, 0.913725, 0.823529, "#f1e9d2", "parchment"),
    (0.689161, 0.739161, 0.124074, 0.933333, 0.843137, 0.580392, "#eed794", "chalky"),
    (0.697679, 0.747679, 0.124161, 0.988235, 0.839216, 0.403922, "#fcd667", "goldenrod"),
    (0.260057, 0.310057, 0.124661, 0.654902, 0.533333, 0.172549, "#a7882c", "luxor gold"),
    (0.585216, 0.635216, 0.124837, 1.000000, 0.749020, 0.000000, "#ffbf00", "amber"),
    (0.160285, 0.210285, 0.125000, 0.545098, 0.419608, 0.043137, "#8b6b0b", "corn harvest"),
    (0.646847, 0.696847, 0.125000, 1.000000, 0.800000, 0.200000, "#ffcc33", "sunglow"),
    (0.905641, 0.955641, 0.125000, 0.988235, 0.956863, 0.862745, "#fcf4dc", "pearl lusta"),
    (0.583154, 0.633154, 0.125527, 0.925490, 0.772549, 0.305882, "#ecc54e", "ronchi"),
    (0.826724, 0.876724, 0.125641, 0.980392, 0.917647, 0.725490, "#faeab9", "astra"),
    (0.031750, 0.081750, 0.125683, 0.247059, 0.188235, 0.007843, "#3f3002", "madras"),
    (0.127199, 0.177199, 0.125731, 0.443137, 0.388235, 0.219608, "#716338", "yellow metal"),
    (0.589264, 0.639264, 0.125850, 0.956863, 0.768627, 0.188235, "#f4c430", "saffron"),
    (0.289407, 0.339407, 0.125954, 0.686275, 0.560784, 0.172549, "#af8f2c", "alpine"),
    (0.405190, 0.455190, 0.126016, 0.776471, 0.658824, 0.294118, "#c6a84b", "roti"),
    (0.020871, 0.070871, 0.126263, 0.184314, 0.152941, 0.054902, "#2f270e", "onion"),
    (0.688649, 0.738649, 0.126543, 0.898039, 0.847059, 0.686275, "#e5d8af", "hampton"),
    (0.947245, 0.997245, 0.126667, 1.000000, 0.976471, 0.901961, "#fff9e6", "early dawn"),
    (0.709729, 0.759729, 0.127329, 0.996078, 0.847059, 0.364706, "#fed85d", "dandelion"),
    (0.085517, 0.135517, 0.127854, 0.384314, 0.317647, 0.098039, "#625119", "west coast"),
    (0.887147, 0.937147, 0.128788, 0.968627, 0.949020, 0.882353, "#f7f2e1", "quarter spanish white"),
    (0.904176, 0.954176, 0.129252, 1.000000, 0.956863, 0.807843, "#fff4ce", "barley white"),
    (0.152867, 0.202867, 0.129630, 0.450980, 0.427451, 0.345098, "#736d58", "crocodile"),
    (0.146980, 0.196980, 0.129630, 0.443137, 0.419608, 0.337255, "#716b56", "peat"),
    (0.679856, 0.729856, 0.129725, 0.996078, 0.827451, 0.235294, "#fed33c", "bright sun"),
    (0.234200, 0.284200, 0.129771, 0.623529, 0.509804, 0.109804, "#9f821c", "reef gold"),
    (0.393428, 0.443428, 0.130208, 0.784314, 0.647059, 0.156863, "#c8a528", "hokey pokey"),
    (0.928663, 0.978663, 0.130208, 0.996078, 0.968627, 0.870588, "#fef7de", "half dutch white"),
    (0.886986, 0.936986, 0.130303, 0.996078, 0.949020, 0.780392, "#fef2c7", "beeswax"),
    (0.726276, 0.776276, 0.130739, 1.000000, 0.858824, 0.345098, "#ffdb58", "mustard"),
    (0.797944, 0.847944, 0.130952, 0.952941, 0.905882, 0.733333, "#f3e7bb", "sidecar"),
    (0.936966, 0.986966, 0.130952, 0.996078, 0.972549, 0.886275, "#fef8e2", "solitaire"),
    (0.630355, 0.680355, 0.131234, 1.000000, 0.788235, 0.003922, "#ffc901", "supernova"),
    (0.052791, 0.102791, 0.131720, 0.301961, 0.250980, 0.058824, "#4d400f", "bronzetone"),
    (0.919250, 0.969250, 0.131783, 1.000000, 0.964706, 0.831373, "#fff6d4", "milk punch"),
    (0.370303, 0.420303, 0.131944, 0.662745, 0.643137, 0.568627, "#a9a491", "gray olive"),
    (0.945024, 0.995024, 0.132184, 1.000000, 0.976471, 0.886275, "#fff9e2", "gin fizz"),
    (0.470830, 0.520830, 0.133013, 0.862745, 0.698039, 0.047059, "#dcb20c", "galliano"),
    (0.106860, 0.156860, 0.133333, 0.364706, 0.360784, 0.345098, "#5d5c58", "chicago"),
    (0.132681, 0.182681, 0.133333, 0.403922, 0.400000, 0.384314, "#676662", "ironside gray"),
    (0.373228, 0.423228, 0.133333, 0.717647, 0.643137, 0.345098, "#b7a458", "husk"),
    (0.454130, 0.504130, 0.133333, 0.788235, 0.701961, 0.356863, "#c9b35b", "sundance"),
    (0.901318, 0.951318, 0.133333, 0.996078, 0.956863, 0.800000, "#fef4cc", "pipi"),
    (0.463266, 0.513266, 0.133681, 0.784314, 0.709804, 0.407843, "#c8b568", "laser"),
    (0.537497, 0.587497, 0.133880, 0.807843, 0.760784, 0.568627, "#cec291", "yuma"),
    (0.669537, 0.719537, 0.134703, 0.894118, 0.839216, 0.607843, "#e4d69b", "zombie"),
    (0.875068, 0.925068, 0.135135, 1.000000, 0.945098, 0.709804, "#fff1b5", "buttermilk"),
    (0.943682, 0.993682, 0.135802, 0.996078, 0.976471, 0.890196, "#fef9e3", "off yellow"),
    (0.374022, 0.424022, 0.135965, 0.674510, 0.647059, 0.525490, "#aca586", "hillary"),
    (0.224550, 0.274550, 0.136000, 0.596078, 0.505882, 0.105882, "#98811b", "hacienda"),
    (0.706690, 0.756690, 0.136232, 0.941176, 0.858824, 0.490196, "#f0db7d", "golden sand"),
    (0.137312, 0.187312, 0.136232, 0.482353, 0.400000, 0.031373, "#7b6608", "yukon gold"),
    (0.980422, 1.030422, 0.136364, 1.000000, 0.992157, 0.956863, "#fffdf4", "quarter pearl lusta"),
    (0.713234, 0.763234, 0.136364, 0.941176, 0.862745, 0.509804, "#f0dc82", "buff"),
    (0.023188, 0.073188, 0.136364, 0.188235, 0.164706, 0.058824, "#302a0f", "woodrush"),
    (0.431657, 0.481657, 0.136364, 0.713725, 0.690196, 0.584314, "#b6b095", "heathered gray"),
    (0.055427, 0.105427, 0.136364, 0.305882, 0.258824, 0.047059, "#4e420c", "bronze olive"),
    (0.899509, 0.949509, 0.136364, 0.988235, 0.956863, 0.815686, "#fcf4d0", "double pearl lusta"),
    (0.567587, 0.617587, 0.136752, 0.807843, 0.780392, 0.654902, "#cec7a7", "chino"),
    (0.506944, 0.556944, 0.137110, 0.870588, 0.729412, 0.074510, "#deba13", "gold tips"),
    (0.542615, 0.592615, 0.137168, 0.905882, 0.749020, 0.019608, "#e7bf05", "corn"),
    (0.543722, 0.593722, 0.137255, 0.776471, 0.764706, 0.709804, "#c6c3b5", "ash"),
    (0.970539, 1.020539, 0.137255, 1.000000, 0.988235, 0.933333, "#fffcee", "island spice"),
    (0.466289, 0.516289, 0.137387, 0.811765, 0.709804, 0.231373, "#cfb53b", "old gold"),
    (0.364878, 0.414878, 0.137566, 0.756863, 0.627451, 0.015686, "#c1a004", "buddha gold"),
    (0.724421, 0.774421, 0.137821, 0.972549, 0.866667, 0.360784, "#f8dd5c", "energy yellow"),
    (0.652969, 0.702969, 0.137931, 0.870588, 0.831373, 0.643137, "#ded4a4", "sapling"),
    (0.855662, 0.905662, 0.138298, 1.000000, 0.937255, 0.631373, "#ffefa1", "vis vis"),
    (0.796267, 0.846267, 0.138298, 1.000000, 0.905882, 0.447059, "#ffe772", "kournikova"),
    (0.761324, 0.811324, 0.138462, 0.933333, 0.890196, 0.678431, "#eee3ad", "double colonial white"),
    (0.791729, 0.841729, 0.138554, 0.960784, 0.905882, 0.635294, "#f5e7a2", "sandwisp"),
    (0.979816, 1.029816, 0.138889, 1.000000, 0.992157, 0.952941, "#fffdf3", "orchid white"),
    (0.841281, 0.891281, 0.138889, 0.952941, 0.929412, 0.811765, "#f3edcf", "wheatfield"),
    (0.224804, 0.274804, 0.138889, 0.541176, 0.513725, 0.376471, "#8a8360", "clay creek"),
    (0.914973, 0.964973, 0.138889, 0.992157, 0.964706, 0.827451, "#fdf6d3", "half colonial white"),
    (0.709752, 0.759752, 0.138889, 0.933333, 0.862745, 0.509804, "#eedc82", "flax"),
    (0.109720, 0.159720, 0.139241, 0.415686, 0.364706, 0.105882, "#6a5d1b", "himalaya"),
    (0.604983, 0.654983, 0.139881, 0.874510, 0.803922, 0.435294, "#dfcd6f", "chenin"),
    (0.248150, 0.298150, 0.140000, 0.552941, 0.537255, 0.454902, "#8d8974", "granite green"),
    (0.698609, 0.748609, 0.140523, 1.000000, 0.843137, 0.000000, "#ffd700", "gold"),
    (0.128564, 0.178564, 0.140777, 0.454902, 0.392157, 0.050980, "#74640d", "spicy mustard"),
    (0.812483, 0.862483, 0.141141, 0.984314, 0.917647, 0.549020, "#fbea8c", "sweet corn"),
    (0.703717, 0.753717, 0.141176, 1.000000, 0.847059, 0.000000, "#ffd800", "school bus yellow"),
    (0.703830, 0.753830, 0.141194, 0.988235, 0.850980, 0.090196, "#fcd917", "candlelight"),
    (0.929983, 0.979983, 0.141304, 1.000000, 0.972549, 0.819608, "#fff8d1", "baja white"),
    (0.551105, 0.601105, 0.142241, 0.839216, 0.772549, 0.384314, "#d6c562", "tacha"),
    (0.968213, 1.018213, 0.142857, 1.000000, 0.988235, 0.917647, "#fffcea", "buttery white"),
    (0.296968, 0.346968, 0.142857, 0.603922, 0.584314, 0.466667, "#9a9577", "gurkha"),
    (0.086072, 0.136072, 0.142857, 0.329412, 0.325490, 0.301961, "#54534d", "fuscous gray"),
    (0.150647, 0.200647, 0.143519, 0.447059, 0.427451, 0.305882, "#726d4e", "go ben"),
    (0.663032, 0.713032, 0.143590, 0.941176, 0.835294, 0.176471, "#f0d52d", "golden dream"),
    (0.793923, 0.843923, 0.143885, 0.984314, 0.909804, 0.439216, "#fbe870", "marigold yellow"),
    (0.424136, 0.474136, 0.144444, 0.701961, 0.686275, 0.584314, "#b3af95", "taupe gray"),
    (0.731578, 0.781578, 0.144928, 0.925490, 0.878431, 0.564706, "#ece090", "wild rice"),
    (0.684287, 0.734287, 0.145062, 0.956863, 0.847059, 0.109804, "#f4d81c", "ripe lemon"),
    (0.359584, 0.409584, 0.145194, 0.717647, 0.635294, 0.078431, "#b7a214", "sahara"),
    (0.776342, 0.826342, 0.145556, 0.976471, 0.901961, 0.388235, "#f9e663", "portica"),
    (0.666627, 0.716627, 0.145688, 0.913725, 0.843137, 0.352941, "#e9d75a", "confetti"),
    (0.798698, 0.848698, 0.145688, 0.984314, 0.913725, 0.423529, "#fbe96c", "festival"),
    (0.891708, 0.941708, 0.145833, 0.960784, 0.952941, 0.898039, "#f5f3e5", "ecru white"),
    (0.877955, 0.927955, 0.146259, 1.000000, 0.952941, 0.615686, "#fff39d", "picasso"),
    (0.968061, 1.018061, 0.147059, 0.996078, 0.988235, 0.929412, "#fefced", "orange white"),
    (0.485651, 0.535651, 0.147436, 0.792157, 0.733333, 0.282353, "#cabb48", "turmeric"),
    (0.954217, 1.004217, 0.147619, 1.000000, 0.984314, 0.862745, "#fffbdc", "scotch mist"),
    (0.474312, 0.524312, 0.147887, 0.788235, 0.725490, 0.231373, "#c9b93b", "earls green"),
    (0.987974, 1.037974, 0.148148, 1.000000, 0.996078, 0.964706, "#fffef6", "black white"),
    (0.770633, 0.820633, 0.148148, 0.901961, 0.894118, 0.831373, "#e6e4d4", "satin linen"),
    (0.961609, 1.011609, 0.148148, 0.988235, 0.984314, 0.952941, "#fcfbf3", "bianca"),
    (0.339941, 0.389941, 0.148526, 0.686275, 0.623529, 0.109804, "#af9f1c", "lucky"),
    (0.333399, 0.383399, 0.149758, 0.674510, 0.619608, 0.133333, "#ac9e22", "lemon ginger"),
    (0.770123, 0.820123, 0.150000, 0.941176, 0.901961, 0.549020, "#f0e68c", "khaki"),
    (0.940390, 0.990390, 0.150000, 1.000000, 0.980392, 0.803922, "#fffacd", "lemon chiffon"),
    (0.370412, 0.420412, 0.150538, 0.658824, 0.647059, 0.537255, "#a8a589", "tallow"),
    (0.776302, 0.826302, 0.150794, 0.945098, 0.905882, 0.533333, "#f1e788", "sahara sand"),
    (0.812904, 0.862904, 0.150844, 0.984314, 0.925490, 0.364706, "#fbec5d", "candy corn"),
    (0.799591, 0.849591, 0.151515, 0.917647, 0.909804, 0.831373, "#eae8d4", "white rock"),
    (0.973368, 1.023368, 0.152174, 1.000000, 0.992157, 0.909804, "#fffde8", "travertine"),
    (0.791979, 0.841979, 0.152602, 0.992157, 0.913725, 0.062745, "#fde910", "lemon"),
    (0.917006, 0.967006, 0.152778, 0.980392, 0.968627, 0.839216, "#faf7d6", "citrine white"),
    (0.636964, 0.686964, 0.152921, 0.894118, 0.831373, 0.133333, "#e4d422", "sunflower"),
    (0.105835, 0.155835, 0.153061, 0.380392, 0.364706, 0.188235, "#615d30", "costa del sol"),
    (0.812979, 0.862979, 0.153249, 1.000000, 0.925490, 0.074510, "#ffec13", "broom"),
    (0.972237, 1.022237, 0.153333, 1.000000, 0.992157, 0.901961, "#fffde6", "chilean heath"),
    (0.769176, 0.819176, 0.153333, 0.980392, 0.901961, 0.000000, "#fae600", "turbo"),
    (0.174637, 0.224637, 0.153333, 0.486275, 0.462745, 0.192157, "#7c7631", "pesto"),
    (0.847351, 0.897351, 0.153409, 1.000000, 0.945098, 0.309804, "#fff14f", "gorse"),
    (0.044977, 0.094977, 0.153846, 0.250980, 0.239216, 0.098039, "#403d19", "thatch green"),
    (0.870872, 0.920872, 0.154023, 1.000000, 0.956863, 0.431373, "#fff46e", "paris daisy"),
    (0.904213, 0.954213, 0.154167, 0.992157, 0.968627, 0.678431, "#fdf7ad", "drover"),
    (0.039243, 0.089243, 0.155303, 0.235294, 0.223529, 0.062745, "#3c3910", "camouflage"),
    (0.984349, 1.034349, 0.155556, 1.000000, 0.996078, 0.941176, "#fffef0", "rice cake"),
    (0.837001, 0.887001, 0.156250, 0.945098, 0.933333, 0.756863, "#f1eec1", "mint julep"),
    (0.619170, 0.669170, 0.156250, 0.835294, 0.819608, 0.584314, "#d5d195", "winter hazel"),
    (0.579056, 0.629056, 0.157407, 0.800000, 0.792157, 0.658824, "#cccaa8", "thistle green"),
    (0.981998, 1.031998, 0.157895, 1.000000, 0.996078, 0.925490, "#fffeec", "apricot white"),
    (0.583150, 0.633150, 0.158730, 0.796078, 0.792157, 0.713725, "#cbcab6", "foggy gray"),
    (0.928760, 0.978760, 0.158730, 0.976471, 0.972549, 0.894118, "#f9f8e4", "rum swizzle"),
    (0.226589, 0.276589, 0.158730, 0.521569, 0.517647, 0.439216, "#858470", "bandicoot"),
    (0.149404, 0.199404, 0.159420, 0.431373, 0.427451, 0.341176, "#6e6d57", "kokoda"),
    (0.960646, 1.010646, 0.159574, 1.000000, 0.992157, 0.815686, "#fffdd0", "cream"),
    (0.442787, 0.492787, 0.160256, 0.721569, 0.709804, 0.415686, "#b8b56a", "gimblet"),
    (0.577176, 0.627176, 0.160526, 0.831373, 0.803922, 0.086275, "#d4cd16", "bird flower"),
    (0.916453, 0.966453, 0.160714, 0.972549, 0.968627, 0.862745, "#f8f7dc", "coconut cream"),
    (0.791501, 0.841501, 0.160714, 0.929412, 0.917647, 0.600000, "#edea99", "primrose"),
    (0.641923, 0.691923, 0.160804, 0.870588, 0.843137, 0.090196, "#ded717", "barberry"),
    (0.252745, 0.302745, 0.160920, 0.564706, 0.552941, 0.223529, "#908d39", "sycamore"),
    (0.642715, 0.692715, 0.161074, 0.862745, 0.843137, 0.278431, "#dcd747", "wattle"),
    (0.817058, 0.867058, 0.161111, 0.925490, 0.921569, 0.807843, "#ecebce", "aths special"),
    (0.975799, 1.025799, 0.161111, 1.000000, 0.996078, 0.882353, "#fffee1", "half and half"),
    (0.147000, 0.197000, 0.161512, 0.443137, 0.431373, 0.062745, "#716e10", "olivetone"),
    (0.931807, 0.981807, 0.161765, 1.000000, 0.988235, 0.600000, "#fffc99", "witch haze"),
    (0.105242, 0.155242, 0.161905, 0.368627, 0.364706, 0.231373, "#5e5d3b", "hemlock"),
    (0.428367, 0.478367, 0.162921, 0.709804, 0.701961, 0.360784, "#b5b35c", "olive green"),
    (0.809237, 0.859237, 0.163121, 0.925490, 0.921569, 0.741176, "#ecebbd", "fall green"),
    (0.127245, 0.177245, 0.166667, 0.392157, 0.392157, 0.388235, "#646463", "storm dust"),
    (0.200275, 0.250275, 0.166667, 0.501961, 0.501961, 0.000000, "#808000", "olive"),
    (0.345675, 0.395675, 0.166667, 0.623529, 0.623529, 0.611765, "#9f9f9c", "star dust"),
    (0.368778, 0.418778, 0.166667, 0.643137, 0.643137, 0.615686, "#a4a49d", "delta"),
    (0.543064, 0.593064, 0.166667, 0.764706, 0.764706, 0.741176, "#c3c3bd", "gray nickel"),
    (0.548465, 0.598465, 0.166667, 0.768627, 0.768627, 0.737255, "#c4c4bc", "mist gray"),
    (0.669927, 0.719927, 0.166667, 0.839216, 0.839216, 0.819608, "#d6d6d1", "quill gray"),
    (0.851524, 0.901524, 0.166667, 0.933333, 0.933333, 0.909804, "#eeeee8", "cararra"),
    (0.898846, 0.948846, 0.166667, 0.960784, 0.960784, 0.862745, "#f5f5dc", "beige"),
    (0.927800, 0.977800, 0.166667, 1.000000, 1.000000, 0.000000, "#ffff00", "yellow"),
    (0.937393, 0.987393, 0.166667, 1.000000, 1.000000, 0.400000, "#ffff66", "laser lemon"),
    (0.938067, 0.988067, 0.166667, 0.972549, 0.972549, 0.968627, "#f8f8f7", "desert storm"),
    (0.950799, 1.000799, 0.166667, 1.000000, 1.000000, 0.600000, "#ffff99", "pale canary"),
    (0.960753, 1.010753, 0.166667, 1.000000, 1.000000, 0.705882, "#ffffb4", "portafino"),
    (0.990713, 1.040713, 0.166667, 1.000000, 1.000000, 0.941176, "#fffff0", "ivory"),
    (0.812662, 0.862662, 0.168067, 0.933333, 0.937255, 0.470588, "#eeef78", "manz"),
    (0.901081, 0.951081, 0.168459, 0.972549, 0.976471, 0.611765, "#f8f99c", "texas"),
    (0.952270, 1.002270, 0.169048, 0.992157, 0.996078, 0.721569, "#fdfeb8", "pale prim"),
    (0.106084, 0.156084, 0.170940, 0.364706, 0.368627, 0.215686, "#5d5e37", "verdigris"),
    (0.887438, 0.937438, 0.171930, 0.960784, 0.984314, 0.239216, "#f5fb3d", "golden fizz"),
    (0.817668, 0.867668, 0.172447, 0.925490, 0.949020, 0.270588, "#ecf245", "starship"),
    (0.927355, 0.977355, 0.174074, 0.972549, 0.980392, 0.803922, "#f8facd", "corn field"),
    (0.972067, 1.022067, 0.174603, 0.992157, 1.000000, 0.835294, "#fdffd5", "cumulus"),
    (0.846674, 0.896674, 0.175000, 0.933333, 0.941176, 0.784314, "#eef0c8", "tahuna sands"),
    (0.935238, 0.985238, 0.175287, 0.976471, 1.000000, 0.545098, "#f9ff8b", "dolly"),
    (0.889309, 0.939309, 0.175381, 0.952941, 0.984314, 0.384314, "#f3fb62", "canary"),
    (0.945243, 0.995243, 0.175824, 0.980392, 1.000000, 0.643137, "#faffa4", "milan"),
    (0.966410, 1.016410, 0.175926, 0.988235, 0.996078, 0.854902, "#fcfeda", "moon glow"),
    (0.955744, 1.005744, 0.176328, 0.984314, 1.000000, 0.729412, "#fbffba", "shalimar"),
    (0.712882, 0.762882, 0.176471, 0.862745, 0.866667, 0.800000, "#dcddcc", "moon mist"),
    (0.529595, 0.579595, 0.176587, 0.749020, 0.788235, 0.129412, "#bfc921", "key lime pie"),
    (0.172379, 0.222379, 0.177215, 0.450980, 0.470588, 0.160784, "#737829", "crete"),
    (0.477610, 0.527610, 0.179849, 0.701961, 0.756863, 0.062745, "#b3c110", "la rioja"),
    (0.357440, 0.407440, 0.179952, 0.619608, 0.662745, 0.121569, "#9ea91f", "citron"),
    (0.094509, 0.144509, 0.180000, 0.333333, 0.356863, 0.062745, "#555b10", "saratoga"),
    (0.681698, 0.731698, 0.182674, 0.819608, 0.886275, 0.192157, "#d1e231", "pear"),
    (0.578184, 0.628184, 0.183060, 0.780392, 0.803922, 0.564706, "#c7cd90", "pine glade"),
    (0.495642, 0.545642, 0.183168, 0.721569, 0.760784, 0.364706, "#b8c25d", "celery"),
    (0.197267, 0.247267, 0.183849, 0.466667, 0.505882, 0.125490, "#778120", "pacifika"),
    (0.862185, 0.912185, 0.184028, 0.933333, 0.952941, 0.764706, "#eef3c3", "tusk"),
    (0.658969, 0.708969, 0.184044, 0.792157, 0.878431, 0.050980, "#cae00d", "bitter lemon"),
    (0.556963, 0.606963, 0.184255, 0.733333, 0.815686, 0.035294, "#bbd009", "rio grande"),
    (0.219680, 0.269680, 0.184848, 0.486275, 0.533333, 0.101961, "#7c881a", "trendy green"),
    (0.697884, 0.747884, 0.185185, 0.850980, 0.862745, 0.756863, "#d9dcc1", "tana"),
    (0.949102, 0.999102, 0.186508, 0.972549, 0.992157, 0.827451, "#f8fdd3", "mimosa"),
    (0.660788, 0.710788, 0.186567, 0.823529, 0.854902, 0.592157, "#d2da97", "deco"),
    (0.961760, 1.011760, 0.186667, 0.980392, 0.992157, 0.894118, "#fafde4", "hint of yellow"),
    (0.508348, 0.558348, 0.187037, 0.725490, 0.768627, 0.415686, "#b9c46a", "wild willow"),
    (0.892913, 0.942913, 0.187500, 0.929412, 0.988235, 0.517647, "#edfc84", "honeysuckle"),
    (0.252236, 0.302236, 0.187500, 0.533333, 0.552941, 0.396078, "#888d65", "avocado"),
    (0.979850, 1.029850, 0.187500, 0.988235, 1.000000, 0.905882, "#fcffe7", "china ivory"),
    (0.639128, 0.689128, 0.187500, 0.819608, 0.823529, 0.792157, "#d1d2ca", "celeste"),
    (0.872080, 0.922080, 0.187582, 0.874510, 1.000000, 0.000000, "#dfff00", "chartreuse yellow"),
    (0.040450, 0.090450, 0.187943, 0.211765, 0.235294, 0.050980, "#363c0d", "waiouru"),
    (0.077571, 0.127571, 0.188492, 0.286275, 0.329412, 0.000000, "#495400", "verdun green"),
    (0.125805, 0.175805, 0.189655, 0.384314, 0.400000, 0.286275, "#626649", "finch"),
    (0.079175, 0.129175, 0.189922, 0.301961, 0.325490, 0.156863, "#4d5328", "woodland"),
    (0.242206, 0.292206, 0.190476, 0.525490, 0.537255, 0.454902, "#868974", "bitter"),
    (0.686368, 0.736368, 0.191589, 0.776471, 0.901961, 0.062745, "#c6e610", "las palmas"),
    (0.632188, 0.682188, 0.192185, 0.745098, 0.870588, 0.050980, "#bede0d", "fuego"),
    (0.946502, 0.996502, 0.192308, 0.960784, 1.000000, 0.745098, "#f5ffbe", "australian mint"),
    (0.149056, 0.199056, 0.193089, 0.396078, 0.447059, 0.125490, "#657220", "fern frond"),
    (0.920302, 0.970302, 0.194719, 0.933333, 1.000000, 0.603922, "#eeff9a", "jonquil"),
    (0.396782, 0.446782, 0.194872, 0.643137, 0.686275, 0.431373, "#a4af6e", "green smoke"),
    (0.932379, 0.982379, 0.195122, 0.945098, 1.000000, 0.678431, "#f1ffad", "tidal"),
    (0.223036, 0.273036, 0.196370, 0.470588, 0.541176, 0.145098, "#788a25", "wasabi"),
    (0.477432, 0.527432, 0.196970, 0.713725, 0.729412, 0.643137, "#b6baa4", "eagle"),
    (0.012224, 0.062224, 0.196970, 0.109804, 0.117647, 0.074510, "#1c1e13", "rangoon green"),
    (0.569884, 0.619884, 0.196970, 0.776471, 0.784314, 0.741176, "#c6c8bd", "kangaroo"),
    (0.753740, 0.803740, 0.198198, 0.870588, 0.898039, 0.752941, "#dee5c0", "beryl green"),
    (0.475315, 0.525315, 0.198752, 0.631373, 0.772549, 0.039216, "#a1c50a", "citrus"),
    (0.858598, 0.908598, 0.199115, 0.890196, 0.976471, 0.533333, "#e3f988", "mindaro"),
    (0.507377, 0.557377, 0.199825, 0.647059, 0.796078, 0.047059, "#a5cb0c", "bahia"),
    (0.334055, 0.384055, 0.200000, 0.607843, 0.619608, 0.560784, "#9b9e8f", "lemon grass"),
    (0.843574, 0.893574, 0.200000, 0.800000, 1.000000, 0.000000, "#ccff00", "electric lime"),
    (0.457714, 0.507714, 0.200000, 0.615686, 0.760784, 0.035294, "#9dc209", "pistachio"),
    (0.928025, 0.978025, 0.200855, 0.952941, 0.984314, 0.831373, "#f3fbd4", "orinoco"),
    (0.062966, 0.112966, 0.201754, 0.270588, 0.286275, 0.211765, "#454936", "kelp"),
    (0.409378, 0.459378, 0.202020, 0.658824, 0.686275, 0.556863, "#a8af8e", "locust"),
    (0.624196, 0.674196, 0.204762, 0.796078, 0.827451, 0.690196, "#cbd3b0", "green mist"),
    (0.359286, 0.409286, 0.205556, 0.619608, 0.647059, 0.529412, "#9ea587", "sage"),
    (0.211158, 0.261158, 0.206897, 0.482353, 0.509804, 0.396078, "#7b8265", "flax smoke"),
    (0.642153, 0.692153, 0.207532, 0.690196, 0.890196, 0.074510, "#b0e313", "inch worm"),
    (0.029775, 0.079775, 0.208333, 0.180392, 0.196078, 0.133333, "#2e3222", "rangitoto"),
    (0.825964, 0.875964, 0.208497, 0.749020, 1.000000, 0.000000, "#bfff00", "lime"),
    (0.943909, 0.993909, 0.209091, 0.945098, 1.000000, 0.784314, "#f1ffc8", "chiffon"),
    (0.962801, 1.012801, 0.209524, 0.964706, 1.000000, 0.862745, "#f6ffdc", "spring sun"),
    (0.006214, 0.056214, 0.211111, 0.062745, 0.078431, 0.019608, "#101405", "green waterloo"),
    (0.445906, 0.495906, 0.211382, 0.674510, 0.717647, 0.556863, "#acb78e", "swamp green"),
    (0.671259, 0.721259, 0.211974, 0.772549, 0.882353, 0.478431, "#c5e17a", "yellow green"),
    (0.136575, 0.186575, 0.212121, 0.392157, 0.415686, 0.329412, "#646a54", "siam"),
    (0.819543, 0.869543, 0.212121, 0.909804, 0.921569, 0.878431, "#e8ebe0", "green white"),
    (0.881524, 0.931524, 0.212121, 0.933333, 0.956863, 0.870588, "#eef4de", "loafer"),
    (0.011709, 0.061709, 0.216049, 0.090196, 0.121569, 0.015686, "#171f04", "pine tree"),
    (0.274978, 0.324978, 0.216129, 0.435294, 0.615686, 0.007843, "#6f9d02", "limeade"),
    (0.790793, 0.840793, 0.216374, 0.862745, 0.929412, 0.705882, "#dcedb4", "caper"),
    (0.056433, 0.106433, 0.216374, 0.219608, 0.286275, 0.062745, "#384910", "clover"),
    (0.955326, 1.005326, 0.217949, 0.952941, 1.000000, 0.847059, "#f3ffd8", "carla"),
    (0.848199, 0.898199, 0.218391, 0.909804, 0.945098, 0.831373, "#e8f1d4", "chrome white"),
    (0.033447, 0.083447, 0.218519, 0.164706, 0.219608, 0.043137, "#2a380b", "turtle green"),
    (0.774562, 0.824562, 0.218750, 0.882353, 0.901961, 0.839216, "#e1e6d6", "periglacial blue"),
    (0.345721, 0.395721, 0.219298, 0.529412, 0.670588, 0.223529, "#87ab39", "sushi"),
    (0.225932, 0.275932, 0.221184, 0.419608, 0.556863, 0.137255, "#6b8e23", "olive drab"),
    (0.409972, 0.459972, 0.222222, 0.658824, 0.682353, 0.611765, "#a8ae9c", "bud"),
    (0.885298, 0.935298, 0.222222, 0.929412, 0.960784, 0.866667, "#edf5dd", "frost"),
    (0.504314, 0.554314, 0.222917, 0.592157, 0.803922, 0.176471, "#97cd2d", "atlantis"),
    (0.610194, 0.660194, 0.223380, 0.674510, 0.866667, 0.301961, "#acdd4d", "conifer"),
    (0.192811, 0.242811, 0.224359, 0.454902, 0.490196, 0.388235, "#747d63", "limed ash"),
    (0.599821, 0.649821, 0.229167, 0.768627, 0.815686, 0.690196, "#c4d0b0", "coriander"),
    (0.433119, 0.483119, 0.229885, 0.662745, 0.705882, 0.592157, "#a9b497", "schist"),
    (0.806095, 0.856095, 0.232372, 0.678431, 1.000000, 0.184314, "#adff2f", "green yellow"),
    (0.751129, 0.801129, 0.234195, 0.756863, 0.941176, 0.486275, "#c1f07c", "sulu"),
    (0.796067, 0.846067, 0.234848, 0.882353, 0.917647, 0.831373, "#e1ead4", "kidnapper"),
    (0.023870, 0.073870, 0.236111, 0.141176, 0.180392, 0.086275, "#242e16", "black olive"),
    (0.115304, 0.165304, 0.236559, 0.262745, 0.415686, 0.050980, "#436a0d", "green leaf"),
    (0.403086, 0.453086, 0.237952, 0.462745, 0.741176, 0.090196, "#76bd17", "lima"),
    (0.305647, 0.355647, 0.238255, 0.403922, 0.654902, 0.070588, "#67a712", "christi"),
    (0.428058, 0.478058, 0.240476, 0.603922, 0.725490, 0.450980, "#9ab973", "olivine"),
    (0.256057, 0.306057, 0.241379, 0.509804, 0.560784, 0.447059, "#828f72", "battleship gray"),
    (0.021197, 0.071197, 0.243590, 0.141176, 0.164706, 0.113725, "#242a1d", "log cabin"),
    (0.990550, 1.040550, 0.250000, 0.988235, 1.000000, 0.976471, "#fcfff9", "ceramic"),
    (0.760320, 0.810320, 0.250327, 0.498039, 1.000000, 0.000000, "#7fff00", "chartreuse"),
    (0.219015, 0.269015, 0.250700, 0.329412, 0.564706, 0.098039, "#549019", "vida loca"),
    (0.343651, 0.393651, 0.251082, 0.513725, 0.666667, 0.364706, "#83aa5d", "chelsea cucumber"),
    (0.221048, 0.271048, 0.253086, 0.470588, 0.525490, 0.419608, "#78866b", "camouflage green"),
    (0.553820, 0.603820, 0.253968, 0.741176, 0.784314, 0.701961, "#bdc8b3", "clay ash"),
    (0.839710, 0.889710, 0.254630, 0.823529, 0.972549, 0.690196, "#d2f8b0", "gossip"),
    (0.100312, 0.150312, 0.255144, 0.223529, 0.392157, 0.074510, "#396413", "dell"),
    (0.005457, 0.055457, 0.255556, 0.043137, 0.074510, 0.015686, "#0b1304", "black forest"),
    (0.546014, 0.596014, 0.255952, 0.725490, 0.784314, 0.674510, "#b9c8ac", "rainee"),
    (0.301079, 0.351079, 0.256039, 0.482353, 0.627451, 0.356863, "#7ba05b", "asparagus"),
    (0.010867, 0.060867, 0.256410, 0.086275, 0.113725, 0.062745, "#161d10", "hunter green"),
    (0.159757, 0.209757, 0.256944, 0.364706, 0.466667, 0.278431, "#5d7747", "dingley"),
    (0.515046, 0.565046, 0.260417, 0.721569, 0.756863, 0.694118, "#b8c1b1", "green spring"),
    (0.630729, 0.680729, 0.260684, 0.756863, 0.843137, 0.690196, "#c1d7b0", "sprout"),
    (0.026738, 0.076738, 0.261905, 0.145098, 0.192157, 0.109804, "#25311c", "green kelp"),
    (0.004303, 0.054303, 0.261905, 0.043137, 0.058824, 0.031373, "#0b0f08", "marshland"),
    (0.865461, 0.915461, 0.263441, 0.788235, 1.000000, 0.635294, "#c9ffa2", "reef"),
    (0.020907, 0.070907, 0.263889, 0.094118, 0.176471, 0.035294, "#182d09", "deep forest green"),
    (0.951881, 1.001881, 0.264368, 0.933333, 1.000000, 0.886275, "#eeffe2", "rice flower"),
    (0.926174, 0.976174, 0.264493, 0.894118, 1.000000, 0.819608, "#e4ffd1", "snow flurry"),
    (0.132381, 0.182381, 0.265306, 0.317647, 0.431373, 0.239216, "#516e3d", "chalet green"),
    (0.743448, 0.793448, 0.266667, 0.400000, 1.000000, 0.000000, "#66ff00", "bright green"),
    (0.004874, 0.054874, 0.266667, 0.043137, 0.066667, 0.027451, "#0b1107", "gordons green"),
    (0.028793, 0.078793, 0.267857, 0.137255, 0.203922, 0.094118, "#233418", "mallard"),
    (0.160478, 0.210478, 0.275362, 0.396078, 0.454902, 0.364706, "#65745d", "willow grove"),
    (0.983136, 1.033136, 0.277778, 0.976471, 1.000000, 0.964706, "#f9fff6", "sugar cane"),
    (0.940866, 0.990866, 0.277778, 0.941176, 0.988235, 0.917647, "#f0fcea", "feta"),
    (0.795358, 0.845358, 0.277778, 0.815686, 0.941176, 0.752941, "#d0f0c0", "tea green"),
    (0.023065, 0.073065, 0.277778, 0.105882, 0.184314, 0.066667, "#1b2f11", "seaweed"),
    (0.061469, 0.111469, 0.279487, 0.141176, 0.313725, 0.058824, "#24500f", "green house"),
    (0.472232, 0.522232, 0.283333, 0.658824, 0.741176, 0.623529, "#a8bd9f", "norway"),
    (0.029480, 0.079480, 0.283333, 0.168627, 0.196078, 0.156863, "#2b3228", "heavy metal"),
    (0.026060, 0.076060, 0.283784, 0.098039, 0.200000, 0.054902, "#19330e", "palm leaf"),
    (0.636956, 0.686956, 0.284314, 0.752941, 0.847059, 0.713725, "#c0d8b6", "pixie green"),
    (0.151439, 0.201439, 0.285256, 0.196078, 0.486275, 0.078431, "#327c14", "bilbao"),
    (0.181701, 0.231701, 0.286136, 0.211765, 0.529412, 0.086275, "#368716", "la palma"),
    (0.236264, 0.286264, 0.286822, 0.435294, 0.556863, 0.388235, "#6f8e63", "highland"),
    (0.065311, 0.115311, 0.287037, 0.247059, 0.298039, 0.227451, "#3f4c3a", "cabbage pont"),
    (0.807408, 0.857408, 0.287037, 0.874510, 0.925490, 0.854902, "#dfecda", "willow brook"),
    (0.612978, 0.662978, 0.288462, 0.752941, 0.827451, 0.725490, "#c0d3b9", "pale leaf"),
    (0.725768, 0.775768, 0.292157, 0.247059, 1.000000, 0.000000, "#3fff00", "harlequin"),
    (0.157304, 0.207304, 0.293939, 0.309804, 0.474510, 0.258824, "#4f7942", "fern green"),
    (0.609773, 0.659773, 0.294239, 0.623529, 0.866667, 0.549020, "#9fdd8c", "feijoa"),
    (0.797514, 0.847514, 0.303030, 0.854902, 0.925490, 0.839216, "#daecd6", "zanah"),
    (0.116035, 0.166035, 0.304598, 0.305882, 0.400000, 0.286275, "#4e6649", "axolotl"),
    (0.300045, 0.350045, 0.305296, 0.309804, 0.658824, 0.239216, "#4fa83d", "apple"),
    (0.826930, 0.876930, 0.305556, 0.905882, 0.925490, 0.901961, "#e7ece6", "gray nurse"),
    (0.436828, 0.486828, 0.306738, 0.454902, 0.764706, 0.396078, "#74c365", "mantis"),
    (0.183123, 0.233123, 0.309091, 0.325490, 0.509804, 0.294118, "#53824b", "hippie green"),
    (0.083520, 0.133520, 0.310345, 0.247059, 0.345098, 0.231373, "#3f583b", "tom thumb"),
    (0.060312, 0.110312, 0.311111, 0.235294, 0.286275, 0.227451, "#3c493a", "lunar green"),
    (0.625860, 0.675860, 0.311688, 0.615686, 0.878431, 0.576471, "#9de093", "granny smith apple"),
    (0.870720, 0.920720, 0.316667, 0.890196, 0.960784, 0.882353, "#e3f5e1", "peppermint"),
    (0.145568, 0.195568, 0.320988, 0.345098, 0.443137, 0.337255, "#587156", "cactus"),
    (0.198701, 0.248701, 0.324324, 0.380392, 0.517647, 0.372549, "#61845f", "glade green"),
    (0.088765, 0.138765, 0.325000, 0.274510, 0.349020, 0.270588, "#465945", "gray asparagus"),
    (0.088219, 0.138219, 0.326007, 0.043137, 0.384314, 0.027451, "#0b6207", "san felix"),
    (0.101808, 0.151808, 0.326599, 0.039216, 0.411765, 0.023529, "#0a6906", "japanese laurel"),
    (0.004052, 0.054052, 0.333333, 0.015686, 0.062745, 0.015686, "#041004", "midnight moss"),
    (0.015859, 0.065859, 0.333333, 0.000000, 0.160784, 0.000000, "#002900", "deep fir"),
    (0.189208, 0.239208, 0.333333, 0.133333, 0.545098, 0.133333, "#228b22", "forest green"),
    (0.268832, 0.318832, 0.333333, 0.541176, 0.560784, 0.541176, "#8a8f8a", "stack"),
    (0.569668, 0.619668, 0.333333, 0.466667, 0.866667, 0.466667, "#77dd77", "pastel green"),
    (0.646767, 0.696767, 0.333333, 0.678431, 0.874510, 0.678431, "#addfad", "moss green"),
    (0.689568, 0.739568, 0.333333, 0.811765, 0.862745, 0.811765, "#cfdccf", "tasman"),
    (0.715200, 0.765200, 0.333333, 0.000000, 1.000000, 0.000000, "#00ff00", "green"),
    (0.753041, 0.803041, 0.333333, 0.400000, 1.000000, 0.400000, "#66ff66", "screamin green"),
    (0.804624, 0.854624, 0.333333, 0.596078, 1.000000, 0.596078, "#98ff98", "mint green"),
    (0.948608, 0.998608, 0.333333, 0.968627, 0.980392, 0.968627, "#f7faf7", "snow drift"),
    (0.135405, 0.185405, 0.340278, 0.333333, 0.427451, 0.337255, "#556d56", "finlandia"),
    (0.047283, 0.097283, 0.341398, 0.039216, 0.282353, 0.050980, "#0a480d", "dark fern"),
    (0.657162, 0.707162, 0.342767, 0.674510, 0.882353, 0.686275, "#ace1af", "celadon"),
    (0.058006, 0.108006, 0.350000, 0.074510, 0.309804, 0.098039, "#134f19", "parsley"),
    (0.376023, 0.426023, 0.351190, 0.388235, 0.717647, 0.423529, "#63b76c", "fern"),
    (0.942262, 0.992262, 0.353333, 0.901961, 1.000000, 0.913725, "#e6ffe9", "hint of green"),
    (0.909306, 0.959306, 0.353659, 0.839216, 1.000000, 0.858824, "#d6ffdb", "snowy mint"),
    (0.761052, 0.811052, 0.353801, 0.717647, 0.941176, 0.745098, "#b7f0be", "madang"),
    (0.259365, 0.309365, 0.354839, 0.454902, 0.576471, 0.470588, "#749378", "laurel"),
    (0.739572, 0.789572, 0.356061, 0.811765, 0.898039, 0.823529, "#cfe5d2", "surf crest"),
    (0.305657, 0.355657, 0.356481, 0.482353, 0.623529, 0.501961, "#7b9f80", "amulet"),
    (0.546569, 0.596569, 0.360215, 0.674510, 0.796078, 0.694118, "#accbb1", "spring rain"),
    (0.881750, 0.931750, 0.361111, 0.894118, 0.964706, 0.905882, "#e4f6e7", "frostee"),
    (0.916331, 0.966331, 0.361111, 0.945098, 0.968627, 0.949020, "#f1f7f2", "saltpan"),
    (0.288171, 0.338171, 0.362319, 0.505882, 0.596078, 0.521569, "#819885", "spanish green"),
    (0.265665, 0.315665, 0.363248, 0.309804, 0.615686, 0.364706, "#4f9d5d", "fruit salad"),
    (0.347750, 0.397750, 0.364198, 0.545098, 0.650980, 0.564706, "#8ba690", "envy"),
    (0.453950, 0.503950, 0.364865, 0.478431, 0.768627, 0.533333, "#7ac488", "de york"),
    (0.630159, 0.680159, 0.369048, 0.733333, 0.843137, 0.756863, "#bbd7c1", "surf"),
    (0.667976, 0.717976, 0.371212, 0.772549, 0.858824, 0.792157, "#c5dbca", "sea mist"),
    (0.012946, 0.062946, 0.371795, 0.035294, 0.137255, 0.058824, "#09230f", "palm green"),
    (0.576959, 0.626959, 0.375000, 0.760784, 0.792157, 0.768627, "#c2cac4", "pumice"),
    (0.220511, 0.270511, 0.377193, 0.450980, 0.525490, 0.470588, "#738678", "xanadu"),
    (0.905729, 0.955729, 0.377778, 0.913725, 0.972549, 0.929412, "#e9f8ed", "ottoman"),
    (0.116625, 0.166625, 0.378472, 0.227451, 0.415686, 0.278431, "#3a6a47", "killarney"),
    (0.191597, 0.241597, 0.378788, 0.341176, 0.513725, 0.388235, "#578363", "spring leaves"),
    (0.312795, 0.362795, 0.382353, 0.545098, 0.611765, 0.564706, "#8b9c90", "mantle"),
    (0.070540, 0.120540, 0.382576, 0.000000, 0.345098, 0.101961, "#00581a", "camarone"),
    (0.866582, 0.916582, 0.383333, 0.909804, 0.949020, 0.921569, "#e8f2eb", "gin"),
    (0.046927, 0.096927, 0.384259, 0.000000, 0.282353, 0.086275, "#004816", "crusoe"),
    (0.299398, 0.349398, 0.384615, 0.250980, 0.658824, 0.376471, "#40a860", "chateau green"),
    (0.602952, 0.652952, 0.385057, 0.713725, 0.827451, 0.749020, "#b6d3bf", "gum leaf"),
    (0.675901, 0.725901, 0.387755, 0.694118, 0.886275, 0.756863, "#b1e2c1", "fringy flower"),
    (0.162685, 0.212685, 0.388021, 0.239216, 0.490196, 0.321569, "#3d7d52", "goblin"),
    (0.895770, 0.945770, 0.388889, 0.917647, 0.964706, 0.933333, "#eaf6ee", "panache"),
    (0.877453, 0.927453, 0.388889, 0.882353, 0.964706, 0.909804, "#e1f6e8", "tara"),
    (0.443701, 0.493701, 0.388889, 0.313725, 0.784314, 0.470588, "#50c878", "emerald"),
    (0.314022, 0.364022, 0.388889, 0.372549, 0.654902, 0.466667, "#5fa777", "aqua forest"),
    (0.848871, 0.898871, 0.388889, 0.823529, 0.964706, 0.870588, "#d2f6de", "blue romance"),
    (0.862678, 0.912678, 0.388889, 0.901961, 0.949020, 0.917647, "#e6f2ea", "harp"),
    (0.921068, 0.971068, 0.388889, 0.929412, 0.976471, 0.945098, "#edf9f1", "narvik"),
    (0.508080, 0.558080, 0.389694, 0.043137, 0.854902, 0.317647, "#0bda51", "malachite"),
    (0.669371, 0.719371, 0.392655, 0.658824, 0.890196, 0.741176, "#a8e3bd", "chinook"),
    (0.346590, 0.396590, 0.393939, 0.490196, 0.662745, 0.552941, "#7da98d", "bay leaf"),
    (0.300969, 0.350969, 0.397436, 0.466667, 0.619608, 0.525490, "#779e86", "oxley"),
    (0.008139, 0.058139, 0.397436, 0.047059, 0.098039, 0.066667, "#0c1911", "racing green"),
    (0.099338, 0.149338, 0.398148, 0.294118, 0.364706, 0.321569, "#4b5d52", "nandor"),
    (0.694634, 0.744634, 0.400585, 0.678431, 0.901961, 0.768627, "#ade6c4", "padua"),
    (0.220592, 0.270592, 0.401961, 0.403922, 0.537255, 0.458824, "#678975", "viridian green"),
    (0.856037, 0.906037, 0.404040, 0.835294, 0.964706, 0.890196, "#d5f6e3", "granny apple"),
    (0.025673, 0.075673, 0.404762, 0.086275, 0.196078, 0.133333, "#163222", "celtic"),
    (0.197342, 0.247342, 0.406810, 0.180392, 0.545098, 0.341176, "#2e8b57", "sea green"),
    (0.019438, 0.069438, 0.406977, 0.007843, 0.176471, 0.082353, "#022d15", "english holly"),
    (0.155370, 0.205370, 0.407407, 0.231373, 0.478431, 0.341176, "#3b7a57", "amazon"),
    (0.021234, 0.071234, 0.409091, 0.050980, 0.180392, 0.109804, "#0d2e1c", "bush"),
    (0.044846, 0.094846, 0.409524, 0.000000, 0.274510, 0.125490, "#004620", "kaitoke green"),
    (0.563597, 0.613597, 0.410256, 0.737255, 0.788235, 0.760784, "#bcc9c2", "powder ash"),
    (0.028134, 0.078134, 0.410494, 0.003922, 0.215686, 0.101961, "#01371a", "county green"),
    (0.007843, 0.057843, 0.411765, 0.031373, 0.098039, 0.062745, "#081910", "black bean"),
    (0.624391, 0.674391, 0.414474, 0.576471, 0.874510, 0.721569, "#93dfb8", "algae green"),
    (0.171239, 0.221239, 0.414729, 0.317647, 0.486275, 0.400000, "#517c66", "como"),
    (0.730523, 0.780523, 0.416340, 0.000000, 1.000000, 0.498039, "#00ff7f", "spring green"),
    (0.038081, 0.088081, 0.416667, 0.015686, 0.250980, 0.133333, "#044022", "zuccini"),
    (0.041109, 0.091109, 0.416667, 0.109804, 0.250980, 0.180392, "#1c402e", "everglade"),
    (0.027286, 0.077286, 0.418239, 0.003922, 0.211765, 0.109804, "#01361c", "cardin green"),
    (0.110142, 0.160142, 0.419476, 0.070588, 0.419608, 0.250980, "#126b40", "jewel"),
    (0.112391, 0.162391, 0.419753, 0.003922, 0.427451, 0.223529, "#016d39", "fun green"),
    (0.895946, 0.945946, 0.419753, 0.788235, 1.000000, 0.898039, "#c9ffe5", "aero blue"),
    (0.378557, 0.428557, 0.419831, 0.400000, 0.709804, 0.560784, "#66b58f", "silver tree"),
    (0.572281, 0.622281, 0.420188, 0.560784, 0.839216, 0.705882, "#8fd6b4", "vista blue"),
    (0.312293, 0.362293, 0.420635, 0.254902, 0.666667, 0.470588, "#41aa78", "ocean green"),
    (0.193636, 0.243636, 0.420875, 0.152941, 0.541176, 0.356863, "#278a5b", "eucalyptus"),
    (0.092039, 0.142039, 0.424020, 0.113725, 0.380392, 0.258824, "#1d6142", "green pea"),
    (0.721238, 0.771238, 0.425926, 0.784314, 0.890196, 0.843137, "#c8e3d7", "edgewater"),
    (0.684964, 0.734964, 0.425926, 0.792157, 0.862745, 0.831373, "#cadcd4", "paris white"),
    (0.754697, 0.804697, 0.426190, 0.666667, 0.941176, 0.819608, "#aaf0d1", "magic mint"),
    (0.157448, 0.207448, 0.426554, 0.035294, 0.498039, 0.294118, "#097f4b", "salem"),
    (0.666964, 0.716964, 0.427083, 0.788235, 0.850980, 0.823529, "#c9d9d2", "conch"),
    (0.449650, 0.499650, 0.427928, 0.588235, 0.733333, 0.670588, "#96bbab", "summer green"),
    (0.146381, 0.196381, 0.428571, 0.376471, 0.431373, 0.407843, "#606e68", "corduroy"),
    (0.742121, 0.792121, 0.428571, 0.792157, 0.901961, 0.854902, "#cae6da", "skeptic"),
    (0.863261, 0.913261, 0.431373, 0.886275, 0.952941, 0.925490, "#e2f3ec", "apple green"),
    (0.028238, 0.078238, 0.433333, 0.035294, 0.211765, 0.141176, "#093624", "bottle green"),
    (0.370625, 0.420625, 0.435185, 0.588235, 0.658824, 0.631373, "#96a8a1", "pewter"),
    (0.272003, 0.322003, 0.439300, 0.003922, 0.639216, 0.407843, "#01a368", "green haze"),
    (0.290668, 0.340668, 0.439484, 0.000000, 0.658824, 0.419608, "#00a86b", "jade"),
    (0.009322, 0.059322, 0.440476, 0.003922, 0.113725, 0.074510, "#011d13", "holly"),
    (0.229063, 0.279063, 0.441667, 0.454902, 0.533333, 0.505882, "#748881", "blue smoke"),
    (0.807855, 0.857855, 0.444010, 0.498039, 1.000000, 0.831373, "#7fffd4", "aquamarine"),
    (0.461894, 0.511894, 0.444444, 0.200000, 0.800000, 0.600000, "#33cc99", "shamrock"),
    (0.095100, 0.145100, 0.444444, 0.247059, 0.364706, 0.325490, "#3f5d53", "mineral green"),
    (0.038615, 0.088615, 0.446237, 0.007843, 0.250980, 0.172549, "#02402c", "sherwood green"),
    (0.181594, 0.231594, 0.446970, 0.250980, 0.509804, 0.427451, "#40826d", "viridian"),
    (0.682146, 0.732146, 0.447917, 0.796078, 0.858824, 0.839216, "#cbdbd6", "nebula"),
    (0.020583, 0.070583, 0.449275, 0.000000, 0.180392, 0.125490, "#002e20", "burnham"),
    (0.341533, 0.391533, 0.449891, 0.101961, 0.701961, 0.521569, "#1ab385", "mountain meadow"),
    (0.834763, 0.884763, 0.450000, 0.862745, 0.941176, 0.917647, "#dcf0ea", "swans down"),
    (0.379090, 0.429090, 0.451923, 0.486275, 0.690196, 0.631373, "#7cb0a1", "acapulco"),
    (0.894744, 0.944744, 0.452381, 0.866667, 0.976471, 0.945098, "#ddf9f1", "white ice"),
    (0.904289, 0.954289, 0.453704, 0.901961, 0.972549, 0.952941, "#e6f8f3", "off green"),
    (0.313465, 0.363465, 0.453846, 0.160784, 0.670588, 0.529412, "#29ab87", "jungle green"),
    (0.918364, 0.968364, 0.455556, 0.917647, 0.976471, 0.960784, "#eaf9f5", "aqua spring"),
    (0.091160, 0.141160, 0.457364, 0.196078, 0.364706, 0.321569, "#325d52", "stromboli"),
    (0.234895, 0.284895, 0.458333, 0.509804, 0.525490, 0.521569, "#828685", "gunsmoke"),
    (0.454856, 0.504856, 0.458333, 0.000000, 0.800000, 0.600000, "#00cc99", "caribbean green"),
    (0.489143, 0.539143, 0.458333, 0.603922, 0.760784, 0.721569, "#9ac2b8", "shadow green"),
    (0.408938, 0.458938, 0.458333, 0.635294, 0.682353, 0.670588, "#a2aeab", "edward"),
    (0.751424, 0.801424, 0.460606, 0.709804, 0.925490, 0.874510, "#b5ecdf", "cruise"),
    (0.888714, 0.938714, 0.461538, 0.909804, 0.960784, 0.949020, "#e8f5f2", "aqua squeeze"),
    (0.120893, 0.170893, 0.462264, 0.019608, 0.435294, 0.341176, "#056f57", "watercourse"),
    (0.026336, 0.076336, 0.464286, 0.086275, 0.196078, 0.172549, "#16322c", "timber green"),
    (0.277470, 0.327470, 0.466667, 0.388235, 0.603922, 0.560784, "#639a8f", "patina"),
    (0.009863, 0.059863, 0.466667, 0.050980, 0.109804, 0.098039, "#0d1c19", "aztec"),
    (0.575489, 0.625489, 0.467033, 0.490196, 0.847059, 0.776471, "#7dd8c6", "bermuda"),
    (0.135307, 0.185307, 0.467236, 0.000000, 0.458824, 0.368627, "#00755e", "tropical rain forest"),
    (0.933574, 0.983574, 0.467593, 0.858824, 1.000000, 0.972549, "#dbfff8", "frosted mint"),
    (0.798180, 0.848180, 0.467662, 0.694118, 0.956863, 0.905882, "#b1f4e7", "ice cold"),
    (0.046166, 0.096166, 0.468468, 0.117647, 0.262745, 0.235294, "#1e433c", "te papa green"),
    (0.824353, 0.874353, 0.468750, 0.768627, 0.956863, 0.921569, "#c4f4eb", "mint tulip"),
    (0.170333, 0.220333, 0.470284, 0.003922, 0.509804, 0.419608, "#01826b", "deep sea"),
    (0.420990, 0.470990, 0.470513, 0.247059, 0.756863, 0.666667, "#3fc1aa", "puerto rico"),
    (0.250664, 0.300664, 0.470917, 0.023529, 0.607843, 0.505882, "#069b81", "gossamer"),
    (0.182108, 0.232108, 0.470960, 0.007843, 0.525490, 0.435294, "#02866f", "observatory"),
    (0.325878, 0.375878, 0.472868, 0.470588, 0.639216, 0.611765, "#78a39c", "sea nymph"),
    (0.273346, 0.323346, 0.474194, 0.023529, 0.631373, 0.537255, "#06a189", "niagara"),
    (0.174541, 0.224541, 0.474255, 0.031373, 0.513725, 0.439216, "#088370", "elf green"),
    (0.858981, 0.908981, 0.474359, 0.854902, 0.956863, 0.941176, "#daf4f0", "iceberg"),
    (0.670405, 0.720405, 0.474359, 0.545098, 0.901961, 0.847059, "#8be6d8", "riptide"),
    (0.711288, 0.761288, 0.474537, 0.631373, 0.913725, 0.870588, "#a1e9de", "water leaf"),
    (0.344188, 0.394188, 0.474576, 0.227451, 0.690196, 0.619608, "#3ab09e", "keppel"),
    (0.910632, 0.960632, 0.475000, 0.898039, 0.976471, 0.964706, "#e5f9f6", "polar"),
    (0.874878, 0.924878, 0.476190, 0.811765, 0.976471, 0.952941, "#cff9f3", "humming bird"),
    (0.881683, 0.931683, 0.476744, 0.811765, 0.980392, 0.956863, "#cffaf4", "scandal"),
    (0.527182, 0.577182, 0.477011, 0.662745, 0.776471, 0.760784, "#a9c6c2", "opal"),
    (0.603732, 0.653732, 0.477012, 0.709804, 0.823529, 0.807843, "#b5d2ce", "jet stream"),
    (0.365815, 0.415815, 0.477778, 0.545098, 0.662745, 0.647059, "#8ba9a5", "cascade"),
    (0.540143, 0.590143, 0.478355, 0.513725, 0.815686, 0.776471, "#83d0c6", "monte carlo"),
    (0.029385, 0.079385, 0.478495, 0.086275, 0.207843, 0.192157, "#163531", "gable green"),
    (0.055002, 0.105002, 0.479167, 0.235294, 0.266667, 0.262745, "#3c4443", "cape cod"),
    (0.066767, 0.116767, 0.479675, 0.152941, 0.313725, 0.294118, "#27504b", "plantation"),
    (0.293790, 0.343790, 0.480924, 0.000000, 0.650980, 0.576471, "#00a693", "persian green"),
    (0.525225, 0.575225, 0.481100, 0.435294, 0.815686, 0.772549, "#6fd0c5", "downy"),
    (0.054439, 0.104439, 0.481982, 0.003922, 0.294118, 0.262745, "#014b43", "aqua deep"),
    (0.158772, 0.208772, 0.482456, 0.313725, 0.462745, 0.447059, "#507672", "cutty sark"),
    (0.059039, 0.109039, 0.482456, 0.007843, 0.305882, 0.274510, "#024e46", "evening sea"),
    (0.398854, 0.448854, 0.483660, 0.501961, 0.701961, 0.682353, "#80b3ae", "gulf stream"),
    (0.959355, 1.009355, 0.484848, 0.913725, 1.000000, 0.992157, "#e9fffd", "clear day"),
    (0.134824, 0.184824, 0.485816, 0.082353, 0.450980, 0.419608, "#15736b", "genoa"),
    (0.209576, 0.259576, 0.486111, 0.172549, 0.549020, 0.517647, "#2c8c84", "lochinvar"),
    (0.376517, 0.426517, 0.486111, 0.372549, 0.701961, 0.674510, "#5fb3ac", "tradewind"),
    (0.076988, 0.126988, 0.486111, 0.062745, 0.345098, 0.321569, "#105852", "eden"),
    (0.148289, 0.198289, 0.486111, 0.003922, 0.474510, 0.435294, "#01796f", "pine green"),
    (0.748397, 0.798397, 0.486842, 0.760784, 0.909804, 0.898039, "#c2e8e5", "jagged ice"),
    (0.523870, 0.573870, 0.486869, 0.188235, 0.835294, 0.784314, "#30d5c8", "turquoise"),
    (0.606750, 0.656750, 0.488095, 0.623529, 0.843137, 0.827451, "#9fd7d3", "sinbad"),
    (0.086048, 0.136048, 0.488372, 0.184314, 0.352941, 0.341176, "#2f5a57", "spectra"),
    (0.027765, 0.077765, 0.490566, 0.000000, 0.207843, 0.196078, "#003532", "deep teal"),
    (0.911219, 0.961219, 0.490741, 0.847059, 0.988235, 0.980392, "#d8fcfa", "foam"),
    (0.626262, 0.676262, 0.491228, 0.631373, 0.854902, 0.843137, "#a1dad7", "aqua island"),
    (0.961682, 1.011682, 0.492063, 0.917647, 1.000000, 0.996078, "#eafffe", "dew"),
    (0.630388, 0.680388, 0.492560, 0.031373, 0.909804, 0.870588, "#08e8de", "bright turquoise"),
    (0.161649, 0.211649, 0.493939, 0.258824, 0.474510, 0.466667, "#427977", "faded jade"),
    (0.303201, 0.353201, 0.495098, 0.364706, 0.631373, 0.623529, "#5da19f", "breaker bay"),
    (0.153777, 0.203777, 0.498485, 0.047059, 0.478431, 0.474510, "#0c7a79", "surfie green"),
    (0.169969, 0.219969, 0.500000, 0.000000, 0.501961, 0.501961, "#008080", "teal"),
    (0.205076, 0.255076, 0.500000, 0.443137, 0.501961, 0.501961, "#718080", "sirocco"),
    (0.258843, 0.308843, 0.500000, 0.427451, 0.572549, 0.572549, "#6d9292", "juniper"),
    (0.325852, 0.375852, 0.500000, 0.517647, 0.627451, 0.627451, "#84a0a0", "granny smith"),
    (0.427699, 0.477699, 0.500000, 0.121569, 0.760784, 0.760784, "#1fc2c2", "java"),
    (0.475454, 0.525454, 0.500000, 0.000000, 0.800000, 0.800000, "#00cccc", "robin egg blue"),
    (0.618065, 0.668065, 0.500000, 0.764706, 0.819608, 0.819608, "#c3d1d1", "tiara"),
    (0.787400, 0.837400, 0.500000, 0.000000, 1.000000, 1.000000, "#00ffff", "cyan / aqua"),
    (0.899019, 0.949019, 0.500000, 0.929412, 0.960784, 0.960784, "#edf5f5", "aqua haze"),
    (0.928298, 0.978298, 0.500000, 0.964706, 0.968627, 0.968627, "#f6f7f7", "black haze"),
    (0.941506, 0.991506, 0.500000, 0.949020, 0.980392, 0.980392, "#f2fafa", "black squeeze"),
    (0.945873, 0.995873, 0.500000, 0.878431, 1.000000, 1.000000, "#e0ffff", "baby blue"),
    (0.955630, 1.005630, 0.500000, 0.901961, 1.000000, 1.000000, "#e6ffff", "tranquil"),
    (0.094377, 0.144377, 0.501718, 0.003922, 0.380392, 0.384314, "#016162", "blue stone"),
    (0.161428, 0.211428, 0.501718, 0.109804, 0.486275, 0.490196, "#1c7c7d", "elm"),
    (0.077588, 0.127588, 0.502083, 0.035294, 0.345098, 0.349020, "#095859", "deep sea green"),
    (0.145874, 0.195874, 0.502688, 0.215686, 0.454902, 0.458824, "#377475", "oracle"),
    (0.648935, 0.698935, 0.505051, 0.619608, 0.870588, 0.878431, "#9edee0", "morning glory"),
    (0.038154, 0.088154, 0.505208, 0.000000, 0.243137, 0.250980, "#003e40", "cyprus"),
    (0.008677, 0.058677, 0.505952, 0.000000, 0.105882, 0.109804, "#001b1c", "swamp"),
    (0.114532, 0.164532, 0.506231, 0.011765, 0.415686, 0.431373, "#036a6e", "mosque"),
    (0.028608, 0.078608, 0.506803, 0.023529, 0.207843, 0.215686, "#063537", "tiber"),
    (0.950925, 1.000925, 0.506944, 0.905882, 0.996078, 1.000000, "#e7feff", "bubbles"),
    (0.199831, 0.249831, 0.508838, 0.047059, 0.537255, 0.564706, "#0c8990", "blue chill"),
    (0.127178, 0.177178, 0.509346, 0.039216, 0.435294, 0.458824, "#0a6f75", "atoll"),
    (0.169319, 0.219319, 0.510288, 0.192157, 0.490196, 0.509804, "#317d82", "paradiso"),
    (0.417399, 0.467399, 0.510582, 0.486275, 0.717647, 0.733333, "#7cb7bb", "neptune"),
    (0.586274, 0.636274, 0.513274, 0.443137, 0.850980, 0.886275, "#71d9e2", "aquamarine blue"),
    (0.118829, 0.168829, 0.513333, 0.227451, 0.407843, 0.423529, "#3a686c", "william"),
    (0.053443, 0.103443, 0.514583, 0.000000, 0.286275, 0.313725, "#004950", "sherpa blue"),
    (0.485918, 0.535918, 0.515152, 0.662745, 0.741176, 0.749020, "#a9bdbf", "tower gray"),
    (0.383387, 0.433387, 0.516026, 0.337255, 0.705882, 0.745098, "#56b4be", "fountain blue"),
    (0.154305, 0.204305, 0.517413, 0.003922, 0.474510, 0.529412, "#017987", "blue lagoon"),
    (0.591005, 0.641005, 0.517615, 0.423529, 0.854902, 0.905882, "#6cdae7", "turquoise blue"),
    (0.682546, 0.732546, 0.518519, 0.690196, 0.878431, 0.901961, "#b0e0e6", "powder blue"),
    (0.908041, 0.958041, 0.518519, 0.933333, 0.964706, 0.968627, "#eef6f7", "catskill white"),
    (0.488260, 0.538260, 0.518779, 0.521569, 0.768627, 0.800000, "#85c4cc", "half baked"),
    (0.956477, 1.006477, 0.519608, 0.933333, 0.992157, 1.000000, "#eefdff", "twilight blue"),
    (0.325280, 0.375280, 0.519841, 0.486275, 0.631373, 0.650980, "#7ca1a6", "gumbo"),
    (0.623636, 0.673636, 0.520290, 0.474510, 0.870588, 0.925490, "#79deec", "spray"),
    (0.101532, 0.151532, 0.520468, 0.184314, 0.380392, 0.407843, "#2f6168", "casal"),
    (0.510095, 0.560095, 0.521008, 0.392157, 0.800000, 0.858824, "#64ccdb", "viking"),
    (0.425959, 0.475959, 0.521084, 0.180392, 0.749020, 0.831373, "#2ebfd4", "scooter"),
    (0.147557, 0.197557, 0.521127, 0.211765, 0.454902, 0.490196, "#36747d", "ming"),
    (0.590321, 0.640321, 0.521505, 0.705882, 0.811765, 0.827451, "#b4cfd3", "jungle mist"),
    (0.555030, 0.605030, 0.522222, 0.729412, 0.780392, 0.788235, "#bac7c9", "submarine"),
    (0.904966, 0.954966, 0.522523, 0.854902, 0.980392, 1.000000, "#dafaff", "oyster bay"),
    (0.688391, 0.738391, 0.522523, 0.639216, 0.890196, 0.929412, "#a3e3ed", "blizzard blue"),
    (0.265218, 0.315218, 0.525114, 0.117647, 0.603922, 0.690196, "#1e9ab0", "eastern blue"),
    (0.036917, 0.086917, 0.525641, 0.176471, 0.219608, 0.227451, "#2d383a", "outer space"),
    (0.339115, 0.389115, 0.525840, 0.243137, 0.670588, 0.749020, "#3eabbf", "pelorous"),
    (0.583929, 0.633929, 0.527299, 0.462745, 0.843137, 0.917647, "#76d7ea", "sky blue"),
    (0.784277, 0.834277, 0.529101, 0.729412, 0.933333, 0.976471, "#baeef9", "charlotte"),
    (0.019627, 0.069627, 0.529412, 0.054902, 0.164706, 0.188235, "#0e2a30", "firefly"),
    (0.248723, 0.298723, 0.530220, 0.000000, 0.584314, 0.713725, "#0095b6", "bondi blue"),
    (0.816998, 0.866998, 0.530303, 0.886275, 0.921569, 0.929412, "#e2ebed", "mystic"),
    (0.280995, 0.330995, 0.533163, 0.000000, 0.615686, 0.768627, "#009dc4", "pacific blue"),
    (0.672304, 0.722304, 0.533333, 0.749020, 0.858824, 0.886275, "#bfdbe2", "ziggurat"),
    (0.055510, 0.105510, 0.533333, 0.125490, 0.282353, 0.321569, "#204852", "blue dianne"),
    (0.016792, 0.066792, 0.534722, 0.003922, 0.152941, 0.192157, "#012731", "daintree"),
    (0.884932, 0.934932, 0.535088, 0.850980, 0.968627, 1.000000, "#d9f7ff", "mabel"),
    (0.722634, 0.772634, 0.535714, 0.831373, 0.874510, 0.886275, "#d4dfe2", "geyser"),
    (0.849005, 0.899005, 0.536667, 0.803922, 0.956863, 1.000000, "#cdf4ff", "onahau"),
    (0.312670, 0.362670, 0.537480, 0.007843, 0.643137, 0.827451, "#02a4d3", "cerulean"),
    (0.282811, 0.332811, 0.540230, 0.345098, 0.603922, 0.686275, "#589aaf", "hippie blue"),
    (0.191708, 0.241708, 0.540323, 0.317647, 0.501961, 0.560784, "#51808f", "smalt blue"),
    (0.883260, 0.933260, 0.541667, 0.937255, 0.949020, 0.952941, "#eff2f3", "porcelain"),
    (0.408149, 0.458149, 0.541667, 0.501961, 0.701961, 0.768627, "#80b3c4", "glacier"),
    (0.784790, 0.834790, 0.541667, 0.741176, 0.929412, 0.992157, "#bdedfd", "french pass"),
    (0.169559, 0.219559, 0.543912, 0.000000, 0.482353, 0.654902, "#007ba7", "deep cerulean"),
    (0.704267, 0.754267, 0.544218, 0.615686, 0.898039, 1.000000, "#9de5ff", "anakiwa"),
    (0.623524, 0.673524, 0.544444, 0.666667, 0.839216, 0.901961, "#aad6e6", "regent st blue"),
    (0.695122, 0.745122, 0.544444, 0.780392, 0.866667, 0.898039, "#c7dde5", "botticelli"),
    (0.046435, 0.096435, 0.545098, 0.015686, 0.258824, 0.349020, "#044259", "teal blue"),
    (0.169704, 0.219704, 0.545723, 0.160784, 0.482353, 0.603922, "#297b9a", "jelly bean"),
    (0.156012, 0.206012, 0.546012, 0.000000, 0.462745, 0.639216, "#0076a3", "allports"),
    (0.537154, 0.587154, 0.547170, 0.501961, 0.800000, 0.917647, "#80ccea", "seagull"),
    (0.263822, 0.313822, 0.548077, 0.427451, 0.572549, 0.631373, "#6d92a1", "gothic"),
    (0.244759, 0.294759, 0.548209, 0.231373, 0.568627, 0.705882, "#3b91b4", "boston blue"),
    (0.353490, 0.403490, 0.548346, 0.305882, 0.670588, 0.819608, "#4eabd1", "shakespeare"),
    (0.913437, 0.963437, 0.548611, 0.905882, 0.972549, 1.000000, "#e7f8ff", "lily white"),
    (0.146107, 0.196107, 0.548913, 0.192157, 0.447059, 0.552941, "#31728d", "calypso"),
    (0.570483, 0.620483, 0.549020, 0.741176, 0.788235, 0.807843, "#bdc9ce", "loblolly"),
    (0.097053, 0.147053, 0.549242, 0.003922, 0.368627, 0.521569, "#015e85", "orient"),
    (0.036505, 0.086505, 0.550228, 0.027451, 0.227451, 0.313725, "#073a50", "tarawera"),
    (0.880544, 0.930544, 0.550505, 0.870588, 0.960784, 1.000000, "#def5ff", "pattens blue"),
    (0.148654, 0.198654, 0.551724, 0.286275, 0.443137, 0.513725, "#497183", "bismark"),
    (0.178834, 0.228834, 0.553030, 0.196078, 0.490196, 0.627451, "#327da0", "astral"),
    (0.531113, 0.581113, 0.555555, 0.749020, 0.756863, 0.760784, "#bfc1c2", "silver sand"),
    (0.385357, 0.435357, 0.556237, 0.270588, 0.694118, 0.909804, "#45b1e8", "picton blue"),
    (0.111065, 0.161065, 0.556689, 0.007843, 0.388235, 0.584314, "#026395", "bahama blue"),
    (0.268095, 0.318095, 0.557171, 0.145098, 0.588235, 0.819608, "#2596d1", "curious blue"),
    (0.553293, 0.603293, 0.557471, 0.576471, 0.800000, 0.917647, "#93ccea", "cornflower"),
    (0.085788, 0.135788, 0.557823, 0.094118, 0.345098, 0.478431, "#18587a", "blumine"),
    (0.220397, 0.270397, 0.559524, 0.352941, 0.529412, 0.627451, "#5a87a0", "horizon"),
    (0.030395, 0.080395, 0.559748, 0.070588, 0.203922, 0.278431, "#123447", "elephant"),
    (0.089832, 0.139832, 0.560606, 0.019608, 0.349020, 0.537255, "#055989", "venice blue"),
    (0.190452, 0.240452, 0.561139, 0.000000, 0.494118, 0.780392, "#007ec7", "lochmara"),
    (0.080596, 0.130596, 0.561224, 0.090196, 0.333333, 0.474510, "#175579", "chathams blue"),
    (0.043335, 0.093335, 0.561856, 0.003922, 0.243137, 0.384314, "#013e62", "astronaut blue"),
    (0.060987, 0.110987, 0.562500, 0.223529, 0.282353, 0.317647, "#394851", "limed spruce"),
    (0.328780, 0.378780, 0.563492, 0.521569, 0.623529, 0.686275, "#859faf", "bali hai"),
    (0.703412, 0.753412, 0.564103, 0.721569, 0.878431, 0.976471, "#b8e0f9", "sail"),
    (0.523839, 0.573839, 0.564208, 0.490196, 0.784314, 0.968627, "#7dc8f7", "malibu"),
    (0.192671, 0.242671, 0.564583, 0.305882, 0.498039, 0.619608, "#4e7f9e", "wedgewood"),
    (0.122997, 0.172997, 0.565972, 0.286275, 0.400000, 0.474510, "#496679", "blue bayoux"),
    (0.262450, 0.312450, 0.566667, 0.529412, 0.552941, 0.568627, "#878d91", "oslo gray"),
    (0.200189, 0.250189, 0.566667, 0.454902, 0.490196, 0.513725, "#747d83", "rolling stone"),
    (0.408004, 0.458004, 0.566667, 0.631373, 0.678431, 0.709804, "#a1adb5", "hit gray"),
    (0.676077, 0.726077, 0.566667, 0.831373, 0.843137, 0.850980, "#d4d7d9", "iron"),
    (0.046021, 0.096021, 0.568254, 0.003922, 0.247059, 0.415686, "#013f6a", "regal blue"),
    (0.028212, 0.078212, 0.568273, 0.000000, 0.192157, 0.325490, "#003153", "prussian blue"),
    (0.151455, 0.201455, 0.568627, 0.392157, 0.431373, 0.458824, "#646e75", "nevada"),
    (0.025016, 0.075016, 0.569444, 0.015686, 0.180392, 0.298039, "#042e4c", "blue whale"),
    (0.241997, 0.291997, 0.569697, 0.419608, 0.545098, 0.635294, "#6b8ba2", "bermuda gray"),
    (0.400920, 0.450920, 0.570513, 0.615686, 0.674510, 0.717647, "#9dacb7", "gull gray"),
    (0.906240, 0.956240, 0.571429, 0.917647, 0.964706, 1.000000, "#eaf6ff", "solitude"),
    (0.119747, 0.169747, 0.571795, 0.105882, 0.396078, 0.615686, "#1b659d", "matisse"),
    (0.223201, 0.273201, 0.571839, 0.396078, 0.525490, 0.623529, "#65869f", "hoki"),
    (0.387269, 0.437269, 0.571895, 0.556863, 0.670588, 0.756863, "#8eabc1", "nepal"),
    (0.287513, 0.337513, 0.573333, 0.525490, 0.580392, 0.623529, "#86949f", "regent gray"),
    (0.205626, 0.255626, 0.575758, 0.274510, 0.509804, 0.705882, "#4682b4", "steel blue"),
    (0.035331, 0.085331, 0.577381, 0.098039, 0.215686, 0.317647, "#193751", "nile blue"),
    (0.928801, 0.978801, 0.577778, 0.941176, 0.972549, 1.000000, "#f0f8ff", "alice blue"),
    (0.614865, 0.664865, 0.580128, 0.713725, 0.819608, 0.917647, "#b6d1ea", "spindle"),
    (0.094456, 0.144456, 0.580838, 0.000000, 0.337255, 0.654902, "#0056a7", "endeavour"),
    (0.274425, 0.324425, 0.582222, 0.117647, 0.564706, 1.000000, "#1e90ff", "dodger blue"),
    (0.023563, 0.073563, 0.582278, 0.011765, 0.168627, 0.321569, "#032b52", "green vogue"),
    (0.006070, 0.056070, 0.583333, 0.015686, 0.074510, 0.133333, "#041322", "black pearl"),
    (0.033270, 0.083270, 0.583333, 0.000000, 0.200000, 0.400000, "#003366", "midnight blue"),
    (0.138624, 0.188624, 0.583333, 0.000000, 0.400000, 0.800000, "#0066cc", "science blue"),
    (0.911361, 0.961361, 0.583333, 0.929412, 0.964706, 1.000000, "#edf6ff", "zumthor"),
    (0.208967, 0.258967, 0.583333, 0.439216, 0.501961, 0.564706, "#708090", "slate gray"),
    (0.223987, 0.273987, 0.583660, 0.000000, 0.498039, 1.000000, "#007fff", "azure radiance"),
    (0.064724, 0.114724, 0.584524, 0.007843, 0.278431, 0.556863, "#02478e", "congress blue"),
    (0.701546, 0.751546, 0.586420, 0.764706, 0.866667, 0.976471, "#c3ddf9", "tropical blue"),
    (0.003689, 0.053689, 0.586667, 0.003922, 0.050980, 0.101961, "#010d1a", "blue charcoal"),
    (0.536516, 0.586516, 0.586667, 0.717647, 0.764706, 0.815686, "#b7c3d0", "heather"),
    (0.021967, 0.071967, 0.587302, 0.086275, 0.164706, 0.250980, "#162a40", "big stone"),
    (0.055085, 0.105085, 0.587500, 0.192157, 0.266667, 0.349020, "#314459", "pickled bluewood"),
    (0.503146, 0.553146, 0.587963, 0.678431, 0.745098, 0.819608, "#adbed1", "casper"),
    (0.396855, 0.446855, 0.588235, 0.635294, 0.666667, 0.701961, "#a2aab3", "gray chateau"),
    (0.067011, 0.117011, 0.589080, 0.188235, 0.294118, 0.415686, "#304b6a", "san juan"),
    (0.154958, 0.204958, 0.590476, 0.313725, 0.439216, 0.588235, "#507096", "kashmir blue"),
    (0.464521, 0.514521, 0.590615, 0.541176, 0.725490, 0.945098, "#8ab9f1", "jordy blue"),
    (0.279577, 0.329577, 0.591445, 0.376471, 0.576471, 0.819608, "#6093d1", "danube"),
    (0.057529, 0.107529, 0.591954, 0.219608, 0.270588, 0.333333, "#384555", "oxford blue"),
    (0.101786, 0.151786, 0.592075, 0.098039, 0.349020, 0.658824, "#1959a8", "fun blue"),
    (0.268876, 0.318876, 0.592172, 0.333333, 0.564706, 0.850980, "#5590d9", "havelock blue"),
    (0.121993, 0.171993, 0.592262, 0.082353, 0.376471, 0.741176, "#1560bd", "denim"),
    (0.181473, 0.231473, 0.595238, 0.431373, 0.466667, 0.513725, "#6e7783", "pale sky"),
    (0.202581, 0.252581, 0.595238, 0.411765, 0.494118, 0.603922, "#697e9a", "lynch"),
    (0.380276, 0.430276, 0.595238, 0.552941, 0.658824, 0.800000, "#8da8cc", "polo blue"),
    (0.038597, 0.088597, 0.595628, 0.117647, 0.219608, 0.356863, "#1e385b", "cello"),
    (0.074468, 0.124468, 0.597466, 0.000000, 0.278431, 0.670588, "#0047ab", "cobalt"),
    (0.079948, 0.129948, 0.597561, 0.250980, 0.317647, 0.411765, "#405169", "fiord"),
    (0.070834, 0.120834, 0.598485, 0.262745, 0.298039, 0.349020, "#434c59", "river bed"),
    (0.431212, 0.481212, 0.599291, 0.619608, 0.694118, 0.803922, "#9eb1cd", "rock blue"),
    (0.008373, 0.058373, 0.599359, 0.003922, 0.086275, 0.207843, "#011635", "midnight"),
    (0.005483, 0.055483, 0.600000, 0.050980, 0.066667, 0.090196, "#0d1117", "bunker"),
    (0.869684, 0.919684, 0.600000, 0.933333, 0.941176, 0.952941, "#eef0f3", "athens gray"),
    (0.087883, 0.137883, 0.600000, 0.078431, 0.313725, 0.666667, "#1450aa", "tory blue"),
    (0.167227, 0.217227, 0.600000, 0.000000, 0.400000, 1.000000, "#0066ff", "blue ribbon"),
    (0.151670, 0.201670, 0.600000, 0.156863, 0.415686, 0.803922, "#286acd", "mariner"),
    (0.768311, 0.818311, 0.601190, 0.850980, 0.894118, 0.960784, "#d9e4f5", "link water"),
    (0.195495, 0.245495, 0.601449, 0.447059, 0.482353, 0.537255, "#727b89", "raven"),
    (0.149689, 0.199689, 0.603560, 0.270588, 0.423529, 0.674510, "#456cac", "san marino"),
    (0.107083, 0.157083, 0.604167, 0.192157, 0.356863, 0.631373, "#315ba1", "azure"),
    (0.095800, 0.145800, 0.604545, 0.176471, 0.337255, 0.607843, "#2d569b", "st tropaz"),
    (0.131505, 0.181505, 0.605263, 0.372549, 0.400000, 0.447059, "#5f6672", "shuttle gray"),
    (0.935879, 0.985879, 0.606061, 0.956863, 0.972549, 1.000000, "#f4f8ff", "zircon"),
    (0.303186, 0.353186, 0.607056, 0.392157, 0.584314, 0.929412, "#6495ed", "cornflower blue"),
    (0.754180, 0.804180, 0.608333, 0.831373, 0.886275, 0.988235, "#d4e2fc", "hawkes blue"),
    (0.442159, 0.492159, 0.608974, 0.662745, 0.698039, 0.764706, "#a9b2c3", "cadet blue"),
    (0.004005, 0.054005, 0.611111, 0.047059, 0.050980, 0.058824, "#0c0d0f", "woodsmoke"),
    (0.021715, 0.071715, 0.611111, 0.035294, 0.145098, 0.364706, "#09255d", "madison"),
    (0.046676, 0.096676, 0.611111, 0.000000, 0.200000, 0.600000, "#003399", "smalt"),
    (0.505189, 0.555189, 0.611111, 0.686275, 0.741176, 0.850980, "#afbdd9", "pigeon post"),
    (0.009194, 0.059194, 0.611111, 0.011765, 0.086275, 0.235294, "#03163c", "tangaroa"),
    (0.020605, 0.070605, 0.612069, 0.074510, 0.149020, 0.301961, "#13264d", "blue zodiac"),
    (0.050177, 0.100177, 0.612179, 0.180392, 0.247059, 0.384314, "#2e3f62", "rhino"),
    (0.018740, 0.068740, 0.612554, 0.035294, 0.133333, 0.337255, "#092256", "downriver"),
    (0.030507, 0.080507, 0.614035, 0.023529, 0.164706, 0.470588, "#062a78", "catalina blue"),
    (0.066341, 0.116341, 0.614583, 0.266667, 0.286275, 0.329412, "#444954", "mako"),
    (0.033115, 0.083115, 0.615023, 0.105882, 0.192157, 0.384314, "#1b3162", "biscay"),
    (0.089578, 0.139578, 0.615616, 0.184314, 0.317647, 0.619608, "#2f519e", "sapphire"),
    (0.023540, 0.073540, 0.615789, 0.031373, 0.145098, 0.403922, "#082567", "deep sapphire"),
    (0.157258, 0.207258, 0.616162, 0.352941, 0.431373, 0.611765, "#5a6e9c", "waikawa gray"),
    (0.078003, 0.128003, 0.616667, 0.298039, 0.309804, 0.337255, "#4c4f56", "abbey"),
    (0.260035, 0.310035, 0.618687, 0.470588, 0.545098, 0.729412, "#788bba", "ship cove"),
    (0.516727, 0.566727, 0.618721, 0.662745, 0.745098, 0.949020, "#a9bef2", "perano"),
    (0.080991, 0.130991, 0.618774, 0.207843, 0.305882, 0.549020, "#354e8c", "chambray"),
    (0.020262, 0.070262, 0.619048, 0.145098, 0.152941, 0.172549, "#25272c", "shark"),
    (0.609779, 0.659779, 0.619048, 0.764706, 0.803922, 0.901961, "#c3cde6", "periwinkle gray"),
    (0.048231, 0.098231, 0.619760, 0.000000, 0.184314, 0.654902, "#002fa7", "international klein blue"),
    (0.102445, 0.152445, 0.621622, 0.164706, 0.321569, 0.745098, "#2a52be", "cerulean blue"),
    (0.029012, 0.079012, 0.621795, 0.125490, 0.180392, 0.329412, "#202e54", "cloud burst"),
    (0.029513, 0.079513, 0.623457, 0.000000, 0.137255, 0.529412, "#002387", "resolution blue"),
    (0.166632, 0.216632, 0.625000, 0.254902, 0.411765, 0.882353, "#4169e1", "royal blue"),
    (0.076428, 0.126428, 0.625000, 0.290196, 0.305882, 0.352941, "#4a4e5a", "trout"),
    (0.254896, 0.304896, 0.626344, 0.478431, 0.537255, 0.721569, "#7a89b8", "wild blue yonder"),
    (0.053353, 0.103353, 0.626984, 0.235294, 0.254902, 0.317647, "#3c4151", "bright gray"),
    (0.413175, 0.463175, 0.628205, 0.662745, 0.674510, 0.713725, "#a9acb6", "aluminium"),
    (0.048091, 0.098091, 0.628692, 0.156863, 0.227451, 0.466667, "#283a77", "astronaut"),
    (0.440189, 0.490189, 0.629630, 0.686275, 0.694118, 0.721569, "#afb1b8", "bombay"),
    (0.158426, 0.208426, 0.630252, 0.309804, 0.411765, 0.776471, "#4f69c6", "indigo"),
    (0.050424, 0.100424, 0.631481, 0.152941, 0.227451, 0.505882, "#273a81", "bay of many"),
    (0.044470, 0.094470, 0.631702, 0.058824, 0.176471, 0.619608, "#0f2d9e", "torea bay"),
    (0.012942, 0.062942, 0.632114, 0.019608, 0.086275, 0.341176, "#051657", "gulf blue"),
    (0.364583, 0.414583, 0.632997, 0.545098, 0.623529, 0.933333, "#8b9fee", "portage"),
    (0.007730, 0.057730, 0.635593, 0.019608, 0.062745, 0.250980, "#051040", "deep cove"),
    (0.077734, 0.127734, 0.636111, 0.254902, 0.298039, 0.490196, "#414c7d", "east bay"),
    (0.067610, 0.117610, 0.636268, 0.109804, 0.223529, 0.733333, "#1c39bb", "persian blue"),
    (0.016612, 0.066612, 0.636364, 0.082353, 0.121569, 0.298039, "#151f4c", "bunting"),
    (0.010190, 0.060190, 0.638889, 0.086275, 0.098039, 0.156863, "#161928", "mirage"),
    (0.006315, 0.056315, 0.641026, 0.062745, 0.070588, 0.113725, "#10121d", "vulcan"),
    (0.281824, 0.331824, 0.641667, 0.552941, 0.564706, 0.631373, "#8d90a1", "manatee"),
    (0.177227, 0.227227, 0.642857, 0.443137, 0.454902, 0.525490, "#717486", "storm gray"),
    (0.587195, 0.637195, 0.642857, 0.780392, 0.788235, 0.835294, "#c7c9d5", "ghost"),
    (0.005336, 0.055336, 0.648718, 0.000000, 0.027451, 0.254902, "#000741", "stratos"),
    (0.070907, 0.120907, 0.650253, 0.184314, 0.235294, 0.701961, "#2f3cb3", "governor bay"),
    (0.022454, 0.072454, 0.650794, 0.149020, 0.156863, 0.231373, "#26283b", "ebony clay"),
    (0.648690, 0.698690, 0.652778, 0.819608, 0.823529, 0.866667, "#d1d2dd", "mischka"),
    (0.410908, 0.460908, 0.653846, 0.666667, 0.670588, 0.717647, "#aaabb7", "spun pearl"),
    (0.356869, 0.406869, 0.657407, 0.623529, 0.627451, 0.694118, "#9fa0b1", "santas gray"),
    (0.057084, 0.107084, 0.659091, 0.254902, 0.258824, 0.341176, "#414257", "gun powder"),
    (0.398681, 0.448681, 0.659574, 0.643137, 0.650980, 0.827451, "#a4a6d3", "wistful"),
    (0.113884, 0.163884, 0.660000, 0.360784, 0.364706, 0.458824, "#5c5d75", "comet"),
    (0.207644, 0.257644, 0.660000, 0.482353, 0.486275, 0.580392, "#7b7c94", "waterloo "),
    (0.004734, 0.054734, 0.666667, 0.054902, 0.054902, 0.094118, "#0e0e18", "cinder"),
    (0.015585, 0.065585, 0.666667, 0.000000, 0.000000, 0.501961, "#000080", "navy blue"),
    (0.019579, 0.069579, 0.666667, 0.101961, 0.101961, 0.407843, "#1a1a68", "lucky point"),
    (0.023331, 0.073331, 0.666667, 0.160784, 0.160784, 0.215686, "#292937", "charade"),
    (0.032632, 0.082632, 0.666667, 0.125490, 0.125490, 0.552941, "#20208d", "jacksons purple"),
    (0.036964, 0.086964, 0.666667, 0.207843, 0.207843, 0.258824, "#353542", "tuna"),
    (0.041701, 0.091701, 0.666667, 0.000000, 0.000000, 0.784314, "#0000c8", "dark blue"),
    (0.072200, 0.122200, 0.666667, 0.000000, 0.000000, 1.000000, "#0000ff", "blue"),
    (0.117431, 0.167431, 0.666667, 0.372549, 0.372549, 0.431373, "#5f5f6e", "mid gray"),
    (0.339144, 0.389144, 0.666667, 0.600000, 0.600000, 0.800000, "#9999cc", "blue bell"),
    (0.512912, 0.562912, 0.666667, 0.741176, 0.741176, 0.776471, "#bdbdc6", "french gray"),
    (0.632431, 0.682431, 0.666667, 0.800000, 0.800000, 1.000000, "#ccccff", "periwinkle"),
    (0.413298, 0.463298, 0.671296, 0.666667, 0.662745, 0.803922, "#aaa9cd", "logan"),
    (0.528611, 0.578611, 0.673077, 0.749020, 0.745098, 0.847059, "#bfbed8", "blue haze"),
    (0.256968, 0.306968, 0.674242, 0.521569, 0.505882, 0.850980, "#8581d9", "chetwode blue"),
    (0.014648, 0.064648, 0.675347, 0.066667, 0.047059, 0.423529, "#110c6c", "arapawa"),
    (0.004062, 0.054062, 0.675926, 0.047059, 0.043137, 0.113725, "#0c0b1d", "ebony"),
    (0.023289, 0.073289, 0.676692, 0.070588, 0.039216, 0.560784, "#120a8f", "ultramarine"),
    (0.512658, 0.562658, 0.678571, 0.741176, 0.733333, 0.843137, "#bdbbd7", "lavender gray"),
    (0.020957, 0.070957, 0.680952, 0.105882, 0.070588, 0.482353, "#1b127b", "deep koamaru"),
    (0.575020, 0.625020, 0.682796, 0.780392, 0.756863, 1.000000, "#c7c1ff", "melrose"),
    (0.221720, 0.271720, 0.682796, 0.498039, 0.462745, 0.827451, "#7f76d3", "moody blue"),
    (0.138212, 0.188212, 0.685446, 0.403922, 0.372549, 0.650980, "#675fa6", "scampi"),
    (0.868943, 0.918943, 0.686275, 0.941176, 0.933333, 1.000000, "#f0eeff", "titan white"),
    (0.019378, 0.069378, 0.687500, 0.145098, 0.121569, 0.309804, "#251f4f", "port gore"),
    (0.867662, 0.917662, 0.688889, 0.941176, 0.933333, 0.992157, "#f0eefd", "selago"),
    (0.168732, 0.218732, 0.689542, 0.450980, 0.423529, 0.623529, "#736c9f", "kimberly"),
    (0.200627, 0.250627, 0.690476, 0.486275, 0.482353, 0.509804, "#7c7b82", "jumbo"),
    (0.127838, 0.177838, 0.690722, 0.392157, 0.337255, 0.717647, "#6456b7", "blue violet"),
    (0.667788, 0.717788, 0.691489, 0.843137, 0.815686, 1.000000, "#d7d0ff", "fog"),
    (0.174315, 0.224315, 0.694444, 0.462745, 0.400000, 0.776471, "#7666c6", "blue marguerite"),
    (0.018712, 0.068712, 0.694444, 0.149020, 0.137255, 0.207843, "#262335", "steel gray"),
    (0.124070, 0.174070, 0.695652, 0.392157, 0.376471, 0.466667, "#646077", "dolphin"),
    (0.034774, 0.084774, 0.697917, 0.211765, 0.188235, 0.313725, "#363050", "martinique"),
    (0.047030, 0.097030, 0.698312, 0.247059, 0.188235, 0.498039, "#3f307f", "minsk"),
    (0.388093, 0.438093, 0.698830, 0.670588, 0.627451, 0.850980, "#aba0d9", "cold purple"),
    (0.080176, 0.130176, 0.699134, 0.325490, 0.266667, 0.568627, "#534491", "victoria"),
    (0.368205, 0.418205, 0.699134, 0.658824, 0.600000, 0.901961, "#a899e6", "dull lavender"),
    (0.650926, 0.700926, 0.700000, 0.839216, 0.807843, 0.964706, "#d6cef6", "moon raker"),
    (0.525721, 0.575721, 0.700000, 0.756863, 0.745098, 0.803922, "#c1becd", "gray suit"),
    (0.935063, 0.985063, 0.700000, 0.972549, 0.968627, 0.988235, "#f8f7fc", "white lilac"),
    (0.112068, 0.162068, 0.701389, 0.376471, 0.356863, 0.450980, "#605b73", "smoky"),
    (0.003810, 0.053810, 0.702128, 0.050980, 0.011765, 0.196078, "#0d0332", "black rock"),
    (0.094535, 0.144535, 0.705128, 0.345098, 0.333333, 0.384314, "#585562", "scarpa flow"),
    (0.018698, 0.068698, 0.705357, 0.133333, 0.031373, 0.470588, "#220878", "deep blue"),
    (0.225198, 0.275198, 0.705387, 0.541176, 0.450980, 0.839216, "#8a73d6", "true v"),
    (0.408952, 0.458952, 0.705479, 0.698039, 0.631373, 0.917647, "#b2a1ea", "biloba flower"),
    (0.027430, 0.077430, 0.706349, 0.172549, 0.054902, 0.549020, "#2c0e8c", "blue gem"),
    (0.071637, 0.121637, 0.708333, 0.321569, 0.235294, 0.580392, "#523c94", "gigas"),
    (0.035961, 0.085961, 0.708333, 0.227451, 0.164706, 0.415686, "#3a2a6a", "jacarta"),
    (0.155327, 0.205327, 0.710145, 0.458824, 0.388235, 0.658824, "#7563a8", "deluge"),
    (0.193137, 0.243137, 0.710526, 0.486275, 0.466667, 0.541176, "#7c778a", "topaz"),
    (0.103785, 0.153785, 0.710526, 0.384314, 0.305882, 0.603922, "#624e9a", "butterfly bush"),
    (0.008606, 0.058606, 0.716216, 0.105882, 0.062745, 0.207843, "#1b1035", "haiti"),
    (0.025159, 0.075159, 0.717949, 0.196078, 0.070588, 0.478431, "#32127a", "persian indigo"),
    (0.067578, 0.117578, 0.718391, 0.305882, 0.270588, 0.384314, "#4e4562", "mulled wine"),
    (0.570141, 0.620141, 0.718391, 0.815686, 0.745098, 0.972549, "#d0bef8", "perfume"),
    (0.149673, 0.199673, 0.720635, 0.478431, 0.345098, 0.756863, "#7a58c1", "fuchsia blue"),
    (0.015612, 0.065612, 0.721122, 0.149020, 0.019608, 0.415686, "#26056a", "paris m"),
    (0.229059, 0.279059, 0.721184, 0.576471, 0.439216, 0.858824, "#9370db", "medium purple"),
    (0.017734, 0.067734, 0.722222, 0.168627, 0.098039, 0.309804, "#2b194f", "valhalla"),
    (0.032486, 0.082486, 0.722222, 0.235294, 0.121569, 0.462745, "#3c1f76", "meteorite"),
    (0.014767, 0.064767, 0.724422, 0.149020, 0.011765, 0.407843, "#260368", "paua"),
    (0.015425, 0.065425, 0.725610, 0.160784, 0.047059, 0.368627, "#290c5e", "violent violet"),
    (0.001484, 0.051484, 0.726190, 0.039216, 0.000000, 0.109804, "#0a001c", "black russian"),
    (0.918778, 0.968778, 0.727273, 0.972549, 0.956863, 1.000000, "#f8f4ff", "magnolia"),
    (0.841986, 0.891986, 0.727273, 0.945098, 0.913725, 1.000000, "#f1e9ff", "blue chalk"),
    (0.007061, 0.057061, 0.728856, 0.105882, 0.007843, 0.270588, "#1b0245", "tolopea"),
    (0.116226, 0.166226, 0.729167, 0.443137, 0.290196, 0.698039, "#714ab2", "studio"),
    (0.051313, 0.101313, 0.729345, 0.309804, 0.137255, 0.596078, "#4f2398", "daisy bush"),
    (0.084937, 0.134937, 0.729730, 0.396078, 0.176471, 0.756863, "#652dc1", "purple heart"),
    (0.238693, 0.288693, 0.729825, 0.596078, 0.454902, 0.827451, "#9874d3", "lilac bush"),
    (0.044676, 0.094676, 0.733333, 0.243137, 0.227451, 0.266667, "#3e3a44", "ship gray"),
    (0.020919, 0.070919, 0.733333, 0.164706, 0.149020, 0.188235, "#2a2630", "baltic sea"),
    (0.919811, 0.969811, 0.733333, 0.968627, 0.960784, 0.980392, "#f7f5fa", "whisper"),
    (0.332150, 0.382150, 0.735632, 0.639216, 0.592157, 0.705882, "#a397b4", "amethyst smoke"),
    (0.567663, 0.617663, 0.738739, 0.815686, 0.752941, 0.898039, "#d0c0e5", "prelude"),
    (0.334777, 0.384777, 0.740437, 0.674510, 0.568627, 0.807843, "#ac91ce", "east side"),
    (0.012786, 0.062786, 0.742248, 0.164706, 0.011765, 0.349020, "#2a0359", "cherry pie"),
    (0.092189, 0.142189, 0.742268, 0.419608, 0.247059, 0.627451, "#6b3fa0", "royal purple"),
    (0.240273, 0.290273, 0.742938, 0.588235, 0.482353, 0.713725, "#967bb6", "lavender purple"),
    (0.018305, 0.068305, 0.743590, 0.200000, 0.011765, 0.419608, "#33036b", "christalle"),
    (0.021885, 0.071885, 0.744048, 0.219608, 0.015686, 0.454902, "#380474", "blue diamond"),
    (0.024904, 0.074904, 0.744048, 0.235294, 0.031373, 0.470588, "#3c0878", "windsor"),
    (0.001107, 0.051107, 0.744444, 0.031373, 0.003922, 0.062745, "#080110", "jaguar"),
    (0.026695, 0.076695, 0.744624, 0.243137, 0.015686, 0.501961, "#3e0480", "kingfisher daisy"),
    (0.713949, 0.763949, 0.746032, 0.886275, 0.847059, 0.929412, "#e2d8ed", "snuff"),
    (0.009623, 0.059623, 0.746914, 0.141176, 0.039216, 0.250980, "#240a40", "violet"),
    (0.232944, 0.282944, 0.747312, 0.588235, 0.470588, 0.713725, "#9678b6", "purple mountain majesty"),
    (0.159742, 0.209742, 0.750000, 0.474510, 0.411765, 0.537255, "#796989", "rum"),
    (0.206347, 0.256347, 0.750000, 0.600000, 0.400000, 0.800000, "#9966cc", "amethyst"),
    (0.471825, 0.521825, 0.750000, 0.741176, 0.701961, 0.780392, "#bdb3c7", "chatelle"),
    (0.190407, 0.240407, 0.750000, 0.498039, 0.458824, 0.537255, "#7f7589", "mobster"),
    (0.025695, 0.075695, 0.754902, 0.196078, 0.160784, 0.227451, "#32293a", "blackcurrant"),
    (0.017725, 0.067725, 0.755556, 0.160784, 0.129412, 0.188235, "#292130", "bastille"),
    (0.017591, 0.067591, 0.755708, 0.207843, 0.054902, 0.341176, "#350e57", "jagger"),
    (0.127090, 0.177090, 0.757516, 0.545098, 0.000000, 1.000000, "#8b00ff", "electric violet"),
    (0.021736, 0.071736, 0.757576, 0.219608, 0.101961, 0.317647, "#381a51", "grape"),
    (0.099976, 0.149976, 0.759740, 0.443137, 0.274510, 0.576471, "#714693", "affair"),
    (0.217258, 0.267258, 0.759804, 0.592157, 0.443137, 0.709804, "#9771b5", "wisteria"),
    (0.031076, 0.081076, 0.762821, 0.294118, 0.000000, 0.509804, "#4b0082", "pigment indigo"),
    (0.299128, 0.349128, 0.764184, 0.709804, 0.494118, 0.862745, "#b57edc", "lavender"),
    (0.036626, 0.086626, 0.767857, 0.309804, 0.109804, 0.439216, "#4f1c70", "honey flower"),
    (0.541180, 0.591180, 0.767932, 0.878431, 0.690196, 1.000000, "#e0b0ff", "mauve"),
    (0.018622, 0.068622, 0.768519, 0.172549, 0.129412, 0.200000, "#2c2133", "bleached cedar"),
    (0.025742, 0.075742, 0.768889, 0.262745, 0.082353, 0.376471, "#431560", "scarlet gum"),
    (0.120743, 0.170743, 0.770833, 0.407843, 0.368627, 0.431373, "#685e6e", "salt box"),
    (0.051247, 0.101247, 0.777778, 0.400000, 0.000000, 0.600000, "#660099", "purple"),
    (0.294590, 0.344590, 0.777778, 0.584314, 0.576471, 0.588235, "#959396", "mountain mist"),
    (0.427264, 0.477264, 0.780556, 0.788235, 0.627451, 0.862745, "#c9a0dc", "light wisteria"),
    (0.069138, 0.119138, 0.788618, 0.423529, 0.188235, 0.509804, "#6c3082", "eminence"),
    (0.040138, 0.090138, 0.791667, 0.305882, 0.164706, 0.352941, "#4e2a5a", "bossanova"),
    (0.014643, 0.064643, 0.791667, 0.207843, 0.054902, 0.258824, "#350e42", "valentino"),
    (0.065566, 0.115566, 0.792035, 0.450980, 0.117647, 0.560784, "#731e8f", "seance"),
    (0.017957, 0.067957, 0.792636, 0.254902, 0.000000, 0.337255, "#410056", "ripe plum"),
    (0.351694, 0.401694, 0.795238, 0.874510, 0.450980, 1.000000, "#df73ff", "heliotrope"),
    (0.013396, 0.063396, 0.797619, 0.172549, 0.086275, 0.196078, "#2c1632", "revolver"),
    (0.168597, 0.218597, 0.802721, 0.549020, 0.392157, 0.584314, "#8c6495", "trendy pink"),
    (0.093352, 0.143352, 0.803371, 0.501961, 0.215686, 0.564706, "#803790", "vivid violet"),
    (0.021799, 0.071799, 0.804167, 0.282353, 0.023529, 0.337255, "#480656", "clairvoyant"),
    (0.421597, 0.471597, 0.804598, 0.745098, 0.650980, 0.764706, "#bea6c3", "london hue"),
    (0.954256, 1.004256, 0.809524, 0.996078, 0.972549, 1.000000, "#fef8ff", "white pointer"),
    (0.060981, 0.110981, 0.809524, 0.290196, 0.266667, 0.294118, "#4a444b", "gravel"),
    (0.234649, 0.284649, 0.811111, 0.556863, 0.505882, 0.564706, "#8e8190", "mamba"),
    (0.063139, 0.113139, 0.821429, 0.313725, 0.262745, 0.317647, "#504351", "mortar"),
    (0.049509, 0.099509, 0.823232, 0.325490, 0.203922, 0.333333, "#533455", "voodoo"),
    (0.648528, 0.698528, 0.824786, 0.925490, 0.780392, 0.933333, "#ecc7ee", "french lilac"),
    (0.010232, 0.060232, 0.830247, 0.207843, 0.000000, 0.211765, "#350036", "mardi gras"),
    (0.094731, 0.144731, 0.833333, 0.600000, 0.066667, 0.600000, "#991199", "violet eggplant"),
    (0.215284, 0.265284, 0.833333, 0.756863, 0.329412, 0.756863, "#c154c1", "fuchsia pink"),
    (0.284800, 0.334800, 0.833333, 1.000000, 0.000000, 1.000000, "#ff00ff", "magenta / fuchsia"),
    (0.379827, 0.429827, 0.833333, 1.000000, 0.400000, 1.000000, "#ff66ff", "pink flamingo"),
    (0.398489, 0.448489, 0.833333, 1.000000, 0.435294, 1.000000, "#ff6fff", "blush pink"),
    (0.403155, 0.453155, 0.833333, 0.933333, 0.509804, 0.933333, "#ee82ee", "lavender magenta"),
    (0.422902, 0.472902, 0.833333, 0.784314, 0.635294, 0.784314, "#c8a2c8", "lilac"),
    (0.568184, 0.618184, 0.833333, 0.847059, 0.749020, 0.847059, "#d8bfd8", "thistle"),
    (0.313488, 0.363488, 0.839623, 0.854902, 0.439216, 0.839216, "#da70d6", "orchid"),
    (0.153216, 0.203216, 0.843137, 0.474510, 0.407843, 0.470588, "#796878", "old lavender"),
    (0.157291, 0.207291, 0.844444, 0.474510, 0.415686, 0.470588, "#796a78", "fedora"),
    (0.019231, 0.069231, 0.847458, 0.274510, 0.043137, 0.254902, "#460b41", "loulou"),
    (0.008061, 0.058061, 0.852713, 0.180392, 0.011765, 0.160784, "#2e0329", "jacaranda"),
    (0.084826, 0.134826, 0.855422, 0.517647, 0.192157, 0.474510, "#843179", "plum"),
    (0.579866, 0.629866, 0.856061, 0.847059, 0.760784, 0.835294, "#d8c2d5", "maverick"),
    (0.234420, 0.284420, 0.857143, 0.541176, 0.513725, 0.537255, "#8a8389", "monsoon"),
    (0.248997, 0.298997, 0.858974, 0.572549, 0.521569, 0.564706, "#928590", "venus"),
    (0.008970, 0.058970, 0.860465, 0.188235, 0.019608, 0.160784, "#300529", "melanzane"),
    (0.256196, 0.306196, 0.866667, 1.000000, 0.000000, 0.800000, "#ff00cc", "purple pizzazz"),
    (0.383209, 0.433209, 0.866667, 0.666667, 0.647059, 0.662745, "#aaa5a9", "shady lady"),
    (0.232161, 0.282161, 0.866667, 0.533333, 0.513725, 0.529412, "#888387", "suva gray"),
    (0.445988, 0.495988, 0.871429, 0.886275, 0.611765, 0.823529, "#e29cd2", "light orchid"),
    (0.654281, 0.704281, 0.875000, 0.874510, 0.811765, 0.858824, "#dfcfdb", "lola"),
    (0.279873, 0.329873, 0.875000, 1.000000, 0.200000, 0.800000, "#ff33cc", "razzle dazzle rose"),
    (0.248429, 0.298429, 0.875527, 0.988235, 0.058824, 0.752941, "#fc0fc0", "shocking pink"),
    (0.511969, 0.561969, 0.877289, 0.984314, 0.627451, 0.890196, "#fba0e3", "lavender rose"),
    (0.170625, 0.220625, 0.880000, 0.584314, 0.388235, 0.529412, "#956387", "strikemaster"),
    (0.789741, 0.839741, 0.880952, 0.941176, 0.886275, 0.925490, "#f0e2ec", "prim"),
    (0.663936, 0.713936, 0.880952, 0.894118, 0.811765, 0.870588, "#e4cfde", "twilight"),
    (0.447904, 0.497904, 0.883333, 0.784314, 0.666667, 0.749020, "#c8aabf", "lily"),
    (0.018565, 0.068565, 0.885965, 0.301961, 0.003922, 0.207843, "#4d0135", "blackberry"),
    (0.795046, 0.845046, 0.887255, 1.000000, 0.866667, 0.956863, "#ffddf4", "pink lace"),
    (0.032545, 0.082545, 0.887255, 0.400000, 0.000000, 0.270588, "#660045", "pompadour"),
    (0.087855, 0.137855, 0.887860, 0.635294, 0.000000, 0.427451, "#a2006d", "flirt"),
    (0.077316, 0.127316, 0.888889, 0.600000, 0.000000, 0.400000, "#990066", "fresh eggplant"),
    (0.218063, 0.268063, 0.890027, 0.956863, 0.000000, 0.631373, "#f400a1", "hollywood cerise"),
    (0.064921, 0.114921, 0.890123, 0.549020, 0.019608, 0.368627, "#8c055e", "cardinal pink"),
    (0.014401, 0.064401, 0.890547, 0.266667, 0.003922, 0.176471, "#44012d", "barossa"),
    (0.269056, 0.319056, 0.891304, 0.682353, 0.501961, 0.619608, "#ae809e", "bouquet"),
    (0.055201, 0.105201, 0.891667, 0.411765, 0.176471, 0.329412, "#692d54", "finn"),
    (0.143719, 0.193719, 0.895131, 0.780392, 0.082353, 0.521569, "#c71585", "red violet"),
    (0.226145, 0.276145, 0.897849, 0.600000, 0.478431, 0.552941, "#997a8d", "mountbatten pink"),
    (0.146259, 0.196259, 0.899510, 0.733333, 0.200000, 0.521569, "#bb3385", "medium red violet"),
    (0.024949, 0.074949, 0.900000, 0.200000, 0.160784, 0.184314, "#33292f", "thunder"),
    (0.854564, 0.904564, 0.900000, 0.976471, 0.917647, 0.952941, "#f9eaf3", "amour"),
    (0.075681, 0.125681, 0.901639, 0.462745, 0.223529, 0.364706, "#76395d", "cosmic"),
    (0.031944, 0.081944, 0.903333, 0.400000, 0.007843, 0.235294, "#66023c", "tyrian purple"),
    (0.405323, 0.455323, 0.904167, 0.886275, 0.572549, 0.752941, "#e292c0", "shocking"),
    (0.694645, 0.744645, 0.904255, 0.984314, 0.800000, 0.905882, "#fbcce7", "classic rose"),
    (0.910101, 0.960101, 0.904762, 1.000000, 0.945098, 0.976471, "#fff1f9", "tutu"),
    (0.251970, 0.301970, 0.904984, 0.996078, 0.156863, 0.635294, "#fe28a2", "persian rose"),
    (0.815212, 0.865212, 0.905556, 1.000000, 0.882353, 0.949020, "#ffe1f2", "pale rose"),
    (0.096673, 0.146673, 0.905622, 0.670588, 0.019608, 0.388235, "#ab0563", "lipstick"),
    (0.026502, 0.076502, 0.906130, 0.360784, 0.019608, 0.211765, "#5c0536", "mulberry wood"),
    (0.598816, 0.648816, 0.906863, 0.894118, 0.760784, 0.835294, "#e4c2d5", "melanie"),
    (0.010038, 0.060038, 0.908046, 0.227451, 0.000000, 0.125490, "#3a0020", "toledo"),
    (0.090468, 0.140468, 0.910173, 0.647059, 0.043137, 0.368627, "#a50b5e", "jazzberry jam"),
    (0.187959, 0.237959, 0.911202, 0.772549, 0.294118, 0.549020, "#c54b8c", "mulberry"),
    (0.643144, 0.693144, 0.911950, 0.972549, 0.764706, 0.874510, "#f8c3df", "chantilly"),
    (0.269204, 0.319204, 0.912458, 0.815686, 0.427451, 0.631373, "#d06da1", "hopbush"),
    (0.386706, 0.436706, 0.912500, 0.968627, 0.498039, 0.745098, "#f77fbe", "persian pink"),
    (0.123288, 0.173288, 0.913165, 0.670588, 0.203922, 0.447059, "#ab3472", "royal heath"),
    (0.795655, 0.845655, 0.913333, 0.976471, 0.878431, 0.929412, "#f9e0ed", "carousel pink"),
    (0.062664, 0.112664, 0.913743, 0.529412, 0.082353, 0.313725, "#871550", "disco"),
    (0.754654, 0.804654, 0.913978, 0.972549, 0.850980, 0.913725, "#f8d9e9", "cherub"),
    (0.068023, 0.118023, 0.914141, 0.380392, 0.250980, 0.317647, "#614051", "eggplant"),
    (0.103119, 0.153119, 0.914286, 0.537255, 0.262745, 0.403922, "#894367", "cannon pink"),
    (0.457707, 0.507707, 0.914352, 0.905882, 0.623529, 0.768627, "#e79fc4", "kobi"),
    (0.052835, 0.102835, 0.914530, 0.501961, 0.043137, 0.278431, "#800b47", "rose bud cherry"),
    (0.285325, 0.335325, 0.915133, 0.964706, 0.325490, 0.650980, "#f653a6", "brilliant rose"),
    (0.189359, 0.239359, 0.915675, 0.854902, 0.196078, 0.529412, "#da3287", "cerise"),
    (0.527140, 0.577140, 0.916667, 0.764706, 0.749020, 0.756863, "#c3bfc1", "pale slate"),
    (0.259276, 0.309276, 0.916667, 1.000000, 0.200000, 0.600000, "#ff3399", "wild strawberry"),
    (0.346584, 0.396584, 0.916667, 1.000000, 0.411765, 0.705882, "#ff69b4", "hot pink"),
    (0.227923, 0.277923, 0.916993, 1.000000, 0.000000, 0.498039, "#ff007f", "rose"),
    (0.118920, 0.168920, 0.920712, 0.635294, 0.231373, 0.423529, "#a23b6c", "rouge"),
    (0.044648, 0.094648, 0.921488, 0.478431, 0.003922, 0.227451, "#7a013a", "siren"),
    (0.047561, 0.097561, 0.921569, 0.411765, 0.145098, 0.270588, "#692545", "tawny port"),
    (0.554345, 0.604345, 0.922078, 0.984314, 0.682353, 0.823529, "#fbaed2", "lavender pink"),
    (0.623981, 0.673981, 0.923497, 0.984314, 0.745098, 0.854902, "#fbbeda", "cupid"),
    (0.503608, 0.553608, 0.924797, 0.964706, 0.643137, 0.788235, "#f6a4c9", "illusion"),
    (0.132244, 0.182244, 0.926065, 0.713725, 0.192157, 0.423529, "#b6316c", "hibiscus"),
    (0.352060, 0.402060, 0.927778, 0.796078, 0.560784, 0.662745, "#cb8fa9", "viola"),
    (0.188205, 0.238205, 0.928862, 0.690196, 0.368627, 0.505882, "#b05e81", "tapestry"),
    (0.869586, 0.919586, 0.929825, 0.996078, 0.921569, 0.952941, "#feebf3", "remy"),
    (0.031382, 0.081382, 0.930000, 0.403922, 0.011765, 0.176471, "#67032d", "black rose"),
    (0.599311, 0.649311, 0.930556, 1.000000, 0.717647, 0.835294, "#ffb7d5", "cotton candy"),
    (0.032596, 0.082596, 0.933333, 0.349020, 0.113725, 0.207843, "#591d35", "wine berry"),
    (0.084462, 0.134462, 0.933333, 0.537255, 0.203922, 0.337255, "#893456", "camelot"),
    (0.925495, 0.975495, 0.933333, 0.996078, 0.956863, 0.972549, "#fef4f8", "wisp pink"),
    (0.108760, 0.158760, 0.934066, 0.596078, 0.239216, 0.380392, "#983d61", "vin rouge"),
    (0.527495, 0.577495, 0.934457, 1.000000, 0.650980, 0.788235, "#ffa6c9", "carnation pink"),
    (0.761504, 0.811504, 0.934524, 0.968627, 0.858824, 0.901961, "#f7dbe6", "we peep"),
    (0.259895, 0.309895, 0.935970, 0.968627, 0.274510, 0.541176, "#f7468a", "violet red"),
    (0.661447, 0.711447, 0.936170, 0.968627, 0.784314, 0.854902, "#f7c8da", "azalea"),
    (0.143515, 0.193515, 0.936782, 0.498039, 0.384314, 0.427451, "#7f626d", "falcon"),
    (0.018928, 0.068928, 0.936992, 0.321569, 0.000000, 0.121569, "#52001f", "castro"),
    (0.173429, 0.223429, 0.937500, 0.890196, 0.043137, 0.360784, "#e30b5c", "razzmatazz"),
    (0.263254, 0.313254, 0.937984, 0.964706, 0.290196, 0.541176, "#f64a8a", "french rose"),
    (0.750850, 0.800850, 0.942982, 0.992157, 0.843137, 0.894118, "#fdd7e4", "pig pink"),
    (0.024013, 0.074013, 0.943223, 0.360784, 0.003922, 0.125490, "#5c0120", "bordeaux"),
    (0.286259, 0.336259, 0.944444, 0.831373, 0.454902, 0.580392, "#d47494", "charm"),
    (0.901727, 0.951727, 0.944444, 1.000000, 0.941176, 0.960784, "#fff0f5", "lavender blush"),
    (0.379279, 0.429279, 0.945578, 0.917647, 0.533333, 0.658824, "#ea88a8", "carissma"),
    (0.051293, 0.101293, 0.947368, 0.305882, 0.231373, 0.254902, "#4e3b41", "matterhorn"),
    (0.150831, 0.200831, 0.948485, 0.705882, 0.274510, 0.407843, "#b44668", "blush"),
    (0.317178, 0.367178, 0.948485, 0.894118, 0.462745, 0.596078, "#e47698", "deep blush"),
    (0.120166, 0.170166, 0.949275, 0.666667, 0.215686, 0.352941, "#aa375a", "night shadz"),
    (0.120695, 0.170695, 0.950000, 0.411765, 0.372549, 0.384314, "#695f62", "scorpion"),
    (0.154396, 0.204396, 0.950000, 0.690196, 0.298039, 0.415686, "#b04c6a", "cadillac"),
    (0.388504, 0.438504, 0.950269, 0.988235, 0.501961, 0.647059, "#fc80a5", "tickle me pink"),
    (0.221779, 0.271779, 0.950839, 0.858824, 0.313725, 0.474510, "#db5079", "cranberry"),
    (0.080901, 0.130901, 0.950980, 0.364706, 0.298039, 0.317647, "#5d4c51", "don juan"),
    (0.186271, 0.236271, 0.951830, 0.870588, 0.192157, 0.388235, "#de3163", "cerise red"),
    (0.182605, 0.232605, 0.952381, 0.505882, 0.450980, 0.466667, "#817377", "empress"),
    (0.207317, 0.257317, 0.952546, 0.850980, 0.286275, 0.447059, "#d94972", "cabaret"),
    (0.370773, 0.420773, 0.953431, 0.835294, 0.568627, 0.643137, "#d591a4", "can can"),
    (0.053728, 0.103728, 0.953526, 0.498039, 0.090196, 0.203922, "#7f1734", "claret"),
    (0.066107, 0.116107, 0.954545, 0.317647, 0.274510, 0.286275, "#514649", "emperor"),
    (0.058461, 0.108461, 0.956835, 0.552941, 0.007843, 0.149020, "#8d0226", "paprika"),
    (0.140994, 0.190994, 0.957143, 0.682353, 0.270588, 0.376471, "#ae4560", "hippie pink"),
    (0.416406, 0.466406, 0.957895, 0.941176, 0.568627, 0.662745, "#f091a9", "mauvelous"),
    (0.862128, 0.912128, 0.958333, 0.960784, 0.929412, 0.937255, "#f5edef", "soft peach"),
    (0.057696, 0.107696, 0.958333, 0.290196, 0.258824, 0.266667, "#4a4244", "tundora"),
    (0.327456, 0.377456, 0.958333, 0.800000, 0.533333, 0.600000, "#cc8899", "puce"),
    (0.578770, 0.628770, 0.959596, 0.882353, 0.752941, 0.784314, "#e1c0c8", "pink flare"),
    (0.131577, 0.181577, 0.959877, 0.764706, 0.129412, 0.282353, "#c32148", "maroon flush"),
    (0.720282, 0.770282, 0.960145, 1.000000, 0.819608, 0.862745, "#ffd1dc", "pastel pink"),
    (0.098821, 0.148821, 0.960552, 0.698039, 0.035294, 0.192157, "#b20931", "shiraz"),
    (0.185805, 0.235805, 0.961087, 0.929412, 0.039216, 0.247059, "#ed0a3f", "red ribbon"),
    (0.410576, 0.460576, 0.961538, 0.823529, 0.619608, 0.666667, "#d29eaa", "careys pink"),
    (0.740081, 0.790081, 0.961538, 0.952941, 0.850980, 0.874510, "#f3d9df", "vanilla ice"),
    (0.234434, 0.284434, 0.962687, 0.709804, 0.447059, 0.505882, "#b57281", "turkish rose"),
    (0.474138, 0.524138, 0.962963, 0.745098, 0.709804, 0.717647, "#beb5b7", "pink swan"),
    (0.060336, 0.110336, 0.962963, 0.564706, 0.000000, 0.125490, "#900020", "burgundy"),
    (0.057623, 0.107623, 0.964646, 0.545098, 0.027451, 0.137255, "#8b0723", "monarch"),
    (0.018608, 0.068608, 0.965174, 0.301961, 0.039216, 0.094118, "#4d0a18", "cab sav"),
    (0.246144, 0.296144, 0.966172, 1.000000, 0.207843, 0.368627, "#ff355e", "radical red"),
    (0.160422, 0.210422, 0.966667, 0.862745, 0.078431, 0.235294, "#dc143c", "crimson"),
    (0.304073, 0.354073, 0.966667, 0.984314, 0.376471, 0.498039, "#fb607f", "brink pink"),
    (0.514890, 0.564890, 0.966667, 0.862745, 0.705882, 0.737255, "#dcb4bc", "blossom"),
    (0.754056, 0.804056, 0.966667, 0.898039, 0.878431, 0.882353, "#e5e0e1", "bon jour"),
    (0.189650, 0.239650, 0.966846, 0.898039, 0.168627, 0.313725, "#e52b50", "amaranth"),
    (0.331479, 0.381479, 0.968750, 0.658824, 0.596078, 0.607843, "#a8989b", "dusty gray"),
    (0.009540, 0.059540, 0.968927, 0.231373, 0.000000, 0.043137, "#3b000b", "temptress"),
    (0.450837, 0.500837, 0.968992, 0.945098, 0.607843, 0.670588, "#f19bab", "wewak"),
    (0.059669, 0.109669, 0.969267, 0.560784, 0.007843, 0.109804, "#8f021c", "pohutukawa"),
    (0.297209, 0.347209, 0.970165, 0.992157, 0.356863, 0.470588, "#fd5b78", "wild watermelon"),
    (0.632711, 0.682711, 0.970899, 1.000000, 0.752941, 0.796078, "#ffc0cb", "pink"),
    (0.441911, 0.491911, 0.971212, 1.000000, 0.568627, 0.643137, "#ff91a4", "pink salmon"),
    (0.129698, 0.179698, 0.971888, 0.768627, 0.117647, 0.227451, "#c41e3a", "cardinal"),
    (0.214538, 0.264538, 0.972803, 0.992157, 0.054902, 0.207843, "#fd0e35", "torch red"),
    (0.032926, 0.082926, 0.972973, 0.301961, 0.156863, 0.180392, "#4d282e", "livid brown"),
    (0.065500, 0.115500, 0.973333, 0.588235, 0.000000, 0.094118, "#960018", "carmine"),
    (0.101446, 0.151446, 0.973684, 0.407843, 0.333333, 0.345098, "#685558", "zambezi"),
    (0.170112, 0.220112, 0.973684, 0.505882, 0.431373, 0.443137, "#816e71", "spicy pink"),
    (0.021186, 0.071186, 0.973810, 0.321569, 0.047059, 0.090196, "#520c17", "maroon oak"),
    (0.064437, 0.114437, 0.976510, 0.584314, 0.000000, 0.082353, "#950015", "scarlett"),
    (0.011626, 0.061626, 0.976667, 0.231373, 0.035294, 0.062745, "#3b0910", "aubergine"),
    (0.123010, 0.173010, 0.977041, 0.780392, 0.011765, 0.117647, "#c7031e", "monza"),
    (0.142759, 0.192759, 0.977124, 0.776471, 0.176471, 0.258824, "#c62d42", "brick red"),
    (0.085520, 0.135520, 0.977366, 0.537255, 0.219608, 0.262745, "#893843", "solid pink"),
    (0.032848, 0.082848, 0.977477, 0.301961, 0.156863, 0.176471, "#4d282d", "cowboy"),
    (0.036336, 0.086336, 0.979351, 0.447059, 0.003922, 0.058824, "#72010f", "venetian red"),
    (0.212991, 0.262991, 0.979798, 0.596078, 0.466667, 0.482353, "#98777b", "bazaar"),
    (0.051305, 0.101305, 0.979950, 0.525490, 0.003922, 0.066667, "#860111", "red devil"),
    (0.234490, 0.284490, 0.980047, 0.886275, 0.329412, 0.396078, "#e25465", "mandy"),
    (0.338010, 0.388010, 0.980469, 0.960784, 0.458824, 0.517647, "#f57584", "froly"),
    (0.027909, 0.077909, 0.981848, 0.396078, 0.000000, 0.043137, "#65000b", "rosewood"),
    (0.056419, 0.106419, 0.984277, 0.513725, 0.098039, 0.137255, "#831923", "merlot"),
    (0.179835, 0.229835, 0.985891, 0.890196, 0.149020, 0.211765, "#e32636", "alizarin crimson"),
    (0.429296, 0.479296, 0.988235, 0.929412, 0.596078, 0.619608, "#ed989e", "sea pink"),
    (0.061329, 0.111329, 0.988584, 0.572549, 0.000000, 0.039216, "#92000a", "sangria"),
    (0.040345, 0.090345, 0.988796, 0.470588, 0.003922, 0.035294, "#780109", "japanese maple"),
    (0.283151, 0.333151, 0.992662, 0.976471, 0.352941, 0.380392, "#f95a61", "carnation"),
    (0.182895, 0.232895, 0.994624, 0.556863, 0.435294, 0.439216, "#8e6f70", "opium"),
    (0.482876, 0.532876, 0.994681, 0.992157, 0.623529, 0.635294, "#fd9fa2", "sweet pink"),
    (0.096159, 0.146159, 0.994949, 0.439216, 0.309804, 0.313725, "#704f50", "ferra"),
    (0.022991, 0.072991, 0.995098, 0.329412, 0.062745, 0.070588, "#541012", "heath"),
    (0.026974, 0.076974, 0.995098, 0.274510, 0.141176, 0.145098, "#462425", "crater brown"),
    (0.097019, 0.147019, 0.995238, 0.611765, 0.200000, 0.211765, "#9c3336", "stiletto"),
    (0.753815, 0.803815, 0.995726, 1.000000, 0.847059, 0.850980, "#ffd8d9", "cosmos"),
    (0.559590, 0.609590, 0.995726, 1.000000, 0.694118, 0.701961, "#ffb1b3", "sundown"),
    (0.048431, 0.098431, 0.996732, 0.384314, 0.184314, 0.188235, "#622f30", "buccaneer"),
    (0.282298, 0.332298, 0.997396, 0.752941, 0.501961, 0.505882, "#c08081", "old rose"),
    (0.015233, 0.065233, 0.997475, 0.282353, 0.023529, 0.027451, "#480607", "bulgarian rose"),
    (0.152696, 0.202696, 0.998889, 0.792157, 0.203922, 0.207843, "#ca3435", "flush mahogany"),
    ]


lum_sorted_colorL = sorted( h_sorted_colorL )
cstr_sorted_colorL = sorted(lum_sorted_colorL, key=lambda t: t[-2])
name_sorted_colorL = sorted(lum_sorted_colorL, key=lambda t: t[-1])

if __name__=="__main__":
     print( 'len(h_sorted_colorL)   =', len(h_sorted_colorL) )
     print( 'len(lum_sorted_colorL) =', len(lum_sorted_colorL) )
     

