#!/usr/bin/env python
# -*- coding: ascii -*-
from __future__ import print_function
from __future__ import unicode_literals
from builtins import range
from builtins import object
import sys
import os, stat

startTag = '# %s generated code. DO NOT EDIT THE FOLLOWING. section "%s"\n'
userTag = '# >>>>>>insert any user code below this comment for section "%s"\n'

def lineIsStartTag( line ):
    lineL = line.split()
    if len(lineL) < 11:
        return 0,''
    if lineL[0] != '#':
        return 0,''
    if line.find('generated code. DO NOT EDIT THE FOLLOWING. section') > -1:
        #print( 'lenth =',len(lineL) )
        return 1,lineL[-1][1:-1]
    else:
        return 0,''

def lineIsUserTag( line ):
    lineL = line.split()
    if len(lineL) < 11:
        return 0,''
    if lineL[0] != '#':
        return 0,''
    if line.find('# >>>>>>insert any user code below this comment for section') > -1:
        #print( 'lenth =',len(lineL) )
        return 1,lineL[-1][1:-1]
    else:
        return 0,''


class SourceSection(object):
    
    def __init__(self, name='top_of_init', appName='TkGridGUI', allowUserCode=1):
        
        self.name = name
        self.genCodeL = [] # list of lines of generated code
        self.userCodeL = [] # lines of code entered by user
        self.allowUserCode = allowUserCode
        
        self.startTag = startTag%(appName, name)
        self.userTag = userTag%(name, )
    
    def Indents(self, lineL):
        '''find initial and final indents in the list of lines'''
        firstIndent = 0
        for line in lineL:
            if len( line.strip() ) > 0:
                firstIndent = len(line) - len( line.lstrip() )
                break
        lastIndent = 0
        for i in range( len(lineL)-1, -1, -1):
            line = lineL[i]
            if len( line.strip() ) > 0:
                lastIndent = len(line) - len( line.lstrip() )
                break
        return firstIndent, lastIndent
    
    def saveToFile(self, fileObj):
        
        firstIndent, lastIndent = self.Indents(self.genCodeL)
        fileObj.write( ' '*firstIndent + self.startTag )
        for line in self.genCodeL:
            fileObj.write( line )
            
        if self.allowUserCode:
            fileObj.write( ' '*lastIndent + self.userTag )
            if self.numLinesOfUserCode()==0:
                fileObj.write('\n\n')
            else:
                for line in self.userCodeL:
                    fileObj.write( line )
    
    def getGenCode(self):
        return ''.join( self.genCodeL )
        
    def getUserCode(self):
        return ''.join( self.userCodeL )
        
    def addGenCode(self, line):
        self.genCodeL.append( line )
        
    def addUserCode(self, line):
        self.userCodeL.append( line )
        
    def numLinesOfUserCode(self):
        N=0
        for line in self.userCodeL:
            if len(line.strip()) > 0:
                N = N + 1
        return N
        
    def numLinesOfGenCode(self):
        return len( self.genCodeL )
        
    def printSummary(self):
        print( 'Lines of code for section',self.name,'user:%i'%self.numLinesOfUserCode(), end='')
        print( 'generated:%i'%self.numLinesOfGenCode() )
        
class SourceFile(object):
    
    def saveToFile(self, fOut=None):
        
        if fOut is None:
            fOut = open( self.pathopen, 'w')
        
        # put shebang line for Linux and future line for python 2
        fOut.write('#!/usr/bin/env python\n# -*- coding: ascii -*-\nfrom __future__ import print_function\n\n')
        fOut.write('''# NOTICE... this file is generated by TkGridGUI.
# Any code or comments added by the user must be in designated areas ONLY.
# User additions will be lost if they are placed in code-generated areas.
# (i.e. Saving from TkGridGUI will over-write code-generated areas.)

''')
        if fOut != sys.stdout:
            print( 'Saving python source to:',os.path.split(self.pathopen)[-1] )
        #print( 'SAVING to DEBUG file test_out.py' )
        #fOut = open( 'test_out.py', 'w')
        for sectName in self.sectionNameList:
            self.sectionSrcD[sectName].saveToFile(fOut)
            
        if fOut != sys.stdout:
            fOut.close()
            
            # set execute permissions on python file
            os.chmod( self.pathopen, stat.S_IRWXU + stat.S_IRWXG + stat.S_IROTH )
        
    
    def __init__(self, fName, appName='TkGridGUI', noUserCodeList=None):
        
        self.pathopen = os.path.abspath(fName)
        self.fName = fName
        
        # sections in the file that are not added with addSection WILL BE LOST
        self.sectionNameList = [] # will be populated ONLY from addSection method
        self.sectionSrcD = {}# will be populated from BOTH file read and addSection method
        self.appName = appName
        if noUserCodeList==None:
            self.noUserCodeList=[]
        else:
            self.noUserCodeList = noUserCodeList
        
        
        # if source file already exists, read it an fill source sections
        if os.path.isfile( self.pathopen ): # if file exists, read it
            fIn = open( self.pathopen,'r')
            self.oldLines = fIn.readlines() # will still have \n line endings
            fIn.close()
        else:
            self.oldLines = []
            
        self.numOldLines = len(self.oldLines)
        #print( 'old file',self.pathopenm )
        #print( 'numOldLines =',self.numOldLines )
        
        # loop through lines of code looking for section tags and user code tags
        activeSection = None
        inUserSection = 0
        startSect = ''
        for line in self.oldLines:
            isStartTag, section = lineIsStartTag( line )
            if isStartTag:
                startSect = section
                activeSection = SourceSection( startSect )
                self.sectionSrcD[startSect] = activeSection
                inUserSection = 0
            elif activeSection:
                isUserTag,userSect = lineIsUserTag( line )
                if isUserTag:
                    inUserSection = 1
                    if userSect != startSect:
                        print( 'WARNING... Section mismatch in file' )
                else:
                    if inUserSection:
                        activeSection.addUserCode( line )
                    else:
                        activeSection.addGenCode( line )

    def clearGenCode(self):
        for section, scode in list(self.sectionSrcD.items()):
            scode.genCodeL = []
    
    def getCleanList(self, myList):
        # clean up any multiline entries
        returnL = []
        for line in myList:
            if line.count('\n')>1:
                sL = line.split('\n')
                for s in sL:
                    returnL.append( s+'\n' )
            else:
                returnL.append(line)
        return returnL
    
    def addSection(self, sectionName, genCodeL, allowUserCode=1, defaultUserCodeL=None):
        '''Sections will be printed to file in the order added here.
           ONLY sections added here will be printed to file'''
        
        #print('defaultUserCodeL = ',defaultUserCodeL)
        
        if sectionName not in self.sectionSrcD:
            self.sectionSrcD[sectionName] = SourceSection( sectionName )
            
        if not allowUserCode:
            self.sectionSrcD[sectionName].allowUserCode = 0
            
        # clear genCodeL and add new generated lines
        self.sectionSrcD[sectionName].genCodeL = []
        sL = self.getCleanList( genCodeL )
        for line in sL:
            self.sectionSrcD[sectionName].genCodeL.append( line )
            
        # add default user code ONLY if available and not already in file
        if defaultUserCodeL and self.sectionSrcD[sectionName].numLinesOfUserCode()==0:
            #print('Saving Default User code for ',sectionName)
            #print('   sL =',sL)
            sL = self.getCleanList( defaultUserCodeL )
            for line in sL:
                self.sectionSrcD[sectionName].userCodeL.append( line )
        else:
            #print('# Overwrite of User code disallowed for ',sectionName)
            pass
            
            
        self.sectionNameList.append( sectionName )

if __name__ == '__main__':
    
    sf = SourceFile( os.path.normpath('./NewForm.py') )
    
    for key,sect in list(sf.sectionSrcD.items()):
        sect.printSummary()
        print( sect.getUserCode() )
    
    import copy
    genCodeL = copy.deepcopy( sf.sectionSrcD['top_of_init'].genCodeL )
    sf.addSection('top_of_init', genCodeL)
    genCodeL = copy.deepcopy( sf.sectionSrcD['end'].genCodeL )
    sf.addSection('end', genCodeL, allowUserCode=0)
    sf.saveToFile()