# kaplanmeier

[![Python](https://img.shields.io/pypi/pyversions/kaplanmeier)](https://img.shields.io/pypi/pyversions/kaplanmeier)
[![PyPI Version](https://img.shields.io/pypi/v/kaplanmeier)](https://pypi.org/project/kaplanmeier/)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](https://github.com/erdogant/kaplanmeier/blob/master/LICENSE)
[![Github Forks](https://img.shields.io/github/forks/erdogant/kaplanmeier.svg)](https://github.com/erdogant/kaplanmeier/network)
[![GitHub Open Issues](https://img.shields.io/github/issues/erdogant/kaplanmeier.svg)](https://github.com/erdogant/kaplanmeier/issues)
[![Project Status](http://www.repostatus.org/badges/latest/active.svg)](http://www.repostatus.org/#active)
[![Downloads](https://pepy.tech/badge/kaplanmeier/month)](https://pepy.tech/project/kaplanmeier/)
[![Downloads](https://pepy.tech/badge/kaplanmeier)](https://pepy.tech/project/kaplanmeier)
[![Sphinx](https://img.shields.io/badge/Sphinx-Docs-Green)](https://erdogant.github.io/kaplanmeier/)
<!---[![BuyMeCoffee](https://img.shields.io/badge/buymea-coffee-yellow.svg)](https://www.buymeacoffee.com/erdogant)-->
<!---[![Coffee](https://img.shields.io/badge/coffee-black-grey.svg)](https://erdogant.github.io/donate/?currency=USD&amount=5)-->

``kaplanmeier`` is a Python package to compute the kaplan meier curves, log-rank test, and make the plots.


# 
**⭐️ Star this repo if you like it ⭐️**
#

#### Install kaplanmeier from PyPI

```bash
pip install kaplanmeier
```

#### Import kaplanmeier package

```python
import kaplanmeier import km
```
# 


### [Documentation pages](https://erdogant.github.io/kaplanmeier/)

On the [documentation pages](https://erdogant.github.io/kaplanmeier/) you can find detailed information about the working of the ``kaplanmeier`` with many examples. 

<hr> 

### Examples

# 

* [Example: Create Kaplan meier plot](https://erdogant.github.io/kaplanmeier/pages/html/Examples.html)

<p align="left">
  <a href="https://erdogant.github.io/kaplanmeier/pages/html/Examples.html">
  <img src="https://github.com/erdogant/kaplanmeier/blob/master/docs/figs/fig2.png" width="600" />
  </a>
</p>


# 

* [Example: Remove the Confidence intervals from plot](https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#custom-colormap)

<p align="left">
  <a href="https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#custom-colormap">
  <img src="https://github.com/erdogant/kaplanmeier/blob/master/docs/figs/fig1.png" width="600" />
  </a>
</p>


# 

* [Example: Change colormap and confidence intervals the confidence interval](https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#change-colormap-and-confidence-intervals)

<p align="left">
  <a href="https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#change-colormap-and-confidence-intervals">
  <img src="https://github.com/erdogant/kaplanmeier/blob/master/docs/figs/fig3.png" width="600" />
  </a>
</p>

# 

* [Example: Use custom colormap](https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#id1)

<p align="left">
  <a href="https://erdogant.github.io/kaplanmeier/pages/html/Examples.html#id1">
  <img src="https://github.com/erdogant/kaplanmeier/blob/master/docs/figs/fig4.png" width="600" />
  </a>
</p>


<hr>


### Maintainer
* Erdogan Taskesen, github: [erdogant](https://github.com/erdogant)
* Contributions are welcome.
* If you wish to buy me a <a href="https://www.buymeacoffee.com/erdogant">Coffee</a> for this work, it is very appreciated :)
