"""
Setup script for types-aioboto3.

Copyright 2025 Vlad Emelianov
"""

from pathlib import Path

from setuptools import setup  # type: ignore

LONG_DESCRIPTION = (Path(__file__).parent / "README.md").read_text()

setup(
    name="types-aioboto3",
    version="15.2.0",
    packages=["aioboto3-stubs"],
    url="https://github.com/youtype/mypy_boto3_builder",
    license="MIT License",
    author="Vlad Emelianov",
    author_email="vlad.emelianov.nz@gmail.com",
    description="Type annotations for aioboto3 15.2.0 generated with mypy-boto3-builder 8.11.0",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: 3.13",
        "Programming Language :: Python :: 3.14",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
        "Typing :: Stubs Only",
    ],
    keywords="aioboto3 aioboto3-stubs type-annotations typeshed autocomplete",
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    package_data={"aioboto3-stubs": ["py.typed", "*.pyi", "*/*.pyi"]},
    python_requires=">=3.8",
    project_urls={
        "Documentation": "https://youtype.github.io/types_aioboto3_docs/",
        "Source": "https://github.com/youtype/mypy_boto3_builder",
        "Tracker": "https://github.com/youtype/mypy_boto3_builder/issues",
    },
    install_requires=[
        "botocore-stubs",
        "types-aiobotocore",
        "types-s3transfer",
        'typing-extensions>=4.1.0; python_version<"3.12"',
    ],
    extras_require={
        "full": ["types-aiobotocore-full>=2.24.0, <2.25.0"],
        "aioboto3": ["aioboto3==15.2.0"],
        "all": [
            "types-aiobotocore-accessanalyzer>=2.24.0, <2.25.0",
            "types-aiobotocore-account>=2.24.0, <2.25.0",
            "types-aiobotocore-acm>=2.24.0, <2.25.0",
            "types-aiobotocore-acm-pca>=2.24.0, <2.25.0",
            "types-aiobotocore-aiops>=2.24.0, <2.25.0",
            "types-aiobotocore-amp>=2.24.0, <2.25.0",
            "types-aiobotocore-amplify>=2.24.0, <2.25.0",
            "types-aiobotocore-amplifybackend>=2.24.0, <2.25.0",
            "types-aiobotocore-amplifyuibuilder>=2.24.0, <2.25.0",
            "types-aiobotocore-apigateway>=2.24.0, <2.25.0",
            "types-aiobotocore-apigatewaymanagementapi>=2.24.0, <2.25.0",
            "types-aiobotocore-apigatewayv2>=2.24.0, <2.25.0",
            "types-aiobotocore-appconfig>=2.24.0, <2.25.0",
            "types-aiobotocore-appconfigdata>=2.24.0, <2.25.0",
            "types-aiobotocore-appfabric>=2.24.0, <2.25.0",
            "types-aiobotocore-appflow>=2.24.0, <2.25.0",
            "types-aiobotocore-appintegrations>=2.24.0, <2.25.0",
            "types-aiobotocore-application-autoscaling>=2.24.0, <2.25.0",
            "types-aiobotocore-application-insights>=2.24.0, <2.25.0",
            "types-aiobotocore-application-signals>=2.24.0, <2.25.0",
            "types-aiobotocore-applicationcostprofiler>=2.24.0, <2.25.0",
            "types-aiobotocore-appmesh>=2.24.0, <2.25.0",
            "types-aiobotocore-apprunner>=2.24.0, <2.25.0",
            "types-aiobotocore-appstream>=2.24.0, <2.25.0",
            "types-aiobotocore-appsync>=2.24.0, <2.25.0",
            "types-aiobotocore-apptest>=2.24.0, <2.25.0",
            "types-aiobotocore-arc-region-switch>=2.24.0, <2.25.0",
            "types-aiobotocore-arc-zonal-shift>=2.24.0, <2.25.0",
            "types-aiobotocore-artifact>=2.24.0, <2.25.0",
            "types-aiobotocore-athena>=2.24.0, <2.25.0",
            "types-aiobotocore-auditmanager>=2.24.0, <2.25.0",
            "types-aiobotocore-autoscaling>=2.24.0, <2.25.0",
            "types-aiobotocore-autoscaling-plans>=2.24.0, <2.25.0",
            "types-aiobotocore-b2bi>=2.24.0, <2.25.0",
            "types-aiobotocore-backup>=2.24.0, <2.25.0",
            "types-aiobotocore-backup-gateway>=2.24.0, <2.25.0",
            "types-aiobotocore-backupsearch>=2.24.0, <2.25.0",
            "types-aiobotocore-batch>=2.24.0, <2.25.0",
            "types-aiobotocore-bcm-dashboards>=2.24.0, <2.25.0",
            "types-aiobotocore-bcm-data-exports>=2.24.0, <2.25.0",
            "types-aiobotocore-bcm-pricing-calculator>=2.24.0, <2.25.0",
            "types-aiobotocore-bcm-recommended-actions>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-agent>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-agent-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-agentcore>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-agentcore-control>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-data-automation>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-data-automation-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-bedrock-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-billing>=2.24.0, <2.25.0",
            "types-aiobotocore-billingconductor>=2.24.0, <2.25.0",
            "types-aiobotocore-braket>=2.24.0, <2.25.0",
            "types-aiobotocore-budgets>=2.24.0, <2.25.0",
            "types-aiobotocore-ce>=2.24.0, <2.25.0",
            "types-aiobotocore-chatbot>=2.24.0, <2.25.0",
            "types-aiobotocore-chime>=2.24.0, <2.25.0",
            "types-aiobotocore-chime-sdk-identity>=2.24.0, <2.25.0",
            "types-aiobotocore-chime-sdk-media-pipelines>=2.24.0, <2.25.0",
            "types-aiobotocore-chime-sdk-meetings>=2.24.0, <2.25.0",
            "types-aiobotocore-chime-sdk-messaging>=2.24.0, <2.25.0",
            "types-aiobotocore-chime-sdk-voice>=2.24.0, <2.25.0",
            "types-aiobotocore-cleanrooms>=2.24.0, <2.25.0",
            "types-aiobotocore-cleanroomsml>=2.24.0, <2.25.0",
            "types-aiobotocore-cloud9>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudcontrol>=2.24.0, <2.25.0",
            "types-aiobotocore-clouddirectory>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudformation>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudfront>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudfront-keyvaluestore>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudhsm>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudhsmv2>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudsearch>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudsearchdomain>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudtrail>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudtrail-data>=2.24.0, <2.25.0",
            "types-aiobotocore-cloudwatch>=2.24.0, <2.25.0",
            "types-aiobotocore-codeartifact>=2.24.0, <2.25.0",
            "types-aiobotocore-codebuild>=2.24.0, <2.25.0",
            "types-aiobotocore-codecatalyst>=2.24.0, <2.25.0",
            "types-aiobotocore-codecommit>=2.24.0, <2.25.0",
            "types-aiobotocore-codeconnections>=2.24.0, <2.25.0",
            "types-aiobotocore-codedeploy>=2.24.0, <2.25.0",
            "types-aiobotocore-codeguru-reviewer>=2.24.0, <2.25.0",
            "types-aiobotocore-codeguru-security>=2.24.0, <2.25.0",
            "types-aiobotocore-codeguruprofiler>=2.24.0, <2.25.0",
            "types-aiobotocore-codepipeline>=2.24.0, <2.25.0",
            "types-aiobotocore-codestar-connections>=2.24.0, <2.25.0",
            "types-aiobotocore-codestar-notifications>=2.24.0, <2.25.0",
            "types-aiobotocore-cognito-identity>=2.24.0, <2.25.0",
            "types-aiobotocore-cognito-idp>=2.24.0, <2.25.0",
            "types-aiobotocore-cognito-sync>=2.24.0, <2.25.0",
            "types-aiobotocore-comprehend>=2.24.0, <2.25.0",
            "types-aiobotocore-comprehendmedical>=2.24.0, <2.25.0",
            "types-aiobotocore-compute-optimizer>=2.24.0, <2.25.0",
            "types-aiobotocore-config>=2.24.0, <2.25.0",
            "types-aiobotocore-connect>=2.24.0, <2.25.0",
            "types-aiobotocore-connect-contact-lens>=2.24.0, <2.25.0",
            "types-aiobotocore-connectcampaigns>=2.24.0, <2.25.0",
            "types-aiobotocore-connectcampaignsv2>=2.24.0, <2.25.0",
            "types-aiobotocore-connectcases>=2.24.0, <2.25.0",
            "types-aiobotocore-connectparticipant>=2.24.0, <2.25.0",
            "types-aiobotocore-controlcatalog>=2.24.0, <2.25.0",
            "types-aiobotocore-controltower>=2.24.0, <2.25.0",
            "types-aiobotocore-cost-optimization-hub>=2.24.0, <2.25.0",
            "types-aiobotocore-cur>=2.24.0, <2.25.0",
            "types-aiobotocore-customer-profiles>=2.24.0, <2.25.0",
            "types-aiobotocore-databrew>=2.24.0, <2.25.0",
            "types-aiobotocore-dataexchange>=2.24.0, <2.25.0",
            "types-aiobotocore-datapipeline>=2.24.0, <2.25.0",
            "types-aiobotocore-datasync>=2.24.0, <2.25.0",
            "types-aiobotocore-datazone>=2.24.0, <2.25.0",
            "types-aiobotocore-dax>=2.24.0, <2.25.0",
            "types-aiobotocore-deadline>=2.24.0, <2.25.0",
            "types-aiobotocore-detective>=2.24.0, <2.25.0",
            "types-aiobotocore-devicefarm>=2.24.0, <2.25.0",
            "types-aiobotocore-devops-guru>=2.24.0, <2.25.0",
            "types-aiobotocore-directconnect>=2.24.0, <2.25.0",
            "types-aiobotocore-discovery>=2.24.0, <2.25.0",
            "types-aiobotocore-dlm>=2.24.0, <2.25.0",
            "types-aiobotocore-dms>=2.24.0, <2.25.0",
            "types-aiobotocore-docdb>=2.24.0, <2.25.0",
            "types-aiobotocore-docdb-elastic>=2.24.0, <2.25.0",
            "types-aiobotocore-drs>=2.24.0, <2.25.0",
            "types-aiobotocore-ds>=2.24.0, <2.25.0",
            "types-aiobotocore-ds-data>=2.24.0, <2.25.0",
            "types-aiobotocore-dsql>=2.24.0, <2.25.0",
            "types-aiobotocore-dynamodb>=2.24.0, <2.25.0",
            "types-aiobotocore-dynamodbstreams>=2.24.0, <2.25.0",
            "types-aiobotocore-ebs>=2.24.0, <2.25.0",
            "types-aiobotocore-ec2>=2.24.0, <2.25.0",
            "types-aiobotocore-ec2-instance-connect>=2.24.0, <2.25.0",
            "types-aiobotocore-ecr>=2.24.0, <2.25.0",
            "types-aiobotocore-ecr-public>=2.24.0, <2.25.0",
            "types-aiobotocore-ecs>=2.24.0, <2.25.0",
            "types-aiobotocore-efs>=2.24.0, <2.25.0",
            "types-aiobotocore-eks>=2.24.0, <2.25.0",
            "types-aiobotocore-eks-auth>=2.24.0, <2.25.0",
            "types-aiobotocore-elasticache>=2.24.0, <2.25.0",
            "types-aiobotocore-elasticbeanstalk>=2.24.0, <2.25.0",
            "types-aiobotocore-elastictranscoder>=2.24.0, <2.25.0",
            "types-aiobotocore-elb>=2.24.0, <2.25.0",
            "types-aiobotocore-elbv2>=2.24.0, <2.25.0",
            "types-aiobotocore-emr>=2.24.0, <2.25.0",
            "types-aiobotocore-emr-containers>=2.24.0, <2.25.0",
            "types-aiobotocore-emr-serverless>=2.24.0, <2.25.0",
            "types-aiobotocore-entityresolution>=2.24.0, <2.25.0",
            "types-aiobotocore-es>=2.24.0, <2.25.0",
            "types-aiobotocore-events>=2.24.0, <2.25.0",
            "types-aiobotocore-evidently>=2.24.0, <2.25.0",
            "types-aiobotocore-evs>=2.24.0, <2.25.0",
            "types-aiobotocore-finspace>=2.24.0, <2.25.0",
            "types-aiobotocore-finspace-data>=2.24.0, <2.25.0",
            "types-aiobotocore-firehose>=2.24.0, <2.25.0",
            "types-aiobotocore-fis>=2.24.0, <2.25.0",
            "types-aiobotocore-fms>=2.24.0, <2.25.0",
            "types-aiobotocore-forecast>=2.24.0, <2.25.0",
            "types-aiobotocore-forecastquery>=2.24.0, <2.25.0",
            "types-aiobotocore-frauddetector>=2.24.0, <2.25.0",
            "types-aiobotocore-freetier>=2.24.0, <2.25.0",
            "types-aiobotocore-fsx>=2.24.0, <2.25.0",
            "types-aiobotocore-gamelift>=2.24.0, <2.25.0",
            "types-aiobotocore-gameliftstreams>=2.24.0, <2.25.0",
            "types-aiobotocore-geo-maps>=2.24.0, <2.25.0",
            "types-aiobotocore-geo-places>=2.24.0, <2.25.0",
            "types-aiobotocore-geo-routes>=2.24.0, <2.25.0",
            "types-aiobotocore-glacier>=2.24.0, <2.25.0",
            "types-aiobotocore-globalaccelerator>=2.24.0, <2.25.0",
            "types-aiobotocore-glue>=2.24.0, <2.25.0",
            "types-aiobotocore-grafana>=2.24.0, <2.25.0",
            "types-aiobotocore-greengrass>=2.24.0, <2.25.0",
            "types-aiobotocore-greengrassv2>=2.24.0, <2.25.0",
            "types-aiobotocore-groundstation>=2.24.0, <2.25.0",
            "types-aiobotocore-guardduty>=2.24.0, <2.25.0",
            "types-aiobotocore-health>=2.24.0, <2.25.0",
            "types-aiobotocore-healthlake>=2.24.0, <2.25.0",
            "types-aiobotocore-iam>=2.24.0, <2.25.0",
            "types-aiobotocore-identitystore>=2.24.0, <2.25.0",
            "types-aiobotocore-imagebuilder>=2.24.0, <2.25.0",
            "types-aiobotocore-importexport>=2.24.0, <2.25.0",
            "types-aiobotocore-inspector>=2.24.0, <2.25.0",
            "types-aiobotocore-inspector-scan>=2.24.0, <2.25.0",
            "types-aiobotocore-inspector2>=2.24.0, <2.25.0",
            "types-aiobotocore-internetmonitor>=2.24.0, <2.25.0",
            "types-aiobotocore-invoicing>=2.24.0, <2.25.0",
            "types-aiobotocore-iot>=2.24.0, <2.25.0",
            "types-aiobotocore-iot-data>=2.24.0, <2.25.0",
            "types-aiobotocore-iot-jobs-data>=2.24.0, <2.25.0",
            "types-aiobotocore-iot-managed-integrations>=2.24.0, <2.25.0",
            "types-aiobotocore-iotanalytics>=2.24.0, <2.25.0",
            "types-aiobotocore-iotdeviceadvisor>=2.24.0, <2.25.0",
            "types-aiobotocore-iotevents>=2.24.0, <2.25.0",
            "types-aiobotocore-iotevents-data>=2.24.0, <2.25.0",
            "types-aiobotocore-iotfleethub>=2.24.0, <2.25.0",
            "types-aiobotocore-iotfleetwise>=2.24.0, <2.25.0",
            "types-aiobotocore-iotsecuretunneling>=2.24.0, <2.25.0",
            "types-aiobotocore-iotsitewise>=2.24.0, <2.25.0",
            "types-aiobotocore-iotthingsgraph>=2.24.0, <2.25.0",
            "types-aiobotocore-iottwinmaker>=2.24.0, <2.25.0",
            "types-aiobotocore-iotwireless>=2.24.0, <2.25.0",
            "types-aiobotocore-ivs>=2.24.0, <2.25.0",
            "types-aiobotocore-ivs-realtime>=2.24.0, <2.25.0",
            "types-aiobotocore-ivschat>=2.24.0, <2.25.0",
            "types-aiobotocore-kafka>=2.24.0, <2.25.0",
            "types-aiobotocore-kafkaconnect>=2.24.0, <2.25.0",
            "types-aiobotocore-kendra>=2.24.0, <2.25.0",
            "types-aiobotocore-kendra-ranking>=2.24.0, <2.25.0",
            "types-aiobotocore-keyspaces>=2.24.0, <2.25.0",
            "types-aiobotocore-keyspacesstreams>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesis>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesis-video-archived-media>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesis-video-media>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesis-video-signaling>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesis-video-webrtc-storage>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesisanalytics>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesisanalyticsv2>=2.24.0, <2.25.0",
            "types-aiobotocore-kinesisvideo>=2.24.0, <2.25.0",
            "types-aiobotocore-kms>=2.24.0, <2.25.0",
            "types-aiobotocore-lakeformation>=2.24.0, <2.25.0",
            "types-aiobotocore-lambda>=2.24.0, <2.25.0",
            "types-aiobotocore-launch-wizard>=2.24.0, <2.25.0",
            "types-aiobotocore-lex-models>=2.24.0, <2.25.0",
            "types-aiobotocore-lex-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-lexv2-models>=2.24.0, <2.25.0",
            "types-aiobotocore-lexv2-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-license-manager>=2.24.0, <2.25.0",
            "types-aiobotocore-license-manager-linux-subscriptions>=2.24.0, <2.25.0",
            "types-aiobotocore-license-manager-user-subscriptions>=2.24.0, <2.25.0",
            "types-aiobotocore-lightsail>=2.24.0, <2.25.0",
            "types-aiobotocore-location>=2.24.0, <2.25.0",
            "types-aiobotocore-logs>=2.24.0, <2.25.0",
            "types-aiobotocore-lookoutequipment>=2.24.0, <2.25.0",
            "types-aiobotocore-lookoutmetrics>=2.24.0, <2.25.0",
            "types-aiobotocore-lookoutvision>=2.24.0, <2.25.0",
            "types-aiobotocore-m2>=2.24.0, <2.25.0",
            "types-aiobotocore-machinelearning>=2.24.0, <2.25.0",
            "types-aiobotocore-macie2>=2.24.0, <2.25.0",
            "types-aiobotocore-mailmanager>=2.24.0, <2.25.0",
            "types-aiobotocore-managedblockchain>=2.24.0, <2.25.0",
            "types-aiobotocore-managedblockchain-query>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplace-agreement>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplace-catalog>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplace-deployment>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplace-entitlement>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplace-reporting>=2.24.0, <2.25.0",
            "types-aiobotocore-marketplacecommerceanalytics>=2.24.0, <2.25.0",
            "types-aiobotocore-mediaconnect>=2.24.0, <2.25.0",
            "types-aiobotocore-mediaconvert>=2.24.0, <2.25.0",
            "types-aiobotocore-medialive>=2.24.0, <2.25.0",
            "types-aiobotocore-mediapackage>=2.24.0, <2.25.0",
            "types-aiobotocore-mediapackage-vod>=2.24.0, <2.25.0",
            "types-aiobotocore-mediapackagev2>=2.24.0, <2.25.0",
            "types-aiobotocore-mediastore>=2.24.0, <2.25.0",
            "types-aiobotocore-mediastore-data>=2.24.0, <2.25.0",
            "types-aiobotocore-mediatailor>=2.24.0, <2.25.0",
            "types-aiobotocore-medical-imaging>=2.24.0, <2.25.0",
            "types-aiobotocore-memorydb>=2.24.0, <2.25.0",
            "types-aiobotocore-meteringmarketplace>=2.24.0, <2.25.0",
            "types-aiobotocore-mgh>=2.24.0, <2.25.0",
            "types-aiobotocore-mgn>=2.24.0, <2.25.0",
            "types-aiobotocore-migration-hub-refactor-spaces>=2.24.0, <2.25.0",
            "types-aiobotocore-migrationhub-config>=2.24.0, <2.25.0",
            "types-aiobotocore-migrationhuborchestrator>=2.24.0, <2.25.0",
            "types-aiobotocore-migrationhubstrategy>=2.24.0, <2.25.0",
            "types-aiobotocore-mpa>=2.24.0, <2.25.0",
            "types-aiobotocore-mq>=2.24.0, <2.25.0",
            "types-aiobotocore-mturk>=2.24.0, <2.25.0",
            "types-aiobotocore-mwaa>=2.24.0, <2.25.0",
            "types-aiobotocore-neptune>=2.24.0, <2.25.0",
            "types-aiobotocore-neptune-graph>=2.24.0, <2.25.0",
            "types-aiobotocore-neptunedata>=2.24.0, <2.25.0",
            "types-aiobotocore-network-firewall>=2.24.0, <2.25.0",
            "types-aiobotocore-networkflowmonitor>=2.24.0, <2.25.0",
            "types-aiobotocore-networkmanager>=2.24.0, <2.25.0",
            "types-aiobotocore-networkmonitor>=2.24.0, <2.25.0",
            "types-aiobotocore-notifications>=2.24.0, <2.25.0",
            "types-aiobotocore-notificationscontacts>=2.24.0, <2.25.0",
            "types-aiobotocore-oam>=2.24.0, <2.25.0",
            "types-aiobotocore-observabilityadmin>=2.24.0, <2.25.0",
            "types-aiobotocore-odb>=2.24.0, <2.25.0",
            "types-aiobotocore-omics>=2.24.0, <2.25.0",
            "types-aiobotocore-opensearch>=2.24.0, <2.25.0",
            "types-aiobotocore-opensearchserverless>=2.24.0, <2.25.0",
            "types-aiobotocore-opsworks>=2.24.0, <2.25.0",
            "types-aiobotocore-opsworkscm>=2.24.0, <2.25.0",
            "types-aiobotocore-organizations>=2.24.0, <2.25.0",
            "types-aiobotocore-osis>=2.24.0, <2.25.0",
            "types-aiobotocore-outposts>=2.24.0, <2.25.0",
            "types-aiobotocore-panorama>=2.24.0, <2.25.0",
            "types-aiobotocore-partnercentral-selling>=2.24.0, <2.25.0",
            "types-aiobotocore-payment-cryptography>=2.24.0, <2.25.0",
            "types-aiobotocore-payment-cryptography-data>=2.24.0, <2.25.0",
            "types-aiobotocore-pca-connector-ad>=2.24.0, <2.25.0",
            "types-aiobotocore-pca-connector-scep>=2.24.0, <2.25.0",
            "types-aiobotocore-pcs>=2.24.0, <2.25.0",
            "types-aiobotocore-personalize>=2.24.0, <2.25.0",
            "types-aiobotocore-personalize-events>=2.24.0, <2.25.0",
            "types-aiobotocore-personalize-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-pi>=2.24.0, <2.25.0",
            "types-aiobotocore-pinpoint>=2.24.0, <2.25.0",
            "types-aiobotocore-pinpoint-email>=2.24.0, <2.25.0",
            "types-aiobotocore-pinpoint-sms-voice>=2.24.0, <2.25.0",
            "types-aiobotocore-pinpoint-sms-voice-v2>=2.24.0, <2.25.0",
            "types-aiobotocore-pipes>=2.24.0, <2.25.0",
            "types-aiobotocore-polly>=2.24.0, <2.25.0",
            "types-aiobotocore-pricing>=2.24.0, <2.25.0",
            "types-aiobotocore-proton>=2.24.0, <2.25.0",
            "types-aiobotocore-qapps>=2.24.0, <2.25.0",
            "types-aiobotocore-qbusiness>=2.24.0, <2.25.0",
            "types-aiobotocore-qconnect>=2.24.0, <2.25.0",
            "types-aiobotocore-qldb>=2.24.0, <2.25.0",
            "types-aiobotocore-qldb-session>=2.24.0, <2.25.0",
            "types-aiobotocore-quicksight>=2.24.0, <2.25.0",
            "types-aiobotocore-ram>=2.24.0, <2.25.0",
            "types-aiobotocore-rbin>=2.24.0, <2.25.0",
            "types-aiobotocore-rds>=2.24.0, <2.25.0",
            "types-aiobotocore-rds-data>=2.24.0, <2.25.0",
            "types-aiobotocore-redshift>=2.24.0, <2.25.0",
            "types-aiobotocore-redshift-data>=2.24.0, <2.25.0",
            "types-aiobotocore-redshift-serverless>=2.24.0, <2.25.0",
            "types-aiobotocore-rekognition>=2.24.0, <2.25.0",
            "types-aiobotocore-repostspace>=2.24.0, <2.25.0",
            "types-aiobotocore-resiliencehub>=2.24.0, <2.25.0",
            "types-aiobotocore-resource-explorer-2>=2.24.0, <2.25.0",
            "types-aiobotocore-resource-groups>=2.24.0, <2.25.0",
            "types-aiobotocore-resourcegroupstaggingapi>=2.24.0, <2.25.0",
            "types-aiobotocore-robomaker>=2.24.0, <2.25.0",
            "types-aiobotocore-rolesanywhere>=2.24.0, <2.25.0",
            "types-aiobotocore-route53>=2.24.0, <2.25.0",
            "types-aiobotocore-route53-recovery-cluster>=2.24.0, <2.25.0",
            "types-aiobotocore-route53-recovery-control-config>=2.24.0, <2.25.0",
            "types-aiobotocore-route53-recovery-readiness>=2.24.0, <2.25.0",
            "types-aiobotocore-route53domains>=2.24.0, <2.25.0",
            "types-aiobotocore-route53profiles>=2.24.0, <2.25.0",
            "types-aiobotocore-route53resolver>=2.24.0, <2.25.0",
            "types-aiobotocore-rum>=2.24.0, <2.25.0",
            "types-aiobotocore-s3>=2.24.0, <2.25.0",
            "types-aiobotocore-s3control>=2.24.0, <2.25.0",
            "types-aiobotocore-s3outposts>=2.24.0, <2.25.0",
            "types-aiobotocore-s3tables>=2.24.0, <2.25.0",
            "types-aiobotocore-s3vectors>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-a2i-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-edge>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-featurestore-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-geospatial>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-metrics>=2.24.0, <2.25.0",
            "types-aiobotocore-sagemaker-runtime>=2.24.0, <2.25.0",
            "types-aiobotocore-savingsplans>=2.24.0, <2.25.0",
            "types-aiobotocore-scheduler>=2.24.0, <2.25.0",
            "types-aiobotocore-schemas>=2.24.0, <2.25.0",
            "types-aiobotocore-sdb>=2.24.0, <2.25.0",
            "types-aiobotocore-secretsmanager>=2.24.0, <2.25.0",
            "types-aiobotocore-security-ir>=2.24.0, <2.25.0",
            "types-aiobotocore-securityhub>=2.24.0, <2.25.0",
            "types-aiobotocore-securitylake>=2.24.0, <2.25.0",
            "types-aiobotocore-serverlessrepo>=2.24.0, <2.25.0",
            "types-aiobotocore-service-quotas>=2.24.0, <2.25.0",
            "types-aiobotocore-servicecatalog>=2.24.0, <2.25.0",
            "types-aiobotocore-servicecatalog-appregistry>=2.24.0, <2.25.0",
            "types-aiobotocore-servicediscovery>=2.24.0, <2.25.0",
            "types-aiobotocore-ses>=2.24.0, <2.25.0",
            "types-aiobotocore-sesv2>=2.24.0, <2.25.0",
            "types-aiobotocore-shield>=2.24.0, <2.25.0",
            "types-aiobotocore-signer>=2.24.0, <2.25.0",
            "types-aiobotocore-simspaceweaver>=2.24.0, <2.25.0",
            "types-aiobotocore-sms>=2.24.0, <2.25.0",
            "types-aiobotocore-snow-device-management>=2.24.0, <2.25.0",
            "types-aiobotocore-snowball>=2.24.0, <2.25.0",
            "types-aiobotocore-sns>=2.24.0, <2.25.0",
            "types-aiobotocore-socialmessaging>=2.24.0, <2.25.0",
            "types-aiobotocore-sqs>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm-contacts>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm-guiconnect>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm-incidents>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm-quicksetup>=2.24.0, <2.25.0",
            "types-aiobotocore-ssm-sap>=2.24.0, <2.25.0",
            "types-aiobotocore-sso>=2.24.0, <2.25.0",
            "types-aiobotocore-sso-admin>=2.24.0, <2.25.0",
            "types-aiobotocore-sso-oidc>=2.24.0, <2.25.0",
            "types-aiobotocore-stepfunctions>=2.24.0, <2.25.0",
            "types-aiobotocore-storagegateway>=2.24.0, <2.25.0",
            "types-aiobotocore-sts>=2.24.0, <2.25.0",
            "types-aiobotocore-supplychain>=2.24.0, <2.25.0",
            "types-aiobotocore-support>=2.24.0, <2.25.0",
            "types-aiobotocore-support-app>=2.24.0, <2.25.0",
            "types-aiobotocore-swf>=2.24.0, <2.25.0",
            "types-aiobotocore-synthetics>=2.24.0, <2.25.0",
            "types-aiobotocore-taxsettings>=2.24.0, <2.25.0",
            "types-aiobotocore-textract>=2.24.0, <2.25.0",
            "types-aiobotocore-timestream-influxdb>=2.24.0, <2.25.0",
            "types-aiobotocore-timestream-query>=2.24.0, <2.25.0",
            "types-aiobotocore-timestream-write>=2.24.0, <2.25.0",
            "types-aiobotocore-tnb>=2.24.0, <2.25.0",
            "types-aiobotocore-transcribe>=2.24.0, <2.25.0",
            "types-aiobotocore-transfer>=2.24.0, <2.25.0",
            "types-aiobotocore-translate>=2.24.0, <2.25.0",
            "types-aiobotocore-trustedadvisor>=2.24.0, <2.25.0",
            "types-aiobotocore-verifiedpermissions>=2.24.0, <2.25.0",
            "types-aiobotocore-voice-id>=2.24.0, <2.25.0",
            "types-aiobotocore-vpc-lattice>=2.24.0, <2.25.0",
            "types-aiobotocore-waf>=2.24.0, <2.25.0",
            "types-aiobotocore-waf-regional>=2.24.0, <2.25.0",
            "types-aiobotocore-wafv2>=2.24.0, <2.25.0",
            "types-aiobotocore-wellarchitected>=2.24.0, <2.25.0",
            "types-aiobotocore-wisdom>=2.24.0, <2.25.0",
            "types-aiobotocore-workdocs>=2.24.0, <2.25.0",
            "types-aiobotocore-workmail>=2.24.0, <2.25.0",
            "types-aiobotocore-workmailmessageflow>=2.24.0, <2.25.0",
            "types-aiobotocore-workspaces>=2.24.0, <2.25.0",
            "types-aiobotocore-workspaces-instances>=2.24.0, <2.25.0",
            "types-aiobotocore-workspaces-thin-client>=2.24.0, <2.25.0",
            "types-aiobotocore-workspaces-web>=2.24.0, <2.25.0",
            "types-aiobotocore-xray>=2.24.0, <2.25.0",
        ],
        "essential": [
            "types-aiobotocore-cloudformation>=2.24.0, <2.25.0",
            "types-aiobotocore-dynamodb>=2.24.0, <2.25.0",
            "types-aiobotocore-ec2>=2.24.0, <2.25.0",
            "types-aiobotocore-lambda>=2.24.0, <2.25.0",
            "types-aiobotocore-rds>=2.24.0, <2.25.0",
            "types-aiobotocore-s3>=2.24.0, <2.25.0",
            "types-aiobotocore-sqs>=2.24.0, <2.25.0",
        ],
        "accessanalyzer": ["types-aiobotocore-accessanalyzer>=2.24.0, <2.25.0"],
        "account": ["types-aiobotocore-account>=2.24.0, <2.25.0"],
        "acm": ["types-aiobotocore-acm>=2.24.0, <2.25.0"],
        "acm-pca": ["types-aiobotocore-acm-pca>=2.24.0, <2.25.0"],
        "aiops": ["types-aiobotocore-aiops>=2.24.0, <2.25.0"],
        "amp": ["types-aiobotocore-amp>=2.24.0, <2.25.0"],
        "amplify": ["types-aiobotocore-amplify>=2.24.0, <2.25.0"],
        "amplifybackend": ["types-aiobotocore-amplifybackend>=2.24.0, <2.25.0"],
        "amplifyuibuilder": ["types-aiobotocore-amplifyuibuilder>=2.24.0, <2.25.0"],
        "apigateway": ["types-aiobotocore-apigateway>=2.24.0, <2.25.0"],
        "apigatewaymanagementapi": ["types-aiobotocore-apigatewaymanagementapi>=2.24.0, <2.25.0"],
        "apigatewayv2": ["types-aiobotocore-apigatewayv2>=2.24.0, <2.25.0"],
        "appconfig": ["types-aiobotocore-appconfig>=2.24.0, <2.25.0"],
        "appconfigdata": ["types-aiobotocore-appconfigdata>=2.24.0, <2.25.0"],
        "appfabric": ["types-aiobotocore-appfabric>=2.24.0, <2.25.0"],
        "appflow": ["types-aiobotocore-appflow>=2.24.0, <2.25.0"],
        "appintegrations": ["types-aiobotocore-appintegrations>=2.24.0, <2.25.0"],
        "application-autoscaling": ["types-aiobotocore-application-autoscaling>=2.24.0, <2.25.0"],
        "application-insights": ["types-aiobotocore-application-insights>=2.24.0, <2.25.0"],
        "application-signals": ["types-aiobotocore-application-signals>=2.24.0, <2.25.0"],
        "applicationcostprofiler": ["types-aiobotocore-applicationcostprofiler>=2.24.0, <2.25.0"],
        "appmesh": ["types-aiobotocore-appmesh>=2.24.0, <2.25.0"],
        "apprunner": ["types-aiobotocore-apprunner>=2.24.0, <2.25.0"],
        "appstream": ["types-aiobotocore-appstream>=2.24.0, <2.25.0"],
        "appsync": ["types-aiobotocore-appsync>=2.24.0, <2.25.0"],
        "apptest": ["types-aiobotocore-apptest>=2.24.0, <2.25.0"],
        "arc-region-switch": ["types-aiobotocore-arc-region-switch>=2.24.0, <2.25.0"],
        "arc-zonal-shift": ["types-aiobotocore-arc-zonal-shift>=2.24.0, <2.25.0"],
        "artifact": ["types-aiobotocore-artifact>=2.24.0, <2.25.0"],
        "athena": ["types-aiobotocore-athena>=2.24.0, <2.25.0"],
        "auditmanager": ["types-aiobotocore-auditmanager>=2.24.0, <2.25.0"],
        "autoscaling": ["types-aiobotocore-autoscaling>=2.24.0, <2.25.0"],
        "autoscaling-plans": ["types-aiobotocore-autoscaling-plans>=2.24.0, <2.25.0"],
        "b2bi": ["types-aiobotocore-b2bi>=2.24.0, <2.25.0"],
        "backup": ["types-aiobotocore-backup>=2.24.0, <2.25.0"],
        "backup-gateway": ["types-aiobotocore-backup-gateway>=2.24.0, <2.25.0"],
        "backupsearch": ["types-aiobotocore-backupsearch>=2.24.0, <2.25.0"],
        "batch": ["types-aiobotocore-batch>=2.24.0, <2.25.0"],
        "bcm-dashboards": ["types-aiobotocore-bcm-dashboards>=2.24.0, <2.25.0"],
        "bcm-data-exports": ["types-aiobotocore-bcm-data-exports>=2.24.0, <2.25.0"],
        "bcm-pricing-calculator": ["types-aiobotocore-bcm-pricing-calculator>=2.24.0, <2.25.0"],
        "bcm-recommended-actions": ["types-aiobotocore-bcm-recommended-actions>=2.24.0, <2.25.0"],
        "bedrock": ["types-aiobotocore-bedrock>=2.24.0, <2.25.0"],
        "bedrock-agent": ["types-aiobotocore-bedrock-agent>=2.24.0, <2.25.0"],
        "bedrock-agent-runtime": ["types-aiobotocore-bedrock-agent-runtime>=2.24.0, <2.25.0"],
        "bedrock-agentcore": ["types-aiobotocore-bedrock-agentcore>=2.24.0, <2.25.0"],
        "bedrock-agentcore-control": [
            "types-aiobotocore-bedrock-agentcore-control>=2.24.0, <2.25.0"
        ],
        "bedrock-data-automation": ["types-aiobotocore-bedrock-data-automation>=2.24.0, <2.25.0"],
        "bedrock-data-automation-runtime": [
            "types-aiobotocore-bedrock-data-automation-runtime>=2.24.0, <2.25.0"
        ],
        "bedrock-runtime": ["types-aiobotocore-bedrock-runtime>=2.24.0, <2.25.0"],
        "billing": ["types-aiobotocore-billing>=2.24.0, <2.25.0"],
        "billingconductor": ["types-aiobotocore-billingconductor>=2.24.0, <2.25.0"],
        "braket": ["types-aiobotocore-braket>=2.24.0, <2.25.0"],
        "budgets": ["types-aiobotocore-budgets>=2.24.0, <2.25.0"],
        "ce": ["types-aiobotocore-ce>=2.24.0, <2.25.0"],
        "chatbot": ["types-aiobotocore-chatbot>=2.24.0, <2.25.0"],
        "chime": ["types-aiobotocore-chime>=2.24.0, <2.25.0"],
        "chime-sdk-identity": ["types-aiobotocore-chime-sdk-identity>=2.24.0, <2.25.0"],
        "chime-sdk-media-pipelines": [
            "types-aiobotocore-chime-sdk-media-pipelines>=2.24.0, <2.25.0"
        ],
        "chime-sdk-meetings": ["types-aiobotocore-chime-sdk-meetings>=2.24.0, <2.25.0"],
        "chime-sdk-messaging": ["types-aiobotocore-chime-sdk-messaging>=2.24.0, <2.25.0"],
        "chime-sdk-voice": ["types-aiobotocore-chime-sdk-voice>=2.24.0, <2.25.0"],
        "cleanrooms": ["types-aiobotocore-cleanrooms>=2.24.0, <2.25.0"],
        "cleanroomsml": ["types-aiobotocore-cleanroomsml>=2.24.0, <2.25.0"],
        "cloud9": ["types-aiobotocore-cloud9>=2.24.0, <2.25.0"],
        "cloudcontrol": ["types-aiobotocore-cloudcontrol>=2.24.0, <2.25.0"],
        "clouddirectory": ["types-aiobotocore-clouddirectory>=2.24.0, <2.25.0"],
        "cloudformation": ["types-aiobotocore-cloudformation>=2.24.0, <2.25.0"],
        "cloudfront": ["types-aiobotocore-cloudfront>=2.24.0, <2.25.0"],
        "cloudfront-keyvaluestore": ["types-aiobotocore-cloudfront-keyvaluestore>=2.24.0, <2.25.0"],
        "cloudhsm": ["types-aiobotocore-cloudhsm>=2.24.0, <2.25.0"],
        "cloudhsmv2": ["types-aiobotocore-cloudhsmv2>=2.24.0, <2.25.0"],
        "cloudsearch": ["types-aiobotocore-cloudsearch>=2.24.0, <2.25.0"],
        "cloudsearchdomain": ["types-aiobotocore-cloudsearchdomain>=2.24.0, <2.25.0"],
        "cloudtrail": ["types-aiobotocore-cloudtrail>=2.24.0, <2.25.0"],
        "cloudtrail-data": ["types-aiobotocore-cloudtrail-data>=2.24.0, <2.25.0"],
        "cloudwatch": ["types-aiobotocore-cloudwatch>=2.24.0, <2.25.0"],
        "codeartifact": ["types-aiobotocore-codeartifact>=2.24.0, <2.25.0"],
        "codebuild": ["types-aiobotocore-codebuild>=2.24.0, <2.25.0"],
        "codecatalyst": ["types-aiobotocore-codecatalyst>=2.24.0, <2.25.0"],
        "codecommit": ["types-aiobotocore-codecommit>=2.24.0, <2.25.0"],
        "codeconnections": ["types-aiobotocore-codeconnections>=2.24.0, <2.25.0"],
        "codedeploy": ["types-aiobotocore-codedeploy>=2.24.0, <2.25.0"],
        "codeguru-reviewer": ["types-aiobotocore-codeguru-reviewer>=2.24.0, <2.25.0"],
        "codeguru-security": ["types-aiobotocore-codeguru-security>=2.24.0, <2.25.0"],
        "codeguruprofiler": ["types-aiobotocore-codeguruprofiler>=2.24.0, <2.25.0"],
        "codepipeline": ["types-aiobotocore-codepipeline>=2.24.0, <2.25.0"],
        "codestar-connections": ["types-aiobotocore-codestar-connections>=2.24.0, <2.25.0"],
        "codestar-notifications": ["types-aiobotocore-codestar-notifications>=2.24.0, <2.25.0"],
        "cognito-identity": ["types-aiobotocore-cognito-identity>=2.24.0, <2.25.0"],
        "cognito-idp": ["types-aiobotocore-cognito-idp>=2.24.0, <2.25.0"],
        "cognito-sync": ["types-aiobotocore-cognito-sync>=2.24.0, <2.25.0"],
        "comprehend": ["types-aiobotocore-comprehend>=2.24.0, <2.25.0"],
        "comprehendmedical": ["types-aiobotocore-comprehendmedical>=2.24.0, <2.25.0"],
        "compute-optimizer": ["types-aiobotocore-compute-optimizer>=2.24.0, <2.25.0"],
        "config": ["types-aiobotocore-config>=2.24.0, <2.25.0"],
        "connect": ["types-aiobotocore-connect>=2.24.0, <2.25.0"],
        "connect-contact-lens": ["types-aiobotocore-connect-contact-lens>=2.24.0, <2.25.0"],
        "connectcampaigns": ["types-aiobotocore-connectcampaigns>=2.24.0, <2.25.0"],
        "connectcampaignsv2": ["types-aiobotocore-connectcampaignsv2>=2.24.0, <2.25.0"],
        "connectcases": ["types-aiobotocore-connectcases>=2.24.0, <2.25.0"],
        "connectparticipant": ["types-aiobotocore-connectparticipant>=2.24.0, <2.25.0"],
        "controlcatalog": ["types-aiobotocore-controlcatalog>=2.24.0, <2.25.0"],
        "controltower": ["types-aiobotocore-controltower>=2.24.0, <2.25.0"],
        "cost-optimization-hub": ["types-aiobotocore-cost-optimization-hub>=2.24.0, <2.25.0"],
        "cur": ["types-aiobotocore-cur>=2.24.0, <2.25.0"],
        "customer-profiles": ["types-aiobotocore-customer-profiles>=2.24.0, <2.25.0"],
        "databrew": ["types-aiobotocore-databrew>=2.24.0, <2.25.0"],
        "dataexchange": ["types-aiobotocore-dataexchange>=2.24.0, <2.25.0"],
        "datapipeline": ["types-aiobotocore-datapipeline>=2.24.0, <2.25.0"],
        "datasync": ["types-aiobotocore-datasync>=2.24.0, <2.25.0"],
        "datazone": ["types-aiobotocore-datazone>=2.24.0, <2.25.0"],
        "dax": ["types-aiobotocore-dax>=2.24.0, <2.25.0"],
        "deadline": ["types-aiobotocore-deadline>=2.24.0, <2.25.0"],
        "detective": ["types-aiobotocore-detective>=2.24.0, <2.25.0"],
        "devicefarm": ["types-aiobotocore-devicefarm>=2.24.0, <2.25.0"],
        "devops-guru": ["types-aiobotocore-devops-guru>=2.24.0, <2.25.0"],
        "directconnect": ["types-aiobotocore-directconnect>=2.24.0, <2.25.0"],
        "discovery": ["types-aiobotocore-discovery>=2.24.0, <2.25.0"],
        "dlm": ["types-aiobotocore-dlm>=2.24.0, <2.25.0"],
        "dms": ["types-aiobotocore-dms>=2.24.0, <2.25.0"],
        "docdb": ["types-aiobotocore-docdb>=2.24.0, <2.25.0"],
        "docdb-elastic": ["types-aiobotocore-docdb-elastic>=2.24.0, <2.25.0"],
        "drs": ["types-aiobotocore-drs>=2.24.0, <2.25.0"],
        "ds": ["types-aiobotocore-ds>=2.24.0, <2.25.0"],
        "ds-data": ["types-aiobotocore-ds-data>=2.24.0, <2.25.0"],
        "dsql": ["types-aiobotocore-dsql>=2.24.0, <2.25.0"],
        "dynamodb": ["types-aiobotocore-dynamodb>=2.24.0, <2.25.0"],
        "dynamodbstreams": ["types-aiobotocore-dynamodbstreams>=2.24.0, <2.25.0"],
        "ebs": ["types-aiobotocore-ebs>=2.24.0, <2.25.0"],
        "ec2": ["types-aiobotocore-ec2>=2.24.0, <2.25.0"],
        "ec2-instance-connect": ["types-aiobotocore-ec2-instance-connect>=2.24.0, <2.25.0"],
        "ecr": ["types-aiobotocore-ecr>=2.24.0, <2.25.0"],
        "ecr-public": ["types-aiobotocore-ecr-public>=2.24.0, <2.25.0"],
        "ecs": ["types-aiobotocore-ecs>=2.24.0, <2.25.0"],
        "efs": ["types-aiobotocore-efs>=2.24.0, <2.25.0"],
        "eks": ["types-aiobotocore-eks>=2.24.0, <2.25.0"],
        "eks-auth": ["types-aiobotocore-eks-auth>=2.24.0, <2.25.0"],
        "elasticache": ["types-aiobotocore-elasticache>=2.24.0, <2.25.0"],
        "elasticbeanstalk": ["types-aiobotocore-elasticbeanstalk>=2.24.0, <2.25.0"],
        "elastictranscoder": ["types-aiobotocore-elastictranscoder>=2.24.0, <2.25.0"],
        "elb": ["types-aiobotocore-elb>=2.24.0, <2.25.0"],
        "elbv2": ["types-aiobotocore-elbv2>=2.24.0, <2.25.0"],
        "emr": ["types-aiobotocore-emr>=2.24.0, <2.25.0"],
        "emr-containers": ["types-aiobotocore-emr-containers>=2.24.0, <2.25.0"],
        "emr-serverless": ["types-aiobotocore-emr-serverless>=2.24.0, <2.25.0"],
        "entityresolution": ["types-aiobotocore-entityresolution>=2.24.0, <2.25.0"],
        "es": ["types-aiobotocore-es>=2.24.0, <2.25.0"],
        "events": ["types-aiobotocore-events>=2.24.0, <2.25.0"],
        "evidently": ["types-aiobotocore-evidently>=2.24.0, <2.25.0"],
        "evs": ["types-aiobotocore-evs>=2.24.0, <2.25.0"],
        "finspace": ["types-aiobotocore-finspace>=2.24.0, <2.25.0"],
        "finspace-data": ["types-aiobotocore-finspace-data>=2.24.0, <2.25.0"],
        "firehose": ["types-aiobotocore-firehose>=2.24.0, <2.25.0"],
        "fis": ["types-aiobotocore-fis>=2.24.0, <2.25.0"],
        "fms": ["types-aiobotocore-fms>=2.24.0, <2.25.0"],
        "forecast": ["types-aiobotocore-forecast>=2.24.0, <2.25.0"],
        "forecastquery": ["types-aiobotocore-forecastquery>=2.24.0, <2.25.0"],
        "frauddetector": ["types-aiobotocore-frauddetector>=2.24.0, <2.25.0"],
        "freetier": ["types-aiobotocore-freetier>=2.24.0, <2.25.0"],
        "fsx": ["types-aiobotocore-fsx>=2.24.0, <2.25.0"],
        "gamelift": ["types-aiobotocore-gamelift>=2.24.0, <2.25.0"],
        "gameliftstreams": ["types-aiobotocore-gameliftstreams>=2.24.0, <2.25.0"],
        "geo-maps": ["types-aiobotocore-geo-maps>=2.24.0, <2.25.0"],
        "geo-places": ["types-aiobotocore-geo-places>=2.24.0, <2.25.0"],
        "geo-routes": ["types-aiobotocore-geo-routes>=2.24.0, <2.25.0"],
        "glacier": ["types-aiobotocore-glacier>=2.24.0, <2.25.0"],
        "globalaccelerator": ["types-aiobotocore-globalaccelerator>=2.24.0, <2.25.0"],
        "glue": ["types-aiobotocore-glue>=2.24.0, <2.25.0"],
        "grafana": ["types-aiobotocore-grafana>=2.24.0, <2.25.0"],
        "greengrass": ["types-aiobotocore-greengrass>=2.24.0, <2.25.0"],
        "greengrassv2": ["types-aiobotocore-greengrassv2>=2.24.0, <2.25.0"],
        "groundstation": ["types-aiobotocore-groundstation>=2.24.0, <2.25.0"],
        "guardduty": ["types-aiobotocore-guardduty>=2.24.0, <2.25.0"],
        "health": ["types-aiobotocore-health>=2.24.0, <2.25.0"],
        "healthlake": ["types-aiobotocore-healthlake>=2.24.0, <2.25.0"],
        "iam": ["types-aiobotocore-iam>=2.24.0, <2.25.0"],
        "identitystore": ["types-aiobotocore-identitystore>=2.24.0, <2.25.0"],
        "imagebuilder": ["types-aiobotocore-imagebuilder>=2.24.0, <2.25.0"],
        "importexport": ["types-aiobotocore-importexport>=2.24.0, <2.25.0"],
        "inspector": ["types-aiobotocore-inspector>=2.24.0, <2.25.0"],
        "inspector-scan": ["types-aiobotocore-inspector-scan>=2.24.0, <2.25.0"],
        "inspector2": ["types-aiobotocore-inspector2>=2.24.0, <2.25.0"],
        "internetmonitor": ["types-aiobotocore-internetmonitor>=2.24.0, <2.25.0"],
        "invoicing": ["types-aiobotocore-invoicing>=2.24.0, <2.25.0"],
        "iot": ["types-aiobotocore-iot>=2.24.0, <2.25.0"],
        "iot-data": ["types-aiobotocore-iot-data>=2.24.0, <2.25.0"],
        "iot-jobs-data": ["types-aiobotocore-iot-jobs-data>=2.24.0, <2.25.0"],
        "iot-managed-integrations": ["types-aiobotocore-iot-managed-integrations>=2.24.0, <2.25.0"],
        "iotanalytics": ["types-aiobotocore-iotanalytics>=2.24.0, <2.25.0"],
        "iotdeviceadvisor": ["types-aiobotocore-iotdeviceadvisor>=2.24.0, <2.25.0"],
        "iotevents": ["types-aiobotocore-iotevents>=2.24.0, <2.25.0"],
        "iotevents-data": ["types-aiobotocore-iotevents-data>=2.24.0, <2.25.0"],
        "iotfleethub": ["types-aiobotocore-iotfleethub>=2.24.0, <2.25.0"],
        "iotfleetwise": ["types-aiobotocore-iotfleetwise>=2.24.0, <2.25.0"],
        "iotsecuretunneling": ["types-aiobotocore-iotsecuretunneling>=2.24.0, <2.25.0"],
        "iotsitewise": ["types-aiobotocore-iotsitewise>=2.24.0, <2.25.0"],
        "iotthingsgraph": ["types-aiobotocore-iotthingsgraph>=2.24.0, <2.25.0"],
        "iottwinmaker": ["types-aiobotocore-iottwinmaker>=2.24.0, <2.25.0"],
        "iotwireless": ["types-aiobotocore-iotwireless>=2.24.0, <2.25.0"],
        "ivs": ["types-aiobotocore-ivs>=2.24.0, <2.25.0"],
        "ivs-realtime": ["types-aiobotocore-ivs-realtime>=2.24.0, <2.25.0"],
        "ivschat": ["types-aiobotocore-ivschat>=2.24.0, <2.25.0"],
        "kafka": ["types-aiobotocore-kafka>=2.24.0, <2.25.0"],
        "kafkaconnect": ["types-aiobotocore-kafkaconnect>=2.24.0, <2.25.0"],
        "kendra": ["types-aiobotocore-kendra>=2.24.0, <2.25.0"],
        "kendra-ranking": ["types-aiobotocore-kendra-ranking>=2.24.0, <2.25.0"],
        "keyspaces": ["types-aiobotocore-keyspaces>=2.24.0, <2.25.0"],
        "keyspacesstreams": ["types-aiobotocore-keyspacesstreams>=2.24.0, <2.25.0"],
        "kinesis": ["types-aiobotocore-kinesis>=2.24.0, <2.25.0"],
        "kinesis-video-archived-media": [
            "types-aiobotocore-kinesis-video-archived-media>=2.24.0, <2.25.0"
        ],
        "kinesis-video-media": ["types-aiobotocore-kinesis-video-media>=2.24.0, <2.25.0"],
        "kinesis-video-signaling": ["types-aiobotocore-kinesis-video-signaling>=2.24.0, <2.25.0"],
        "kinesis-video-webrtc-storage": [
            "types-aiobotocore-kinesis-video-webrtc-storage>=2.24.0, <2.25.0"
        ],
        "kinesisanalytics": ["types-aiobotocore-kinesisanalytics>=2.24.0, <2.25.0"],
        "kinesisanalyticsv2": ["types-aiobotocore-kinesisanalyticsv2>=2.24.0, <2.25.0"],
        "kinesisvideo": ["types-aiobotocore-kinesisvideo>=2.24.0, <2.25.0"],
        "kms": ["types-aiobotocore-kms>=2.24.0, <2.25.0"],
        "lakeformation": ["types-aiobotocore-lakeformation>=2.24.0, <2.25.0"],
        "lambda": ["types-aiobotocore-lambda>=2.24.0, <2.25.0"],
        "launch-wizard": ["types-aiobotocore-launch-wizard>=2.24.0, <2.25.0"],
        "lex-models": ["types-aiobotocore-lex-models>=2.24.0, <2.25.0"],
        "lex-runtime": ["types-aiobotocore-lex-runtime>=2.24.0, <2.25.0"],
        "lexv2-models": ["types-aiobotocore-lexv2-models>=2.24.0, <2.25.0"],
        "lexv2-runtime": ["types-aiobotocore-lexv2-runtime>=2.24.0, <2.25.0"],
        "license-manager": ["types-aiobotocore-license-manager>=2.24.0, <2.25.0"],
        "license-manager-linux-subscriptions": [
            "types-aiobotocore-license-manager-linux-subscriptions>=2.24.0, <2.25.0"
        ],
        "license-manager-user-subscriptions": [
            "types-aiobotocore-license-manager-user-subscriptions>=2.24.0, <2.25.0"
        ],
        "lightsail": ["types-aiobotocore-lightsail>=2.24.0, <2.25.0"],
        "location": ["types-aiobotocore-location>=2.24.0, <2.25.0"],
        "logs": ["types-aiobotocore-logs>=2.24.0, <2.25.0"],
        "lookoutequipment": ["types-aiobotocore-lookoutequipment>=2.24.0, <2.25.0"],
        "lookoutmetrics": ["types-aiobotocore-lookoutmetrics>=2.24.0, <2.25.0"],
        "lookoutvision": ["types-aiobotocore-lookoutvision>=2.24.0, <2.25.0"],
        "m2": ["types-aiobotocore-m2>=2.24.0, <2.25.0"],
        "machinelearning": ["types-aiobotocore-machinelearning>=2.24.0, <2.25.0"],
        "macie2": ["types-aiobotocore-macie2>=2.24.0, <2.25.0"],
        "mailmanager": ["types-aiobotocore-mailmanager>=2.24.0, <2.25.0"],
        "managedblockchain": ["types-aiobotocore-managedblockchain>=2.24.0, <2.25.0"],
        "managedblockchain-query": ["types-aiobotocore-managedblockchain-query>=2.24.0, <2.25.0"],
        "marketplace-agreement": ["types-aiobotocore-marketplace-agreement>=2.24.0, <2.25.0"],
        "marketplace-catalog": ["types-aiobotocore-marketplace-catalog>=2.24.0, <2.25.0"],
        "marketplace-deployment": ["types-aiobotocore-marketplace-deployment>=2.24.0, <2.25.0"],
        "marketplace-entitlement": ["types-aiobotocore-marketplace-entitlement>=2.24.0, <2.25.0"],
        "marketplace-reporting": ["types-aiobotocore-marketplace-reporting>=2.24.0, <2.25.0"],
        "marketplacecommerceanalytics": [
            "types-aiobotocore-marketplacecommerceanalytics>=2.24.0, <2.25.0"
        ],
        "mediaconnect": ["types-aiobotocore-mediaconnect>=2.24.0, <2.25.0"],
        "mediaconvert": ["types-aiobotocore-mediaconvert>=2.24.0, <2.25.0"],
        "medialive": ["types-aiobotocore-medialive>=2.24.0, <2.25.0"],
        "mediapackage": ["types-aiobotocore-mediapackage>=2.24.0, <2.25.0"],
        "mediapackage-vod": ["types-aiobotocore-mediapackage-vod>=2.24.0, <2.25.0"],
        "mediapackagev2": ["types-aiobotocore-mediapackagev2>=2.24.0, <2.25.0"],
        "mediastore": ["types-aiobotocore-mediastore>=2.24.0, <2.25.0"],
        "mediastore-data": ["types-aiobotocore-mediastore-data>=2.24.0, <2.25.0"],
        "mediatailor": ["types-aiobotocore-mediatailor>=2.24.0, <2.25.0"],
        "medical-imaging": ["types-aiobotocore-medical-imaging>=2.24.0, <2.25.0"],
        "memorydb": ["types-aiobotocore-memorydb>=2.24.0, <2.25.0"],
        "meteringmarketplace": ["types-aiobotocore-meteringmarketplace>=2.24.0, <2.25.0"],
        "mgh": ["types-aiobotocore-mgh>=2.24.0, <2.25.0"],
        "mgn": ["types-aiobotocore-mgn>=2.24.0, <2.25.0"],
        "migration-hub-refactor-spaces": [
            "types-aiobotocore-migration-hub-refactor-spaces>=2.24.0, <2.25.0"
        ],
        "migrationhub-config": ["types-aiobotocore-migrationhub-config>=2.24.0, <2.25.0"],
        "migrationhuborchestrator": ["types-aiobotocore-migrationhuborchestrator>=2.24.0, <2.25.0"],
        "migrationhubstrategy": ["types-aiobotocore-migrationhubstrategy>=2.24.0, <2.25.0"],
        "mpa": ["types-aiobotocore-mpa>=2.24.0, <2.25.0"],
        "mq": ["types-aiobotocore-mq>=2.24.0, <2.25.0"],
        "mturk": ["types-aiobotocore-mturk>=2.24.0, <2.25.0"],
        "mwaa": ["types-aiobotocore-mwaa>=2.24.0, <2.25.0"],
        "neptune": ["types-aiobotocore-neptune>=2.24.0, <2.25.0"],
        "neptune-graph": ["types-aiobotocore-neptune-graph>=2.24.0, <2.25.0"],
        "neptunedata": ["types-aiobotocore-neptunedata>=2.24.0, <2.25.0"],
        "network-firewall": ["types-aiobotocore-network-firewall>=2.24.0, <2.25.0"],
        "networkflowmonitor": ["types-aiobotocore-networkflowmonitor>=2.24.0, <2.25.0"],
        "networkmanager": ["types-aiobotocore-networkmanager>=2.24.0, <2.25.0"],
        "networkmonitor": ["types-aiobotocore-networkmonitor>=2.24.0, <2.25.0"],
        "notifications": ["types-aiobotocore-notifications>=2.24.0, <2.25.0"],
        "notificationscontacts": ["types-aiobotocore-notificationscontacts>=2.24.0, <2.25.0"],
        "oam": ["types-aiobotocore-oam>=2.24.0, <2.25.0"],
        "observabilityadmin": ["types-aiobotocore-observabilityadmin>=2.24.0, <2.25.0"],
        "odb": ["types-aiobotocore-odb>=2.24.0, <2.25.0"],
        "omics": ["types-aiobotocore-omics>=2.24.0, <2.25.0"],
        "opensearch": ["types-aiobotocore-opensearch>=2.24.0, <2.25.0"],
        "opensearchserverless": ["types-aiobotocore-opensearchserverless>=2.24.0, <2.25.0"],
        "opsworks": ["types-aiobotocore-opsworks>=2.24.0, <2.25.0"],
        "opsworkscm": ["types-aiobotocore-opsworkscm>=2.24.0, <2.25.0"],
        "organizations": ["types-aiobotocore-organizations>=2.24.0, <2.25.0"],
        "osis": ["types-aiobotocore-osis>=2.24.0, <2.25.0"],
        "outposts": ["types-aiobotocore-outposts>=2.24.0, <2.25.0"],
        "panorama": ["types-aiobotocore-panorama>=2.24.0, <2.25.0"],
        "partnercentral-selling": ["types-aiobotocore-partnercentral-selling>=2.24.0, <2.25.0"],
        "payment-cryptography": ["types-aiobotocore-payment-cryptography>=2.24.0, <2.25.0"],
        "payment-cryptography-data": [
            "types-aiobotocore-payment-cryptography-data>=2.24.0, <2.25.0"
        ],
        "pca-connector-ad": ["types-aiobotocore-pca-connector-ad>=2.24.0, <2.25.0"],
        "pca-connector-scep": ["types-aiobotocore-pca-connector-scep>=2.24.0, <2.25.0"],
        "pcs": ["types-aiobotocore-pcs>=2.24.0, <2.25.0"],
        "personalize": ["types-aiobotocore-personalize>=2.24.0, <2.25.0"],
        "personalize-events": ["types-aiobotocore-personalize-events>=2.24.0, <2.25.0"],
        "personalize-runtime": ["types-aiobotocore-personalize-runtime>=2.24.0, <2.25.0"],
        "pi": ["types-aiobotocore-pi>=2.24.0, <2.25.0"],
        "pinpoint": ["types-aiobotocore-pinpoint>=2.24.0, <2.25.0"],
        "pinpoint-email": ["types-aiobotocore-pinpoint-email>=2.24.0, <2.25.0"],
        "pinpoint-sms-voice": ["types-aiobotocore-pinpoint-sms-voice>=2.24.0, <2.25.0"],
        "pinpoint-sms-voice-v2": ["types-aiobotocore-pinpoint-sms-voice-v2>=2.24.0, <2.25.0"],
        "pipes": ["types-aiobotocore-pipes>=2.24.0, <2.25.0"],
        "polly": ["types-aiobotocore-polly>=2.24.0, <2.25.0"],
        "pricing": ["types-aiobotocore-pricing>=2.24.0, <2.25.0"],
        "proton": ["types-aiobotocore-proton>=2.24.0, <2.25.0"],
        "qapps": ["types-aiobotocore-qapps>=2.24.0, <2.25.0"],
        "qbusiness": ["types-aiobotocore-qbusiness>=2.24.0, <2.25.0"],
        "qconnect": ["types-aiobotocore-qconnect>=2.24.0, <2.25.0"],
        "qldb": ["types-aiobotocore-qldb>=2.24.0, <2.25.0"],
        "qldb-session": ["types-aiobotocore-qldb-session>=2.24.0, <2.25.0"],
        "quicksight": ["types-aiobotocore-quicksight>=2.24.0, <2.25.0"],
        "ram": ["types-aiobotocore-ram>=2.24.0, <2.25.0"],
        "rbin": ["types-aiobotocore-rbin>=2.24.0, <2.25.0"],
        "rds": ["types-aiobotocore-rds>=2.24.0, <2.25.0"],
        "rds-data": ["types-aiobotocore-rds-data>=2.24.0, <2.25.0"],
        "redshift": ["types-aiobotocore-redshift>=2.24.0, <2.25.0"],
        "redshift-data": ["types-aiobotocore-redshift-data>=2.24.0, <2.25.0"],
        "redshift-serverless": ["types-aiobotocore-redshift-serverless>=2.24.0, <2.25.0"],
        "rekognition": ["types-aiobotocore-rekognition>=2.24.0, <2.25.0"],
        "repostspace": ["types-aiobotocore-repostspace>=2.24.0, <2.25.0"],
        "resiliencehub": ["types-aiobotocore-resiliencehub>=2.24.0, <2.25.0"],
        "resource-explorer-2": ["types-aiobotocore-resource-explorer-2>=2.24.0, <2.25.0"],
        "resource-groups": ["types-aiobotocore-resource-groups>=2.24.0, <2.25.0"],
        "resourcegroupstaggingapi": ["types-aiobotocore-resourcegroupstaggingapi>=2.24.0, <2.25.0"],
        "robomaker": ["types-aiobotocore-robomaker>=2.24.0, <2.25.0"],
        "rolesanywhere": ["types-aiobotocore-rolesanywhere>=2.24.0, <2.25.0"],
        "route53": ["types-aiobotocore-route53>=2.24.0, <2.25.0"],
        "route53-recovery-cluster": ["types-aiobotocore-route53-recovery-cluster>=2.24.0, <2.25.0"],
        "route53-recovery-control-config": [
            "types-aiobotocore-route53-recovery-control-config>=2.24.0, <2.25.0"
        ],
        "route53-recovery-readiness": [
            "types-aiobotocore-route53-recovery-readiness>=2.24.0, <2.25.0"
        ],
        "route53domains": ["types-aiobotocore-route53domains>=2.24.0, <2.25.0"],
        "route53profiles": ["types-aiobotocore-route53profiles>=2.24.0, <2.25.0"],
        "route53resolver": ["types-aiobotocore-route53resolver>=2.24.0, <2.25.0"],
        "rum": ["types-aiobotocore-rum>=2.24.0, <2.25.0"],
        "s3": ["types-aiobotocore-s3>=2.24.0, <2.25.0"],
        "s3control": ["types-aiobotocore-s3control>=2.24.0, <2.25.0"],
        "s3outposts": ["types-aiobotocore-s3outposts>=2.24.0, <2.25.0"],
        "s3tables": ["types-aiobotocore-s3tables>=2.24.0, <2.25.0"],
        "s3vectors": ["types-aiobotocore-s3vectors>=2.24.0, <2.25.0"],
        "sagemaker": ["types-aiobotocore-sagemaker>=2.24.0, <2.25.0"],
        "sagemaker-a2i-runtime": ["types-aiobotocore-sagemaker-a2i-runtime>=2.24.0, <2.25.0"],
        "sagemaker-edge": ["types-aiobotocore-sagemaker-edge>=2.24.0, <2.25.0"],
        "sagemaker-featurestore-runtime": [
            "types-aiobotocore-sagemaker-featurestore-runtime>=2.24.0, <2.25.0"
        ],
        "sagemaker-geospatial": ["types-aiobotocore-sagemaker-geospatial>=2.24.0, <2.25.0"],
        "sagemaker-metrics": ["types-aiobotocore-sagemaker-metrics>=2.24.0, <2.25.0"],
        "sagemaker-runtime": ["types-aiobotocore-sagemaker-runtime>=2.24.0, <2.25.0"],
        "savingsplans": ["types-aiobotocore-savingsplans>=2.24.0, <2.25.0"],
        "scheduler": ["types-aiobotocore-scheduler>=2.24.0, <2.25.0"],
        "schemas": ["types-aiobotocore-schemas>=2.24.0, <2.25.0"],
        "sdb": ["types-aiobotocore-sdb>=2.24.0, <2.25.0"],
        "secretsmanager": ["types-aiobotocore-secretsmanager>=2.24.0, <2.25.0"],
        "security-ir": ["types-aiobotocore-security-ir>=2.24.0, <2.25.0"],
        "securityhub": ["types-aiobotocore-securityhub>=2.24.0, <2.25.0"],
        "securitylake": ["types-aiobotocore-securitylake>=2.24.0, <2.25.0"],
        "serverlessrepo": ["types-aiobotocore-serverlessrepo>=2.24.0, <2.25.0"],
        "service-quotas": ["types-aiobotocore-service-quotas>=2.24.0, <2.25.0"],
        "servicecatalog": ["types-aiobotocore-servicecatalog>=2.24.0, <2.25.0"],
        "servicecatalog-appregistry": [
            "types-aiobotocore-servicecatalog-appregistry>=2.24.0, <2.25.0"
        ],
        "servicediscovery": ["types-aiobotocore-servicediscovery>=2.24.0, <2.25.0"],
        "ses": ["types-aiobotocore-ses>=2.24.0, <2.25.0"],
        "sesv2": ["types-aiobotocore-sesv2>=2.24.0, <2.25.0"],
        "shield": ["types-aiobotocore-shield>=2.24.0, <2.25.0"],
        "signer": ["types-aiobotocore-signer>=2.24.0, <2.25.0"],
        "simspaceweaver": ["types-aiobotocore-simspaceweaver>=2.24.0, <2.25.0"],
        "sms": ["types-aiobotocore-sms>=2.24.0, <2.25.0"],
        "snow-device-management": ["types-aiobotocore-snow-device-management>=2.24.0, <2.25.0"],
        "snowball": ["types-aiobotocore-snowball>=2.24.0, <2.25.0"],
        "sns": ["types-aiobotocore-sns>=2.24.0, <2.25.0"],
        "socialmessaging": ["types-aiobotocore-socialmessaging>=2.24.0, <2.25.0"],
        "sqs": ["types-aiobotocore-sqs>=2.24.0, <2.25.0"],
        "ssm": ["types-aiobotocore-ssm>=2.24.0, <2.25.0"],
        "ssm-contacts": ["types-aiobotocore-ssm-contacts>=2.24.0, <2.25.0"],
        "ssm-guiconnect": ["types-aiobotocore-ssm-guiconnect>=2.24.0, <2.25.0"],
        "ssm-incidents": ["types-aiobotocore-ssm-incidents>=2.24.0, <2.25.0"],
        "ssm-quicksetup": ["types-aiobotocore-ssm-quicksetup>=2.24.0, <2.25.0"],
        "ssm-sap": ["types-aiobotocore-ssm-sap>=2.24.0, <2.25.0"],
        "sso": ["types-aiobotocore-sso>=2.24.0, <2.25.0"],
        "sso-admin": ["types-aiobotocore-sso-admin>=2.24.0, <2.25.0"],
        "sso-oidc": ["types-aiobotocore-sso-oidc>=2.24.0, <2.25.0"],
        "stepfunctions": ["types-aiobotocore-stepfunctions>=2.24.0, <2.25.0"],
        "storagegateway": ["types-aiobotocore-storagegateway>=2.24.0, <2.25.0"],
        "sts": ["types-aiobotocore-sts>=2.24.0, <2.25.0"],
        "supplychain": ["types-aiobotocore-supplychain>=2.24.0, <2.25.0"],
        "support": ["types-aiobotocore-support>=2.24.0, <2.25.0"],
        "support-app": ["types-aiobotocore-support-app>=2.24.0, <2.25.0"],
        "swf": ["types-aiobotocore-swf>=2.24.0, <2.25.0"],
        "synthetics": ["types-aiobotocore-synthetics>=2.24.0, <2.25.0"],
        "taxsettings": ["types-aiobotocore-taxsettings>=2.24.0, <2.25.0"],
        "textract": ["types-aiobotocore-textract>=2.24.0, <2.25.0"],
        "timestream-influxdb": ["types-aiobotocore-timestream-influxdb>=2.24.0, <2.25.0"],
        "timestream-query": ["types-aiobotocore-timestream-query>=2.24.0, <2.25.0"],
        "timestream-write": ["types-aiobotocore-timestream-write>=2.24.0, <2.25.0"],
        "tnb": ["types-aiobotocore-tnb>=2.24.0, <2.25.0"],
        "transcribe": ["types-aiobotocore-transcribe>=2.24.0, <2.25.0"],
        "transfer": ["types-aiobotocore-transfer>=2.24.0, <2.25.0"],
        "translate": ["types-aiobotocore-translate>=2.24.0, <2.25.0"],
        "trustedadvisor": ["types-aiobotocore-trustedadvisor>=2.24.0, <2.25.0"],
        "verifiedpermissions": ["types-aiobotocore-verifiedpermissions>=2.24.0, <2.25.0"],
        "voice-id": ["types-aiobotocore-voice-id>=2.24.0, <2.25.0"],
        "vpc-lattice": ["types-aiobotocore-vpc-lattice>=2.24.0, <2.25.0"],
        "waf": ["types-aiobotocore-waf>=2.24.0, <2.25.0"],
        "waf-regional": ["types-aiobotocore-waf-regional>=2.24.0, <2.25.0"],
        "wafv2": ["types-aiobotocore-wafv2>=2.24.0, <2.25.0"],
        "wellarchitected": ["types-aiobotocore-wellarchitected>=2.24.0, <2.25.0"],
        "wisdom": ["types-aiobotocore-wisdom>=2.24.0, <2.25.0"],
        "workdocs": ["types-aiobotocore-workdocs>=2.24.0, <2.25.0"],
        "workmail": ["types-aiobotocore-workmail>=2.24.0, <2.25.0"],
        "workmailmessageflow": ["types-aiobotocore-workmailmessageflow>=2.24.0, <2.25.0"],
        "workspaces": ["types-aiobotocore-workspaces>=2.24.0, <2.25.0"],
        "workspaces-instances": ["types-aiobotocore-workspaces-instances>=2.24.0, <2.25.0"],
        "workspaces-thin-client": ["types-aiobotocore-workspaces-thin-client>=2.24.0, <2.25.0"],
        "workspaces-web": ["types-aiobotocore-workspaces-web>=2.24.0, <2.25.0"],
        "xray": ["types-aiobotocore-xray>=2.24.0, <2.25.0"],
    },
    zip_safe=False,
)
