# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['exiot']
install_requires = \
['PyYAML>=5.4.1,<6.0.0', 'junitparser']

entry_points = \
{'console_scripts': ['exiot = exiot:main']}

setup_kwargs = {
    'name': 'exiot',
    'version': '0.1.0',
    'description': "The 'exiot' is a testing tool to test the executable STDIN, STDOUT, STDERR, and many more.",
    'long_description': '# Executable I/O Testing Tool (exiot)\n\n![Exiot Tests Pipeline](https://github.com/pestanko/exiot/actions/workflows/tests.yml/badge.svg)\n\nThe (`exiot`) is a testing tool to test the executable `STDIN`, `STDOUT`, `STDERR`, and many more.\n\nYou can take a look to the (man/architecture.md)[Architecture] `man` documentation.\n\n## Getting Started\n\nIn order to install the latest "stable" version of the tool you can use\nthe [pip](https://packaging.python.org/tutorials/installing-packages/).\n\n```shell\npip install exiot\n```\n\nIn order to get latest version of the tool you can just clone the repository:\n\n```shell\ngit clone https://github.com/pestanko/exiot.git\n```\n\nand then use the [poetry](https://python-poetry.org/docs/) to install dependencies, or just install them manually (\ndependencies are optional).\n\n```shell\ncd exiot\npoetry install\n```\n\nOptional dependencies:\n\n- ``junitparser`` - to produce the junit report\n- ``pyyaml`` - to parse yaml schemas and generate yaml reports\n\nYou can install them manually if you do not want to use the poetry\n\n```shell\npip install junitparser pyyaml\n```\n\n## Usage\n\nShow help:\n\n```shell\n$ python -m exiot --help\n```\n\n### Parse the tests\n\nParse the tests - show all available tests:\n\n```shell\npython -m exiot parse [-o OUTPUT_FORMAT] [-p PARSER] <TEST_DIR>\n# Example:\npython -m exiot parse examples/single_fail\n```\n\nParse the tests - show all available tests, dump them as `json` or `yaml` (if `pyyaml` installed):\n\n```shell\n# Examples:\npython -m exiot parse -o json examples/single_fail\n# or yaml if PyYAML installed\npython -m exiot parse -o yaml examples/single_fail\n```\n\n#### Supported parsers\n\nTool is currently supporting these parsers:\n\n- [``minihw``](man/minihw_def.md) - MiniHomework parser for _MUNI FI:PB071_ course (`examples/minihw_not_impl`)\n- [``dir``](man/directory_def.md) - Directory parser (`examples/single`, `examples/single_fail`)\n- [``scenario``](man/scenario_def.md) - Scenario parser, this is most advanced parser, and it is the preferred way to\n  write tests\n- ``auto`` - Autodetect parser - automatically detect which parser to use based on the root tests structure\n\n### Run the tests\n\nRun tests in directory:\n\n```shell\npython -m exiot -Linfo exec -E <EXECUTABLE> <TESTS_DIR>\n# Example:\npython -m exiot -Linfo exec -E ./myexec ./tests\n```\n\nRun Mini Homeworks:\n\n```shell\n# -p parameters specifies the "parser" - minihw is special parser for parsing the mini homeworks for FI:PB071\npython -m exiot -Linfo exec -p minihw <PATH_TO_MINIHW>\n# Example:\npython -m exiot -Linfo exec -p minihw examples/minihw_not_impl\n# Example to run the solution\npython -m exiot -Linfo exec -D="target: solution" <PATH_TO_MINIHW>\n```\n\n## Supported execution parameters\n\nTo provide/override parameters you can use ``params`` property for definitions or pass it as command line parameter\nusing: `-D` or `--define` option.\n\n- `valgrind` (not implemented)\n- `executable` - do not use directly from command line (use `-E` or `--executable` param)\n- `timeout` - Timeout - max execution time\n- `devel_mode` - Enable development mode, only for test development, not for "production"\n- `target` - for minihw you can toggle between `source|solution` executable testing (default: `source`)\n- `diff_params` - `diff` executable additional params\n- `junit_dump` - Print out the JUNIT dump at the end of the execution\n\n## Examples\n\nFor examples - take a look at the ``examples`` directory.\n\n- ``minihw_not_impl`` - Mini Homework format for FI:PB071, the minihw `source.c` is not implemented\n- ``proj_def_yml`` - Passing project definition - all tests should be passing\n- ``proj_def_fail_yml`` - Failing project def. - all tests should be failing\n- ``single`` - Single directory with tests - files based tests definition, all should be passing\n- ``single_fail`` - Single directory with tests - files based tests definition, all tests should be failing\n- ``echocat.c`` - reference implementation for the testing binary `echocat` (used in tests)\n\n## TODOs\n\n- [ ] Definition support templates (parametrized tests)\n- [ ] Valgrind Support\n- [ ] More tests\n- [ ] Support more parsers (ex. `kontr`)\n- [ ] Support tests generation\n',
    'author': 'Peter Stanko',
    'author_email': 'peter.stanko0@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pestanko/exiot',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
