"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterStrategy = exports.FilterPreset = void 0;
/** Filter presets */
var FilterPreset;
(function (FilterPreset) {
    /**
     * Collapses extraneous nodes to parent and cdk created nodes on themselves,
     * and prunes extraneous edges.
     *
     * This most closely represents the developers code for the current application
     * and reduces the noise one expects.
     */
    FilterPreset["COMPACT"] = "compact";
})(FilterPreset = exports.FilterPreset || (exports.FilterPreset = {}));
/**
 * Filter strategy to apply to filter matches.
 */
var FilterStrategy;
(function (FilterStrategy) {
    /** Remove filtered entity and all its edges */
    FilterStrategy["PRUNE"] = "prune";
    /** Collapse all child entities of filtered entity into filtered entity; and hoist all edges. */
    FilterStrategy["COLLAPSE"] = "collapse";
    /** Collapse all filtered entities into their parent entity; and hoist its edges to parent. */
    FilterStrategy["COLLAPSE_TO_PARENT"] = "collapse_to_parent";
})(FilterStrategy = exports.FilterStrategy || (exports.FilterStrategy = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZmlsdGVyaW5nL3R5cGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQWtCQSxxQkFBcUI7QUFDckIsSUFBWSxZQVNYO0FBVEQsV0FBWSxZQUFZO0lBQ3RCOzs7Ozs7T0FNRztJQUNILG1DQUFtQixDQUFBO0FBQ3JCLENBQUMsRUFUVyxZQUFZLEdBQVosb0JBQVksS0FBWixvQkFBWSxRQVN2QjtBQUVEOztHQUVHO0FBQ0gsSUFBWSxjQU9YO0FBUEQsV0FBWSxjQUFjO0lBQ3hCLCtDQUErQztJQUMvQyxpQ0FBZSxDQUFBO0lBQ2YsZ0dBQWdHO0lBQ2hHLHVDQUFxQixDQUFBO0lBQ3JCLDhGQUE4RjtJQUM5RiwyREFBeUMsQ0FBQTtBQUMzQyxDQUFDLEVBUFcsY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUFPekIiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5cbiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLlxuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiBZb3UgbWF5IG9idGFpbiBhIGNvcHkgb2YgdGhlIExpY2Vuc2UgYXRcblxuIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuXG4gVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC5cbiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiogKi9cbmltcG9ydCB7IENvbnN0cnVjdE9yZGVyIH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IEdyYXBoIH0gZnJvbSBcIi4uL2NvcmVcIjtcblxuLyoqIEZpbHRlciBwcmVzZXRzICovXG5leHBvcnQgZW51bSBGaWx0ZXJQcmVzZXQge1xuICAvKipcbiAgICogQ29sbGFwc2VzIGV4dHJhbmVvdXMgbm9kZXMgdG8gcGFyZW50IGFuZCBjZGsgY3JlYXRlZCBub2RlcyBvbiB0aGVtc2VsdmVzLFxuICAgKiBhbmQgcHJ1bmVzIGV4dHJhbmVvdXMgZWRnZXMuXG4gICAqXG4gICAqIFRoaXMgbW9zdCBjbG9zZWx5IHJlcHJlc2VudHMgdGhlIGRldmVsb3BlcnMgY29kZSBmb3IgdGhlIGN1cnJlbnQgYXBwbGljYXRpb25cbiAgICogYW5kIHJlZHVjZXMgdGhlIG5vaXNlIG9uZSBleHBlY3RzLlxuICAgKi9cbiAgQ09NUEFDVCA9IFwiY29tcGFjdFwiLFxufVxuXG4vKipcbiAqIEZpbHRlciBzdHJhdGVneSB0byBhcHBseSB0byBmaWx0ZXIgbWF0Y2hlcy5cbiAqL1xuZXhwb3J0IGVudW0gRmlsdGVyU3RyYXRlZ3kge1xuICAvKiogUmVtb3ZlIGZpbHRlcmVkIGVudGl0eSBhbmQgYWxsIGl0cyBlZGdlcyAqL1xuICBQUlVORSA9IFwicHJ1bmVcIixcbiAgLyoqIENvbGxhcHNlIGFsbCBjaGlsZCBlbnRpdGllcyBvZiBmaWx0ZXJlZCBlbnRpdHkgaW50byBmaWx0ZXJlZCBlbnRpdHk7IGFuZCBob2lzdCBhbGwgZWRnZXMuICovXG4gIENPTExBUFNFID0gXCJjb2xsYXBzZVwiLFxuICAvKiogQ29sbGFwc2UgYWxsIGZpbHRlcmVkIGVudGl0aWVzIGludG8gdGhlaXIgcGFyZW50IGVudGl0eTsgYW5kIGhvaXN0IGl0cyBlZGdlcyB0byBwYXJlbnQuICovXG4gIENPTExBUFNFX1RPX1BBUkVOVCA9IFwiY29sbGFwc2VfdG9fcGFyZW50XCIsXG59XG5cbi8qKlxuICogR3JhcGggZmlsdGVyLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElHcmFwaEZpbHRlciB7XG4gIC8qKlxuICAgKiBJbmRpY2F0ZXMgdGhhdCBtYXRjaGVzIHdpbGwgYmUgZmlsdGVyZWQsIGFzIG9wcG9zZWQgdG8gbm9uLW1hdGNoZXMuXG4gICAqXG4gICAqIFRoZSBkZWZhdWx0IGZvbGxvd3MgY29tbW9uIFtKYXZhc2NyaXB0IEFycmF5LmZpbHRlcl0oaHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvSmF2YVNjcmlwdC9SZWZlcmVuY2UvR2xvYmFsX09iamVjdHMvQXJyYXkvZmlsdGVyKVxuICAgKiBwcmVjZWRlbmNlIG9mIHByZXNlcnZpbmcgbWF0Y2hlcyBkdXJpbmcgZmlsdGVyaW5nLCB3aGlsZSBwcnVuaW5nIG5vbi1tYXRjaGVzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZSAtIFByZXNlcnZlIG1hdGNoZXMsIGFuZCBmaWx0ZXIgb3V0IG5vbi1tYXRjaGVzLlxuICAgKi9cbiAgcmVhZG9ubHkgaW52ZXJzZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBGaWx0ZXIgc3RyYXRlZ3kgdG8gYXBwbHkgdG8gbWF0Y2hpbmcgbm9kZXMuXG4gICAqXG4gICAqIEVkZ2VzIGRvIG5vdCBoYXZlIGEgc3RyYXRlZ3ksIHRoZXkgYXJlIGFsd2F5cyBwcnVuZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IHtGaWx0ZXJTdHJhdGVneS5QUlVORX1cbiAgICovXG4gIHJlYWRvbmx5IHN0cmF0ZWd5PzogRmlsdGVyU3RyYXRlZ3k7XG4gIC8qKiBQcmVkaWNhdGUgdG8gbWF0Y2ggbm9kZXMgKi9cbiAgcmVhZG9ubHkgbm9kZT86IEdyYXBoLklOb2RlUHJlZGljYXRlO1xuICAvKiogUHJlZGljYXRlIHRvIG1hdGNoIGVkZ2VzLiBFZGdlcyBhcmUgZXZhbHVhdGVkIGFmdGVyIG5vZGVzIGFyZSBmaWx0ZXJlZC4gKi9cbiAgcmVhZG9ubHkgZWRnZT86IEdyYXBoLklFZGdlUHJlZGljYXRlO1xufVxuXG4vKipcbiAqIERldGVybWluZXMgcm9vdCBub2RlIG9mIGZpbHRlciBwbGFuLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElGaWx0ZXJSb290Q2FsbGJhY2sge1xuICAoc3RvcmU6IEdyYXBoLlN0b3JlKTogR3JhcGguTm9kZTtcbn1cblxuLyoqXG4gKiBHcmFwaCBmaWx0ZXIgcGxhblxuICovXG5leHBvcnQgaW50ZXJmYWNlIElHcmFwaEZpbHRlclBsYW4ge1xuICAvKipcbiAgICogT3B0aW9uYWwgcHJlc2V0IGZpbHRlciB0byBhcHBseSBiZWZvcmUgb3RoZXIgZmlsdGVycy5cbiAgICovXG4gIHJlYWRvbmx5IHByZXNldD86IEZpbHRlclByZXNldDtcblxuICAvKipcbiAgICogTm9kZS9FZGdlIHByZWRpY2F0ZSBmaWx0ZXJzIHRvIGFwcGx5IHRvIHRoZSBncmFwaC5cbiAgICpcbiAgICogLSBGaWx0ZXJzIGFyZSBhcHBsaWVkICphZnRlciogdGhlIHByZXNldCBmaWx0ZXJpbmcgaXMgYXBwbGllZCBpZiBwcmVzZW50LlxuICAgKiAtIEZpbHRlcnMgYXJlIGFwcGxpZWQgc2VxdWVudGlhbGx5IGFnYWluc3QgYWxsIG5vZGVzLCBhcyBvcHBvc2VkIHRvIElBc3BlY3QudmlzaXRvciBwYXR0ZXJuXG4gICAqIHdoaWNoIGFyZSBzZXF1ZW50aWFsbHkgYXBwbGllZCBwZXIgbm9kZS5cbiAgICovXG4gIHJlYWRvbmx5IGZpbHRlcnM/OiBJR3JhcGhGaWx0ZXJbXTtcblxuICAvKipcbiAgICogVGhlIHJvb3Qgbm9kZSBvciByZXNvbHZlciB0byBkZXRlcm1pbmUgdGhlIGZpbHRlcmluZyByb290LlxuICAgKi9cbiAgcmVhZG9ubHkgcm9vdD86IElGaWx0ZXJSb290Q2FsbGJhY2sgfCBHcmFwaC5Ob2RlO1xuICAvKipcbiAgICogSW5kaWNhdGVzIGlmIGFuY2VzdHJhbCBjb250YWluZXJzIGFyZSBwcmVzZXJ2ZWQgKGVnOiBTdGFnZXMsIFN0YWNrKVxuICAgKlxuICAgKiBJZiBgdHJ1ZWAsIHRoZSBcInJvb3RcIiB3aWxsIGJlIGhvaXN0ZWQgdG8gdGhlIGdyYXBoIHJvb3QgYW5kIGFsbCBhbmNlc3RvcnMgd2lsbCBiZSBwcnVuZWQuXG4gICAqIElmIGBmYWxzZWAsIHRoZSBcInJvb3RcIiB3aWxsIGJlIGxlZnQgaW4tcGxhY2UsIHdoaWxlIGFsbCBzaWJsaW5ncyBhbmQgbm9uLXNjb3BlIGFuY2VzdG9ycyB3aWxsIGJlIHBydW5lZC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGhvaXN0Um9vdD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEluZGljYXRlcyB0aGF0IGFsbCBub2RlcyB3aWxsIGJlIGZpbHRlcmVkLCByYXRoZXIgdGhhbiBqdXN0IFJlc291cmNlIGFuZCBDZm5SZXNvdXJjZSBub2Rlcy5cbiAgICpcbiAgICogQnkgZW5hYmxpbmcgdGhpcywgYWxsIFN0YWdlcywgU3RhY2tzLCBhbmQgc3RydWN0dXJhbCBjb25zdHJ1Y3QgYm91bmRhcmllcyB3aWxsIGJlIGZpbHRlcmVkIGFzIHdlbGwuXG4gICAqIEluIGdlbmVyYWwsIG1vc3QgdXNlcnMgaW50ZW50IGlzIHRvIG9wZXJhdGUgYWdhaW5zdCByZXNvdXJjZXMgYW5kIGRlc2lyZSB0byBwcmVzZXJ2ZSBzdHJ1Y3R1cmFsIGdyb3VwaW5ncyxcbiAgICogd2hpY2ggaXMgY29tbW9uIGluIG1vc3QgQ2ZuL0NkayBiYXNlZCBmaWx0ZXJpbmcgd2hlcmUgaW5wdXRzIGFyZSBcImluY2x1ZGVcIiBsaXN0cy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2UgQnkgZGVmYXVsdCBvbmx5IFJlc291cmNlIGFuZCBDZm5SZXNvdXJjZSBub2RlcyBhcmUgZmlsdGVyZWQuXG4gICAqL1xuICByZWFkb25seSBhbGxOb2Rlcz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBvcmRlciB0byB2aXNpdCBub2RlcyBhbmQgZWRnZXMgZHVyaW5nIGZpbHRlcmluZy5cbiAgICpcbiAgICogQGRlZmF1bHQge0NvbnN0cnVjdE9yZGVyLlBSRU9SREVSfVxuICAgKi9cbiAgcmVhZG9ubHkgb3JkZXI/OiBDb25zdHJ1Y3RPcmRlcjtcbn1cbiJdfQ==