import { Graph } from "../core";
import { IGraphFilterPlan } from "./types";
/**
 * Verify that store is filterable, meaning it allows destructive mutations.
 * @throws Error if store is not filterable
 * @internal
 */
export declare function verifyFilterable(store: Graph.Store): void;
/**
 * Changes the root of the store based on filter plan.
 * @throws Error if store is not filterable
 * @internal
 * @destructive
 */
export declare function rerootFilter(store: Graph.Store, plan: IGraphFilterPlan): void;
/**
 * Performs **compact** filter preset to store.
 * @throws Error if store is not filterable
 * @internal
 * @destructive
 */
export declare function compactFilterPreset(store: Graph.Store): void;
