"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.performGraphFilterPlan = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const constructs_1 = require("constructs");
const core_1 = require("../core");
const presets = require("./presets");
const types_1 = require("./types");
__exportStar(require("./types"), exports);
/**
 * Perform graph filter plan on store.
 *
 * This operation is performed *in-place* and is destructive, therefore can only be applied
 * on stores that allow destructive mutations.
 * @param {Graph.Store} store - The store to perform filter plan against
 * @param {IGraphFilterPlan} plan - The filter plan to apply
 * @throws Error is store does not allow destructive mutations
 * @destructive
 */
function performGraphFilterPlan(store, plan) {
    presets.verifyFilterable(store);
    if (plan.root) {
        presets.rerootFilter(store, plan);
    }
    if (plan.preset) {
        if (plan.preset === types_1.FilterPreset.COMPACT) {
            presets.compactFilterPreset(store);
        }
    }
    if (plan.filters) {
        const nodes = store.root.findAll({
            order: plan.order || constructs_1.ConstructOrder.PREORDER,
            predicate: (node) => {
                // never filter store root
                if (node === store.root)
                    return false;
                if (plan.allNodes)
                    return true;
                // by default only return Resources and CfnResources
                return (core_1.Graph.ResourceNode.isResourceNode(node) ||
                    core_1.Graph.CfnResourceNode.isCfnResourceNode(node));
            },
        });
        for (const filter of plan.filters) {
            const inverse = filter.inverse === true;
            if (filter.node) {
                for (const node of nodes) {
                    if (node.isDestroyed)
                        continue;
                    const match = filter.node(node);
                    if ((match && inverse) || (!match && !inverse)) {
                        switch (filter.strategy || types_1.FilterStrategy.PRUNE) {
                            case types_1.FilterStrategy.PRUNE: {
                                node.mutateDestroy();
                                break;
                            }
                            case types_1.FilterStrategy.COLLAPSE: {
                                node.mutateCollapse();
                                break;
                            }
                            case types_1.FilterStrategy.COLLAPSE_TO_PARENT: {
                                node.mutateCollapseToParent();
                                break;
                            }
                        }
                    }
                }
            }
        }
        const edges = store.edges;
        for (const filter of plan.filters) {
            const inverse = filter.inverse === true;
            if (filter.edge) {
                for (const edge of edges) {
                    if (edge.isDestroyed)
                        continue;
                    const match = filter.edge(edge);
                    if ((match && inverse) || (!match && !inverse)) {
                        edge.mutateDestroy();
                    }
                }
            }
        }
    }
}
exports.performGraphFilterPlan = performGraphFilterPlan;
//# sourceMappingURL=data:application/json;base64,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