"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlagEnum = exports.ReferenceTypeEnum = exports.EdgeDirectionEnum = exports.EdgeTypeEnum = exports.NodeTypeEnum = exports.MetadataTypeEnum = exports.CfnAttributesEnum = exports.ExtraneousFqnEnum = exports.AssetFqnEnum = exports.ConstructInfoFqnEnum = exports.CdkConstructIds = void 0;
/** Common cdk construct ids */
var CdkConstructIds;
(function (CdkConstructIds) {
    CdkConstructIds["DEFAULT"] = "Default";
    CdkConstructIds["RESOURCE"] = "Resource";
    CdkConstructIds["EXPORTS"] = "Exports";
})(CdkConstructIds = exports.CdkConstructIds || (exports.CdkConstructIds = {}));
/** Commonly used cdk construct info fqn (jsii fully-qualified ids) */
var ConstructInfoFqnEnum;
(function (ConstructInfoFqnEnum) {
    ConstructInfoFqnEnum["APP"] = "aws-cdk-lib.App";
    ConstructInfoFqnEnum["STAGE"] = "aws-cdk-lib.Stage";
    ConstructInfoFqnEnum["STACK"] = "aws-cdk-lib.Stack";
    ConstructInfoFqnEnum["NESTED_STACK"] = "aws-cdk-lib.NestedStack";
    ConstructInfoFqnEnum["CFN_STACK"] = "aws-cdk-lib.CfnStack";
    ConstructInfoFqnEnum["CFN_OUTPUT"] = "aws-cdk-lib.CfnOutput";
    ConstructInfoFqnEnum["CFN_PARAMETER"] = "aws-cdk-lib.CfnParameter";
    // Custom Resources
    ConstructInfoFqnEnum["CUSTOM_RESOURCE"] = "aws-cdk-lib.CustomResource";
    ConstructInfoFqnEnum["AWS_CUSTOM_RESOURCE"] = "aws-cdk-lib.custom_resources.AwsCustomResource";
    ConstructInfoFqnEnum["CUSTOM_RESOURCE_PROVIDER"] = "aws-cdk-lib.custom_resources.Provider";
    ConstructInfoFqnEnum["CUSTOM_RESOURCE_PROVIDER_2"] = "aws-cdk-lib.CustomResourceProvider";
    // Lambda
    ConstructInfoFqnEnum["CFN_LAMBDA"] = "aws-cdk-lib.aws_lambda.CfnFunction";
    ConstructInfoFqnEnum["LAMBDA_LAYER_VERSION"] = "aws-cdk-lib.aws_lambda.LayerVersion";
    ConstructInfoFqnEnum["CFN_LAMBDA_LAYER_VERSION"] = "aws-cdk-lib.aws_lambda.CfnLayerVersion";
    ConstructInfoFqnEnum["LAMBDA_ALIAS"] = "aws-cdk-lib.aws_lambda.Alias";
    ConstructInfoFqnEnum["CFN_LAMBDA_ALIAS"] = "aws-cdk-lib.aws_lambda.CfnAlias";
    // Assets
    ConstructInfoFqnEnum["ASSET_STAGING"] = "aws-cdk-lib.AssetStaging";
    ConstructInfoFqnEnum["S3_ASSET"] = "aws-cdk-lib.aws_s3_assets.Asset";
    ConstructInfoFqnEnum["ECR_TARBALL_ASSET"] = "aws-cdk-lib.aws_ecr_assets.TarballImageAsset";
    // EC2
    ConstructInfoFqnEnum["EC2_INSTANCE"] = "aws-cdk-lib.aws_ec2.Instance";
    ConstructInfoFqnEnum["CFN_EC2_INSTANCE"] = "aws-cdk-lib.aws_ec2.CfnInstance";
    ConstructInfoFqnEnum["SECURITY_GROUP"] = "aws-cdk-lib.aws_ec2.SecurityGroup";
    ConstructInfoFqnEnum["CFN_SECURITY_GROUP"] = "aws-cdk-lib.aws_ec2.CfnSecurityGroup";
    ConstructInfoFqnEnum["VPC"] = "aws-cdk-lib.aws_ec2.Vpc";
    ConstructInfoFqnEnum["CFN_VPC"] = "aws-cdk-lib.aws_ec2.CfnVpc";
    ConstructInfoFqnEnum["PRIVATE_SUBNET"] = "aws-cdk-lib.aws_ec2.PrivateSubnet";
    ConstructInfoFqnEnum["CFN_PRIVATE_SUBNET"] = "aws-cdk-lib.aws_ec2.CfnPrivateSubnet";
    ConstructInfoFqnEnum["PUBLIC_SUBNET"] = "aws-cdk-lib.aws_ec2.PublicSubnet";
    ConstructInfoFqnEnum["CFN_PUBLIC_SUBNET"] = "aws-cdk-lib.aws_ec2.CfnPublicSubnet";
})(ConstructInfoFqnEnum = exports.ConstructInfoFqnEnum || (exports.ConstructInfoFqnEnum = {}));
/** Fqns that denote a cdk asset */
exports.AssetFqnEnum = [
    ConstructInfoFqnEnum.S3_ASSET,
    ConstructInfoFqnEnum.ECR_TARBALL_ASSET,
];
/** Fqns considered extraneous */
exports.ExtraneousFqnEnum = [
    ...exports.AssetFqnEnum,
    ConstructInfoFqnEnum.ASSET_STAGING,
    ConstructInfoFqnEnum.LAMBDA_LAYER_VERSION,
    ConstructInfoFqnEnum.CFN_LAMBDA_LAYER_VERSION,
    ConstructInfoFqnEnum.LAMBDA_ALIAS,
    ConstructInfoFqnEnum.CFN_LAMBDA_ALIAS,
];
/** Common cfn attribute keys */
var CfnAttributesEnum;
(function (CfnAttributesEnum) {
    CfnAttributesEnum["TYPE"] = "aws:cdk:cloudformation:type";
    CfnAttributesEnum["PROPS"] = "aws:cdk:cloudformation:props";
})(CfnAttributesEnum = exports.CfnAttributesEnum || (exports.CfnAttributesEnum = {}));
/** Common cdk metadata types */
var MetadataTypeEnum;
(function (MetadataTypeEnum) {
    MetadataTypeEnum["LOGICAL_ID"] = "aws:cdk:logicalId";
})(MetadataTypeEnum = exports.MetadataTypeEnum || (exports.MetadataTypeEnum = {}));
/** Node types handled by the graph */
var NodeTypeEnum;
(function (NodeTypeEnum) {
    /** Default node type - used for all nodes that don't have explicit type defined */
    NodeTypeEnum["DEFAULT"] = "DEFAULT";
    /** L1 cfn resource node */
    NodeTypeEnum["CFN_RESOURCE"] = "CFN_RESOURCE";
    /** L2 cdk resource node */
    NodeTypeEnum["RESOURCE"] = "RESOURCE";
    /** Cdk customer resource node */
    NodeTypeEnum["CUSTOM_RESOURCE"] = "CUSTOM_RESOURCE";
    /** Graph root node */
    NodeTypeEnum["ROOT"] = "ROOT";
    /** Cdk App node */
    NodeTypeEnum["APP"] = "APP";
    /** Cdk Stage node */
    NodeTypeEnum["STAGE"] = "STAGE";
    /** Cdk Stack node */
    NodeTypeEnum["STACK"] = "STACK";
    /** Cdk NestedStack node */
    NodeTypeEnum["NESTED_STACK"] = "NESTED_STACK";
    /** CfnOutput node */
    NodeTypeEnum["OUTPUT"] = "OUTPUT";
    /** CfnParameter node */
    NodeTypeEnum["PARAMETER"] = "PARAMETER";
    /** Cdk asset node */
    NodeTypeEnum["ASSET"] = "ASSET";
})(NodeTypeEnum = exports.NodeTypeEnum || (exports.NodeTypeEnum = {}));
/** Edge types handles by the graph */
var EdgeTypeEnum;
(function (EdgeTypeEnum) {
    /** Custom edge */
    EdgeTypeEnum["CUSTOM"] = "CUSTOM";
    /** Reference edge (Ref, Fn::GetAtt, Fn::ImportValue) */
    EdgeTypeEnum["REFERENCE"] = "REFERENCE";
    /** CloudFormation dependency edge */
    EdgeTypeEnum["DEPENDENCY"] = "DEPENDENCY";
})(EdgeTypeEnum = exports.EdgeTypeEnum || (exports.EdgeTypeEnum = {}));
/**
 * EdgeDirection specifies in which direction the edge is directed or if it is undirected.
 */
var EdgeDirectionEnum;
(function (EdgeDirectionEnum) {
    /** Indicates that edge is *undirected*; meaning there is no directional relationship between the **source** and **target**. */
    EdgeDirectionEnum["NONE"] = "none";
    /** Indicates the edge is *directed* from the **source** to the **target** */
    EdgeDirectionEnum["FORWARD"] = "forward";
    /** Indicates the edge is *directed* from the **target** to the **source** */
    EdgeDirectionEnum["BACK"] = "back";
    /** Indicates the edge is *bi-directional* */
    EdgeDirectionEnum["BOTH"] = "both";
})(EdgeDirectionEnum = exports.EdgeDirectionEnum || (exports.EdgeDirectionEnum = {}));
/** Reference edge types */
var ReferenceTypeEnum;
(function (ReferenceTypeEnum) {
    /** CloudFormation **Ref** reference */
    ReferenceTypeEnum["REF"] = "Ref";
    /** CloudFormation **Fn::GetAtt** reference */
    ReferenceTypeEnum["ATTRIBUTE"] = "Fn::GetAtt";
    /** CloudFormation **Fn::ImportValue** reference */
    ReferenceTypeEnum["IMPORT"] = "Fn::ImportValue";
})(ReferenceTypeEnum = exports.ReferenceTypeEnum || (exports.ReferenceTypeEnum = {}));
/** Graph flags */
var FlagEnum;
(function (FlagEnum) {
    /** Indicates that node is a cluster (container) and treated like an emphasized subgraph. */
    FlagEnum["CLUSTER"] = "CLUSTER";
    /** Indicates that node is non-resource container (Root, App) and used for structural purpose in the graph only. */
    FlagEnum["GRAPH_CONTAINER"] = "GRAPH_CONTAINER";
    /** Indicates that the entity is extraneous and considered collapsible to parent without impact of intent. */
    FlagEnum["EXTRANEOUS"] = "EXTRANEOUS";
    /** Indicates node is a simple CfnResource wrapper and can be collapsed without change of intent; Determined by only containing a single child of "Default" or "Resource" */
    FlagEnum["RESOURCE_WRAPPER"] = "RESOURCE_WRAPPER";
    /** Indicates node is considered a CDK Asset (Lambda Code, Docker Image, etc). */
    FlagEnum["ASSET"] = "ASSET";
    /** Indicates that node was created by CDK (`construct.node.defaultChild === CfnResource`). */
    FlagEnum["CDK_OWNED"] = "CDK_OWNED";
    /** Indicates that edge is closed; meaning `source === target`. This flag only gets applied on creation of edge, not during mutations to maintain initial intent. */
    FlagEnum["CLOSED_EDGE"] = "CLOSED_EDGE";
    /** Indicates that entity was mutated; meaning a mutation was performed to change originally computed graph value. */
    FlagEnum["MUTATED"] = "MUTATED";
})(FlagEnum = exports.FlagEnum || (exports.FlagEnum = {}));
//# sourceMappingURL=data:application/json;base64,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