"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Counter = void 0;
/**
 * Counter class provides utils for adding/subtracting key based counts.
 *
 * For example, you can create a counter to track number of each CfnResourceType based on resource type key.
 *
 * @internal
 */
class Counter {
    constructor() {
        /** @internal */
        this._counts = new Map();
    }
    /** Gets record of keyed counts */
    get counts() {
        return Object.fromEntries(this._counts);
    }
    /** Increment key count by 1 */
    add(key) {
        const count = (this._counts.get(key) || 0) + 1;
        this._counts.set(key, count);
        return count;
    }
    /** Decrement key count by 1 */
    subtract(key) {
        const count = (this._counts.get(key) || 0) - 1;
        if (count < 0) {
            throw new Error(`Attempt to subtract count from zero`);
        }
        this._counts.set(key, count);
        return count;
    }
    /** Gets the current count for given key */
    getCount(key) {
        return this._counts.get(key) || 0;
    }
}
exports.Counter = Counter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY291bnRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb3JlL2NvdW50ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBMkJBOzs7Ozs7R0FNRztBQUNILE1BQWEsT0FBTztJQUFwQjtRQUNFLGdCQUFnQjtRQUNSLFlBQU8sR0FBbUIsSUFBSSxHQUFHLEVBQUUsQ0FBQztJQTRCOUMsQ0FBQztJQTFCQyxrQ0FBa0M7SUFDbEMsSUFBSSxNQUFNO1FBQ1IsT0FBTyxNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQsK0JBQStCO0lBQy9CLEdBQUcsQ0FBQyxHQUFNO1FBQ1IsTUFBTSxLQUFLLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQzdCLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELCtCQUErQjtJQUMvQixRQUFRLENBQUMsR0FBTTtRQUNiLE1BQU0sS0FBSyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQy9DLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRTtZQUNiLE1BQU0sSUFBSSxLQUFLLENBQUMscUNBQXFDLENBQUMsQ0FBQztTQUN4RDtRQUNELElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM3QixPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCwyQ0FBMkM7SUFDM0MsUUFBUSxDQUFDLEdBQU07UUFDYixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNwQyxDQUFDO0NBQ0Y7QUE5QkQsMEJBOEJDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuXG4gTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS5cbiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuXG4gWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG5cbiBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcblxuIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiBkaXN0cmlidXRlZCB1bmRlciB0aGUgTGljZW5zZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsXG4gV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqICovXG4vKipcbiAqIElDb3VudGVyUmVjb3JkIGlzIHJlY29yZCBvZiBrZXllZCBjb3VudHMgZnJvbSB7QGxpbmsgQ291bnRlcnN9LlxuICpcbiAqIFRoZSByZWNvcmQgaXMgYSBtYXBwaW5nIG9mIGBrZXkgPT4gY291bnRgIHZhbHVlcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQ291bnRlclJlY29yZCB7XG4gIC8qKlxuICAgKiBDb3VudGVyIGtleSA9PiBjb3VudCB2YWx1ZSBwcm9wZXJ0aWVzXG4gICAqL1xuICBba2V5OiBzdHJpbmddOiBudW1iZXI7XG59XG5cbi8qKlxuICogQ291bnRlciBjbGFzcyBwcm92aWRlcyB1dGlscyBmb3IgYWRkaW5nL3N1YnRyYWN0aW5nIGtleSBiYXNlZCBjb3VudHMuXG4gKlxuICogRm9yIGV4YW1wbGUsIHlvdSBjYW4gY3JlYXRlIGEgY291bnRlciB0byB0cmFjayBudW1iZXIgb2YgZWFjaCBDZm5SZXNvdXJjZVR5cGUgYmFzZWQgb24gcmVzb3VyY2UgdHlwZSBrZXkuXG4gKlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBjbGFzcyBDb3VudGVyPFQgPSBzdHJpbmc+IHtcbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBwcml2YXRlIF9jb3VudHM6IE1hcDxULCBudW1iZXI+ID0gbmV3IE1hcCgpO1xuXG4gIC8qKiBHZXRzIHJlY29yZCBvZiBrZXllZCBjb3VudHMgKi9cbiAgZ2V0IGNvdW50cygpOiBJQ291bnRlclJlY29yZCB7XG4gICAgcmV0dXJuIE9iamVjdC5mcm9tRW50cmllcyh0aGlzLl9jb3VudHMpO1xuICB9XG5cbiAgLyoqIEluY3JlbWVudCBrZXkgY291bnQgYnkgMSAqL1xuICBhZGQoa2V5OiBUKTogbnVtYmVyIHtcbiAgICBjb25zdCBjb3VudCA9ICh0aGlzLl9jb3VudHMuZ2V0KGtleSkgfHwgMCkgKyAxO1xuICAgIHRoaXMuX2NvdW50cy5zZXQoa2V5LCBjb3VudCk7XG4gICAgcmV0dXJuIGNvdW50O1xuICB9XG5cbiAgLyoqIERlY3JlbWVudCBrZXkgY291bnQgYnkgMSAqL1xuICBzdWJ0cmFjdChrZXk6IFQpOiBudW1iZXIge1xuICAgIGNvbnN0IGNvdW50ID0gKHRoaXMuX2NvdW50cy5nZXQoa2V5KSB8fCAwKSAtIDE7XG4gICAgaWYgKGNvdW50IDwgMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBBdHRlbXB0IHRvIHN1YnRyYWN0IGNvdW50IGZyb20gemVyb2ApO1xuICAgIH1cbiAgICB0aGlzLl9jb3VudHMuc2V0KGtleSwgY291bnQpO1xuICAgIHJldHVybiBjb3VudDtcbiAgfVxuXG4gIC8qKiBHZXRzIHRoZSBjdXJyZW50IGNvdW50IGZvciBnaXZlbiBrZXkgKi9cbiAgZ2V0Q291bnQoa2V5OiBUKTogbnVtYmVyIHtcbiAgICByZXR1cm4gdGhpcy5fY291bnRzLmdldChrZXkpIHx8IDA7XG4gIH1cbn1cbiJdfQ==