"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveOutdir = exports.resolveConfig = exports.DEFAULT_OUTDIR = exports.CDK_OUTDIR_VAR = exports.CDK_GRAPH_RC = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const findUp = require("find-up"); // eslint-disable-line @typescript-eslint/no-require-imports
/** CdkGraph config file name */
exports.CDK_GRAPH_RC = ".cdkgraphrc.js";
/** Variable replacement token for cdk.out directory */
exports.CDK_OUTDIR_VAR = "<cdk.out>";
/** Default graph artifact output directory */
exports.DEFAULT_OUTDIR = `${exports.CDK_OUTDIR_VAR}/cdkgraph`;
/** Default CdkGraph configuration */
const DEFAULT_CONFIG = {
    outdir: exports.DEFAULT_OUTDIR,
};
/**
 * Resolve CdkGraph runtime configuration. Will detect local file system config if available and
 * merge with default configuration.
 * @internal
 */
function resolveConfig(cwd) {
    const config = findUp.sync(exports.CDK_GRAPH_RC, { cwd });
    if (config) {
        return {
            ...DEFAULT_CONFIG,
            ...require(config),
        };
    }
    return { ...DEFAULT_CONFIG };
}
exports.resolveConfig = resolveConfig;
/**
 * Resolve CdkGraph output directory. Performs replacement of tokens in config path.
 * @internal
 */
function resolveOutdir(cdkOutdir, outdir = exports.DEFAULT_OUTDIR) {
    return outdir.replace(exports.CDK_OUTDIR_VAR, cdkOutdir);
}
exports.resolveOutdir = resolveOutdir;
//# sourceMappingURL=data:application/json;base64,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