/** CdkGraph config file name */
export declare const CDK_GRAPH_RC = ".cdkgraphrc.js";
/** Variable replacement token for cdk.out directory */
export declare const CDK_OUTDIR_VAR = "<cdk.out>";
/** Default graph artifact output directory */
export declare const DEFAULT_OUTDIR: string;
/** CdkGraph configuration definition */
export interface CdkGraphConfig {
    /**
     * Directory where artifacts are written.
     *
     * The key `<cdk.out>` will be replaced with the synthesizer cdk `outdir`.
     *
     * Relative paths not prefixed with `<cdk.out>` will be relative to `process.cwd`
     *
     * @default "<cdk.out>/cdkgraph"
     */
    readonly outdir?: string;
    /** Additional configs */
    readonly [key: string]: any;
}
/**
 * Resolve CdkGraph runtime configuration. Will detect local file system config if available and
 * merge with default configuration.
 * @internal
 */
export declare function resolveConfig(cwd?: string): CdkGraphConfig;
/**
 * Resolve CdkGraph output directory. Performs replacement of tokens in config path.
 * @internal
 */
export declare function resolveOutdir(cdkOutdir: string, outdir?: string): string;
