"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructInfoFromConstruct = exports.addCustomSynthesis = void 0;
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 *
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L17
 *
 * @internal
 */
const JSII_RUNTIME_SYMBOL = Symbol.for("jsii.rtti");
/**
 * Symbol to identify custom cdk synthesis method.
 *
 * @internal
 */
const CUSTOM_SYNTHESIS_SYM = Symbol.for("@aws-cdk/core:customSynthesis");
/**
 * Cdk internal function for mapping construct synthesis property
 * for custom synthesis handling.
 *
 * @internal
 */
function addCustomSynthesis(construct, synthesis) {
    Object.defineProperty(construct, CUSTOM_SYNTHESIS_SYM, {
        value: synthesis,
        enumerable: false,
    });
}
exports.addCustomSynthesis = addCustomSynthesis;
/**
 * Retrieve {@link ConstructInfo} for a {@link IConstruct}
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L46
 */
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === "object" &&
        jsiiRuntimeInfo !== null &&
        typeof jsiiRuntimeInfo.fqn === "string" &&
        typeof jsiiRuntimeInfo.version === "string") {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
exports.constructInfoFromConstruct = constructInfoFromConstruct;
//# sourceMappingURL=data:application/json;base64,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