/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { ISynthesisSession } from "aws-cdk-lib";
import { IConstruct } from "constructs";
/**
 * Interface for constructs that want to do something custom during synthesis
 *
 * This feature is intended for use by official AWS CDK libraries only; 3rd party
 * library authors and CDK users should not use this function.
 *
 * **TODO**: Find an alternative synthesis solution that does not conflict with
 * the above statement. Before this package is stable, this should be resolved.
 *
 * @internal
 */
export interface ICustomSynthesis {
    /**
     * Called when the construct is synthesized
     */
    onSynthesize(session: ISynthesisSession): void;
}
/**
 * Cdk internal function for mapping construct synthesis property
 * for custom synthesis handling.
 *
 * @internal
 */
export declare function addCustomSynthesis(construct: IConstruct, synthesis: ICustomSynthesis): void;
/**
 * Source information on a construct (class fqn and version)
 *
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L22
 */
export interface ConstructInfo {
    readonly fqn: string;
    readonly version: string;
}
/**
 * Retrieve {@link ConstructInfo} for a {@link IConstruct}
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L46
 */
export declare function constructInfoFromConstruct(construct: IConstruct): ConstructInfo | undefined;
